/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.bridge;

import java.util.List;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotCompliantMBeanException;
import org.apache.activemq.artemis.core.management.impl.AbstractControl;
import org.apache.activemq.artemis.core.management.impl.MBeanInfoHelper;
import org.apache.activemq.artemis.logs.AuditLogger;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeReceiver;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeReceiverControl;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeReceiverInfo;

public class AMQPBridgeReceiverControlType
extends AbstractControl
implements AMQPBridgeReceiverControl {
    private final AMQPBridgeReceiver receiver;
    private final AMQPBridgeReceiverInfo receiverInfo;

    public AMQPBridgeReceiverControlType(AMQPBridgeReceiver receiver) throws NotCompliantMBeanException {
        super(AMQPBridgeReceiverControl.class, receiver.getBridgeManager().getServer().getStorageManager());
        this.receiver = receiver;
        this.receiverInfo = receiver.getReceiverInfo();
    }

    @Override
    public long getMessagesReceived() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getMessagesReceived((Object)this.receiverInfo);
        }
        this.clearIO();
        try {
            long l = this.receiver.getMessagesReceived();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getRole() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getRole((Object)this.receiverInfo);
        }
        this.clearIO();
        try {
            String string = this.receiverInfo.getRole().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getQueueName() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getQueueName((Object)this.receiverInfo);
        }
        this.clearIO();
        try {
            String string = this.receiverInfo.getLocalQueue();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getAddress() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getAddress((Object)this.receiverInfo);
        }
        this.clearIO();
        try {
            String string = this.receiverInfo.getLocalAddress();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getFqqn() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getFqqn((Object)this.receiverInfo);
        }
        this.clearIO();
        try {
            String string = this.receiverInfo.getLocalFqqn();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getRoutingType() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getRoutingType((Object)this.receiverInfo);
        }
        this.clearIO();
        try {
            String string = this.receiverInfo.getRoutingType().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getFilterString() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getFilterString((Object)this.receiverInfo);
        }
        this.clearIO();
        try {
            String string = this.receiverInfo.getFilterString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public int getPriority() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getPriority((Object)this.receiverInfo);
        }
        List.of(new Object[]{"one"});
        this.clearIO();
        try {
            int n = this.receiverInfo.getPriority();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    protected MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(AMQPBridgeReceiverControl.class);
    }

    protected MBeanAttributeInfo[] fillMBeanAttributeInfo() {
        return MBeanInfoHelper.getMBeanAttributesInfo(AMQPBridgeReceiverControl.class);
    }
}

