/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class SessionXAGetTimeoutResponseMessage
extends PacketImpl {
    private int timeoutSeconds;

    public SessionXAGetTimeoutResponseMessage(int timeoutSeconds) {
        super((byte)66);
        this.timeoutSeconds = timeoutSeconds;
    }

    public SessionXAGetTimeoutResponseMessage() {
        super((byte)66);
    }

    @Override
    public boolean isResponse() {
        return true;
    }

    public int getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeInt(this.timeoutSeconds);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.timeoutSeconds = buffer.readInt();
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hashCode(this.timeoutSeconds);
    }

    @Override
    protected String getPacketString() {
        StringBuilder sb = new StringBuilder(super.getPacketString());
        sb.append(", timeoutSeconds=" + this.timeoutSeconds);
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionXAGetTimeoutResponseMessage)) {
            return false;
        }
        SessionXAGetTimeoutResponseMessage other = (SessionXAGetTimeoutResponseMessage)obj;
        return this.timeoutSeconds == other.timeoutSeconds;
    }
}

