/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.handler;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.core.Ordered;
import org.springframework.core.log.LogDelegateFactory;
import org.springframework.http.server.RequestPath;
import org.springframework.lang.Nullable;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.PathMatcher;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.springframework.web.context.request.async.WebAsyncManager;
import org.springframework.web.context.request.async.WebAsyncUtils;
import org.springframework.web.context.support.WebApplicationObjectSupport;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.CorsProcessor;
import org.springframework.web.cors.CorsUtils;
import org.springframework.web.cors.DefaultCorsProcessor;
import org.springframework.web.cors.PreFlightRequestHandler;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.MappedInterceptor;
import org.springframework.web.servlet.handler.WebRequestHandlerInterceptorAdapter;
import org.springframework.web.util.ServletRequestPathUtils;
import org.springframework.web.util.UrlPathHelper;
import org.springframework.web.util.pattern.PathPatternParser;

public abstract class AbstractHandlerMapping
extends WebApplicationObjectSupport
implements HandlerMapping,
Ordered,
BeanNameAware {
    static final String SUPPRESS_LOGGING_ATTRIBUTE = AbstractHandlerMapping.class.getName() + ".SUPPRESS_LOGGING";
    protected final Log mappingsLogger = LogDelegateFactory.getHiddenLog((String)(HandlerMapping.class.getName() + ".Mappings"));
    @Nullable
    private Object defaultHandler;
    @Nullable
    private PathPatternParser patternParser = new PathPatternParser();
    private UrlPathHelper urlPathHelper = new UrlPathHelper();
    private PathMatcher pathMatcher = new AntPathMatcher();
    private final List<Object> interceptors = new ArrayList<Object>();
    private final List<HandlerInterceptor> adaptedInterceptors = new ArrayList<HandlerInterceptor>();
    @Nullable
    private CorsConfigurationSource corsConfigurationSource;
    private CorsProcessor corsProcessor = new DefaultCorsProcessor();
    private int order = Integer.MAX_VALUE;
    @Nullable
    private String beanName;

    public void setDefaultHandler(@Nullable Object defaultHandler) {
        this.defaultHandler = defaultHandler;
    }

    @Nullable
    public Object getDefaultHandler() {
        return this.defaultHandler;
    }

    public void setPatternParser(@Nullable PathPatternParser patternParser) {
        this.patternParser = patternParser;
    }

    @Nullable
    public PathPatternParser getPatternParser() {
        return this.patternParser;
    }

    @Deprecated(since="6.0")
    public void setAlwaysUseFullPath(boolean alwaysUseFullPath) {
        this.urlPathHelper.setAlwaysUseFullPath(alwaysUseFullPath);
        CorsConfigurationSource corsConfigurationSource = this.corsConfigurationSource;
        if (corsConfigurationSource instanceof UrlBasedCorsConfigurationSource) {
            UrlBasedCorsConfigurationSource urlConfigSource = (UrlBasedCorsConfigurationSource)corsConfigurationSource;
            urlConfigSource.setAlwaysUseFullPath(alwaysUseFullPath);
        }
    }

    @Deprecated(since="6.0")
    public void setUrlDecode(boolean urlDecode) {
        this.urlPathHelper.setUrlDecode(urlDecode);
        CorsConfigurationSource corsConfigurationSource = this.corsConfigurationSource;
        if (corsConfigurationSource instanceof UrlBasedCorsConfigurationSource) {
            UrlBasedCorsConfigurationSource urlConfigSource = (UrlBasedCorsConfigurationSource)corsConfigurationSource;
            urlConfigSource.setUrlDecode(urlDecode);
        }
    }

    @Deprecated(since="6.0")
    public void setRemoveSemicolonContent(boolean removeSemicolonContent) {
        this.urlPathHelper.setRemoveSemicolonContent(removeSemicolonContent);
        CorsConfigurationSource corsConfigurationSource = this.corsConfigurationSource;
        if (corsConfigurationSource instanceof UrlBasedCorsConfigurationSource) {
            UrlBasedCorsConfigurationSource urlConfigSource = (UrlBasedCorsConfigurationSource)corsConfigurationSource;
            urlConfigSource.setRemoveSemicolonContent(removeSemicolonContent);
        }
    }

    public void setUrlPathHelper(UrlPathHelper urlPathHelper) {
        Assert.notNull((Object)urlPathHelper, (String)"UrlPathHelper must not be null");
        this.urlPathHelper = urlPathHelper;
        CorsConfigurationSource corsConfigurationSource = this.corsConfigurationSource;
        if (corsConfigurationSource instanceof UrlBasedCorsConfigurationSource) {
            UrlBasedCorsConfigurationSource urlConfigSource = (UrlBasedCorsConfigurationSource)corsConfigurationSource;
            urlConfigSource.setUrlPathHelper(urlPathHelper);
        }
    }

    public UrlPathHelper getUrlPathHelper() {
        return this.urlPathHelper;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        Assert.notNull((Object)pathMatcher, (String)"PathMatcher must not be null");
        this.pathMatcher = pathMatcher;
        CorsConfigurationSource corsConfigurationSource = this.corsConfigurationSource;
        if (corsConfigurationSource instanceof UrlBasedCorsConfigurationSource) {
            UrlBasedCorsConfigurationSource urlConfigSource = (UrlBasedCorsConfigurationSource)corsConfigurationSource;
            urlConfigSource.setPathMatcher(pathMatcher);
        }
    }

    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    public void setInterceptors(Object ... interceptors) {
        this.interceptors.addAll(Arrays.asList(interceptors));
    }

    @Nullable
    public final HandlerInterceptor[] getAdaptedInterceptors() {
        return !this.adaptedInterceptors.isEmpty() ? this.adaptedInterceptors.toArray(new HandlerInterceptor[0]) : null;
    }

    @Nullable
    protected final MappedInterceptor[] getMappedInterceptors() {
        ArrayList<MappedInterceptor> mappedInterceptors = new ArrayList<MappedInterceptor>(this.adaptedInterceptors.size());
        for (HandlerInterceptor interceptor : this.adaptedInterceptors) {
            if (!(interceptor instanceof MappedInterceptor)) continue;
            MappedInterceptor mappedInterceptor = (MappedInterceptor)interceptor;
            mappedInterceptors.add(mappedInterceptor);
        }
        return !mappedInterceptors.isEmpty() ? mappedInterceptors.toArray(new MappedInterceptor[0]) : null;
    }

    public void setCorsConfigurations(Map<String, CorsConfiguration> corsConfigurations) {
        UrlBasedCorsConfigurationSource source;
        if (CollectionUtils.isEmpty(corsConfigurations)) {
            this.corsConfigurationSource = null;
            return;
        }
        if (this.getPatternParser() != null) {
            source = new UrlBasedCorsConfigurationSource(this.getPatternParser());
            source.setCorsConfigurations(corsConfigurations);
        } else {
            source = new UrlBasedCorsConfigurationSource();
            source.setCorsConfigurations(corsConfigurations);
            source.setPathMatcher(this.pathMatcher);
            source.setUrlPathHelper(this.urlPathHelper);
        }
        this.setCorsConfigurationSource((CorsConfigurationSource)source);
    }

    public void setCorsConfigurationSource(CorsConfigurationSource source) {
        Assert.notNull((Object)source, (String)"CorsConfigurationSource must not be null");
        this.corsConfigurationSource = source;
        if (source instanceof UrlBasedCorsConfigurationSource) {
            UrlBasedCorsConfigurationSource urlConfigSource = (UrlBasedCorsConfigurationSource)source;
            urlConfigSource.setAllowInitLookupPath(false);
        }
    }

    @Nullable
    public CorsConfigurationSource getCorsConfigurationSource() {
        return this.corsConfigurationSource;
    }

    public void setCorsProcessor(CorsProcessor corsProcessor) {
        Assert.notNull((Object)corsProcessor, (String)"CorsProcessor must not be null");
        this.corsProcessor = corsProcessor;
    }

    public CorsProcessor getCorsProcessor() {
        return this.corsProcessor;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    protected String formatMappingName() {
        return this.beanName != null ? "'" + this.beanName + "'" : this.getClass().getName();
    }

    protected void initApplicationContext() throws BeansException {
        this.extendInterceptors(this.interceptors);
        this.detectMappedInterceptors(this.adaptedInterceptors);
        this.initInterceptors();
    }

    protected void extendInterceptors(List<Object> interceptors) {
    }

    protected void detectMappedInterceptors(List<HandlerInterceptor> mappedInterceptors) {
        mappedInterceptors.addAll(BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.obtainApplicationContext(), MappedInterceptor.class, (boolean)true, (boolean)false).values());
    }

    protected void initInterceptors() {
        if (!this.interceptors.isEmpty()) {
            for (int i2 = 0; i2 < this.interceptors.size(); ++i2) {
                Object interceptor = this.interceptors.get(i2);
                if (interceptor == null) {
                    throw new IllegalArgumentException("Entry number " + i2 + " in interceptors array is null");
                }
                this.adaptedInterceptors.add(this.adaptInterceptor(interceptor));
            }
        }
    }

    protected HandlerInterceptor adaptInterceptor(Object interceptor) {
        if (interceptor instanceof HandlerInterceptor) {
            HandlerInterceptor handlerInterceptor = (HandlerInterceptor)interceptor;
            return handlerInterceptor;
        }
        if (interceptor instanceof WebRequestInterceptor) {
            WebRequestInterceptor webRequestInterceptor = (WebRequestInterceptor)interceptor;
            return new WebRequestHandlerInterceptorAdapter(webRequestInterceptor);
        }
        throw new IllegalArgumentException("Interceptor type not supported: " + interceptor.getClass().getName());
    }

    @Override
    public boolean usesPathPatterns() {
        return this.getPatternParser() != null;
    }

    @Override
    @Nullable
    public final HandlerExecutionChain getHandler(HttpServletRequest request) throws Exception {
        Object handler = this.getHandlerInternal(request);
        if (handler == null) {
            handler = this.getDefaultHandler();
        }
        if (handler == null) {
            return null;
        }
        if (handler instanceof String) {
            String handlerName = (String)handler;
            handler = this.obtainApplicationContext().getBean(handlerName);
        }
        if (!ServletRequestPathUtils.hasCachedPath((ServletRequest)request)) {
            this.initLookupPath(request);
        }
        HandlerExecutionChain executionChain = this.getHandlerExecutionChain(handler, request);
        if (request.getAttribute(SUPPRESS_LOGGING_ATTRIBUTE) == null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Mapped to " + String.valueOf(handler)));
            } else if (this.logger.isDebugEnabled() && !DispatcherType.ASYNC.equals((Object)request.getDispatcherType())) {
                this.logger.debug((Object)("Mapped to " + String.valueOf(executionChain.getHandler())));
            }
        }
        if (this.hasCorsConfigurationSource(handler) || CorsUtils.isPreFlightRequest((HttpServletRequest)request)) {
            CorsConfiguration config = this.getCorsConfiguration(handler, request);
            if (this.getCorsConfigurationSource() != null) {
                CorsConfiguration globalConfig = this.getCorsConfigurationSource().getCorsConfiguration(request);
                CorsConfiguration corsConfiguration = config = globalConfig != null ? globalConfig.combine(config) : config;
            }
            if (config != null) {
                config.validateAllowCredentials();
                config.validateAllowPrivateNetwork();
            }
            executionChain = this.getCorsHandlerExecutionChain(request, executionChain, config);
        }
        return executionChain;
    }

    @Nullable
    protected abstract Object getHandlerInternal(HttpServletRequest var1) throws Exception;

    protected String initLookupPath(HttpServletRequest request) {
        if (this.usesPathPatterns()) {
            request.removeAttribute(UrlPathHelper.PATH_ATTRIBUTE);
            RequestPath requestPath = this.getRequestPath(request);
            String lookupPath = requestPath.pathWithinApplication().value();
            return UrlPathHelper.defaultInstance.removeSemicolonContent(lookupPath);
        }
        return this.getUrlPathHelper().resolveAndCacheLookupPath(request);
    }

    private RequestPath getRequestPath(HttpServletRequest request) {
        return request.getAttribute(DispatcherServlet.WEB_APPLICATION_CONTEXT_ATTRIBUTE) != null ? ServletRequestPathUtils.getParsedRequestPath((ServletRequest)request) : ServletRequestPathUtils.parseAndCache((HttpServletRequest)request);
    }

    protected HandlerExecutionChain getHandlerExecutionChain(Object handler, HttpServletRequest request) {
        HandlerExecutionChain handlerExecutionChain;
        HandlerExecutionChain chain = handler instanceof HandlerExecutionChain ? (handlerExecutionChain = (HandlerExecutionChain)handler) : new HandlerExecutionChain(handler);
        for (HandlerInterceptor interceptor : this.adaptedInterceptors) {
            if (interceptor instanceof MappedInterceptor) {
                MappedInterceptor mappedInterceptor = (MappedInterceptor)interceptor;
                if (!mappedInterceptor.matches(request)) continue;
                chain.addInterceptor(mappedInterceptor.getInterceptor());
                continue;
            }
            chain.addInterceptor(interceptor);
        }
        return chain;
    }

    protected boolean hasCorsConfigurationSource(Object handler) {
        if (handler instanceof HandlerExecutionChain) {
            HandlerExecutionChain handlerExecutionChain = (HandlerExecutionChain)handler;
            handler = handlerExecutionChain.getHandler();
        }
        return handler instanceof CorsConfigurationSource || this.corsConfigurationSource != null;
    }

    @Nullable
    protected CorsConfiguration getCorsConfiguration(Object handler, HttpServletRequest request) {
        Object resolvedHandler = handler;
        if (handler instanceof HandlerExecutionChain) {
            HandlerExecutionChain handlerExecutionChain = (HandlerExecutionChain)handler;
            resolvedHandler = handlerExecutionChain.getHandler();
        }
        if (resolvedHandler instanceof CorsConfigurationSource) {
            CorsConfigurationSource configSource = (CorsConfigurationSource)resolvedHandler;
            return configSource.getCorsConfiguration(request);
        }
        return null;
    }

    protected HandlerExecutionChain getCorsHandlerExecutionChain(HttpServletRequest request, HandlerExecutionChain chain, @Nullable CorsConfiguration config) {
        if (CorsUtils.isPreFlightRequest((HttpServletRequest)request)) {
            PreFlightHttpRequestHandler handler = new PreFlightHttpRequestHandler(config);
            chain.addInterceptor(0, handler);
            return new HandlerExecutionChain((Object)handler, chain.getInterceptors());
        }
        chain.addInterceptor(0, new CorsInterceptor(config));
        return chain;
    }

    private final class PreFlightHttpRequestHandler
    extends CorsInterceptor
    implements HttpRequestHandler,
    PreFlightRequestHandler {
        public PreFlightHttpRequestHandler(CorsConfiguration config) {
            super(config);
        }

        public void handleRequest(HttpServletRequest request, HttpServletResponse response) {
        }

        public void handlePreFlight(HttpServletRequest request, HttpServletResponse response) throws IOException {
            this.invokeCorsProcessor(request, response);
        }
    }

    private class CorsInterceptor
    implements HandlerInterceptor,
    CorsConfigurationSource {
        @Nullable
        private final CorsConfiguration config;

        public CorsInterceptor(CorsConfiguration config) {
            this.config = config;
        }

        @Nullable
        public CorsConfiguration getCorsConfiguration(HttpServletRequest request) {
            return this.config;
        }

        @Override
        public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
            WebAsyncManager asyncManager = WebAsyncUtils.getAsyncManager((ServletRequest)request);
            if (asyncManager.hasConcurrentResult()) {
                return true;
            }
            return this.invokeCorsProcessor(request, response);
        }

        protected boolean invokeCorsProcessor(HttpServletRequest request, HttpServletResponse response) throws IOException {
            return AbstractHandlerMapping.this.corsProcessor.processRequest(this.config, request, response);
        }
    }
}

