/*
 * SPDX-License-Identifier: ISC
 *
 * Copyright (c) 2021 Todd C. Miller <Todd.Miller@sudo.ws>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <config.h>

#ifndef HAVE_LOCALTIME_R

#include <sys/types.h>
#include <time.h>

#include <sudo_compat.h>
#include <sudo_util.h>

/*
 * Fake localtime_r() that just stores the result.
 * Still has the normal localtime() side effects.
 */
struct tm *
sudo_localtime_r(const time_t * restrict timer, struct tm * restrict result)
{
    struct tm *tm;

    if ((tm = localtime(timer)) == NULL)
	return NULL;
    memcpy(result, tm, sizeof(struct tm));

    return result;
}
#endif /* HAVE_LOCALTIME_T */
