/* -*- mode: C; buffer-read-only: t -*-
 *
 *    regcharclass.h
 *
 *    Copyright (C) 2007, 2011 by Larry Wall and others
 *
 *    You may distribute under the terms of either the GNU General Public
 *    License or the Artistic License, as specified in the README file.
 *
 * !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
 * This file is built by regen/regcharclass.pl.
 * Any changes made here will be lost!
 * WARNING: These macros are for internal Perl core use only, and may be
 * changed or removed without notice.
 */


#ifndef PERL_REGCHARCLASS_H_ /* Guard against nested #includes */
#define PERL_REGCHARCLASS_H_

#if 'A' == 65 /* ASCII/Latin1 */
/*
	LNBREAK: Line Break: \R

	"\x0D\x0A"      # CRLF - Network (Windows) line ending
	\p{VertSpace}
*/
/*** GENERATED CODE ***/
#define is_LNBREAK_safe(s,e,is_utf8)                                        \
( ((e)-(s) > 2) ?                                                           \
    ( ( inRANGE_helper_(U8, ((const U8*)s)[0], '\n', '\f') ) ? 1            \
    : ( '\r' == ((const U8*)s)[0] ) ?                                       \
	( ( '\n' == ((const U8*)s)[1] ) ? 2 : 1 )                           \
    : ( is_utf8 ) ?                                                         \
	( ( 0xC2 == ((const U8*)s)[0] ) ?                                   \
	    ( ( 0x85 == ((const U8*)s)[1] ) ? 2 : 0 )                       \
	: ( ( ( 0xE2 == ((const U8*)s)[0] ) && ( 0x80 == ((const U8*)s)[1] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[2], 0xA8, 0xA9) ) ) ? 3 : 0 )\
    : ( 0x85 == ((const U8*)s)[0] ) )                                       \
: ((e)-(s) > 1) ?                                                           \
    ( ( inRANGE_helper_(U8, ((const U8*)s)[0], '\n', '\f') ) ? 1            \
    : ( '\r' == ((const U8*)s)[0] ) ?                                       \
	( ( '\n' == ((const U8*)s)[1] ) ? 2 : 1 )                           \
    : ( is_utf8 ) ?                                                         \
	( ( ( 0xC2 == ((const U8*)s)[0] ) && ( 0x85 == ((const U8*)s)[1] ) ) ? 2 : 0 )\
    : ( 0x85 == ((const U8*)s)[0] ) )                                       \
: ((e)-(s) > 0) ?                                                           \
    ( ( inRANGE_helper_(U8, ((const U8*)s)[0], '\n', '\r') ) ? 1            \
    : ( !( is_utf8 ) ) ?                                                    \
	( 0x85 == ((const U8*)s)[0] )                                       \
    : 0 )                                                                   \
: 0 )

/*** GENERATED CODE ***/
#define is_LNBREAK_utf8_safe(s,e)                                           \
( ((e)-(s) > 2) ?                                                           \
    ( ( inRANGE_helper_(U8, ((const U8*)s)[0], '\n', '\f') ) ? 1            \
    : ( '\r' == ((const U8*)s)[0] ) ?                                       \
	( ( '\n' == ((const U8*)s)[1] ) ? 2 : 1 )                           \
    : ( 0xC2 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x85 == ((const U8*)s)[1] ) ? 2 : 0 )                           \
    : ( ( ( 0xE2 == ((const U8*)s)[0] ) && ( 0x80 == ((const U8*)s)[1] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[2], 0xA8, 0xA9) ) ) ? 3 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( inRANGE_helper_(U8, ((const U8*)s)[0], '\n', '\f') ) ? 1            \
    : ( '\r' == ((const U8*)s)[0] ) ?                                       \
	( ( '\n' == ((const U8*)s)[1] ) ? 2 : 1 )                           \
    : ( ( 0xC2 == ((const U8*)s)[0] ) && ( 0x85 == ((const U8*)s)[1] ) ) ? 2 : 0 )\
: ((e)-(s) > 0) ?                                                           \
    ( inRANGE_helper_(U8, ((const U8*)s)[0], '\n', '\r') )                  \
: 0 )

/*** GENERATED CODE ***/
#define is_LNBREAK_latin1_safe(s,e)                                         \
( ((e)-(s) > 1) ?                                                           \
    ( ( inRANGE_helper_(U8, ((const U8*)s)[0], '\n', '\f') || 0x85 == ((const U8*)s)[0] ) ? 1\
    : ( '\r' == ((const U8*)s)[0] ) ?                                       \
	( ( '\n' == ((const U8*)s)[1] ) ? 2 : 1 )                           \
    : 0 )                                                                   \
: ((e)-(s) > 0) ?                                                           \
    ( inRANGE_helper_(U8, ((const U8*)s)[0], '\n', '\r') || 0x85 == ((const U8*)s)[0] )\
: 0 )

/*
	HORIZWS: Horizontal Whitespace: \h \H

	\p{HorizSpace}
*/
/*** GENERATED CODE ***/
#define is_HORIZWS_high(s)                                                  \
( ( 0xE1 == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x9A == ((const U8*)s)[1] ) && ( 0x80 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xE2 == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x80 == ((const U8*)s)[1] ) ?                                       \
	( ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x80, 0x8A) || 0xAF == ((const U8*)s)[2] ) ? 3 : 0 )\
    : ( ( 0x81 == ((const U8*)s)[1] ) && ( 0x9F == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( ( ( 0xE3 == ((const U8*)s)[0] ) && ( 0x80 == ((const U8*)s)[1] ) ) && ( 0x80 == ((const U8*)s)[2] ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_HORIZWS_cp_high(cp)                                              \
( 0x1680 == cp || ( 0x1680 < cp &&                                          \
( inRANGE_helper_(UV, cp, 0x2000, 0x200A) || ( 0x200A < cp &&               \
( 0x202F == cp || ( 0x202F < cp &&                                          \
( 0x205F == cp || 0x3000 == cp ) ) ) ) ) ) )

/*
	VERTWS: Vertical Whitespace: \v \V

	\p{VertSpace}
*/
/*** GENERATED CODE ***/
#define is_VERTWS_high(s)                                                   \
( ( ( ( 0xE2 == ((const U8*)s)[0] ) && ( 0x80 == ((const U8*)s)[1] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[2], 0xA8, 0xA9) ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_VERTWS_cp_high(cp)                                               \
( inRANGE_helper_(UV, cp, 0x2028, 0x2029) )

/*
	XDIGIT: Hexadecimal digits

	\p{XDigit}
*/
/*** GENERATED CODE ***/
#define is_XDIGIT_high(s)                                                   \
( ( 0xEF == ((const U8*)s)[0] ) ?                                           \
    ( ( 0xBC == ((const U8*)s)[1] ) ?                                       \
	( ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x90, 0x99) || inRANGE_helper_(U8, ((const U8*)s)[2], 0xA1, 0xA6) ) ? 3 : 0 )\
    : ( ( 0xBD == ((const U8*)s)[1] ) && ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x81, 0x86) ) ) ? 3 : 0 )\
: 0 )

/*** GENERATED CODE ***/
#define is_XDIGIT_cp_high(cp)                                               \
( inRANGE_helper_(UV, cp, 0xFF10, 0xFF19) || ( 0xFF19 < cp &&               \
( inRANGE_helper_(UV, cp, 0xFF21, 0xFF26) || inRANGE_helper_(UV, cp, 0xFF41, 0xFF46) ) ) )

/*
	XPERLSPACE: \p{XPerlSpace}

	\p{XPerlSpace}
*/
/*** GENERATED CODE ***/
#define is_XPERLSPACE_high(s)                                               \
( ( 0xE1 == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x9A == ((const U8*)s)[1] ) && ( 0x80 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xE2 == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x80 == ((const U8*)s)[1] ) ?                                       \
	( ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x80, 0x8A) || inRANGE_helper_(U8, ((const U8*)s)[2], 0xA8, 0xA9) || 0xAF == ((const U8*)s)[2] ) ? 3 : 0 )\
    : ( ( 0x81 == ((const U8*)s)[1] ) && ( 0x9F == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( ( ( 0xE3 == ((const U8*)s)[0] ) && ( 0x80 == ((const U8*)s)[1] ) ) && ( 0x80 == ((const U8*)s)[2] ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_XPERLSPACE_cp_high(cp)                                           \
( 0x1680 == cp || ( 0x1680 < cp &&                                          \
( inRANGE_helper_(UV, cp, 0x2000, 0x200A) || ( 0x200A < cp &&               \
( inRANGE_helper_(UV, cp, 0x2028, 0x2029) || ( 0x2029 < cp &&               \
( 0x202F == cp || ( 0x202F < cp &&                                          \
( 0x205F == cp || 0x3000 == cp ) ) ) ) ) ) ) ) )

/*
	SPACE: Backwards \p{XPerlSpace}

	\p{XPerlSpace}
*/
/*** GENERATED CODE ***/
#define is_SPACE_utf8_safe_backwards(s,e)                                   \
( ((s) - (e) > 2) ?                                                         \
    ( ( inRANGE_helper_(U8, *((const U8*)s - 1), '\t', '\r') || ' ' == *((const U8*)s - 1) ) ? 1\
    : ( 0x80 == *((const U8*)s - 1) ) ?                                     \
	( ( 0x80 == *((const U8*)s - 2) ) ?                                 \
	    ( ( inRANGE_helper_(U8, *((const U8*)s - 3), 0xE2, 0xE3) ) ? 3 : 0 )\
	: ( ( 0x9A == *((const U8*)s - 2) ) && ( 0xE1 == *((const U8*)s - 3) ) ) ? 3 : 0 )\
    : ( inRANGE_helper_(U8, *((const U8*)s - 1), 0x81, 0x84) || inRANGE_helper_(U8, *((const U8*)s - 1), 0x86, 0x8A) || inRANGE_helper_(U8, *((const U8*)s - 1), 0xA8, 0xA9) || 0xAF == *((const U8*)s - 1) ) ?\
	( ( ( 0x80 == *((const U8*)s - 2) ) && ( 0xE2 == *((const U8*)s - 3) ) ) ? 3 : 0 )\
    : ( 0x85 == *((const U8*)s - 1) ) ?                                     \
	( ( 0x80 == *((const U8*)s - 2) ) ?                                 \
	    ( ( 0xE2 == *((const U8*)s - 3) ) ? 3 : 0 )                     \
	: ( 0xC2 == *((const U8*)s - 2) ) ? 2 : 0 )                         \
    : ( 0x9F == *((const U8*)s - 1) ) ?                                     \
	( ( ( 0x81 == *((const U8*)s - 2) ) && ( 0xE2 == *((const U8*)s - 3) ) ) ? 3 : 0 )\
    : ( ( 0xA0 == *((const U8*)s - 1) ) && ( 0xC2 == *((const U8*)s - 2) ) ) ? 2 : 0 )\
: ((s) - (e) > 1) ?                                                         \
    ( ( inRANGE_helper_(U8, *((const U8*)s - 1), '\t', '\r') || ' ' == *((const U8*)s - 1) ) ? 1\
    : ( ( 0x85 == *((const U8*)s - 1) || 0xA0 == *((const U8*)s - 1) ) && ( 0xC2 == *((const U8*)s - 2) ) ) ? 2 : 0 )\
: ((s) - (e) > 0) ?                                                         \
    ( inRANGE_helper_(U8, *((const U8*)s - 1), '\t', '\r') || ' ' == *((const U8*)s - 1) )\
: 0 )

/*
	NONCHAR: Non character code points

	\p{_Perl_Nchar}
*/
/*** GENERATED CODE ***/
#define is_NONCHAR_utf8_safe(s,e)                                           \
( ( ( LIKELY((e) > (s)) ) && ( LIKELY(((e) - (s)) >= UTF8SKIP(s)) ) ) ? ( ( 0xEF == ((const U8*)s)[0] ) ?\
	    ( ( 0xB7 == ((const U8*)s)[1] ) ?                               \
		( ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x90, 0xAF) ) ? 3 : 0 )\
	    : ( ( 0xBF == ((const U8*)s)[1] ) && ( inRANGE_helper_(U8, ((const U8*)s)[2], 0xBE, 0xBF) ) ) ? 3 : 0 )\
	: ( 0xF0 == ((const U8*)s)[0] ) ?                                   \
	    ( ( ( ( ((const U8*)s)[1] == 0x9F || ( ( ((const U8*)s)[1] & 0xEF ) == 0xAF ) ) && ( 0xBF == ((const U8*)s)[2] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[3], 0xBE, 0xBF) ) ) ? 4 : 0 )\
	: ( inRANGE_helper_(U8, ((const U8*)s)[0], 0xF1, 0xF3) ) ?          \
	    ( ( ( ( ( ((const U8*)s)[1] & 0xCF ) == 0x8F ) && ( 0xBF == ((const U8*)s)[2] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[3], 0xBE, 0xBF) ) ) ? 4 : 0 )\
	: ( ( ( ( 0xF4 == ((const U8*)s)[0] ) && ( 0x8F == ((const U8*)s)[1] ) ) && ( 0xBF == ((const U8*)s)[2] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[3], 0xBE, 0xBF) ) ) ? 4 : 0 ) : 0 )

/*
	SHORTER_NON_CHARS: # 3 bytes

	0xFDD0 - 0xFDEF
	0xFFFE - 0xFFFF
*/
/*** GENERATED CODE ***/
#define is_SHORTER_NON_CHARS_utf8(s)                                        \
( ( 0xEF == ((const U8*)s)[0] ) ?                                           \
    ( ( 0xB7 == ((const U8*)s)[1] ) ?                                       \
	( ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x90, 0xAF) ) ? 3 : 0 )  \
    : ( ( 0xBF == ((const U8*)s)[1] ) && ( inRANGE_helper_(U8, ((const U8*)s)[2], 0xBE, 0xBF) ) ) ? 3 : 0 )\
: 0 )

/*
	LARGER_NON_CHARS: # 4 bytes

	0x1FFFE - 0x1FFFF
	0x2FFFE - 0x2FFFF
	0x3FFFE - 0x3FFFF
	0x4FFFE - 0x4FFFF
	0x5FFFE - 0x5FFFF
	0x6FFFE - 0x6FFFF
	0x7FFFE - 0x7FFFF
	0x8FFFE - 0x8FFFF
	0x9FFFE - 0x9FFFF
	0xAFFFE - 0xAFFFF
	0xBFFFE - 0xBFFFF
	0xCFFFE - 0xCFFFF
	0xDFFFE - 0xDFFFF
	0xEFFFE - 0xEFFFF
	0xFFFFE - 0xFFFFF
	0x10FFFE - 0x10FFFF
*/
/*** GENERATED CODE ***/
#define is_LARGER_NON_CHARS_utf8(s)                                         \
( ( 0xF0 == ((const U8*)s)[0] ) ?                                           \
    ( ( ( ( ((const U8*)s)[1] == 0x9F || ( ( ((const U8*)s)[1] & 0xEF ) == 0xAF ) ) && ( 0xBF == ((const U8*)s)[2] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[3], 0xBE, 0xBF) ) ) ? 4 : 0 )\
: ( inRANGE_helper_(U8, ((const U8*)s)[0], 0xF1, 0xF3) ) ?                  \
    ( ( ( ( ( ((const U8*)s)[1] & 0xCF ) == 0x8F ) && ( 0xBF == ((const U8*)s)[2] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[3], 0xBE, 0xBF) ) ) ? 4 : 0 )\
: ( ( ( ( 0xF4 == ((const U8*)s)[0] ) && ( 0x8F == ((const U8*)s)[1] ) ) && ( 0xBF == ((const U8*)s)[2] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[3], 0xBE, 0xBF) ) ) ? 4 : 0 )

/*
	SURROGATE: Surrogate code points

	\p{_Perl_Surrogate}
*/
/*** GENERATED CODE ***/
#define is_SURROGATE_utf8(s)                                                \
( ( ( 0xED == ((const U8*)s)[0] ) && ( inRANGE_helper_(U8, ((const U8*)s)[1], 0xA0, 0xBF) ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_SURROGATE_utf8_safe(s,e)                                         \
( ( ( ( ( ((e) - (s)) >= 3 ) && ( 0xED == ((const U8*)s)[0] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[1], 0xA0, 0xBF) ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x80, 0xBF) ) ) ? 3 : 0 )

/*
	QUOTEMETA: Meta-characters that \Q should quote

	\p{_Perl_Quotemeta}
*/
/*** GENERATED CODE ***/
#define is_QUOTEMETA_high(s)                                                \
( ( 0xCD == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x8F == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xD8 == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x9C == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xE1 == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x85 == ((const U8*)s)[1] ) ?                                       \
	( ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x9F, 0xA0) ) ? 3 : 0 )  \
    : ( 0x9A == ((const U8*)s)[1] ) ?                                       \
	( ( 0x80 == ((const U8*)s)[2] ) ? 3 : 0 )                           \
    : ( 0x9E == ((const U8*)s)[1] ) ?                                       \
	( ( inRANGE_helper_(U8, ((const U8*)s)[2], 0xB4, 0xB5) ) ? 3 : 0 )  \
    : ( ( 0xA0 == ((const U8*)s)[1] ) && ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x8B, 0x8F) ) ) ? 3 : 0 )\
: ( 0xE2 == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x80 == ((const U8*)s)[1] ) ?                                       \
	( ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x80, 0xBE) ) ? 3 : 0 )  \
    : ( 0x81 == ((const U8*)s)[1] ) ?                                       \
	( ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x81, 0x93) || inRANGE_helper_(U8, ((const U8*)s)[2], 0x95, 0xAF) ) ? 3 : 0 )\
    : ( 0x86 == ((const U8*)s)[1] ) ?                                       \
	( ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x90, 0xBF) ) ? 3 : 0 )  \
    : ( inRANGE_helper_(U8, ((const U8*)s)[1], 0x87, 0x90) || inRANGE_helper_(U8, ((const U8*)s)[1], 0x94, 0x9C) || inRANGE_helper_(U8, ((const U8*)s)[1], 0x9F, 0xAF) || inRANGE_helper_(U8, ((const U8*)s)[1], 0xB8, 0xB9) ) ?\
	3                                                                   \
    : ( 0x91 == ((const U8*)s)[1] ) ?                                       \
	( ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x80, 0x9F) ) ? 3 : 0 )  \
    : ( 0x9D == ((const U8*)s)[1] ) ?                                       \
	( ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x80, 0xB5) ) ? 3 : 0 )  \
    : ( ( 0x9E == ((const U8*)s)[1] ) && ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x94, 0xBF) ) ) ? 3 : 0 )\
: ( 0xE3 == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x80 == ((const U8*)s)[1] ) ?                                       \
	( ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x80, 0x83) || inRANGE_helper_(U8, ((const U8*)s)[2], 0x88, 0xA0) || 0xB0 == ((const U8*)s)[2] ) ? 3 : 0 )\
    : ( ( 0x85 == ((const U8*)s)[1] ) && ( 0xA4 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xEF == ((const U8*)s)[0] ) ?                                           \
    ( ( 0xB4 == ((const U8*)s)[1] ) ?                                       \
	( ( inRANGE_helper_(U8, ((const U8*)s)[2], 0xBE, 0xBF) ) ? 3 : 0 )  \
    : ( 0xB8 == ((const U8*)s)[1] ) ?                                       \
	( ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x80, 0x8F) ) ? 3 : 0 )  \
    : ( 0xB9 == ((const U8*)s)[1] ) ?                                       \
	( ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x85, 0x86) ) ? 3 : 0 )  \
    : ( 0xBB == ((const U8*)s)[1] ) ?                                       \
	( ( 0xBF == ((const U8*)s)[2] ) ? 3 : 0 )                           \
    : ( 0xBE == ((const U8*)s)[1] ) ?                                       \
	( ( 0xA0 == ((const U8*)s)[2] ) ? 3 : 0 )                           \
    : ( ( 0xBF == ((const U8*)s)[1] ) && ( inRANGE_helper_(U8, ((const U8*)s)[2], 0xB0, 0xB8) ) ) ? 3 : 0 )\
: ( 0xF0 == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x9B == ((const U8*)s)[1] ) ?                                       \
	( ( ( 0xB2 == ((const U8*)s)[2] ) && ( inRANGE_helper_(U8, ((const U8*)s)[3], 0xA0, 0xA3) ) ) ? 4 : 0 )\
    : ( ( ( 0x9D == ((const U8*)s)[1] ) && ( 0x85 == ((const U8*)s)[2] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[3], 0xB3, 0xBA) ) ) ? 4 : 0 )\
: ( ( 0xF3 == ((const U8*)s)[0] ) && ( 0xA0 == ((const U8*)s)[1] ) ) ? 4 : 0 )

/*
	MULTI_CHAR_FOLD: multi-char strings that are folded to by a single character

	%regcharclass_multi_char_folds::multi_char_folds('u', 'a')
*/
/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part0_(s,e)                            \
( ( ( ((const U8*)s)[1] & 0xDF ) == 'F' ) ?                                 \
	    ( ( ( ( ((const U8*)s)[2] & 0xDF ) == 'I' ) || ( ( ((const U8*)s)[2] & 0xDF ) == 'L' ) ) ? 3 : 2 )\
	: ( ( ( ((const U8*)s)[1] & 0xDF ) == 'I' ) || ( ( ((const U8*)s)[1] & 0xDF ) == 'L' ) ) ? 2 : 0 )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part1_(s,e)                            \
( ( ( ((const U8*)s)[0] & 0xDF ) == 'H' ) ?                                 \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0xB1 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'I' ) ?                             \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x87 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'J' ) ?                             \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x8C == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'S' ) ?                             \
	( ( inRANGE_helper_(U8, ((const U8*)s)[1], 'S', 'T') || inRANGE_helper_(U8, ((const U8*)s)[1], 's', 't') ) ? 2\
	: ( ( 0xC5 == ((const U8*)s)[1] ) && ( 0xBF == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'T' ) ?                             \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x88 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ( ((const U8*)s)[0] & 0xDF ) == 'W' ) || ( ( ((const U8*)s)[0] & 0xDF ) == 'Y' ) ) ?\
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x8A == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xC5 == ((const U8*)s)[0] ) ?                                       \
	( ( 0xBF == ((const U8*)s)[1] ) ?                                   \
	    ( ( inRANGE_helper_(U8, ((const U8*)s)[2], 'S', 'T') || inRANGE_helper_(U8, ((const U8*)s)[2], 's', 't') ) ? 3\
	    : ( ( 0xC5 == ((const U8*)s)[2] ) && ( 0xBF == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: 0 )                                                               \
    : ( 0xCA == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xBC == ((const U8*)s)[1] ) && ( ( ((const U8*)s)[2] & 0xDF ) == 'N' ) ) ? 3 : 0 )\
    : ( 0xCE == ((const U8*)s)[0] ) ?                                       \
	( ( ( ((const U8*)s)[1] & 0xFD ) == 0xAC ) ?                        \
	    ( ( ( 0xCE == ((const U8*)s)[2] ) && ( 0xB9 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0xB1 == ((const U8*)s)[1] || 0xB7 == ((const U8*)s)[1] ) ?      \
	    ( ( 0xCD == ((const U8*)s)[2] ) ?                               \
		( ( 0x82 == ((const U8*)s)[3] ) ?                           \
		    ( ( ( 0xCE == ((const U8*)s)[4] ) && ( 0xB9 == ((const U8*)s)[5] ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xCE == ((const U8*)s)[2] ) && ( 0xB9 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0xB9 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xCC == ((const U8*)s)[2] ) ?                               \
		( ( 0x88 == ((const U8*)s)[3] ) ?                           \
		    ( ( 0xCC == ((const U8*)s)[4] ) ?                       \
			( ( inRANGE_helper_(U8, ((const U8*)s)[5], 0x80, 0x81) ) ? 6 : 0 )\
		    : ( ( 0xCD == ((const U8*)s)[4] ) && ( 0x82 == ((const U8*)s)[5] ) ) ? 6 : 0 )\
		: 0 )                                                       \
	    : ( ( 0xCD == ((const U8*)s)[2] ) && ( 0x82 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: 0 )                                                               \
    : ( 0xCF == ((const U8*)s)[0] ) ?                                       \
	( ( 0x81 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xCC == ((const U8*)s)[2] ) && ( 0x93 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x85 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xCC == ((const U8*)s)[2] ) ?                               \
		( ( 0x88 == ((const U8*)s)[3] ) ?                           \
		    ( ( 0xCC == ((const U8*)s)[4] ) ?                       \
			( ( inRANGE_helper_(U8, ((const U8*)s)[5], 0x80, 0x81) ) ? 6 : 0 )\
		    : ( ( 0xCD == ((const U8*)s)[4] ) && ( 0x82 == ((const U8*)s)[5] ) ) ? 6 : 0 )\
		: ( 0x93 == ((const U8*)s)[3] ) ?                           \
		    ( ( 0xCC == ((const U8*)s)[4] ) ?                       \
			( ( inRANGE_helper_(U8, ((const U8*)s)[5], 0x80, 0x81) ) ? 6 : 4 )\
		    : ( ( 0xCD == ((const U8*)s)[4] ) && ( 0x82 == ((const U8*)s)[5] ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xCD == ((const U8*)s)[2] ) && ( 0x82 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x89 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xCD == ((const U8*)s)[2] ) ?                               \
		( ( 0x82 == ((const U8*)s)[3] ) ?                           \
		    ( ( ( 0xCE == ((const U8*)s)[4] ) && ( 0xB9 == ((const U8*)s)[5] ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xCE == ((const U8*)s)[2] ) && ( 0xB9 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x8E == ((const U8*)s)[1] ) && ( 0xCE == ((const U8*)s)[2] ) ) && ( 0xB9 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xD5 == ((const U8*)s)[0] ) ?                                       \
	( ( 0xA5 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xD6 == ((const U8*)s)[2] ) && ( 0x82 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0xB4 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xD5 == ((const U8*)s)[2] ) && ( ( ( ((const U8*)s)[3] & 0xF7 ) == 0xA5 ) || ((const U8*)s)[3] == 0xAB || ((const U8*)s)[3] == 0xB6 ) ) ? 4 : 0 )\
	: ( ( ( 0xBE == ((const U8*)s)[1] ) && ( 0xD5 == ((const U8*)s)[2] ) ) && ( 0xB6 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xE1 == ((const U8*)s)[0] ) ?                                       \
	( ( 0xBC == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( ( ( ((const U8*)s)[2] & 0xD8 ) == 0x80 ) && ( 0xCE == ((const U8*)s)[3] ) ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 5 : 0 )\
	: ( ( ( ( 0xBD == ((const U8*)s)[1] ) && ( ( ( ((const U8*)s)[2] & 0xF8 ) == 0xA0 ) || ( ( ((const U8*)s)[2] & 0xFB ) == 0xB0 ) || ((const U8*)s)[2] == 0xBC ) ) && ( 0xCE == ((const U8*)s)[3] ) ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 5 : 0 )\
    : 0 )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part2_(s,e)                            \
( ( ( ((const U8*)s)[0] & 0xDF ) == 'A' ) ?                                 \
	( ( ( 0xCA == ((const U8*)s)[1] ) && ( 0xBE == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'F' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xDF ) == 'F' ) ?                         \
	    ( ( ( ( ((const U8*)s)[2] & 0xDF ) == 'I' ) || ( ( ((const U8*)s)[2] & 0xDF ) == 'L' ) ) ? 3 : 2 )\
	: ( ( ( ((const U8*)s)[1] & 0xDF ) == 'I' ) || ( ( ((const U8*)s)[1] & 0xDF ) == 'L' ) ) ? 2 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'H' ) ?                             \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0xB1 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'I' ) ?                             \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x87 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'J' ) ?                             \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x8C == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'S' ) ?                             \
	( ( inRANGE_helper_(U8, ((const U8*)s)[1], 'S', 'T') || inRANGE_helper_(U8, ((const U8*)s)[1], 's', 't') ) ? 2\
	: ( ( 0xC5 == ((const U8*)s)[1] ) && ( 0xBF == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'T' ) ?                             \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x88 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ( ((const U8*)s)[0] & 0xDF ) == 'W' ) || ( ( ((const U8*)s)[0] & 0xDF ) == 'Y' ) ) ?\
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x8A == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xC5 == ((const U8*)s)[0] ) ?                                       \
	( ( 0xBF == ((const U8*)s)[1] ) ?                                   \
	    ( ( inRANGE_helper_(U8, ((const U8*)s)[2], 'S', 'T') || inRANGE_helper_(U8, ((const U8*)s)[2], 's', 't') ) ? 3\
	    : ( ( 0xC5 == ((const U8*)s)[2] ) && ( 0xBF == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: 0 )                                                               \
    : ( 0xCA == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xBC == ((const U8*)s)[1] ) && ( ( ((const U8*)s)[2] & 0xDF ) == 'N' ) ) ? 3 : 0 )\
    : ( 0xCE == ((const U8*)s)[0] ) ?                                       \
	( ( ( ((const U8*)s)[1] & 0xFD ) == 0xAC ) ?                        \
	    ( ( ( 0xCE == ((const U8*)s)[2] ) && ( 0xB9 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0xB1 == ((const U8*)s)[1] || 0xB7 == ((const U8*)s)[1] ) ?      \
	    ( ( 0xCD == ((const U8*)s)[2] ) ?                               \
		( ( 0x82 == ((const U8*)s)[3] ) ? 4 : 0 )                   \
	    : ( ( 0xCE == ((const U8*)s)[2] ) && ( 0xB9 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0xB9 == ((const U8*)s)[1] ) && ( 0xCD == ((const U8*)s)[2] ) ) && ( 0x82 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xCF == ((const U8*)s)[0] ) ?                                       \
	( ( 0x81 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xCC == ((const U8*)s)[2] ) && ( 0x93 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x85 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xCC == ((const U8*)s)[2] ) ?                               \
		( ( 0x93 == ((const U8*)s)[3] ) ? 4 : 0 )                   \
	    : ( ( 0xCD == ((const U8*)s)[2] ) && ( 0x82 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x89 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xCD == ((const U8*)s)[2] ) ?                               \
		( ( 0x82 == ((const U8*)s)[3] ) ? 4 : 0 )                   \
	    : ( ( 0xCE == ((const U8*)s)[2] ) && ( 0xB9 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x8E == ((const U8*)s)[1] ) && ( 0xCE == ((const U8*)s)[2] ) ) && ( 0xB9 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xD5 == ((const U8*)s)[0] ) ?                                       \
	( ( 0xA5 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xD6 == ((const U8*)s)[2] ) && ( 0x82 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0xB4 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xD5 == ((const U8*)s)[2] ) && ( ( ( ((const U8*)s)[3] & 0xF7 ) == 0xA5 ) || ((const U8*)s)[3] == 0xAB || ((const U8*)s)[3] == 0xB6 ) ) ? 4 : 0 )\
	: ( ( ( 0xBE == ((const U8*)s)[1] ) && ( 0xD5 == ((const U8*)s)[2] ) ) && ( 0xB6 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : 0 )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part3_(s,e)                            \
( ((e)-(s) > 2) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xDF ) == 'A' ) ?                             \
	( ( ( 0xCA == ((const U8*)s)[1] ) && ( 0xBE == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'F' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xDF ) == 'F' ) ?                         \
	    ( ( ( ( ((const U8*)s)[2] & 0xDF ) == 'I' ) || ( ( ((const U8*)s)[2] & 0xDF ) == 'L' ) ) ? 3 : 2 )\
	: ( ( ( ((const U8*)s)[1] & 0xDF ) == 'I' ) || ( ( ((const U8*)s)[1] & 0xDF ) == 'L' ) ) ? 2 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'H' ) ?                             \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0xB1 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'I' ) ?                             \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x87 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'J' ) ?                             \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x8C == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'S' ) ?                             \
	( ( inRANGE_helper_(U8, ((const U8*)s)[1], 'S', 'T') || inRANGE_helper_(U8, ((const U8*)s)[1], 's', 't') ) ? 2\
	: ( ( 0xC5 == ((const U8*)s)[1] ) && ( 0xBF == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'T' ) ?                             \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x88 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ( ((const U8*)s)[0] & 0xDF ) == 'W' ) || ( ( ((const U8*)s)[0] & 0xDF ) == 'Y' ) ) ?\
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x8A == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xC5 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xBF == ((const U8*)s)[1] ) && ( inRANGE_helper_(U8, ((const U8*)s)[2], 'S', 'T') || inRANGE_helper_(U8, ((const U8*)s)[2], 's', 't') ) ) ? 3 : 0 )\
    : ( ( ( 0xCA == ((const U8*)s)[0] ) && ( 0xBC == ((const U8*)s)[1] ) ) && ( ( ((const U8*)s)[2] & 0xDF ) == 'N' ) ) ? 3 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xDF ) == 'F' ) ?                             \
	( ( ( ( ((const U8*)s)[1] & 0xDF ) == 'F' ) || ( ( ((const U8*)s)[1] & 0xDF ) == 'I' ) || ( ( ((const U8*)s)[1] & 0xDF ) == 'L' ) ) ? 2 : 0 )\
    : ( ( ( ((const U8*)s)[0] & 0xDF ) == 'S' ) && ( inRANGE_helper_(U8, ((const U8*)s)[1], 'S', 'T') || inRANGE_helper_(U8, ((const U8*)s)[1], 's', 't') ) ) ? 2 : 0 )\
: 0 )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe(s,e)                                   \
( ((e)-(s) > 5) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xDF ) == 'A' ) ?                             \
	( ( ( 0xCA == ((const U8*)s)[1] ) && ( 0xBE == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'F' ) ? is_MULTI_CHAR_FOLD_utf8_safe_part0_(s,e) : is_MULTI_CHAR_FOLD_utf8_safe_part1_(s,e) )\
: ((e)-(s) > 4) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xDF ) == 'A' ) ?                             \
	( ( ( 0xCA == ((const U8*)s)[1] ) && ( 0xBE == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'F' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xDF ) == 'F' ) ?                         \
	    ( ( ( ( ((const U8*)s)[2] & 0xDF ) == 'I' ) || ( ( ((const U8*)s)[2] & 0xDF ) == 'L' ) ) ? 3 : 2 )\
	: ( ( ( ((const U8*)s)[1] & 0xDF ) == 'I' ) || ( ( ((const U8*)s)[1] & 0xDF ) == 'L' ) ) ? 2 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'H' ) ?                             \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0xB1 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'I' ) ?                             \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x87 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'J' ) ?                             \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x8C == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'S' ) ?                             \
	( ( inRANGE_helper_(U8, ((const U8*)s)[1], 'S', 'T') || inRANGE_helper_(U8, ((const U8*)s)[1], 's', 't') ) ? 2\
	: ( ( 0xC5 == ((const U8*)s)[1] ) && ( 0xBF == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'T' ) ?                             \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x88 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ( ((const U8*)s)[0] & 0xDF ) == 'W' ) || ( ( ((const U8*)s)[0] & 0xDF ) == 'Y' ) ) ?\
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x8A == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xC5 == ((const U8*)s)[0] ) ?                                       \
	( ( 0xBF == ((const U8*)s)[1] ) ?                                   \
	    ( ( inRANGE_helper_(U8, ((const U8*)s)[2], 'S', 'T') || inRANGE_helper_(U8, ((const U8*)s)[2], 's', 't') ) ? 3\
	    : ( ( 0xC5 == ((const U8*)s)[2] ) && ( 0xBF == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: 0 )                                                               \
    : ( 0xCA == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xBC == ((const U8*)s)[1] ) && ( ( ((const U8*)s)[2] & 0xDF ) == 'N' ) ) ? 3 : 0 )\
    : ( 0xCE == ((const U8*)s)[0] ) ?                                       \
	( ( ( ((const U8*)s)[1] & 0xFD ) == 0xAC ) ?                        \
	    ( ( ( 0xCE == ((const U8*)s)[2] ) && ( 0xB9 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0xB1 == ((const U8*)s)[1] || 0xB7 == ((const U8*)s)[1] ) ?      \
	    ( ( 0xCD == ((const U8*)s)[2] ) ?                               \
		( ( 0x82 == ((const U8*)s)[3] ) ? 4 : 0 )                   \
	    : ( ( 0xCE == ((const U8*)s)[2] ) && ( 0xB9 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0xB9 == ((const U8*)s)[1] ) && ( 0xCD == ((const U8*)s)[2] ) ) && ( 0x82 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xCF == ((const U8*)s)[0] ) ?                                       \
	( ( 0x81 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xCC == ((const U8*)s)[2] ) && ( 0x93 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x85 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xCC == ((const U8*)s)[2] ) ?                               \
		( ( 0x93 == ((const U8*)s)[3] ) ? 4 : 0 )                   \
	    : ( ( 0xCD == ((const U8*)s)[2] ) && ( 0x82 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x89 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xCD == ((const U8*)s)[2] ) ?                               \
		( ( 0x82 == ((const U8*)s)[3] ) ? 4 : 0 )                   \
	    : ( ( 0xCE == ((const U8*)s)[2] ) && ( 0xB9 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x8E == ((const U8*)s)[1] ) && ( 0xCE == ((const U8*)s)[2] ) ) && ( 0xB9 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xD5 == ((const U8*)s)[0] ) ?                                       \
	( ( 0xA5 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xD6 == ((const U8*)s)[2] ) && ( 0x82 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0xB4 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xD5 == ((const U8*)s)[2] ) && ( ( ( ((const U8*)s)[3] & 0xF7 ) == 0xA5 ) || ((const U8*)s)[3] == 0xAB || ((const U8*)s)[3] == 0xB6 ) ) ? 4 : 0 )\
	: ( ( ( 0xBE == ((const U8*)s)[1] ) && ( 0xD5 == ((const U8*)s)[2] ) ) && ( 0xB6 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xE1 == ((const U8*)s)[0] ) ?                                       \
	( ( 0xBC == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( ( ( ((const U8*)s)[2] & 0xD8 ) == 0x80 ) && ( 0xCE == ((const U8*)s)[3] ) ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 5 : 0 )\
	: ( ( ( ( 0xBD == ((const U8*)s)[1] ) && ( ( ( ((const U8*)s)[2] & 0xF8 ) == 0xA0 ) || ( ( ((const U8*)s)[2] & 0xFB ) == 0xB0 ) || ((const U8*)s)[2] == 0xBC ) ) && ( 0xCE == ((const U8*)s)[3] ) ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 5 : 0 )\
    : 0 )                                                                   \
: ((e)-(s) > 3) ? is_MULTI_CHAR_FOLD_utf8_safe_part2_(s,e) : is_MULTI_CHAR_FOLD_utf8_safe_part3_(s,e) )

/*** GENERATED CODE ***/
#define what_MULTI_CHAR_FOLD_utf8_safe_part0_(s,e)                          \
( ( 0x81 == ((const U8*)s)[1] ) ?                                           \
	    ( ( ( 0xCC == ((const U8*)s)[2] ) && ( 0x93 == ((const U8*)s)[3] ) ) ? 0x1FE4 : 0 )\
	: ( 0x85 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xCC == ((const U8*)s)[2] ) ?                               \
		( ( 0x88 == ((const U8*)s)[3] ) ?                           \
		    ( ( 0xCC == ((const U8*)s)[4] ) ?                       \
			( ( 0x80 == ((const U8*)s)[5] ) ? 0x1FE2            \
			: ( 0x81 == ((const U8*)s)[5] ) ? 0x3B0 : 0 )       \
		    : ( ( 0xCD == ((const U8*)s)[4] ) && ( 0x82 == ((const U8*)s)[5] ) ) ? 0x1FE7 : 0 )\
		: ( 0x93 == ((const U8*)s)[3] ) ?                           \
		    ( ( 0xCC == ((const U8*)s)[4] ) ?                       \
			( ( 0x80 == ((const U8*)s)[5] ) ? 0x1F52            \
			: ( 0x81 == ((const U8*)s)[5] ) ? 0x1F54 : 0x1F50 ) \
		    : ( ( 0xCD == ((const U8*)s)[4] ) && ( 0x82 == ((const U8*)s)[5] ) ) ? 0x1F56 : 0x1F50 )\
		: 0 )                                                       \
	    : ( ( 0xCD == ((const U8*)s)[2] ) && ( 0x82 == ((const U8*)s)[3] ) ) ? 0x1FE6 : 0 )\
	: ( 0x89 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xCD == ((const U8*)s)[2] ) ?                               \
		( ( 0x82 == ((const U8*)s)[3] ) ?                           \
		    ( ( ( 0xCE == ((const U8*)s)[4] ) && ( 0xB9 == ((const U8*)s)[5] ) ) ? 0x1FF7 : 0x1FF6 )\
		: 0 )                                                       \
	    : ( ( 0xCE == ((const U8*)s)[2] ) && ( 0xB9 == ((const U8*)s)[3] ) ) ? 0x1FF3 : 0 )\
	: ( ( ( 0x8E == ((const U8*)s)[1] ) && ( 0xCE == ((const U8*)s)[2] ) ) && ( 0xB9 == ((const U8*)s)[3] ) ) ? 0x1FF4 : 0 )


/*** GENERATED CODE ***/
#define what_MULTI_CHAR_FOLD_utf8_safe_part1_(s,e)                          \
( ( 0xD5 == ((const U8*)s)[0] ) ?                                           \
	( ( 0xA5 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xD6 == ((const U8*)s)[2] ) && ( 0x82 == ((const U8*)s)[3] ) ) ? 0x587 : 0 )\
	: ( 0xB4 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xD5 == ((const U8*)s)[2] ) ?                               \
		( ( 0xA5 == ((const U8*)s)[3] ) ? 0xFB14                    \
		: ( 0xAB == ((const U8*)s)[3] ) ? 0xFB15                    \
		: ( 0xAD == ((const U8*)s)[3] ) ? 0xFB17                    \
		: ( 0xB6 == ((const U8*)s)[3] ) ? 0xFB13 : 0 )              \
	    : 0 )                                                           \
	: ( ( ( 0xBE == ((const U8*)s)[1] ) && ( 0xD5 == ((const U8*)s)[2] ) ) && ( 0xB6 == ((const U8*)s)[3] ) ) ? 0xFB16 : 0 )\
    : ( 0xE1 == ((const U8*)s)[0] ) ?                                       \
	( ( 0xBC == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x80 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1F80 : 0 )\
	    : ( 0x81 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1F81 : 0 )\
	    : ( 0x82 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1F82 : 0 )\
	    : ( 0x83 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1F83 : 0 )\
	    : ( 0x84 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1F84 : 0 )\
	    : ( 0x85 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1F85 : 0 )\
	    : ( 0x86 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1F86 : 0 )\
	    : ( 0x87 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1F87 : 0 )\
	    : ( 0xA0 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1F90 : 0 )\
	    : ( 0xA1 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1F91 : 0 )\
	    : ( 0xA2 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1F92 : 0 )\
	    : ( 0xA3 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1F93 : 0 )\
	    : ( 0xA4 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1F94 : 0 )\
	    : ( 0xA5 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1F95 : 0 )\
	    : ( 0xA6 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1F96 : 0 )\
	    : ( ( ( 0xA7 == ((const U8*)s)[2] ) && ( 0xCE == ((const U8*)s)[3] ) ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1F97 : 0 )\
	: ( 0xBD == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xA0 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1FA0 : 0 )\
	    : ( 0xA1 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1FA1 : 0 )\
	    : ( 0xA2 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1FA2 : 0 )\
	    : ( 0xA3 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1FA3 : 0 )\
	    : ( 0xA4 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1FA4 : 0 )\
	    : ( 0xA5 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1FA5 : 0 )\
	    : ( 0xA6 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1FA6 : 0 )\
	    : ( 0xA7 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1FA7 : 0 )\
	    : ( 0xB0 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1FB2 : 0 )\
	    : ( 0xB4 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1FC2 : 0 )\
	    : ( ( ( 0xBC == ((const U8*)s)[2] ) && ( 0xCE == ((const U8*)s)[3] ) ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1FF2 : 0 )\
	: 0 )                                                               \
    : 0 )


/*** GENERATED CODE ***/
#define what_MULTI_CHAR_FOLD_utf8_safe_part2_(s,e)                          \
( ( 0x81 == ((const U8*)s)[1] ) ?                                           \
	    ( ( ( 0xCC == ((const U8*)s)[2] ) && ( 0x93 == ((const U8*)s)[3] ) ) ? 0x1FE4 : 0 )\
	: ( 0x85 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xCC == ((const U8*)s)[2] ) ?                               \
		( ( 0x93 == ((const U8*)s)[3] ) ? 0x1F50 : 0 )              \
	    : ( ( 0xCD == ((const U8*)s)[2] ) && ( 0x82 == ((const U8*)s)[3] ) ) ? 0x1FE6 : 0 )\
	: ( 0x89 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xCD == ((const U8*)s)[2] ) ?                               \
		( ( 0x82 == ((const U8*)s)[3] ) ? 0x1FF6 : 0 )              \
	    : ( ( 0xCE == ((const U8*)s)[2] ) && ( 0xB9 == ((const U8*)s)[3] ) ) ? 0x1FF3 : 0 )\
	: ( ( ( 0x8E == ((const U8*)s)[1] ) && ( 0xCE == ((const U8*)s)[2] ) ) && ( 0xB9 == ((const U8*)s)[3] ) ) ? 0x1FF4 : 0 )


/*** GENERATED CODE ***/
#define what_MULTI_CHAR_FOLD_utf8_safe_part3_(s,e)                          \
( ( 0xD5 == ((const U8*)s)[0] ) ?                                           \
	( ( 0xA5 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xD6 == ((const U8*)s)[2] ) && ( 0x82 == ((const U8*)s)[3] ) ) ? 0x587 : 0 )\
	: ( 0xB4 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xD5 == ((const U8*)s)[2] ) ?                               \
		( ( 0xA5 == ((const U8*)s)[3] ) ? 0xFB14                    \
		: ( 0xAB == ((const U8*)s)[3] ) ? 0xFB15                    \
		: ( 0xAD == ((const U8*)s)[3] ) ? 0xFB17                    \
		: ( 0xB6 == ((const U8*)s)[3] ) ? 0xFB13 : 0 )              \
	    : 0 )                                                           \
	: ( ( ( 0xBE == ((const U8*)s)[1] ) && ( 0xD5 == ((const U8*)s)[2] ) ) && ( 0xB6 == ((const U8*)s)[3] ) ) ? 0xFB16 : 0 )\
    : ( 0xE1 == ((const U8*)s)[0] ) ?                                       \
	( ( 0xBC == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x80 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1F80 : 0 )\
	    : ( 0x81 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1F81 : 0 )\
	    : ( 0x82 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1F82 : 0 )\
	    : ( 0x83 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1F83 : 0 )\
	    : ( 0x84 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1F84 : 0 )\
	    : ( 0x85 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1F85 : 0 )\
	    : ( 0x86 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1F86 : 0 )\
	    : ( 0x87 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1F87 : 0 )\
	    : ( 0xA0 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1F90 : 0 )\
	    : ( 0xA1 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1F91 : 0 )\
	    : ( 0xA2 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1F92 : 0 )\
	    : ( 0xA3 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1F93 : 0 )\
	    : ( 0xA4 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1F94 : 0 )\
	    : ( 0xA5 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1F95 : 0 )\
	    : ( 0xA6 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1F96 : 0 )\
	    : ( ( ( 0xA7 == ((const U8*)s)[2] ) && ( 0xCE == ((const U8*)s)[3] ) ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1F97 : 0 )\
	: ( 0xBD == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xA0 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1FA0 : 0 )\
	    : ( 0xA1 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1FA1 : 0 )\
	    : ( 0xA2 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1FA2 : 0 )\
	    : ( 0xA3 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1FA3 : 0 )\
	    : ( 0xA4 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1FA4 : 0 )\
	    : ( 0xA5 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1FA5 : 0 )\
	    : ( 0xA6 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1FA6 : 0 )\
	    : ( 0xA7 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1FA7 : 0 )\
	    : ( 0xB0 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1FB2 : 0 )\
	    : ( 0xB4 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xCE == ((const U8*)s)[3] ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1FC2 : 0 )\
	    : ( ( ( 0xBC == ((const U8*)s)[2] ) && ( 0xCE == ((const U8*)s)[3] ) ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 0x1FF2 : 0 )\
	: 0 )                                                               \
    : 0 )


/*** GENERATED CODE ***/
#define what_MULTI_CHAR_FOLD_utf8_safe_part4_(s,e)                          \
( ( ( ((const U8*)s)[0] & 0xDF ) == 'A' ) ?                                 \
	( ( ( 0xCA == ((const U8*)s)[1] ) && ( 0xBE == ((const U8*)s)[2] ) ) ? 0x1E9A : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'F' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xDF ) == 'F' ) ?                         \
	    ( ( ( ((const U8*)s)[2] & 0xDF ) == 'I' ) ? 0xFB03              \
	    : ( ( ((const U8*)s)[2] & 0xDF ) == 'L' ) ? 0xFB04 : 0xFB00 )   \
	: ( ( ((const U8*)s)[1] & 0xDF ) == 'I' ) ? 0xFB01                  \
	: ( ( ((const U8*)s)[1] & 0xDF ) == 'L' ) ? 0xFB02 : 0 )            \
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'H' ) ?                             \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0xB1 == ((const U8*)s)[2] ) ) ? 0x1E96 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'I' ) ?                             \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x87 == ((const U8*)s)[2] ) ) ? 0x130 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'J' ) ?                             \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x8C == ((const U8*)s)[2] ) ) ? 0x1F0 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'S' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xDF ) == 'S' ) ? 0xDF                    \
	: ( ( ((const U8*)s)[1] & 0xDF ) == 'T' ) ? 0xFB05                  \
	: ( ( 0xC5 == ((const U8*)s)[1] ) && ( 0xBF == ((const U8*)s)[2] ) ) ? 0xDF : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'T' ) ?                             \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x88 == ((const U8*)s)[2] ) ) ? 0x1E97 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'W' ) ?                             \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x8A == ((const U8*)s)[2] ) ) ? 0x1E98 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'Y' ) ?                             \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x8A == ((const U8*)s)[2] ) ) ? 0x1E99 : 0 )\
    : ( 0xC5 == ((const U8*)s)[0] ) ?                                       \
	( ( 0xBF == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( ((const U8*)s)[2] & 0xDF ) == 'S' ) ? 0xDF                \
	    : ( ( ((const U8*)s)[2] & 0xDF ) == 'T' ) ? 0xFB05              \
	    : ( ( 0xC5 == ((const U8*)s)[2] ) && ( 0xBF == ((const U8*)s)[3] ) ) ? 0xDF : 0 )\
	: 0 )                                                               \
    : ( 0xCA == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xBC == ((const U8*)s)[1] ) && ( ( ((const U8*)s)[2] & 0xDF ) == 'N' ) ) ? 0x149 : 0 )\
    : ( 0xCE == ((const U8*)s)[0] ) ?                                       \
	( ( 0xAC == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xCE == ((const U8*)s)[2] ) && ( 0xB9 == ((const U8*)s)[3] ) ) ? 0x1FB4 : 0 )\
	: ( 0xAE == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xCE == ((const U8*)s)[2] ) && ( 0xB9 == ((const U8*)s)[3] ) ) ? 0x1FC4 : 0 )\
	: ( 0xB1 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xCD == ((const U8*)s)[2] ) ?                               \
		( ( 0x82 == ((const U8*)s)[3] ) ? 0x1FB6 : 0 )              \
	    : ( ( 0xCE == ((const U8*)s)[2] ) && ( 0xB9 == ((const U8*)s)[3] ) ) ? 0x1FB3 : 0 )\
	: ( 0xB7 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xCD == ((const U8*)s)[2] ) ?                               \
		( ( 0x82 == ((const U8*)s)[3] ) ? 0x1FC6 : 0 )              \
	    : ( ( 0xCE == ((const U8*)s)[2] ) && ( 0xB9 == ((const U8*)s)[3] ) ) ? 0x1FC3 : 0 )\
	: ( ( ( 0xB9 == ((const U8*)s)[1] ) && ( 0xCD == ((const U8*)s)[2] ) ) && ( 0x82 == ((const U8*)s)[3] ) ) ? 0x1FD6 : 0 )\
    : ( 0xCF == ((const U8*)s)[0] ) ?                                       \
	( ( 0x81 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xCC == ((const U8*)s)[2] ) && ( 0x93 == ((const U8*)s)[3] ) ) ? 0x1FE4 : 0 )\
	: ( 0x85 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xCC == ((const U8*)s)[2] ) ?                               \
		( ( 0x93 == ((const U8*)s)[3] ) ? 0x1F50 : 0 )              \
	    : ( ( 0xCD == ((const U8*)s)[2] ) && ( 0x82 == ((const U8*)s)[3] ) ) ? 0x1FE6 : 0 )\
	: ( 0x89 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xCD == ((const U8*)s)[2] ) ?                               \
		( ( 0x82 == ((const U8*)s)[3] ) ? 0x1FF6 : 0 )              \
	    : ( ( 0xCE == ((const U8*)s)[2] ) && ( 0xB9 == ((const U8*)s)[3] ) ) ? 0x1FF3 : 0 )\
	: ( ( ( 0x8E == ((const U8*)s)[1] ) && ( 0xCE == ((const U8*)s)[2] ) ) && ( 0xB9 == ((const U8*)s)[3] ) ) ? 0x1FF4 : 0 )\
    : ( 0xD5 == ((const U8*)s)[0] ) ?                                       \
	( ( 0xA5 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xD6 == ((const U8*)s)[2] ) && ( 0x82 == ((const U8*)s)[3] ) ) ? 0x587 : 0 )\
	: ( 0xB4 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xD5 == ((const U8*)s)[2] ) ?                               \
		( ( 0xA5 == ((const U8*)s)[3] ) ? 0xFB14                    \
		: ( 0xAB == ((const U8*)s)[3] ) ? 0xFB15                    \
		: ( 0xAD == ((const U8*)s)[3] ) ? 0xFB17                    \
		: ( 0xB6 == ((const U8*)s)[3] ) ? 0xFB13 : 0 )              \
	    : 0 )                                                           \
	: ( ( ( 0xBE == ((const U8*)s)[1] ) && ( 0xD5 == ((const U8*)s)[2] ) ) && ( 0xB6 == ((const U8*)s)[3] ) ) ? 0xFB16 : 0 )\
    : 0 )


/*** GENERATED CODE ***/
#define what_MULTI_CHAR_FOLD_utf8_safe_part5_(s,e)                          \
( ((e)-(s) > 2) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xDF ) == 'A' ) ?                             \
	( ( ( 0xCA == ((const U8*)s)[1] ) && ( 0xBE == ((const U8*)s)[2] ) ) ? 0x1E9A : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'F' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xDF ) == 'F' ) ?                         \
	    ( ( ( ((const U8*)s)[2] & 0xDF ) == 'I' ) ? 0xFB03              \
	    : ( ( ((const U8*)s)[2] & 0xDF ) == 'L' ) ? 0xFB04 : 0xFB00 )   \
	: ( ( ((const U8*)s)[1] & 0xDF ) == 'I' ) ? 0xFB01                  \
	: ( ( ((const U8*)s)[1] & 0xDF ) == 'L' ) ? 0xFB02 : 0 )            \
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'H' ) ?                             \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0xB1 == ((const U8*)s)[2] ) ) ? 0x1E96 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'I' ) ?                             \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x87 == ((const U8*)s)[2] ) ) ? 0x130 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'J' ) ?                             \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x8C == ((const U8*)s)[2] ) ) ? 0x1F0 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'S' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xDF ) == 'S' ) ? 0xDF                    \
	: ( ( ((const U8*)s)[1] & 0xDF ) == 'T' ) ? 0xFB05                  \
	: ( ( 0xC5 == ((const U8*)s)[1] ) && ( 0xBF == ((const U8*)s)[2] ) ) ? 0xDF : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'T' ) ?                             \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x88 == ((const U8*)s)[2] ) ) ? 0x1E97 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'W' ) ?                             \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x8A == ((const U8*)s)[2] ) ) ? 0x1E98 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'Y' ) ?                             \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x8A == ((const U8*)s)[2] ) ) ? 0x1E99 : 0 )\
    : ( 0xC5 == ((const U8*)s)[0] ) ?                                       \
	( ( 0xBF == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( ((const U8*)s)[2] & 0xDF ) == 'S' ) ? 0xDF                \
	    : ( ( ((const U8*)s)[2] & 0xDF ) == 'T' ) ? 0xFB05 : 0 )        \
	: 0 )                                                               \
    : ( ( ( 0xCA == ((const U8*)s)[0] ) && ( 0xBC == ((const U8*)s)[1] ) ) && ( ( ((const U8*)s)[2] & 0xDF ) == 'N' ) ) ? 0x149 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xDF ) == 'F' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xDF ) == 'F' ) ? 0xFB00                  \
	: ( ( ((const U8*)s)[1] & 0xDF ) == 'I' ) ? 0xFB01                  \
	: ( ( ((const U8*)s)[1] & 0xDF ) == 'L' ) ? 0xFB02 : 0 )            \
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'S' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xDF ) == 'S' ) ? 0xDF                    \
	: ( ( ((const U8*)s)[1] & 0xDF ) == 'T' ) ? 0xFB05 : 0 )            \
    : 0 )                                                                   \
: 0 )


/*** GENERATED CODE ***/
#define what_MULTI_CHAR_FOLD_utf8_safe_part6_(s,e)                          \
( ( ( ((const U8*)s)[0] & 0xDF ) == 'A' ) ?                                 \
	( ( ( 0xCA == ((const U8*)s)[1] ) && ( 0xBE == ((const U8*)s)[2] ) ) ? 0x1E9A : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'F' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xDF ) == 'F' ) ?                         \
	    ( ( ( ((const U8*)s)[2] & 0xDF ) == 'I' ) ? 0xFB03              \
	    : ( ( ((const U8*)s)[2] & 0xDF ) == 'L' ) ? 0xFB04 : 0xFB00 )   \
	: ( ( ((const U8*)s)[1] & 0xDF ) == 'I' ) ? 0xFB01                  \
	: ( ( ((const U8*)s)[1] & 0xDF ) == 'L' ) ? 0xFB02 : 0 )            \
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'H' ) ?                             \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0xB1 == ((const U8*)s)[2] ) ) ? 0x1E96 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'I' ) ?                             \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x87 == ((const U8*)s)[2] ) ) ? 0x130 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'J' ) ?                             \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x8C == ((const U8*)s)[2] ) ) ? 0x1F0 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'S' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xDF ) == 'S' ) ? 0xDF                    \
	: ( ( ((const U8*)s)[1] & 0xDF ) == 'T' ) ? 0xFB05                  \
	: ( ( 0xC5 == ((const U8*)s)[1] ) && ( 0xBF == ((const U8*)s)[2] ) ) ? 0xDF : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'T' ) ?                             \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x88 == ((const U8*)s)[2] ) ) ? 0x1E97 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'W' ) ?                             \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x8A == ((const U8*)s)[2] ) ) ? 0x1E98 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'Y' ) ?                             \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x8A == ((const U8*)s)[2] ) ) ? 0x1E99 : 0 )\
    : ( 0xC5 == ((const U8*)s)[0] ) ?                                       \
	( ( 0xBF == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( ((const U8*)s)[2] & 0xDF ) == 'S' ) ? 0xDF                \
	    : ( ( ((const U8*)s)[2] & 0xDF ) == 'T' ) ? 0xFB05              \
	    : ( ( 0xC5 == ((const U8*)s)[2] ) && ( 0xBF == ((const U8*)s)[3] ) ) ? 0xDF : 0 )\
	: 0 )                                                               \
    : ( 0xCA == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xBC == ((const U8*)s)[1] ) && ( ( ((const U8*)s)[2] & 0xDF ) == 'N' ) ) ? 0x149 : 0 )\
    : ( 0xCE == ((const U8*)s)[0] ) ?                                       \
	( ( 0xAC == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xCE == ((const U8*)s)[2] ) && ( 0xB9 == ((const U8*)s)[3] ) ) ? 0x1FB4 : 0 )\
	: ( 0xAE == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xCE == ((const U8*)s)[2] ) && ( 0xB9 == ((const U8*)s)[3] ) ) ? 0x1FC4 : 0 )\
	: ( 0xB1 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xCD == ((const U8*)s)[2] ) ?                               \
		( ( 0x82 == ((const U8*)s)[3] ) ?                           \
		    ( ( ( 0xCE == ((const U8*)s)[4] ) && ( 0xB9 == ((const U8*)s)[5] ) ) ? 0x1FB7 : 0x1FB6 )\
		: 0 )                                                       \
	    : ( ( 0xCE == ((const U8*)s)[2] ) && ( 0xB9 == ((const U8*)s)[3] ) ) ? 0x1FB3 : 0 )\
	: ( 0xB7 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xCD == ((const U8*)s)[2] ) ?                               \
		( ( 0x82 == ((const U8*)s)[3] ) ?                           \
		    ( ( ( 0xCE == ((const U8*)s)[4] ) && ( 0xB9 == ((const U8*)s)[5] ) ) ? 0x1FC7 : 0x1FC6 )\
		: 0 )                                                       \
	    : ( ( 0xCE == ((const U8*)s)[2] ) && ( 0xB9 == ((const U8*)s)[3] ) ) ? 0x1FC3 : 0 )\
	: ( 0xB9 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xCC == ((const U8*)s)[2] ) ?                               \
		( ( 0x88 == ((const U8*)s)[3] ) ?                           \
		    ( ( 0xCC == ((const U8*)s)[4] ) ?                       \
			( ( 0x80 == ((const U8*)s)[5] ) ? 0x1FD2            \
			: ( 0x81 == ((const U8*)s)[5] ) ? 0x390 : 0 )       \
		    : ( ( 0xCD == ((const U8*)s)[4] ) && ( 0x82 == ((const U8*)s)[5] ) ) ? 0x1FD7 : 0 )\
		: 0 )                                                       \
	    : ( ( 0xCD == ((const U8*)s)[2] ) && ( 0x82 == ((const U8*)s)[3] ) ) ? 0x1FD6 : 0 )\
	: 0 )                                                               \
    : ( 0xCF == ((const U8*)s)[0] ) ? what_MULTI_CHAR_FOLD_utf8_safe_part0_(s,e) : what_MULTI_CHAR_FOLD_utf8_safe_part1_(s,e) )


/*** GENERATED CODE ***/
#define what_MULTI_CHAR_FOLD_utf8_safe_part7_(s,e)                          \
( ((e)-(s) > 4) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xDF ) == 'A' ) ?                             \
	( ( ( 0xCA == ((const U8*)s)[1] ) && ( 0xBE == ((const U8*)s)[2] ) ) ? 0x1E9A : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'F' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xDF ) == 'F' ) ?                         \
	    ( ( ( ((const U8*)s)[2] & 0xDF ) == 'I' ) ? 0xFB03              \
	    : ( ( ((const U8*)s)[2] & 0xDF ) == 'L' ) ? 0xFB04 : 0xFB00 )   \
	: ( ( ((const U8*)s)[1] & 0xDF ) == 'I' ) ? 0xFB01                  \
	: ( ( ((const U8*)s)[1] & 0xDF ) == 'L' ) ? 0xFB02 : 0 )            \
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'H' ) ?                             \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0xB1 == ((const U8*)s)[2] ) ) ? 0x1E96 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'I' ) ?                             \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x87 == ((const U8*)s)[2] ) ) ? 0x130 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'J' ) ?                             \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x8C == ((const U8*)s)[2] ) ) ? 0x1F0 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'S' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xDF ) == 'S' ) ? 0xDF                    \
	: ( ( ((const U8*)s)[1] & 0xDF ) == 'T' ) ? 0xFB05                  \
	: ( ( 0xC5 == ((const U8*)s)[1] ) && ( 0xBF == ((const U8*)s)[2] ) ) ? 0xDF : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'T' ) ?                             \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x88 == ((const U8*)s)[2] ) ) ? 0x1E97 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'W' ) ?                             \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x8A == ((const U8*)s)[2] ) ) ? 0x1E98 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'Y' ) ?                             \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x8A == ((const U8*)s)[2] ) ) ? 0x1E99 : 0 )\
    : ( 0xC5 == ((const U8*)s)[0] ) ?                                       \
	( ( 0xBF == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( ((const U8*)s)[2] & 0xDF ) == 'S' ) ? 0xDF                \
	    : ( ( ((const U8*)s)[2] & 0xDF ) == 'T' ) ? 0xFB05              \
	    : ( ( 0xC5 == ((const U8*)s)[2] ) && ( 0xBF == ((const U8*)s)[3] ) ) ? 0xDF : 0 )\
	: 0 )                                                               \
    : ( 0xCA == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xBC == ((const U8*)s)[1] ) && ( ( ((const U8*)s)[2] & 0xDF ) == 'N' ) ) ? 0x149 : 0 )\
    : ( 0xCE == ((const U8*)s)[0] ) ?                                       \
	( ( 0xAC == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xCE == ((const U8*)s)[2] ) && ( 0xB9 == ((const U8*)s)[3] ) ) ? 0x1FB4 : 0 )\
	: ( 0xAE == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xCE == ((const U8*)s)[2] ) && ( 0xB9 == ((const U8*)s)[3] ) ) ? 0x1FC4 : 0 )\
	: ( 0xB1 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xCD == ((const U8*)s)[2] ) ?                               \
		( ( 0x82 == ((const U8*)s)[3] ) ? 0x1FB6 : 0 )              \
	    : ( ( 0xCE == ((const U8*)s)[2] ) && ( 0xB9 == ((const U8*)s)[3] ) ) ? 0x1FB3 : 0 )\
	: ( 0xB7 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xCD == ((const U8*)s)[2] ) ?                               \
		( ( 0x82 == ((const U8*)s)[3] ) ? 0x1FC6 : 0 )              \
	    : ( ( 0xCE == ((const U8*)s)[2] ) && ( 0xB9 == ((const U8*)s)[3] ) ) ? 0x1FC3 : 0 )\
	: ( ( ( 0xB9 == ((const U8*)s)[1] ) && ( 0xCD == ((const U8*)s)[2] ) ) && ( 0x82 == ((const U8*)s)[3] ) ) ? 0x1FD6 : 0 )\
    : ( 0xCF == ((const U8*)s)[0] ) ? what_MULTI_CHAR_FOLD_utf8_safe_part2_(s,e) : what_MULTI_CHAR_FOLD_utf8_safe_part3_(s,e) )\
: ((e)-(s) > 3) ? what_MULTI_CHAR_FOLD_utf8_safe_part4_(s,e) : what_MULTI_CHAR_FOLD_utf8_safe_part5_(s,e) )


/*** GENERATED CODE ***/
#define what_MULTI_CHAR_FOLD_utf8_safe(s,e)                                 \
( ((e)-(s) > 5) ? what_MULTI_CHAR_FOLD_utf8_safe_part6_(s,e) : what_MULTI_CHAR_FOLD_utf8_safe_part7_(s,e) )

/*
	MULTI_CHAR_FOLD: multi-char strings that are folded to by a single character

	%regcharclass_multi_char_folds::multi_char_folds('l', 'a')
*/
/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_latin1_safe(s,e)                                 \
( ((e)-(s) > 2) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xDF ) == 'F' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xDF ) == 'F' ) ?                         \
	    ( ( ( ( ((const U8*)s)[2] & 0xDF ) == 'I' ) || ( ( ((const U8*)s)[2] & 0xDF ) == 'L' ) ) ? 3 : 2 )\
	: ( ( ( ((const U8*)s)[1] & 0xDF ) == 'I' ) || ( ( ((const U8*)s)[1] & 0xDF ) == 'L' ) ) ? 2 : 0 )\
    : ( ( ( ((const U8*)s)[0] & 0xDF ) == 'S' ) && ( inRANGE_helper_(U8, ((const U8*)s)[1], 'S', 'T') || inRANGE_helper_(U8, ((const U8*)s)[1], 's', 't') ) ) ? 2 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xDF ) == 'F' ) ?                             \
	( ( ( ( ((const U8*)s)[1] & 0xDF ) == 'F' ) || ( ( ((const U8*)s)[1] & 0xDF ) == 'I' ) || ( ( ((const U8*)s)[1] & 0xDF ) == 'L' ) ) ? 2 : 0 )\
    : ( ( ( ((const U8*)s)[0] & 0xDF ) == 'S' ) && ( inRANGE_helper_(U8, ((const U8*)s)[1], 'S', 'T') || inRANGE_helper_(U8, ((const U8*)s)[1], 's', 't') ) ) ? 2 : 0 )\
: 0 )

/*** GENERATED CODE ***/
#define what_MULTI_CHAR_FOLD_latin1_safe(s,e)                               \
( ((e)-(s) > 2) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xDF ) == 'F' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xDF ) == 'F' ) ?                         \
	    ( ( ( ((const U8*)s)[2] & 0xDF ) == 'I' ) ? 0xFB03              \
	    : ( ( ((const U8*)s)[2] & 0xDF ) == 'L' ) ? 0xFB04 : 0xFB00 )   \
	: ( ( ((const U8*)s)[1] & 0xDF ) == 'I' ) ? 0xFB01                  \
	: ( ( ((const U8*)s)[1] & 0xDF ) == 'L' ) ? 0xFB02 : 0 )            \
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'S' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xDF ) == 'S' ) ? 0xDF                    \
	: ( ( ((const U8*)s)[1] & 0xDF ) == 'T' ) ? 0xFB05 : 0 )            \
    : 0 )                                                                   \
: ((e)-(s) > 1) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xDF ) == 'F' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xDF ) == 'F' ) ? 0xFB00                  \
	: ( ( ((const U8*)s)[1] & 0xDF ) == 'I' ) ? 0xFB01                  \
	: ( ( ((const U8*)s)[1] & 0xDF ) == 'L' ) ? 0xFB02 : 0 )            \
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'S' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xDF ) == 'S' ) ? 0xDF                    \
	: ( ( ((const U8*)s)[1] & 0xDF ) == 'T' ) ? 0xFB05 : 0 )            \
    : 0 )                                                                   \
: 0 )

/*
	THREE_CHAR_FOLD: A three-character multi-char fold

	%regcharclass_multi_char_folds::multi_char_folds('u', '3')
*/
/*** GENERATED CODE ***/
#define is_THREE_CHAR_FOLD_utf8_safe(s,e)                                   \
( ((e)-(s) > 5) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xDF ) == 'F' ) ?                             \
	( ( ( ( ((const U8*)s)[1] & 0xDF ) == 'F' ) && ( ( ( ((const U8*)s)[2] & 0xDF ) == 'I' ) || ( ( ((const U8*)s)[2] & 0xDF ) == 'L' ) ) ) ? 3 : 0 )\
    : ( 0xCE == ((const U8*)s)[0] ) ?                                       \
	( ( 0xB1 == ((const U8*)s)[1] || 0xB7 == ((const U8*)s)[1] ) ?      \
	    ( ( ( ( ( 0xCD == ((const U8*)s)[2] ) && ( 0x82 == ((const U8*)s)[3] ) ) && ( 0xCE == ((const U8*)s)[4] ) ) && ( 0xB9 == ((const U8*)s)[5] ) ) ? 6 : 0 )\
	: ( ( ( 0xB9 == ((const U8*)s)[1] ) && ( 0xCC == ((const U8*)s)[2] ) ) && ( 0x88 == ((const U8*)s)[3] ) ) ? ( ( 0xCC == ((const U8*)s)[4] ) ?\
			( ( inRANGE_helper_(U8, ((const U8*)s)[5], 0x80, 0x81) ) ? 6 : 0 )\
		    : ( ( 0xCD == ((const U8*)s)[4] ) && ( 0x82 == ((const U8*)s)[5] ) ) ? 6 : 0 ) : 0 )\
    : ( 0xCF == ((const U8*)s)[0] ) ?                                       \
	( ( 0x85 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xCC == ((const U8*)s)[2] ) && ( 0x88 == ((const U8*)s)[3] || 0x93 == ((const U8*)s)[3] ) ) ? ( ( 0xCC == ((const U8*)s)[4] ) ?\
			( ( inRANGE_helper_(U8, ((const U8*)s)[5], 0x80, 0x81) ) ? 6 : 0 )\
		    : ( ( 0xCD == ((const U8*)s)[4] ) && ( 0x82 == ((const U8*)s)[5] ) ) ? 6 : 0 ) : 0 )\
	: ( ( ( ( ( 0x89 == ((const U8*)s)[1] ) && ( 0xCD == ((const U8*)s)[2] ) ) && ( 0x82 == ((const U8*)s)[3] ) ) && ( 0xCE == ((const U8*)s)[4] ) ) && ( 0xB9 == ((const U8*)s)[5] ) ) ? 6 : 0 )\
    : 0 )                                                                   \
: ( ( ( ((e)-(s) > 2) && ( ( ((const U8*)s)[0] & 0xDF ) == 'F' ) ) && ( ( ((const U8*)s)[1] & 0xDF ) == 'F' ) ) && ( ( ( ((const U8*)s)[2] & 0xDF ) == 'I' ) || ( ( ((const U8*)s)[2] & 0xDF ) == 'L' ) ) ) ? 3 : 0 )

/*
	THREE_CHAR_FOLD: A three-character multi-char fold

	%regcharclass_multi_char_folds::multi_char_folds('l', '3')
*/
/*** GENERATED CODE ***/
#define is_THREE_CHAR_FOLD_latin1_safe(s,e)                                 \
( ( ( ( ( ((e) - (s)) >= 3 ) && ( ( ((const U8*)s)[0] & 0xDF ) == 'F' ) ) && ( ( ((const U8*)s)[1] & 0xDF ) == 'F' ) ) && ( ( ( ((const U8*)s)[2] & 0xDF ) == 'I' ) || ( ( ((const U8*)s)[2] & 0xDF ) == 'L' ) ) ) ? 3 : 0 )

/*
	THREE_CHAR_FOLD_HEAD: The first two of three-character multi-char folds

	%regcharclass_multi_char_folds::multi_char_folds('u', 'h')
*/
/*** GENERATED CODE ***/
#define is_THREE_CHAR_FOLD_HEAD_utf8_safe(s,e)                              \
( ((e)-(s) > 3) ?                                                           \
    ( ( ( ( ((const U8*)s)[0] & 0xDF ) == 'A' ) || ( ( ((const U8*)s)[0] & 0xDE ) == 'H' ) || ( ( ((const U8*)s)[0] & 0xDF ) == 'J' ) || ( ( ((const U8*)s)[0] & 0xDB ) == 'S' ) || ( ( ((const U8*)s)[0] & 0xDF ) == 'T' ) || ( ( ((const U8*)s)[0] & 0xDF ) == 'Y' ) ) ? 1\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'F' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xDF ) == 'F' ) ? 2 : 1 )                 \
    : ( 0xC5 == ((const U8*)s)[0] ) ?                                       \
	( ( 0xBF == ((const U8*)s)[1] ) ? 2 : 0 )                           \
    : ( 0xCA == ((const U8*)s)[0] ) ?                                       \
	( ( 0xBC == ((const U8*)s)[1] ) ? 2 : 0 )                           \
    : ( 0xCE == ((const U8*)s)[0] ) ?                                       \
	( ( ( ((const U8*)s)[1] & 0xFD ) == 0xAC ) ? 2                      \
	: ( 0xB1 == ((const U8*)s)[1] || 0xB7 == ((const U8*)s)[1] ) ?      \
	    ( ( ( 0xCD == ((const U8*)s)[2] ) && ( 0x82 == ((const U8*)s)[3] ) ) ? 4 : 2 )\
	: ( 0xB9 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xCC == ((const U8*)s)[2] ) && ( 0x88 == ((const U8*)s)[3] ) ) ? 4 : 2 )\
	: 0 )                                                               \
    : ( 0xCF == ((const U8*)s)[0] ) ?                                       \
	( ( 0x81 == ((const U8*)s)[1] || 0x8E == ((const U8*)s)[1] ) ? 2    \
	: ( 0x85 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xCC == ((const U8*)s)[2] ) && ( 0x88 == ((const U8*)s)[3] || 0x93 == ((const U8*)s)[3] ) ) ? 4 : 2 )\
	: ( 0x89 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xCD == ((const U8*)s)[2] ) && ( 0x82 == ((const U8*)s)[3] ) ) ? 4 : 2 )\
	: 0 )                                                               \
    : ( 0xD5 == ((const U8*)s)[0] ) ?                                       \
	( ( 0xA5 == ((const U8*)s)[1] || 0xB4 == ((const U8*)s)[1] || 0xBE == ((const U8*)s)[1] ) ? 2 : 0 )\
    : ( 0xE1 == ((const U8*)s)[0] ) ?                                       \
	( ( 0xBC == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( ((const U8*)s)[2] & 0xD8 ) == 0x80 ) ? 3 : 0 )            \
	: ( ( 0xBD == ((const U8*)s)[1] ) && ( ( ( ((const U8*)s)[2] & 0xF8 ) == 0xA0 ) || ( ( ((const U8*)s)[2] & 0xFB ) == 0xB0 ) || ((const U8*)s)[2] == 0xBC ) ) ? 3 : 0 )\
    : 0 )                                                                   \
: ((e)-(s) > 2) ?                                                           \
    ( ( ( ( ((const U8*)s)[0] & 0xDF ) == 'A' ) || ( ( ((const U8*)s)[0] & 0xDE ) == 'H' ) || ( ( ((const U8*)s)[0] & 0xDF ) == 'J' ) || ( ( ((const U8*)s)[0] & 0xDB ) == 'S' ) || ( ( ((const U8*)s)[0] & 0xDF ) == 'T' ) || ( ( ((const U8*)s)[0] & 0xDF ) == 'Y' ) ) ? 1\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'F' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xDF ) == 'F' ) ? 2 : 1 )                 \
    : ( 0xC5 == ((const U8*)s)[0] ) ?                                       \
	( ( 0xBF == ((const U8*)s)[1] ) ? 2 : 0 )                           \
    : ( 0xCA == ((const U8*)s)[0] ) ?                                       \
	( ( 0xBC == ((const U8*)s)[1] ) ? 2 : 0 )                           \
    : ( 0xCE == ((const U8*)s)[0] ) ?                                       \
	( ( ( ( ((const U8*)s)[1] & 0xFD ) == 0xAC ) || ( ( ((const U8*)s)[1] & 0xF7 ) == 0xB1 ) || ((const U8*)s)[1] == 0xB7 ) ? 2 : 0 )\
    : ( 0xCF == ((const U8*)s)[0] ) ?                                       \
	( ( ( ( ((const U8*)s)[1] & 0xFB ) == 0x81 ) || ((const U8*)s)[1] == 0x89 || ((const U8*)s)[1] == 0x8E ) ? 2 : 0 )\
    : ( 0xD5 == ((const U8*)s)[0] ) ?                                       \
	( ( 0xA5 == ((const U8*)s)[1] || 0xB4 == ((const U8*)s)[1] || 0xBE == ((const U8*)s)[1] ) ? 2 : 0 )\
    : ( 0xE1 == ((const U8*)s)[0] ) ?                                       \
	( ( 0xBC == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( ((const U8*)s)[2] & 0xD8 ) == 0x80 ) ? 3 : 0 )            \
	: ( ( 0xBD == ((const U8*)s)[1] ) && ( ( ( ((const U8*)s)[2] & 0xF8 ) == 0xA0 ) || ( ( ((const U8*)s)[2] & 0xFB ) == 0xB0 ) || ((const U8*)s)[2] == 0xBC ) ) ? 3 : 0 )\
    : 0 )                                                                   \
: ((e)-(s) > 1) ?                                                           \
    ( ( ( ( ((const U8*)s)[0] & 0xDF ) == 'A' ) || ( ( ((const U8*)s)[0] & 0xDE ) == 'H' ) || ( ( ((const U8*)s)[0] & 0xDF ) == 'J' ) || ( ( ((const U8*)s)[0] & 0xDB ) == 'S' ) || ( ( ((const U8*)s)[0] & 0xDF ) == 'T' ) || ( ( ((const U8*)s)[0] & 0xDF ) == 'Y' ) ) ? 1\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'F' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xDF ) == 'F' ) ? 2 : 1 )                 \
    : ( 0xC5 == ((const U8*)s)[0] ) ?                                       \
	( ( 0xBF == ((const U8*)s)[1] ) ? 2 : 0 )                           \
    : ( 0xCA == ((const U8*)s)[0] ) ?                                       \
	( ( 0xBC == ((const U8*)s)[1] ) ? 2 : 0 )                           \
    : ( 0xCE == ((const U8*)s)[0] ) ?                                       \
	( ( ( ( ((const U8*)s)[1] & 0xFD ) == 0xAC ) || ( ( ((const U8*)s)[1] & 0xF7 ) == 0xB1 ) || ((const U8*)s)[1] == 0xB7 ) ? 2 : 0 )\
    : ( 0xCF == ((const U8*)s)[0] ) ?                                       \
	( ( ( ( ((const U8*)s)[1] & 0xFB ) == 0x81 ) || ((const U8*)s)[1] == 0x89 || ((const U8*)s)[1] == 0x8E ) ? 2 : 0 )\
    : ( ( 0xD5 == ((const U8*)s)[0] ) && ( 0xA5 == ((const U8*)s)[1] || 0xB4 == ((const U8*)s)[1] || 0xBE == ((const U8*)s)[1] ) ) ? 2 : 0 )\
: ((e)-(s) > 0) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xDF ) == 'A' ) || ( ( ((const U8*)s)[0] & 0xDF ) == 'F' ) || ( ( ((const U8*)s)[0] & 0xDE ) == 'H' ) || ( ( ((const U8*)s)[0] & 0xDF ) == 'J' ) || ( ( ((const U8*)s)[0] & 0xDB ) == 'S' ) || ( ( ((const U8*)s)[0] & 0xDF ) == 'T' ) || ( ( ((const U8*)s)[0] & 0xDF ) == 'Y' ) )\
: 0 )

/*
	THREE_CHAR_FOLD_HEAD: The first two of three-character multi-char folds

	%regcharclass_multi_char_folds::multi_char_folds('l', 'h')
*/
/*** GENERATED CODE ***/
#define is_THREE_CHAR_FOLD_HEAD_latin1_safe(s,e)                            \
( ((e)-(s) > 1) ?                                                           \
    ( ( ( ( ((const U8*)s)[0] & 0xDF ) == 'A' ) || ( ( ((const U8*)s)[0] & 0xDE ) == 'H' ) || ( ( ((const U8*)s)[0] & 0xDF ) == 'J' ) || ( ( ((const U8*)s)[0] & 0xDB ) == 'S' ) || ( ( ((const U8*)s)[0] & 0xDF ) == 'T' ) || ( ( ((const U8*)s)[0] & 0xDF ) == 'Y' ) ) ? 1\
    : ( ( ((const U8*)s)[0] & 0xDF ) == 'F' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xDF ) == 'F' ) ? 2 : 1 )                 \
    : 0 )                                                                   \
: ((e)-(s) > 0) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xDF ) == 'A' ) || ( ( ((const U8*)s)[0] & 0xDF ) == 'F' ) || ( ( ((const U8*)s)[0] & 0xDE ) == 'H' ) || ( ( ((const U8*)s)[0] & 0xDF ) == 'J' ) || ( ( ((const U8*)s)[0] & 0xDB ) == 'S' ) || ( ( ((const U8*)s)[0] & 0xDF ) == 'T' ) || ( ( ((const U8*)s)[0] & 0xDF ) == 'Y' ) )\
: 0 )

/*
	FOLDS_TO_MULTI: characters that fold to multi-char strings

	\p{_Perl_Folds_To_Multi_Char}
*/
/*** GENERATED CODE ***/
#define is_FOLDS_TO_MULTI_utf8(s)                                           \
( ( 0xC3 == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x9F == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xC4 == ((const U8*)s)[0] || 0xC7 == ((const U8*)s)[0] ) ?              \
    ( ( 0xB0 == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xC5 == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x89 == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xCE == ((const U8*)s)[0] ) ?                                           \
    ( ( ( ((const U8*)s)[1] & 0xDF ) == 0x90 ) ? 2 : 0 )                    \
: ( 0xD6 == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x87 == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xE1 == ((const U8*)s)[0] ) ?                                           \
    ( ( 0xBA == ((const U8*)s)[1] ) ?                                       \
	( ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x96, 0x9A) || 0x9E == ((const U8*)s)[2] ) ? 3 : 0 )\
    : ( 0xBD == ((const U8*)s)[1] ) ?                                       \
	( ( ( ((const U8*)s)[2] & 0xF9 ) == 0x90 ) ? 3 : 0 )                \
    : ( 0xBE == ((const U8*)s)[1] ) ?                                       \
	( ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x80, 0xAF) || inRANGE_helper_(U8, ((const U8*)s)[2], 0xB2, 0xB4) || inRANGE_helper_(U8, ((const U8*)s)[2], 0xB6, 0xB7) || 0xBC == ((const U8*)s)[2] ) ? 3 : 0 )\
    : ( ( 0xBF == ((const U8*)s)[1] ) && ( ( ( ((const U8*)s)[2] & 0xCA ) == 0x82 ) || ( ( ((const U8*)s)[2] & 0xF7 ) == 0x84 ) || ((const U8*)s)[2] == 0xA4 || ( ( ((const U8*)s)[2] & 0xF7 ) == 0xB4 ) ) ) ? 3 : 0 )\
: ( ( ( 0xEF == ((const U8*)s)[0] ) && ( 0xAC == ((const U8*)s)[1] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x80, 0x86) || inRANGE_helper_(U8, ((const U8*)s)[2], 0x93, 0x97) ) ) ? 3 : 0 )

/*
	PROBLEMATIC_LOCALE_FOLD: characters whose fold is problematic under locale

	\p{_Perl_Problematic_Locale_Folds}
*/
/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLD_utf8(s)                                  \
( ( ((const U8*)s)[0] <= 0x7F ) ? 1                                         \
: ( inRANGE_helper_(U8, ((const U8*)s)[0], 0xC2, 0xC3) ) ?                  \
    2                                                                       \
: ( 0xC4 == ((const U8*)s)[0] ) ?                                           \
    ( ( inRANGE_helper_(U8, ((const U8*)s)[1], 0xB0, 0xB1) ) ? 2 : 0 )      \
: ( 0xC5 == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x89 == ((const U8*)s)[1] || 0xB8 == ((const U8*)s)[1] || 0xBF == ((const U8*)s)[1] ) ? 2 : 0 )\
: ( 0xC7 == ((const U8*)s)[0] ) ?                                           \
    ( ( 0xB0 == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xCC == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x87 == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xCE == ((const U8*)s)[0] ) ?                                           \
    ( ( ( ((const U8*)s)[1] & 0xDF ) == 0x9C ) ? 2 : 0 )                    \
: ( 0xE1 == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0xBA == ((const U8*)s)[1] ) && ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x96, 0x9A) || 0x9E == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xE2 == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x84 == ((const U8*)s)[1] ) && ( inRANGE_helper_(U8, ((const U8*)s)[2], 0xAA, 0xAB) ) ) ? 3 : 0 )\
: ( ( ( 0xEF == ((const U8*)s)[0] ) && ( 0xAC == ((const U8*)s)[1] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x80, 0x86) ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLD_cp(cp)                                   \
( cp <= 0xFF || ( 0xFF < cp &&                                              \
( inRANGE_helper_(UV, cp, 0x130, 0x131) || ( 0x131 < cp &&                  \
( 0x149 == cp || ( 0x149 < cp &&                                            \
( 0x178 == cp || ( 0x178 < cp &&                                            \
( 0x17F == cp || ( 0x17F < cp &&                                            \
( 0x1F0 == cp || ( 0x1F0 < cp &&                                            \
( 0x307 == cp || ( 0x307 < cp &&                                            \
( 0x39C == cp || ( 0x39C < cp &&                                            \
( 0x3BC == cp || ( 0x3BC < cp &&                                            \
( inRANGE_helper_(UV, cp, 0x1E96, 0x1E9A) || ( 0x1E9A < cp &&               \
( 0x1E9E == cp || ( 0x1E9E < cp &&                                          \
( inRANGE_helper_(UV, cp, 0x212A, 0x212B) || inRANGE_helper_(UV, cp, 0xFB00, 0xFB06) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) )

/*
	PROBLEMATIC_LOCALE_FOLDEDS_START: The first folded character of folds which are problematic under locale

	\p{_Perl_Problematic_Locale_Foldeds_Start}
*/
/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLDEDS_START_utf8(s)                         \
( ( ((const U8*)s)[0] <= 0x7F ) ? 1                                         \
: ( inRANGE_helper_(U8, ((const U8*)s)[0], 0xC2, 0xC3) ) ?                  \
    2                                                                       \
: ( 0xC4 == ((const U8*)s)[0] ) ?                                           \
    ( ( inRANGE_helper_(U8, ((const U8*)s)[1], 0xB0, 0xB1) ) ? 2 : 0 )      \
: ( 0xC5 == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x89 == ((const U8*)s)[1] || 0xB8 == ((const U8*)s)[1] || 0xBF == ((const U8*)s)[1] ) ? 2 : 0 )\
: ( 0xC7 == ((const U8*)s)[0] ) ?                                           \
    ( ( 0xB0 == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xCA == ((const U8*)s)[0] ) ?                                           \
    ( ( 0xBC == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xCE == ((const U8*)s)[0] ) ?                                           \
    ( ( ( ((const U8*)s)[1] & 0xDF ) == 0x9C ) ? 2 : 0 )                    \
: ( 0xE1 == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0xBA == ((const U8*)s)[1] ) && ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x96, 0x9A) || 0x9E == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xE2 == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x84 == ((const U8*)s)[1] ) && ( inRANGE_helper_(U8, ((const U8*)s)[2], 0xAA, 0xAB) ) ) ? 3 : 0 )\
: ( ( ( 0xEF == ((const U8*)s)[0] ) && ( 0xAC == ((const U8*)s)[1] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x80, 0x86) ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLDEDS_START_cp(cp)                          \
( cp <= 0xFF || ( 0xFF < cp &&                                              \
( inRANGE_helper_(UV, cp, 0x130, 0x131) || ( 0x131 < cp &&                  \
( 0x149 == cp || ( 0x149 < cp &&                                            \
( 0x178 == cp || ( 0x178 < cp &&                                            \
( 0x17F == cp || ( 0x17F < cp &&                                            \
( 0x1F0 == cp || ( 0x1F0 < cp &&                                            \
( 0x2BC == cp || ( 0x2BC < cp &&                                            \
( 0x39C == cp || ( 0x39C < cp &&                                            \
( 0x3BC == cp || ( 0x3BC < cp &&                                            \
( inRANGE_helper_(UV, cp, 0x1E96, 0x1E9A) || ( 0x1E9A < cp &&               \
( 0x1E9E == cp || ( 0x1E9E < cp &&                                          \
( inRANGE_helper_(UV, cp, 0x212A, 0x212B) || inRANGE_helper_(UV, cp, 0xFB00, 0xFB06) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) )

/*
	PATWS: pattern white space

	\p{_Perl_PatWS}
*/
/*** GENERATED CODE ***/
#define is_PATWS_safe(s,e,is_utf8)                                          \
( ( LIKELY((e) > (s)) ) ?                                                   \
    ( ( inRANGE_helper_(U8, ((const U8*)s)[0], '\t', '\r') || ' ' == ((const U8*)s)[0] ) ? 1\
    : (! is_utf8 ) ?                                                        \
	    ( 0x85 == ((const U8*)s)[0] )                                   \
	: ( LIKELY(((e) - (s)) >= UTF8SKIP(s)) ) ?                          \
	    ( ( 0xC2 == ((const U8*)s)[0] ) ?                               \
		( ( 0x85 == ((const U8*)s)[1] ) ? 2 : 0 )                   \
	    : ( ( ( 0xE2 == ((const U8*)s)[0] ) && ( 0x80 == ((const U8*)s)[1] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x8E, 0x8F) || inRANGE_helper_(U8, ((const U8*)s)[2], 0xA8, 0xA9) ) ) ? 3 : 0 )\
	: 0 )                                                               \
: 0 )

/*
	HANGUL_ED: Hangul syllables whose first UTF-8 byte is \xED

	0xD000 - 0xD7FF
*/
/*** GENERATED CODE ***/
#define is_HANGUL_ED_utf8_safe(s,e)                                         \
( ( ( ( ( ((e) - (s)) >= 3 ) && ( 0xED == ((const U8*)s)[0] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[1], 0x80, 0x9F) ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x80, 0xBF) ) ) ? 3 : 0 )

#endif	/* ASCII/Latin1 */

#if 'A' == 193 /* EBCDIC 1047 */ \
     && '\\' == 224 && '[' == 173 && ']' == 189 && '{' == 192 && '}' == 208 \
     && '^' == 95 && '~' == 161 && '!' == 90 && '#' == 123 && '|' == 79 \
     && '$' == 91 && '@' == 124 && '`' == 121 && '\n' == 21
/*
	LNBREAK: Line Break: \R

	"\x0D\x0A"      # CRLF - Network (Windows) line ending
	\p{VertSpace}
*/
/*** GENERATED CODE ***/
#define is_LNBREAK_safe(s,e,is_utf8)                                        \
( ((e)-(s) > 2) ?                                                           \
    ( ( inRANGE_helper_(U8, ((const U8*)s)[0], '\v', '\f') || '\n' == ((const U8*)s)[0] || 0x25 == ((const U8*)s)[0] ) ? 1\
    : ( '\r' == ((const U8*)s)[0] ) ?                                       \
	( ( '\n' == ((const U8*)s)[1] ) ? 2 : 1 )                           \
    : ( ( ( ( is_utf8 ) && ( 0xCA == ((const U8*)s)[0] ) ) && ( 0x42 == ((const U8*)s)[1] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x49, 0x4A) ) ) ? 3 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( inRANGE_helper_(U8, ((const U8*)s)[0], '\v', '\f') || '\n' == ((const U8*)s)[0] || 0x25 == ((const U8*)s)[0] ) ? 1\
    : ( '\r' == ((const U8*)s)[0] ) ?                                       \
	( ( '\n' == ((const U8*)s)[1] ) ? 2 : 1 )                           \
    : 0 )                                                                   \
: ((e)-(s) > 0) ?                                                           \
    ( inRANGE_helper_(U8, ((const U8*)s)[0], '\v', '\r') || '\n' == ((const U8*)s)[0] || 0x25 == ((const U8*)s)[0] )\
: 0 )

/*** GENERATED CODE ***/
#define is_LNBREAK_utf8_safe(s,e)                                           \
( ((e)-(s) > 2) ?                                                           \
    ( ( inRANGE_helper_(U8, ((const U8*)s)[0], '\v', '\f') || '\n' == ((const U8*)s)[0] || 0x25 == ((const U8*)s)[0] ) ? 1\
    : ( '\r' == ((const U8*)s)[0] ) ?                                       \
	( ( '\n' == ((const U8*)s)[1] ) ? 2 : 1 )                           \
    : ( ( ( 0xCA == ((const U8*)s)[0] ) && ( 0x42 == ((const U8*)s)[1] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x49, 0x4A) ) ) ? 3 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( inRANGE_helper_(U8, ((const U8*)s)[0], '\v', '\f') || '\n' == ((const U8*)s)[0] || 0x25 == ((const U8*)s)[0] ) ? 1\
    : ( '\r' == ((const U8*)s)[0] ) ?                                       \
	( ( '\n' == ((const U8*)s)[1] ) ? 2 : 1 )                           \
    : 0 )                                                                   \
: ((e)-(s) > 0) ?                                                           \
    ( inRANGE_helper_(U8, ((const U8*)s)[0], '\v', '\r') || '\n' == ((const U8*)s)[0] || 0x25 == ((const U8*)s)[0] )\
: 0 )

/*** GENERATED CODE ***/
#define is_LNBREAK_latin1_safe(s,e)                                         \
( ((e)-(s) > 1) ?                                                           \
    ( ( inRANGE_helper_(U8, ((const U8*)s)[0], '\v', '\f') || '\n' == ((const U8*)s)[0] || 0x25 == ((const U8*)s)[0] ) ? 1\
    : ( '\r' == ((const U8*)s)[0] ) ?                                       \
	( ( '\n' == ((const U8*)s)[1] ) ? 2 : 1 )                           \
    : 0 )                                                                   \
: ((e)-(s) > 0) ?                                                           \
    ( inRANGE_helper_(U8, ((const U8*)s)[0], '\v', '\r') || '\n' == ((const U8*)s)[0] || 0x25 == ((const U8*)s)[0] )\
: 0 )

/*
	HORIZWS: Horizontal Whitespace: \h \H

	\p{HorizSpace}
*/
/*** GENERATED CODE ***/
#define is_HORIZWS_high(s)                                                  \
( ( 0xBC == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x63 == ((const U8*)s)[1] ) && ( 0x41 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xCA == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x41 == ((const U8*)s)[1] ) ?                                       \
	( ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[2]), 0xA0, 0xAA) ) ? 3 : 0 )\
    : ( 0x42 == ((const U8*)s)[1] ) ?                                       \
	( ( 0x56 == ((const U8*)s)[2] ) ? 3 : 0 )                           \
    : ( ( 0x43 == ((const U8*)s)[1] ) && ( 0x73 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( ( ( 0xCE == ((const U8*)s)[0] ) && ( 0x41 == ((const U8*)s)[1] ) ) && ( 0x41 == ((const U8*)s)[2] ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_HORIZWS_cp_high(cp)                                              \
( 0x1680 == cp || ( 0x1680 < cp &&                                          \
( inRANGE_helper_(UV, cp, 0x2000, 0x200A) || ( 0x200A < cp &&               \
( 0x202F == cp || ( 0x202F < cp &&                                          \
( 0x205F == cp || 0x3000 == cp ) ) ) ) ) ) )

/*
	VERTWS: Vertical Whitespace: \v \V

	\p{VertSpace}
*/
/*** GENERATED CODE ***/
#define is_VERTWS_high(s)                                                   \
( ( ( ( 0xCA == ((const U8*)s)[0] ) && ( 0x42 == ((const U8*)s)[1] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x49, 0x4A) ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_VERTWS_cp_high(cp)                                               \
( inRANGE_helper_(UV, cp, 0x2028, 0x2029) )

/*
	XDIGIT: Hexadecimal digits

	\p{XDigit}
*/
/*** GENERATED CODE ***/
#define is_XDIGIT_high(s)                                                   \
( ( ( 0xDD == ((const U8*)s)[0] ) && ( 0x73 == ((const U8*)s)[1] ) ) ? ( ( 0x67 == ((const U8*)s)[2] ) ?\
	    ( ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[3]), 0xB0, 0xB9) ) ? 4 : 0 )\
	: ( ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x68, 0x69) ) && ( inRANGE_helper_(U8, ((const U8*)s)[3], 0x42, 0x47) ) ) ? 4 : 0 ) : 0 )

/*** GENERATED CODE ***/
#define is_XDIGIT_cp_high(cp)                                               \
( inRANGE_helper_(UV, cp, 0xFF10, 0xFF19) || ( 0xFF19 < cp &&               \
( inRANGE_helper_(UV, cp, 0xFF21, 0xFF26) || inRANGE_helper_(UV, cp, 0xFF41, 0xFF46) ) ) )

/*
	XPERLSPACE: \p{XPerlSpace}

	\p{XPerlSpace}
*/
/*** GENERATED CODE ***/
#define is_XPERLSPACE_high(s)                                               \
( ( 0xBC == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x63 == ((const U8*)s)[1] ) && ( 0x41 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xCA == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x41 == ((const U8*)s)[1] ) ?                                       \
	( ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[2]), 0xA0, 0xAA) ) ? 3 : 0 )\
    : ( 0x42 == ((const U8*)s)[1] ) ?                                       \
	( ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x49, 0x4A) || 0x56 == ((const U8*)s)[2] ) ? 3 : 0 )\
    : ( ( 0x43 == ((const U8*)s)[1] ) && ( 0x73 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( ( ( 0xCE == ((const U8*)s)[0] ) && ( 0x41 == ((const U8*)s)[1] ) ) && ( 0x41 == ((const U8*)s)[2] ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_XPERLSPACE_cp_high(cp)                                           \
( 0x1680 == cp || ( 0x1680 < cp &&                                          \
( inRANGE_helper_(UV, cp, 0x2000, 0x200A) || ( 0x200A < cp &&               \
( inRANGE_helper_(UV, cp, 0x2028, 0x2029) || ( 0x2029 < cp &&               \
( 0x202F == cp || ( 0x202F < cp &&                                          \
( 0x205F == cp || 0x3000 == cp ) ) ) ) ) ) ) ) )

/*
	SPACE: Backwards \p{XPerlSpace}

	\p{XPerlSpace}
*/
/*** GENERATED CODE ***/
#define is_SPACE_utf8_safe_backwards(s,e)                                   \
( ((s) - (e) > 2) ?                                                         \
    ( ( '\t' == *((const U8*)s - 1) || inRANGE_helper_(U8, *((const U8*)s - 1), '\v', '\r') || '\n' == *((const U8*)s - 1) || 0x25 == *((const U8*)s - 1) || ' ' == *((const U8*)s - 1) ) ? 1\
    : ( 0x41 == *((const U8*)s - 1) ) ?                                     \
	( ( 0x41 == *((const U8*)s - 2) ) ?                                 \
	    ( ( ( *((const U8*)s - 3) & 0xFB ) == 0xCA ) ? 3 : 0 )          \
	: ( 0x63 == *((const U8*)s - 2) ) ?                                 \
	    ( ( 0xBC == *((const U8*)s - 3) ) ? 3 : 0 )                     \
	: ( 0x80 == *((const U8*)s - 2) ) ? 2 : 0 )                         \
    : ( inRANGE_helper_(U8, *((const U8*)s - 1), 0x42, 0x48) || 0x51 == *((const U8*)s - 1) ) ?\
	( ( ( 0x41 == *((const U8*)s - 2) ) && ( 0xCA == *((const U8*)s - 3) ) ) ? 3 : 0 )\
    : ( inRANGE_helper_(U8, *((const U8*)s - 1), 0x49, 0x4A) ) ?            \
	( ( ( inRANGE_helper_(U8, *((const U8*)s - 2), 0x41, 0x42) ) && ( 0xCA == *((const U8*)s - 3) ) ) ? 3 : 0 )\
    : ( 0x56 == *((const U8*)s - 1) ) ?                                     \
	( ( ( 0x42 == *((const U8*)s - 2) ) && ( 0xCA == *((const U8*)s - 3) ) ) ? 3 : 0 )\
    : ( ( ( 0x73 == *((const U8*)s - 1) ) && ( 0x43 == *((const U8*)s - 2) ) ) && ( 0xCA == *((const U8*)s - 3) ) ) ? 3 : 0 )\
: ((s) - (e) > 1) ?                                                         \
    ( ( '\t' == *((const U8*)s - 1) || inRANGE_helper_(U8, *((const U8*)s - 1), '\v', '\r') || '\n' == *((const U8*)s - 1) || 0x25 == *((const U8*)s - 1) || ' ' == *((const U8*)s - 1) ) ? 1\
    : ( ( 0x41 == *((const U8*)s - 1) ) && ( 0x80 == *((const U8*)s - 2) ) ) ? 2 : 0 )\
: ((s) - (e) > 0) ?                                                         \
    ( '\t' == *((const U8*)s - 1) || inRANGE_helper_(U8, *((const U8*)s - 1), '\v', '\r') || '\n' == *((const U8*)s - 1) || 0x25 == *((const U8*)s - 1) || ' ' == *((const U8*)s - 1) )\
: 0 )

/*
	NONCHAR: Non character code points

	\p{_Perl_Nchar}
*/
/*** GENERATED CODE ***/
#define is_NONCHAR_utf8_safe(s,e)                                           \
( ( ( LIKELY((e) > (s)) ) && ( LIKELY(((e) - (s)) >= UTF8SKIP(s)) ) ) ? ( ( 0xDD == ((const U8*)s)[0] ) ?\
	    ( ( 0x73 == ((const U8*)s)[1] ) ?                               \
		( ( 0x55 == ((const U8*)s)[2] ) ?                           \
		    ( ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[3]), 0xB0, 0xBF) ) ? 4 : 0 )\
		: ( 0x56 == ((const U8*)s)[2] ) ?                           \
		    ( ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[3]), 0xA0, 0xAF) ) ? 4 : 0 )\
		: ( ( 0x73 == ((const U8*)s)[2] ) && ( inRANGE_helper_(U8, ((const U8*)s)[3], 0x72, 0x73) ) ) ? 4 : 0 )\
	    : 0 )                                                           \
	: ( ((const U8*)s)[0] == 0xDF || ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[0]) & 0xFD ) == 0xF5 ) ) ?\
	    ( ( ( ( 0x73 == ((const U8*)s)[1] ) && ( 0x73 == ((const U8*)s)[2] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[3], 0x72, 0x73) ) ) ? 4 : 0 )\
	: ( 0xED == ((const U8*)s)[0] ) ?                                   \
	    ( ( ( ( ( ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[1]) & 0xF9 ) == 0xA9 ) || ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[1]) & 0xF1 ) == 0xB1 ) ) && ( 0x73 == ((const U8*)s)[2] ) ) && ( 0x73 == ((const U8*)s)[3] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[4], 0x72, 0x73) ) ) ? 5 : 0 )\
	: ( ( ( ( ( 0xEE == ((const U8*)s)[0] ) && ( 0x42 == ((const U8*)s)[1] ) ) && ( 0x73 == ((const U8*)s)[2] ) ) && ( 0x73 == ((const U8*)s)[3] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[4], 0x72, 0x73) ) ) ? 5 : 0 ) : 0 )

/*
	SHORTER_NON_CHARS: # 4 bytes

	0xFDD0 - 0xFDEF
	0xFFFE - 0xFFFF
	0x1FFFE - 0x1FFFF
	0x2FFFE - 0x2FFFF
	0x3FFFE - 0x3FFFF
*/
/*** GENERATED CODE ***/
#define is_SHORTER_NON_CHARS_utf8(s)                                        \
( ( 0xDD == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x73 == ((const U8*)s)[1] ) ?                                       \
	( ( 0x55 == ((const U8*)s)[2] ) ?                                   \
	    ( ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[3]), 0xB0, 0xBF) ) ? 4 : 0 )\
	: ( 0x56 == ((const U8*)s)[2] ) ?                                   \
	    ( ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[3]), 0xA0, 0xAF) ) ? 4 : 0 )\
	: ( ( 0x73 == ((const U8*)s)[2] ) && ( inRANGE_helper_(U8, ((const U8*)s)[3], 0x72, 0x73) ) ) ? 4 : 0 )\
    : 0 )                                                                   \
: ( ( ( ( ((const U8*)s)[0] == 0xDF || ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[0]) & 0xFD ) == 0xF5 ) ) && ( 0x73 == ((const U8*)s)[1] ) ) && ( 0x73 == ((const U8*)s)[2] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[3], 0x72, 0x73) ) ) ? 4 : 0 )

/*
	LARGER_NON_CHARS: # 5 bytes

	0x4FFFE - 0x4FFFF
	0x5FFFE - 0x5FFFF
	0x6FFFE - 0x6FFFF
	0x7FFFE - 0x7FFFF
	0x8FFFE - 0x8FFFF
	0x9FFFE - 0x9FFFF
	0xAFFFE - 0xAFFFF
	0xBFFFE - 0xBFFFF
	0xCFFFE - 0xCFFFF
	0xDFFFE - 0xDFFFF
	0xEFFFE - 0xEFFFF
	0xFFFFE - 0xFFFFF
	0x10FFFE - 0x10FFFF
*/
/*** GENERATED CODE ***/
#define is_LARGER_NON_CHARS_utf8(s)                                         \
( ( 0xED == ((const U8*)s)[0] ) ?                                           \
    ( ( ( ( ( ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[1]) & 0xF9 ) == 0xA9 ) || ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[1]) & 0xF1 ) == 0xB1 ) ) && ( 0x73 == ((const U8*)s)[2] ) ) && ( 0x73 == ((const U8*)s)[3] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[4], 0x72, 0x73) ) ) ? 5 : 0 )\
: ( ( ( ( ( 0xEE == ((const U8*)s)[0] ) && ( 0x42 == ((const U8*)s)[1] ) ) && ( 0x73 == ((const U8*)s)[2] ) ) && ( 0x73 == ((const U8*)s)[3] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[4], 0x72, 0x73) ) ) ? 5 : 0 )

/*
	SURROGATE: Surrogate code points

	\p{_Perl_Surrogate}
*/
/*** GENERATED CODE ***/
#define is_SURROGATE_utf8(s)                                                \
( ( ( 0xDD == ((const U8*)s)[0] ) && ( inRANGE_helper_(U8, ((const U8*)s)[1], 0x65, 0x66) ) ) ? 4 : 0 )

/*** GENERATED CODE ***/
#define is_SURROGATE_utf8_safe(s,e)                                         \
( ( ( ( ( ( ((e) - (s)) >= 4 ) && ( 0xDD == ((const U8*)s)[0] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[1], 0x65, 0x66) ) ) && ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[2]), 0xA0, 0xBF) ) ) && ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[3]), 0xA0, 0xBF) ) ) ? 4 : 0 )

/*
	QUOTEMETA: Meta-characters that \Q should quote

	\p{_Perl_Quotemeta}
*/
/*** GENERATED CODE ***/
#define is_QUOTEMETA_high(s)                                                \
( ( 0xB1 == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x56 == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xB8 == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x57 == ((const U8*)s)[1] ) && ( 0x70 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xBB == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x51 == ((const U8*)s)[1] ) ?                                       \
	( ( 0x73 == ((const U8*)s)[2] ) ? 3 : 0 )                           \
    : ( ( 0x52 == ((const U8*)s)[1] ) && ( 0x41 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xBC == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x63 == ((const U8*)s)[1] ) ?                                       \
	( ( 0x41 == ((const U8*)s)[2] ) ? 3 : 0 )                           \
    : ( ( 0x71 == ((const U8*)s)[1] ) && ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x63, 0x64) ) ) ? 3 : 0 )\
: ( 0xBE == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x41 == ((const U8*)s)[1] ) && ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x52, 0x56) ) ) ? 3 : 0 )\
: ( 0xCA == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x41 == ((const U8*)s)[1] || inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[1]), 0xAD, 0xBF) ) ?\
	3                                                                   \
    : ( 0x42 == ((const U8*)s)[1] ) ?                                       \
	( ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[2]), 0xA0, 0xBE) ) ? 3 : 0 )\
    : ( 0x43 == ((const U8*)s)[1] ) ?                                       \
	( ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[2]), 0xA1, 0xB3) || inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[2]), 0xB5, 0xBF) ) ? 3 : 0 )\
    : ( 0x44 == ((const U8*)s)[1] ) ?                                       \
	( ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[2]), 0xA0, 0xAF) ) ? 3 : 0 )\
    : ( ( 0x53 == ((const U8*)s)[1] ) && ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[2]), 0xB0, 0xBF) ) ) ? 3 : 0 )\
: ( 0xCB == ((const U8*)s)[0] ) ?                                           \
    ( ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[1]), 0xA0, 0xA2) || inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[1]), 0xA8, 0xBA) || inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[1]), 0xBD, 0xBF) ) ?\
	3                                                                   \
    : ( 0x6A == ((const U8*)s)[1] ) ?                                       \
	( ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[2]), 0xA0, 0xB5) ) ? 3 : 0 )\
    : ( ( 0x70 == ((const U8*)s)[1] ) && ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[2]), 0xB4, 0xBF) ) ) ? 3 : 0 )\
: ( 0xCC == ((const U8*)s)[0] ) ?                                           \
    3                                                                       \
: ( 0xCD == ((const U8*)s)[0] ) ?                                           \
    ( ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[1]), 0xB0, 0xB3) ) ?\
	3                                                                   \
    : 0 )                                                                   \
: ( 0xCE == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x41 == ((const U8*)s)[1] ) ?                                       \
	( ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[2]), 0xA0, 0xA3) || inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[2]), 0xA8, 0xBF) ) ? 3 : 0 )\
    : ( 0x42 == ((const U8*)s)[1] ) ?                                       \
	( ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[2]) & 0xEF ) == 0xA0 ) ? 3 : 0 )\
    : ( ( 0x52 == ((const U8*)s)[1] ) && ( 0x45 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xDD == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x73 == ((const U8*)s)[1] ) ?                                       \
	( ( 0x4A == ((const U8*)s)[2] ) ?                                   \
	    ( ( inRANGE_helper_(U8, ((const U8*)s)[3], 0x72, 0x73) ) ? 4 : 0 )\
	: ( 0x57 == ((const U8*)s)[2] ) ?                                   \
	    ( ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[3]), 0xA0, 0xAF) ) ? 4 : 0 )\
	: ( 0x59 == ((const U8*)s)[2] ) ?                                   \
	    ( ( inRANGE_helper_(U8, ((const U8*)s)[3], 0x46, 0x47) ) ? 4 : 0 )\
	: ( 0x66 == ((const U8*)s)[2] ) ?                                   \
	    ( ( 0x73 == ((const U8*)s)[3] ) ? 4 : 0 )                       \
	: ( 0x71 == ((const U8*)s)[2] ) ?                                   \
	    ( ( 0x41 == ((const U8*)s)[3] ) ? 4 : 0 )                       \
	: ( ( 0x73 == ((const U8*)s)[2] ) && ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[3]), 0xB0, 0xB8) ) ) ? 4 : 0 )\
    : 0 )                                                                   \
: ( 0xDF == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x56 == ((const U8*)s)[1] ) ?                                       \
	( ( ( 0x46 == ((const U8*)s)[2] ) && ( inRANGE_helper_(U8, ((const U8*)s)[3], 0x41, 0x44) ) ) ? 4 : 0 )\
    : ( ( ( 0x63 == ((const U8*)s)[1] ) && ( 0x52 == ((const U8*)s)[2] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[3], 0x62, 0x69) ) ) ? 4 : 0 )\
: ( ( ( 0xED == ((const U8*)s)[0] ) && ( 0x70 == ((const U8*)s)[1] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x41, 0x44) ) ) ? 5 : 0 )

/*
	MULTI_CHAR_FOLD: multi-char strings that are folded to by a single character

	%regcharclass_multi_char_folds::multi_char_folds('u', 'a')
*/
/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part0_(s,e)                            \
( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x48 == ((const U8*)s)[2] ) ) ? 3 : 0 )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part1_(s,e)                            \
( ( 0x8F == ((const U8*)s)[0] ) ?                                           \
	( ( 0x73 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x8F == ((const U8*)s)[2] ) ?                               \
		( ( 0x73 == ((const U8*)s)[3] ) ? 4 : 0 )                   \
	    : ( ( ((const U8*)s)[2] & 0xBE ) == 's' ) ? 3 : 0 )             \
	: 0 )                                                               \
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'j' ) ?                             \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x53 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 's' ) ?                             \
	( ( 0x8F == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x73 == ((const U8*)s)[2] ) ? 3 : 0 )                       \
	: ( ( ((const U8*)s)[1] & 0xBE ) == 's' ) ? 2 : 0 )                 \
    : ( ( ((const U8*)s)[0] & 0xBF ) == 't' ) ?                             \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x49 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ( ((const U8*)s)[0] & 0xBF ) == 'w' ) || ( ( ((const U8*)s)[0] & 0xBF ) == 'y' ) ) ?\
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x51 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xAB == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0x70 == ((const U8*)s)[1] ) && ( ( ((const U8*)s)[2] & 0xBF ) == 'n' ) ) ? 3 : 0 )\
    : ( 0xB4 == ((const U8*)s)[0] ) ?                                       \
	( ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[1]) & 0xFD ) == 0xAC ) ?     \
	    ( ( ( 0xB4 == ((const U8*)s)[2] ) && ( 0x68 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x58 == ((const U8*)s)[1] || 0x66 == ((const U8*)s)[1] ) ?      \
	    ( ( 0xB1 == ((const U8*)s)[2] ) ?                               \
		( ( 0x43 == ((const U8*)s)[3] ) ?                           \
		    ( ( ( 0xB4 == ((const U8*)s)[4] ) && ( 0x68 == ((const U8*)s)[5] ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xB4 == ((const U8*)s)[2] ) && ( 0x68 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x68 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xAF == ((const U8*)s)[2] ) ?                               \
		( ( 0x49 == ((const U8*)s)[3] ) ?                           \
		    ( ( 0xAF == ((const U8*)s)[4] ) ?                       \
			( ( inRANGE_helper_(U8, ((const U8*)s)[5], 0x41, 0x42) ) ? 6 : 0 )\
		    : ( ( 0xB1 == ((const U8*)s)[4] ) && ( 0x43 == ((const U8*)s)[5] ) ) ? 6 : 0 )\
		: 0 )                                                       \
	    : ( ( 0xB1 == ((const U8*)s)[2] ) && ( 0x43 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: 0 )                                                               \
    : ( 0xB5 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x42 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xAF == ((const U8*)s)[2] ) && ( 0x62 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x46 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xAF == ((const U8*)s)[2] ) ?                               \
		( ( 0x49 == ((const U8*)s)[3] ) ?                           \
		    ( ( 0xAF == ((const U8*)s)[4] ) ?                       \
			( ( inRANGE_helper_(U8, ((const U8*)s)[5], 0x41, 0x42) ) ? 6 : 0 )\
		    : ( ( 0xB1 == ((const U8*)s)[4] ) && ( 0x43 == ((const U8*)s)[5] ) ) ? 6 : 0 )\
		: ( 0x62 == ((const U8*)s)[3] ) ?                           \
		    ( ( 0xAF == ((const U8*)s)[4] ) ?                       \
			( ( inRANGE_helper_(U8, ((const U8*)s)[5], 0x41, 0x42) ) ? 6 : 4 )\
		    : ( ( 0xB1 == ((const U8*)s)[4] ) && ( 0x43 == ((const U8*)s)[5] ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xB1 == ((const U8*)s)[2] ) && ( 0x43 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x4A == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xB1 == ((const U8*)s)[2] ) ?                               \
		( ( 0x43 == ((const U8*)s)[3] ) ?                           \
		    ( ( ( 0xB4 == ((const U8*)s)[4] ) && ( 0x68 == ((const U8*)s)[5] ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xB4 == ((const U8*)s)[2] ) && ( 0x68 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x55 == ((const U8*)s)[1] ) && ( 0xB4 == ((const U8*)s)[2] ) ) && ( 0x68 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xB8 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x52 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x46 == ((const U8*)s)[2] ) ?                               \
		( ( ( ( 0xB8 == ((const U8*)s)[3] ) && ( 0x53 == ((const U8*)s)[4] ) ) && ( 0x43 == ((const U8*)s)[5] ) ) ? 6 : 0 )\
	    : ( 0x63 == ((const U8*)s)[2] ) ?                               \
		( ( ( ( 0xB8 == ((const U8*)s)[3] ) && ( 0x52 == ((const U8*)s)[4] ) ) && ( ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[5]) & 0xF7 ) == 0xA5 ) || ((const U8*)s)[5] == 0x52 || ((const U8*)s)[5] == 0x65 ) ) ? 6 : 0 )\
	    : ( ( ( ( 0x72 == ((const U8*)s)[2] ) && ( 0xB8 == ((const U8*)s)[3] ) ) && ( 0x52 == ((const U8*)s)[4] ) ) && ( 0x65 == ((const U8*)s)[5] ) ) ? 6 : 0 )\
	: 0 )                                                               \
    : ( 0xBF == ((const U8*)s)[0] ) ?                                       \
	( ( inRANGE_helper_(U8, ((const U8*)s)[1], 0x67, 0x68) ) ?          \
	    ( ( ( ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x41, 0x48) ) && ( 0xB4 == ((const U8*)s)[3] ) ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 5 : 0 )\
	: ( ( ( ( 0x6A == ((const U8*)s)[1] ) && ( ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[2]) & 0xF8 ) == 0xA0 ) || ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[2]) & 0xFB ) == 0xB0 ) || ((const U8*)s)[2] == 0x70 ) ) && ( 0xB4 == ((const U8*)s)[3] ) ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 5 : 0 )\
    : 0 )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part2_(s,e)                            \
( ( ( ((const U8*)s)[0] & 0xBF ) == 'a' ) ?                                 \
	( ( ( 0xAB == ((const U8*)s)[1] ) && ( 0x72 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'f' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xBF ) == 'f' ) ?                         \
	    ( ( ( ( ((const U8*)s)[2] & 0xBF ) == 'i' ) || ( ( ((const U8*)s)[2] & 0xBF ) == 'l' ) ) ? 3 : 2 )\
	: ( ( ( ((const U8*)s)[1] & 0xBF ) == 'i' ) || ( ( ((const U8*)s)[1] & 0xBF ) == 'l' ) ) ? 2 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'h' ) ?                             \
	( ( ( 0xB0 == ((const U8*)s)[1] ) && ( 0x58 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'i' ) ?                             \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x48 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x8F == ((const U8*)s)[0] ) ?                                       \
	( ( 0x73 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x8F == ((const U8*)s)[2] ) ?                               \
		( ( 0x73 == ((const U8*)s)[3] ) ? 4 : 0 )                   \
	    : ( ( ((const U8*)s)[2] & 0xBE ) == 's' ) ? 3 : 0 )             \
	: 0 )                                                               \
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'j' ) ?                             \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x53 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 's' ) ?                             \
	( ( 0x8F == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x73 == ((const U8*)s)[2] ) ? 3 : 0 )                       \
	: ( ( ((const U8*)s)[1] & 0xBE ) == 's' ) ? 2 : 0 )                 \
    : ( ( ((const U8*)s)[0] & 0xBF ) == 't' ) ?                             \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x49 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ( ((const U8*)s)[0] & 0xBF ) == 'w' ) || ( ( ((const U8*)s)[0] & 0xBF ) == 'y' ) ) ?\
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x51 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xAB == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0x70 == ((const U8*)s)[1] ) && ( ( ((const U8*)s)[2] & 0xBF ) == 'n' ) ) ? 3 : 0 )\
    : ( 0xB4 == ((const U8*)s)[0] ) ?                                       \
	( ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[1]) & 0xFD ) == 0xAC ) ?     \
	    ( ( ( 0xB4 == ((const U8*)s)[2] ) && ( 0x68 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x58 == ((const U8*)s)[1] || 0x66 == ((const U8*)s)[1] ) ?      \
	    ( ( 0xB1 == ((const U8*)s)[2] ) ?                               \
		( ( 0x43 == ((const U8*)s)[3] ) ? 4 : 0 )                   \
	    : ( ( 0xB4 == ((const U8*)s)[2] ) && ( 0x68 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x68 == ((const U8*)s)[1] ) && ( 0xB1 == ((const U8*)s)[2] ) ) && ( 0x43 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xB5 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x42 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xAF == ((const U8*)s)[2] ) && ( 0x62 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x46 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xAF == ((const U8*)s)[2] ) ?                               \
		( ( 0x62 == ((const U8*)s)[3] ) ? 4 : 0 )                   \
	    : ( ( 0xB1 == ((const U8*)s)[2] ) && ( 0x43 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x4A == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xB1 == ((const U8*)s)[2] ) ?                               \
		( ( 0x43 == ((const U8*)s)[3] ) ? 4 : 0 )                   \
	    : ( ( 0xB4 == ((const U8*)s)[2] ) && ( 0x68 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x55 == ((const U8*)s)[1] ) && ( 0xB4 == ((const U8*)s)[2] ) ) && ( 0x68 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xBF == ((const U8*)s)[0] ) ?                                       \
	( ( inRANGE_helper_(U8, ((const U8*)s)[1], 0x67, 0x68) ) ?          \
	    ( ( ( ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x41, 0x48) ) && ( 0xB4 == ((const U8*)s)[3] ) ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 5 : 0 )\
	: ( ( ( ( 0x6A == ((const U8*)s)[1] ) && ( ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[2]) & 0xF8 ) == 0xA0 ) || ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[2]) & 0xFB ) == 0xB0 ) || ((const U8*)s)[2] == 0x70 ) ) && ( 0xB4 == ((const U8*)s)[3] ) ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 5 : 0 )\
    : 0 )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part3_(s,e)                            \
( ((e)-(s) > 3) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xBF ) == 'a' ) ?                             \
	( ( ( 0xAB == ((const U8*)s)[1] ) && ( 0x72 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'f' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xBF ) == 'f' ) ?                         \
	    ( ( ( ( ((const U8*)s)[2] & 0xBF ) == 'i' ) || ( ( ((const U8*)s)[2] & 0xBF ) == 'l' ) ) ? 3 : 2 )\
	: ( ( ( ((const U8*)s)[1] & 0xBF ) == 'i' ) || ( ( ((const U8*)s)[1] & 0xBF ) == 'l' ) ) ? 2 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'h' ) ?                             \
	( ( ( 0xB0 == ((const U8*)s)[1] ) && ( 0x58 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'i' ) ?                             \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x48 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x8F == ((const U8*)s)[0] ) ?                                       \
	( ( 0x73 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x8F == ((const U8*)s)[2] ) ?                               \
		( ( 0x73 == ((const U8*)s)[3] ) ? 4 : 0 )                   \
	    : ( ( ((const U8*)s)[2] & 0xBE ) == 's' ) ? 3 : 0 )             \
	: 0 )                                                               \
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'j' ) ?                             \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x53 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 's' ) ?                             \
	( ( 0x8F == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x73 == ((const U8*)s)[2] ) ? 3 : 0 )                       \
	: ( ( ((const U8*)s)[1] & 0xBE ) == 's' ) ? 2 : 0 )                 \
    : ( ( ((const U8*)s)[0] & 0xBF ) == 't' ) ?                             \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x49 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ( ((const U8*)s)[0] & 0xBF ) == 'w' ) || ( ( ((const U8*)s)[0] & 0xBF ) == 'y' ) ) ?\
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x51 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xAB == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0x70 == ((const U8*)s)[1] ) && ( ( ((const U8*)s)[2] & 0xBF ) == 'n' ) ) ? 3 : 0 )\
    : ( 0xB4 == ((const U8*)s)[0] ) ?                                       \
	( ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[1]) & 0xFD ) == 0xAC ) ?     \
	    ( ( ( 0xB4 == ((const U8*)s)[2] ) && ( 0x68 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x58 == ((const U8*)s)[1] || 0x66 == ((const U8*)s)[1] ) ?      \
	    ( ( 0xB1 == ((const U8*)s)[2] ) ?                               \
		( ( 0x43 == ((const U8*)s)[3] ) ? 4 : 0 )                   \
	    : ( ( 0xB4 == ((const U8*)s)[2] ) && ( 0x68 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x68 == ((const U8*)s)[1] ) && ( 0xB1 == ((const U8*)s)[2] ) ) && ( 0x43 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xB5 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x42 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xAF == ((const U8*)s)[2] ) && ( 0x62 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x46 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xAF == ((const U8*)s)[2] ) ?                               \
		( ( 0x62 == ((const U8*)s)[3] ) ? 4 : 0 )                   \
	    : ( ( 0xB1 == ((const U8*)s)[2] ) && ( 0x43 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x4A == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xB1 == ((const U8*)s)[2] ) ?                               \
		( ( 0x43 == ((const U8*)s)[3] ) ? 4 : 0 )                   \
	    : ( ( 0xB4 == ((const U8*)s)[2] ) && ( 0x68 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x55 == ((const U8*)s)[1] ) && ( 0xB4 == ((const U8*)s)[2] ) ) && ( 0x68 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : 0 )                                                                   \
: ((e)-(s) > 2) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xBF ) == 'a' ) ?                             \
	( ( ( 0xAB == ((const U8*)s)[1] ) && ( 0x72 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'f' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xBF ) == 'f' ) ?                         \
	    ( ( ( ( ((const U8*)s)[2] & 0xBF ) == 'i' ) || ( ( ((const U8*)s)[2] & 0xBF ) == 'l' ) ) ? 3 : 2 )\
	: ( ( ( ((const U8*)s)[1] & 0xBF ) == 'i' ) || ( ( ((const U8*)s)[1] & 0xBF ) == 'l' ) ) ? 2 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'h' ) ?                             \
	( ( ( 0xB0 == ((const U8*)s)[1] ) && ( 0x58 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'i' ) ?                             \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x48 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x8F == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0x73 == ((const U8*)s)[1] ) && ( ( ((const U8*)s)[2] & 0xBE ) == 's' ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'j' ) ?                             \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x53 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 's' ) ?                             \
	( ( 0x8F == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x73 == ((const U8*)s)[2] ) ? 3 : 0 )                       \
	: ( ( ((const U8*)s)[1] & 0xBE ) == 's' ) ? 2 : 0 )                 \
    : ( ( ((const U8*)s)[0] & 0xBF ) == 't' ) ?                             \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x49 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ( ((const U8*)s)[0] & 0xBF ) == 'w' ) || ( ( ((const U8*)s)[0] & 0xBF ) == 'y' ) ) ?\
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x51 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ( 0xAB == ((const U8*)s)[0] ) && ( 0x70 == ((const U8*)s)[1] ) ) && ( ( ((const U8*)s)[2] & 0xBF ) == 'n' ) ) ? 3 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xBF ) == 'f' ) ?                             \
	( ( ( ( ((const U8*)s)[1] & 0xBF ) == 'f' ) || ( ( ((const U8*)s)[1] & 0xBF ) == 'i' ) || ( ( ((const U8*)s)[1] & 0xBF ) == 'l' ) ) ? 2 : 0 )\
    : ( ( ( ((const U8*)s)[0] & 0xBF ) == 's' ) && ( ( ((const U8*)s)[1] & 0xBE ) == 's' ) ) ? 2 : 0 )\
: 0 )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe(s,e)                                   \
( ((e)-(s) > 5) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xBF ) == 'a' ) ?                             \
	( ( ( 0xAB == ((const U8*)s)[1] ) && ( 0x72 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'f' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xBF ) == 'f' ) ?                         \
	    ( ( ( ( ((const U8*)s)[2] & 0xBF ) == 'i' ) || ( ( ((const U8*)s)[2] & 0xBF ) == 'l' ) ) ? 3 : 2 )\
	: ( ( ( ((const U8*)s)[1] & 0xBF ) == 'i' ) || ( ( ((const U8*)s)[1] & 0xBF ) == 'l' ) ) ? 2 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'h' ) ?                             \
	( ( ( 0xB0 == ((const U8*)s)[1] ) && ( 0x58 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'i' ) ? is_MULTI_CHAR_FOLD_utf8_safe_part0_(s,e) : is_MULTI_CHAR_FOLD_utf8_safe_part1_(s,e) )\
: ((e)-(s) > 4) ? is_MULTI_CHAR_FOLD_utf8_safe_part2_(s,e) : is_MULTI_CHAR_FOLD_utf8_safe_part3_(s,e) )

/*** GENERATED CODE ***/
#define what_MULTI_CHAR_FOLD_utf8_safe_part0_(s,e)                          \
( ( 0x52 == ((const U8*)s)[1] ) ?                                           \
	    ( ( 0x46 == ((const U8*)s)[2] ) ?                               \
		( ( ( ( 0xB8 == ((const U8*)s)[3] ) && ( 0x53 == ((const U8*)s)[4] ) ) && ( 0x43 == ((const U8*)s)[5] ) ) ? 0x587 : 0 )\
	    : ( 0x63 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB8 == ((const U8*)s)[3] ) && ( 0x52 == ((const U8*)s)[4] ) ) ? ( ( 0x46 == ((const U8*)s)[5] ) ? 0xFB14\
			: ( 0x52 == ((const U8*)s)[5] ) ? 0xFB15            \
			: ( 0x54 == ((const U8*)s)[5] ) ? 0xFB17            \
			: ( 0x65 == ((const U8*)s)[5] ) ? 0xFB13 : 0 ) : 0 )\
	    : ( ( ( ( 0x72 == ((const U8*)s)[2] ) && ( 0xB8 == ((const U8*)s)[3] ) ) && ( 0x52 == ((const U8*)s)[4] ) ) && ( 0x65 == ((const U8*)s)[5] ) ) ? 0xFB16 : 0 )\
	: 0 )


/*** GENERATED CODE ***/
#define what_MULTI_CHAR_FOLD_utf8_safe_part1_(s,e)                          \
( ( 0xBF == ((const U8*)s)[0] ) ?                                           \
	( ( 0x67 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x41 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1F80 : 0 )\
	    : ( 0x42 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1F81 : 0 )\
	    : ( 0x43 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1F82 : 0 )\
	    : ( 0x44 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1F83 : 0 )\
	    : ( 0x45 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1F84 : 0 )\
	    : ( 0x46 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1F85 : 0 )\
	    : ( 0x47 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1F86 : 0 )\
	    : ( ( ( 0x48 == ((const U8*)s)[2] ) && ( 0xB4 == ((const U8*)s)[3] ) ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1F87 : 0 )\
	: ( 0x68 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x41 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1F90 : 0 )\
	    : ( 0x42 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1F91 : 0 )\
	    : ( 0x43 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1F92 : 0 )\
	    : ( 0x44 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1F93 : 0 )\
	    : ( 0x45 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1F94 : 0 )\
	    : ( 0x46 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1F95 : 0 )\
	    : ( 0x47 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1F96 : 0 )\
	    : ( ( ( 0x48 == ((const U8*)s)[2] ) && ( 0xB4 == ((const U8*)s)[3] ) ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1F97 : 0 )\
	: ( 0x6A == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x41 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1FA0 : 0 )\
	    : ( 0x42 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1FA1 : 0 )\
	    : ( 0x43 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1FA2 : 0 )\
	    : ( 0x44 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1FA3 : 0 )\
	    : ( 0x45 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1FA4 : 0 )\
	    : ( 0x46 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1FA5 : 0 )\
	    : ( 0x47 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1FA6 : 0 )\
	    : ( 0x48 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1FA7 : 0 )\
	    : ( 0x57 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1FB2 : 0 )\
	    : ( 0x63 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1FC2 : 0 )\
	    : ( ( ( 0x70 == ((const U8*)s)[2] ) && ( 0xB4 == ((const U8*)s)[3] ) ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1FF2 : 0 )\
	: 0 )                                                               \
    : 0 )


/*** GENERATED CODE ***/
#define what_MULTI_CHAR_FOLD_utf8_safe_part2_(s,e)                          \
( ( ( ((const U8*)s)[1] & 0xBF ) == 'f' ) ?                                 \
	    ( ( ( ((const U8*)s)[2] & 0xBF ) == 'i' ) ? 0xFB03              \
	    : ( ( ((const U8*)s)[2] & 0xBF ) == 'l' ) ? 0xFB04 : 0xFB00 )   \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 'i' ) ? 0xFB01                  \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 'l' ) ? 0xFB02 : 0 )


/*** GENERATED CODE ***/
#define what_MULTI_CHAR_FOLD_utf8_safe_part3_(s,e)                          \
( ( ( ((const U8*)s)[0] & 0xBF ) == 'h' ) ?                                 \
	( ( ( 0xB0 == ((const U8*)s)[1] ) && ( 0x58 == ((const U8*)s)[2] ) ) ? 0x1E96 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'i' ) ?                             \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x48 == ((const U8*)s)[2] ) ) ? 0x130 : 0 )\
    : ( 0x8F == ((const U8*)s)[0] ) ?                                       \
	( ( 0x73 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x8F == ((const U8*)s)[2] ) ?                               \
		( ( 0x73 == ((const U8*)s)[3] ) ? 0x59 : 0 )                \
	    : ( ( ((const U8*)s)[2] & 0xBF ) == 's' ) ? 0x59                \
	    : ( ( ((const U8*)s)[2] & 0xBF ) == 't' ) ? 0xFB05 : 0 )        \
	: 0 )                                                               \
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'j' ) ?                             \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x53 == ((const U8*)s)[2] ) ) ? 0x1F0 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 's' ) ?                             \
	( ( 0x8F == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x73 == ((const U8*)s)[2] ) ? 0x59 : 0 )                    \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 's' ) ? 0x59                    \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 't' ) ? 0xFB05 : 0 )            \
    : ( ( ((const U8*)s)[0] & 0xBF ) == 't' ) ?                             \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x49 == ((const U8*)s)[2] ) ) ? 0x1E97 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'w' ) ?                             \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x51 == ((const U8*)s)[2] ) ) ? 0x1E98 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'y' ) ?                             \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x51 == ((const U8*)s)[2] ) ) ? 0x1E99 : 0 )\
    : ( 0xAB == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0x70 == ((const U8*)s)[1] ) && ( ( ((const U8*)s)[2] & 0xBF ) == 'n' ) ) ? 0x149 : 0 )\
    : ( 0xB4 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x53 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xB4 == ((const U8*)s)[2] ) && ( 0x68 == ((const U8*)s)[3] ) ) ? 0x1FB4 : 0 )\
	: ( 0x55 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xB4 == ((const U8*)s)[2] ) && ( 0x68 == ((const U8*)s)[3] ) ) ? 0x1FC4 : 0 )\
	: ( 0x58 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xB1 == ((const U8*)s)[2] ) ?                               \
		( ( 0x43 == ((const U8*)s)[3] ) ?                           \
		    ( ( ( 0xB4 == ((const U8*)s)[4] ) && ( 0x68 == ((const U8*)s)[5] ) ) ? 0x1FB7 : 0x1FB6 )\
		: 0 )                                                       \
	    : ( ( 0xB4 == ((const U8*)s)[2] ) && ( 0x68 == ((const U8*)s)[3] ) ) ? 0x1FB3 : 0 )\
	: ( 0x66 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xB1 == ((const U8*)s)[2] ) ?                               \
		( ( 0x43 == ((const U8*)s)[3] ) ?                           \
		    ( ( ( 0xB4 == ((const U8*)s)[4] ) && ( 0x68 == ((const U8*)s)[5] ) ) ? 0x1FC7 : 0x1FC6 )\
		: 0 )                                                       \
	    : ( ( 0xB4 == ((const U8*)s)[2] ) && ( 0x68 == ((const U8*)s)[3] ) ) ? 0x1FC3 : 0 )\
	: ( 0x68 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xAF == ((const U8*)s)[2] ) ?                               \
		( ( 0x49 == ((const U8*)s)[3] ) ?                           \
		    ( ( 0xAF == ((const U8*)s)[4] ) ?                       \
			( ( 0x41 == ((const U8*)s)[5] ) ? 0x1FD2            \
			: ( 0x42 == ((const U8*)s)[5] ) ? 0x390 : 0 )       \
		    : ( ( 0xB1 == ((const U8*)s)[4] ) && ( 0x43 == ((const U8*)s)[5] ) ) ? 0x1FD7 : 0 )\
		: 0 )                                                       \
	    : ( ( 0xB1 == ((const U8*)s)[2] ) && ( 0x43 == ((const U8*)s)[3] ) ) ? 0x1FD6 : 0 )\
	: 0 )                                                               \
    : ( 0xB5 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x42 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xAF == ((const U8*)s)[2] ) && ( 0x62 == ((const U8*)s)[3] ) ) ? 0x1FE4 : 0 )\
	: ( 0x46 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xAF == ((const U8*)s)[2] ) ?                               \
		( ( 0x49 == ((const U8*)s)[3] ) ?                           \
		    ( ( 0xAF == ((const U8*)s)[4] ) ?                       \
			( ( 0x41 == ((const U8*)s)[5] ) ? 0x1FE2            \
			: ( 0x42 == ((const U8*)s)[5] ) ? 0x3B0 : 0 )       \
		    : ( ( 0xB1 == ((const U8*)s)[4] ) && ( 0x43 == ((const U8*)s)[5] ) ) ? 0x1FE7 : 0 )\
		: ( 0x62 == ((const U8*)s)[3] ) ?                           \
		    ( ( 0xAF == ((const U8*)s)[4] ) ?                       \
			( ( 0x41 == ((const U8*)s)[5] ) ? 0x1F52            \
			: ( 0x42 == ((const U8*)s)[5] ) ? 0x1F54 : 0x1F50 ) \
		    : ( ( 0xB1 == ((const U8*)s)[4] ) && ( 0x43 == ((const U8*)s)[5] ) ) ? 0x1F56 : 0x1F50 )\
		: 0 )                                                       \
	    : ( ( 0xB1 == ((const U8*)s)[2] ) && ( 0x43 == ((const U8*)s)[3] ) ) ? 0x1FE6 : 0 )\
	: ( 0x4A == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xB1 == ((const U8*)s)[2] ) ?                               \
		( ( 0x43 == ((const U8*)s)[3] ) ?                           \
		    ( ( ( 0xB4 == ((const U8*)s)[4] ) && ( 0x68 == ((const U8*)s)[5] ) ) ? 0x1FF7 : 0x1FF6 )\
		: 0 )                                                       \
	    : ( ( 0xB4 == ((const U8*)s)[2] ) && ( 0x68 == ((const U8*)s)[3] ) ) ? 0x1FF3 : 0 )\
	: ( ( ( 0x55 == ((const U8*)s)[1] ) && ( 0xB4 == ((const U8*)s)[2] ) ) && ( 0x68 == ((const U8*)s)[3] ) ) ? 0x1FF4 : 0 )\
    : ( 0xB8 == ((const U8*)s)[0] ) ? what_MULTI_CHAR_FOLD_utf8_safe_part0_(s,e) : what_MULTI_CHAR_FOLD_utf8_safe_part1_(s,e) )


/*** GENERATED CODE ***/
#define what_MULTI_CHAR_FOLD_utf8_safe_part4_(s,e)                          \
( ( 0x42 == ((const U8*)s)[1] ) ?                                           \
	    ( ( ( 0xAF == ((const U8*)s)[2] ) && ( 0x62 == ((const U8*)s)[3] ) ) ? 0x1FE4 : 0 )\
	: ( 0x46 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xAF == ((const U8*)s)[2] ) ?                               \
		( ( 0x62 == ((const U8*)s)[3] ) ? 0x1F50 : 0 )              \
	    : ( ( 0xB1 == ((const U8*)s)[2] ) && ( 0x43 == ((const U8*)s)[3] ) ) ? 0x1FE6 : 0 )\
	: ( 0x4A == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xB1 == ((const U8*)s)[2] ) ?                               \
		( ( 0x43 == ((const U8*)s)[3] ) ? 0x1FF6 : 0 )              \
	    : ( ( 0xB4 == ((const U8*)s)[2] ) && ( 0x68 == ((const U8*)s)[3] ) ) ? 0x1FF3 : 0 )\
	: ( ( ( 0x55 == ((const U8*)s)[1] ) && ( 0xB4 == ((const U8*)s)[2] ) ) && ( 0x68 == ((const U8*)s)[3] ) ) ? 0x1FF4 : 0 )


/*** GENERATED CODE ***/
#define what_MULTI_CHAR_FOLD_utf8_safe_part5_(s,e)                          \
( ( 0xBF == ((const U8*)s)[0] ) ?                                           \
	( ( 0x67 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x41 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1F80 : 0 )\
	    : ( 0x42 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1F81 : 0 )\
	    : ( 0x43 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1F82 : 0 )\
	    : ( 0x44 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1F83 : 0 )\
	    : ( 0x45 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1F84 : 0 )\
	    : ( 0x46 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1F85 : 0 )\
	    : ( 0x47 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1F86 : 0 )\
	    : ( ( ( 0x48 == ((const U8*)s)[2] ) && ( 0xB4 == ((const U8*)s)[3] ) ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1F87 : 0 )\
	: ( 0x68 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x41 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1F90 : 0 )\
	    : ( 0x42 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1F91 : 0 )\
	    : ( 0x43 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1F92 : 0 )\
	    : ( 0x44 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1F93 : 0 )\
	    : ( 0x45 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1F94 : 0 )\
	    : ( 0x46 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1F95 : 0 )\
	    : ( 0x47 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1F96 : 0 )\
	    : ( ( ( 0x48 == ((const U8*)s)[2] ) && ( 0xB4 == ((const U8*)s)[3] ) ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1F97 : 0 )\
	: ( 0x6A == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x41 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1FA0 : 0 )\
	    : ( 0x42 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1FA1 : 0 )\
	    : ( 0x43 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1FA2 : 0 )\
	    : ( 0x44 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1FA3 : 0 )\
	    : ( 0x45 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1FA4 : 0 )\
	    : ( 0x46 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1FA5 : 0 )\
	    : ( 0x47 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1FA6 : 0 )\
	    : ( 0x48 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1FA7 : 0 )\
	    : ( 0x57 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1FB2 : 0 )\
	    : ( 0x63 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB4 == ((const U8*)s)[3] ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1FC2 : 0 )\
	    : ( ( ( 0x70 == ((const U8*)s)[2] ) && ( 0xB4 == ((const U8*)s)[3] ) ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 0x1FF2 : 0 )\
	: 0 )                                                               \
    : 0 )


/*** GENERATED CODE ***/
#define what_MULTI_CHAR_FOLD_utf8_safe_part6_(s,e)                          \
( ( ( ((const U8*)s)[0] & 0xBF ) == 'a' ) ?                                 \
	( ( ( 0xAB == ((const U8*)s)[1] ) && ( 0x72 == ((const U8*)s)[2] ) ) ? 0x1E9A : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'f' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xBF ) == 'f' ) ?                         \
	    ( ( ( ((const U8*)s)[2] & 0xBF ) == 'i' ) ? 0xFB03              \
	    : ( ( ((const U8*)s)[2] & 0xBF ) == 'l' ) ? 0xFB04 : 0xFB00 )   \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 'i' ) ? 0xFB01                  \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 'l' ) ? 0xFB02 : 0 )            \
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'h' ) ?                             \
	( ( ( 0xB0 == ((const U8*)s)[1] ) && ( 0x58 == ((const U8*)s)[2] ) ) ? 0x1E96 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'i' ) ?                             \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x48 == ((const U8*)s)[2] ) ) ? 0x130 : 0 )\
    : ( 0x8F == ((const U8*)s)[0] ) ?                                       \
	( ( 0x73 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x8F == ((const U8*)s)[2] ) ?                               \
		( ( 0x73 == ((const U8*)s)[3] ) ? 0x59 : 0 )                \
	    : ( ( ((const U8*)s)[2] & 0xBF ) == 's' ) ? 0x59                \
	    : ( ( ((const U8*)s)[2] & 0xBF ) == 't' ) ? 0xFB05 : 0 )        \
	: 0 )                                                               \
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'j' ) ?                             \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x53 == ((const U8*)s)[2] ) ) ? 0x1F0 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 's' ) ?                             \
	( ( 0x8F == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x73 == ((const U8*)s)[2] ) ? 0x59 : 0 )                    \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 's' ) ? 0x59                    \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 't' ) ? 0xFB05 : 0 )            \
    : ( ( ((const U8*)s)[0] & 0xBF ) == 't' ) ?                             \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x49 == ((const U8*)s)[2] ) ) ? 0x1E97 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'w' ) ?                             \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x51 == ((const U8*)s)[2] ) ) ? 0x1E98 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'y' ) ?                             \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x51 == ((const U8*)s)[2] ) ) ? 0x1E99 : 0 )\
    : ( 0xAB == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0x70 == ((const U8*)s)[1] ) && ( ( ((const U8*)s)[2] & 0xBF ) == 'n' ) ) ? 0x149 : 0 )\
    : ( 0xB4 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x53 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xB4 == ((const U8*)s)[2] ) && ( 0x68 == ((const U8*)s)[3] ) ) ? 0x1FB4 : 0 )\
	: ( 0x55 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xB4 == ((const U8*)s)[2] ) && ( 0x68 == ((const U8*)s)[3] ) ) ? 0x1FC4 : 0 )\
	: ( 0x58 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xB1 == ((const U8*)s)[2] ) ?                               \
		( ( 0x43 == ((const U8*)s)[3] ) ? 0x1FB6 : 0 )              \
	    : ( ( 0xB4 == ((const U8*)s)[2] ) && ( 0x68 == ((const U8*)s)[3] ) ) ? 0x1FB3 : 0 )\
	: ( 0x66 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xB1 == ((const U8*)s)[2] ) ?                               \
		( ( 0x43 == ((const U8*)s)[3] ) ? 0x1FC6 : 0 )              \
	    : ( ( 0xB4 == ((const U8*)s)[2] ) && ( 0x68 == ((const U8*)s)[3] ) ) ? 0x1FC3 : 0 )\
	: ( ( ( 0x68 == ((const U8*)s)[1] ) && ( 0xB1 == ((const U8*)s)[2] ) ) && ( 0x43 == ((const U8*)s)[3] ) ) ? 0x1FD6 : 0 )\
    : ( 0xB5 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x42 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xAF == ((const U8*)s)[2] ) && ( 0x62 == ((const U8*)s)[3] ) ) ? 0x1FE4 : 0 )\
	: ( 0x46 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xAF == ((const U8*)s)[2] ) ?                               \
		( ( 0x62 == ((const U8*)s)[3] ) ? 0x1F50 : 0 )              \
	    : ( ( 0xB1 == ((const U8*)s)[2] ) && ( 0x43 == ((const U8*)s)[3] ) ) ? 0x1FE6 : 0 )\
	: ( 0x4A == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xB1 == ((const U8*)s)[2] ) ?                               \
		( ( 0x43 == ((const U8*)s)[3] ) ? 0x1FF6 : 0 )              \
	    : ( ( 0xB4 == ((const U8*)s)[2] ) && ( 0x68 == ((const U8*)s)[3] ) ) ? 0x1FF3 : 0 )\
	: ( ( ( 0x55 == ((const U8*)s)[1] ) && ( 0xB4 == ((const U8*)s)[2] ) ) && ( 0x68 == ((const U8*)s)[3] ) ) ? 0x1FF4 : 0 )\
    : 0 )


/*** GENERATED CODE ***/
#define what_MULTI_CHAR_FOLD_utf8_safe_part7_(s,e)                          \
( ((e)-(s) > 2) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xBF ) == 'a' ) ?                             \
	( ( ( 0xAB == ((const U8*)s)[1] ) && ( 0x72 == ((const U8*)s)[2] ) ) ? 0x1E9A : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'f' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xBF ) == 'f' ) ?                         \
	    ( ( ( ((const U8*)s)[2] & 0xBF ) == 'i' ) ? 0xFB03              \
	    : ( ( ((const U8*)s)[2] & 0xBF ) == 'l' ) ? 0xFB04 : 0xFB00 )   \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 'i' ) ? 0xFB01                  \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 'l' ) ? 0xFB02 : 0 )            \
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'h' ) ?                             \
	( ( ( 0xB0 == ((const U8*)s)[1] ) && ( 0x58 == ((const U8*)s)[2] ) ) ? 0x1E96 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'i' ) ?                             \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x48 == ((const U8*)s)[2] ) ) ? 0x130 : 0 )\
    : ( 0x8F == ((const U8*)s)[0] ) ?                                       \
	( ( 0x73 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( ((const U8*)s)[2] & 0xBF ) == 's' ) ? 0x59                \
	    : ( ( ((const U8*)s)[2] & 0xBF ) == 't' ) ? 0xFB05 : 0 )        \
	: 0 )                                                               \
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'j' ) ?                             \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x53 == ((const U8*)s)[2] ) ) ? 0x1F0 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 's' ) ?                             \
	( ( 0x8F == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x73 == ((const U8*)s)[2] ) ? 0x59 : 0 )                    \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 's' ) ? 0x59                    \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 't' ) ? 0xFB05 : 0 )            \
    : ( ( ((const U8*)s)[0] & 0xBF ) == 't' ) ?                             \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x49 == ((const U8*)s)[2] ) ) ? 0x1E97 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'w' ) ?                             \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x51 == ((const U8*)s)[2] ) ) ? 0x1E98 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'y' ) ?                             \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x51 == ((const U8*)s)[2] ) ) ? 0x1E99 : 0 )\
    : ( ( ( 0xAB == ((const U8*)s)[0] ) && ( 0x70 == ((const U8*)s)[1] ) ) && ( ( ((const U8*)s)[2] & 0xBF ) == 'n' ) ) ? 0x149 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xBF ) == 'f' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xBF ) == 'f' ) ? 0xFB00                  \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 'i' ) ? 0xFB01                  \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 'l' ) ? 0xFB02 : 0 )            \
    : ( ( ((const U8*)s)[0] & 0xBF ) == 's' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xBF ) == 's' ) ? 0x59                    \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 't' ) ? 0xFB05 : 0 )            \
    : 0 )                                                                   \
: 0 )


/*** GENERATED CODE ***/
#define what_MULTI_CHAR_FOLD_utf8_safe(s,e)                                 \
( ((e)-(s) > 5) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xBF ) == 'a' ) ?                             \
	( ( ( 0xAB == ((const U8*)s)[1] ) && ( 0x72 == ((const U8*)s)[2] ) ) ? 0x1E9A : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'f' ) ? what_MULTI_CHAR_FOLD_utf8_safe_part2_(s,e) : what_MULTI_CHAR_FOLD_utf8_safe_part3_(s,e) )\
: ((e)-(s) > 4) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xBF ) == 'a' ) ?                             \
	( ( ( 0xAB == ((const U8*)s)[1] ) && ( 0x72 == ((const U8*)s)[2] ) ) ? 0x1E9A : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'f' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xBF ) == 'f' ) ?                         \
	    ( ( ( ((const U8*)s)[2] & 0xBF ) == 'i' ) ? 0xFB03              \
	    : ( ( ((const U8*)s)[2] & 0xBF ) == 'l' ) ? 0xFB04 : 0xFB00 )   \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 'i' ) ? 0xFB01                  \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 'l' ) ? 0xFB02 : 0 )            \
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'h' ) ?                             \
	( ( ( 0xB0 == ((const U8*)s)[1] ) && ( 0x58 == ((const U8*)s)[2] ) ) ? 0x1E96 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'i' ) ?                             \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x48 == ((const U8*)s)[2] ) ) ? 0x130 : 0 )\
    : ( 0x8F == ((const U8*)s)[0] ) ?                                       \
	( ( 0x73 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x8F == ((const U8*)s)[2] ) ?                               \
		( ( 0x73 == ((const U8*)s)[3] ) ? 0x59 : 0 )                \
	    : ( ( ((const U8*)s)[2] & 0xBF ) == 's' ) ? 0x59                \
	    : ( ( ((const U8*)s)[2] & 0xBF ) == 't' ) ? 0xFB05 : 0 )        \
	: 0 )                                                               \
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'j' ) ?                             \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x53 == ((const U8*)s)[2] ) ) ? 0x1F0 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 's' ) ?                             \
	( ( 0x8F == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x73 == ((const U8*)s)[2] ) ? 0x59 : 0 )                    \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 's' ) ? 0x59                    \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 't' ) ? 0xFB05 : 0 )            \
    : ( ( ((const U8*)s)[0] & 0xBF ) == 't' ) ?                             \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x49 == ((const U8*)s)[2] ) ) ? 0x1E97 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'w' ) ?                             \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x51 == ((const U8*)s)[2] ) ) ? 0x1E98 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'y' ) ?                             \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x51 == ((const U8*)s)[2] ) ) ? 0x1E99 : 0 )\
    : ( 0xAB == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0x70 == ((const U8*)s)[1] ) && ( ( ((const U8*)s)[2] & 0xBF ) == 'n' ) ) ? 0x149 : 0 )\
    : ( 0xB4 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x53 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xB4 == ((const U8*)s)[2] ) && ( 0x68 == ((const U8*)s)[3] ) ) ? 0x1FB4 : 0 )\
	: ( 0x55 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xB4 == ((const U8*)s)[2] ) && ( 0x68 == ((const U8*)s)[3] ) ) ? 0x1FC4 : 0 )\
	: ( 0x58 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xB1 == ((const U8*)s)[2] ) ?                               \
		( ( 0x43 == ((const U8*)s)[3] ) ? 0x1FB6 : 0 )              \
	    : ( ( 0xB4 == ((const U8*)s)[2] ) && ( 0x68 == ((const U8*)s)[3] ) ) ? 0x1FB3 : 0 )\
	: ( 0x66 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xB1 == ((const U8*)s)[2] ) ?                               \
		( ( 0x43 == ((const U8*)s)[3] ) ? 0x1FC6 : 0 )              \
	    : ( ( 0xB4 == ((const U8*)s)[2] ) && ( 0x68 == ((const U8*)s)[3] ) ) ? 0x1FC3 : 0 )\
	: ( ( ( 0x68 == ((const U8*)s)[1] ) && ( 0xB1 == ((const U8*)s)[2] ) ) && ( 0x43 == ((const U8*)s)[3] ) ) ? 0x1FD6 : 0 )\
    : ( 0xB5 == ((const U8*)s)[0] ) ? what_MULTI_CHAR_FOLD_utf8_safe_part4_(s,e) : what_MULTI_CHAR_FOLD_utf8_safe_part5_(s,e) )\
: ((e)-(s) > 3) ? what_MULTI_CHAR_FOLD_utf8_safe_part6_(s,e) : what_MULTI_CHAR_FOLD_utf8_safe_part7_(s,e) )

/*
	MULTI_CHAR_FOLD: multi-char strings that are folded to by a single character

	%regcharclass_multi_char_folds::multi_char_folds('l', 'a')
*/
/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_latin1_safe(s,e)                                 \
( ((e)-(s) > 2) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xBF ) == 'f' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xBF ) == 'f' ) ?                         \
	    ( ( ( ( ((const U8*)s)[2] & 0xBF ) == 'i' ) || ( ( ((const U8*)s)[2] & 0xBF ) == 'l' ) ) ? 3 : 2 )\
	: ( ( ( ((const U8*)s)[1] & 0xBF ) == 'i' ) || ( ( ((const U8*)s)[1] & 0xBF ) == 'l' ) ) ? 2 : 0 )\
    : ( ( ( ((const U8*)s)[0] & 0xBF ) == 's' ) && ( ( ((const U8*)s)[1] & 0xBE ) == 's' ) ) ? 2 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xBF ) == 'f' ) ?                             \
	( ( ( ( ((const U8*)s)[1] & 0xBF ) == 'f' ) || ( ( ((const U8*)s)[1] & 0xBF ) == 'i' ) || ( ( ((const U8*)s)[1] & 0xBF ) == 'l' ) ) ? 2 : 0 )\
    : ( ( ( ((const U8*)s)[0] & 0xBF ) == 's' ) && ( ( ((const U8*)s)[1] & 0xBE ) == 's' ) ) ? 2 : 0 )\
: 0 )

/*** GENERATED CODE ***/
#define what_MULTI_CHAR_FOLD_latin1_safe(s,e)                               \
( ((e)-(s) > 2) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xBF ) == 'f' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xBF ) == 'f' ) ?                         \
	    ( ( ( ((const U8*)s)[2] & 0xBF ) == 'i' ) ? 0xFB03              \
	    : ( ( ((const U8*)s)[2] & 0xBF ) == 'l' ) ? 0xFB04 : 0xFB00 )   \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 'i' ) ? 0xFB01                  \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 'l' ) ? 0xFB02 : 0 )            \
    : ( ( ((const U8*)s)[0] & 0xBF ) == 's' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xBF ) == 's' ) ? 0x59                    \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 't' ) ? 0xFB05 : 0 )            \
    : 0 )                                                                   \
: ((e)-(s) > 1) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xBF ) == 'f' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xBF ) == 'f' ) ? 0xFB00                  \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 'i' ) ? 0xFB01                  \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 'l' ) ? 0xFB02 : 0 )            \
    : ( ( ((const U8*)s)[0] & 0xBF ) == 's' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xBF ) == 's' ) ? 0x59                    \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 't' ) ? 0xFB05 : 0 )            \
    : 0 )                                                                   \
: 0 )

/*
	THREE_CHAR_FOLD: A three-character multi-char fold

	%regcharclass_multi_char_folds::multi_char_folds('u', '3')
*/
/*** GENERATED CODE ***/
#define is_THREE_CHAR_FOLD_utf8_safe(s,e)                                   \
( ((e)-(s) > 5) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xBF ) == 'f' ) ?                             \
	( ( ( ( ((const U8*)s)[1] & 0xBF ) == 'f' ) && ( ( ( ((const U8*)s)[2] & 0xBF ) == 'i' ) || ( ( ((const U8*)s)[2] & 0xBF ) == 'l' ) ) ) ? 3 : 0 )\
    : ( 0xB4 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x58 == ((const U8*)s)[1] || 0x66 == ((const U8*)s)[1] ) ?      \
	    ( ( ( ( ( 0xB1 == ((const U8*)s)[2] ) && ( 0x43 == ((const U8*)s)[3] ) ) && ( 0xB4 == ((const U8*)s)[4] ) ) && ( 0x68 == ((const U8*)s)[5] ) ) ? 6 : 0 )\
	: ( ( ( 0x68 == ((const U8*)s)[1] ) && ( 0xAF == ((const U8*)s)[2] ) ) && ( 0x49 == ((const U8*)s)[3] ) ) ? ( ( 0xAF == ((const U8*)s)[4] ) ?\
			( ( inRANGE_helper_(U8, ((const U8*)s)[5], 0x41, 0x42) ) ? 6 : 0 )\
		    : ( ( 0xB1 == ((const U8*)s)[4] ) && ( 0x43 == ((const U8*)s)[5] ) ) ? 6 : 0 ) : 0 )\
    : ( 0xB5 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x46 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xAF == ((const U8*)s)[2] ) && ( 0x49 == ((const U8*)s)[3] || 0x62 == ((const U8*)s)[3] ) ) ? ( ( 0xAF == ((const U8*)s)[4] ) ?\
			( ( inRANGE_helper_(U8, ((const U8*)s)[5], 0x41, 0x42) ) ? 6 : 0 )\
		    : ( ( 0xB1 == ((const U8*)s)[4] ) && ( 0x43 == ((const U8*)s)[5] ) ) ? 6 : 0 ) : 0 )\
	: ( ( ( ( ( 0x4A == ((const U8*)s)[1] ) && ( 0xB1 == ((const U8*)s)[2] ) ) && ( 0x43 == ((const U8*)s)[3] ) ) && ( 0xB4 == ((const U8*)s)[4] ) ) && ( 0x68 == ((const U8*)s)[5] ) ) ? 6 : 0 )\
    : 0 )                                                                   \
: ( ( ( ((e)-(s) > 2) && ( ( ((const U8*)s)[0] & 0xBF ) == 'f' ) ) && ( ( ((const U8*)s)[1] & 0xBF ) == 'f' ) ) && ( ( ( ((const U8*)s)[2] & 0xBF ) == 'i' ) || ( ( ((const U8*)s)[2] & 0xBF ) == 'l' ) ) ) ? 3 : 0 )

/*
	THREE_CHAR_FOLD: A three-character multi-char fold

	%regcharclass_multi_char_folds::multi_char_folds('l', '3')
*/
/*** GENERATED CODE ***/
#define is_THREE_CHAR_FOLD_latin1_safe(s,e)                                 \
( ( ( ( ( ((e) - (s)) >= 3 ) && ( ( ((const U8*)s)[0] & 0xBF ) == 'f' ) ) && ( ( ((const U8*)s)[1] & 0xBF ) == 'f' ) ) && ( ( ( ((const U8*)s)[2] & 0xBF ) == 'i' ) || ( ( ((const U8*)s)[2] & 0xBF ) == 'l' ) ) ) ? 3 : 0 )

/*
	THREE_CHAR_FOLD_HEAD: The first two of three-character multi-char folds

	%regcharclass_multi_char_folds::multi_char_folds('u', 'h')
*/
/*** GENERATED CODE ***/
#define is_THREE_CHAR_FOLD_HEAD_utf8_safe(s,e)                              \
( ((e)-(s) > 3) ?                                                           \
    ( ( ( ( ((const U8*)s)[0] & 0xAF ) == 'a' ) || ( ( ((const U8*)s)[0] & 0xBE ) == 'h' ) || ( ( ((const U8*)s)[0] & 0xBE ) == 's' ) || ( ( ((const U8*)s)[0] & 0xBF ) == 'w' ) || ( ( ((const U8*)s)[0] & 0xBF ) == 'y' ) ) ? 1\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'f' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xBF ) == 'f' ) ? 2 : 1 )                 \
    : ( 0x8F == ((const U8*)s)[0] ) ?                                       \
	( ( 0x73 == ((const U8*)s)[1] ) ? 2 : 0 )                           \
    : ( 0xAB == ((const U8*)s)[0] ) ?                                       \
	( ( 0x70 == ((const U8*)s)[1] ) ? 2 : 0 )                           \
    : ( 0xB4 == ((const U8*)s)[0] ) ?                                       \
	( ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[1]) & 0xFD ) == 0xAC ) ? 2   \
	: ( 0x58 == ((const U8*)s)[1] || 0x66 == ((const U8*)s)[1] ) ?      \
	    ( ( ( 0xB1 == ((const U8*)s)[2] ) && ( 0x43 == ((const U8*)s)[3] ) ) ? 4 : 2 )\
	: ( 0x68 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xAF == ((const U8*)s)[2] ) && ( 0x49 == ((const U8*)s)[3] ) ) ? 4 : 2 )\
	: 0 )                                                               \
    : ( 0xB5 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x42 == ((const U8*)s)[1] || 0x55 == ((const U8*)s)[1] ) ? 2    \
	: ( 0x46 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xAF == ((const U8*)s)[2] ) && ( 0x49 == ((const U8*)s)[3] || 0x62 == ((const U8*)s)[3] ) ) ? 4 : 2 )\
	: ( 0x4A == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xB1 == ((const U8*)s)[2] ) && ( 0x43 == ((const U8*)s)[3] ) ) ? 4 : 2 )\
	: 0 )                                                               \
    : ( 0xB8 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0x52 == ((const U8*)s)[1] ) && ( 0x46 == ((const U8*)s)[2] || 0x63 == ((const U8*)s)[2] || 0x72 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xBF == ((const U8*)s)[0] ) ?                                       \
	( ( inRANGE_helper_(U8, ((const U8*)s)[1], 0x67, 0x68) ) ?          \
	    ( ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x41, 0x48) ) ? 3 : 0 )\
	: ( ( 0x6A == ((const U8*)s)[1] ) && ( ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[2]) & 0xF8 ) == 0xA0 ) || ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[2]) & 0xFB ) == 0xB0 ) || ((const U8*)s)[2] == 0x70 ) ) ? 3 : 0 )\
    : 0 )                                                                   \
: ((e)-(s) > 2) ?                                                           \
    ( ( ( ( ((const U8*)s)[0] & 0xAF ) == 'a' ) || ( ( ((const U8*)s)[0] & 0xBE ) == 'h' ) || ( ( ((const U8*)s)[0] & 0xBE ) == 's' ) || ( ( ((const U8*)s)[0] & 0xBF ) == 'w' ) || ( ( ((const U8*)s)[0] & 0xBF ) == 'y' ) ) ? 1\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'f' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xBF ) == 'f' ) ? 2 : 1 )                 \
    : ( 0x8F == ((const U8*)s)[0] ) ?                                       \
	( ( 0x73 == ((const U8*)s)[1] ) ? 2 : 0 )                           \
    : ( 0xAB == ((const U8*)s)[0] ) ?                                       \
	( ( 0x70 == ((const U8*)s)[1] ) ? 2 : 0 )                           \
    : ( 0xB4 == ((const U8*)s)[0] ) ?                                       \
	( ( ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[1]) & 0xFD ) == 0xAC ) || ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[1]) & 0xF7 ) == 0xB1 ) || ((const U8*)s)[1] == 0x66 ) ? 2 : 0 )\
    : ( 0xB5 == ((const U8*)s)[0] ) ?                                       \
	( ( ( ( ((const U8*)s)[1] & 0xFB ) == 0x42 ) || ((const U8*)s)[1] == 0x4A || ((const U8*)s)[1] == 0x55 ) ? 2 : 0 )\
    : ( 0xB8 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0x52 == ((const U8*)s)[1] ) && ( 0x46 == ((const U8*)s)[2] || 0x63 == ((const U8*)s)[2] || 0x72 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xBF == ((const U8*)s)[0] ) ?                                       \
	( ( inRANGE_helper_(U8, ((const U8*)s)[1], 0x67, 0x68) ) ?          \
	    ( ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x41, 0x48) ) ? 3 : 0 )\
	: ( ( 0x6A == ((const U8*)s)[1] ) && ( ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[2]) & 0xF8 ) == 0xA0 ) || ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[2]) & 0xFB ) == 0xB0 ) || ((const U8*)s)[2] == 0x70 ) ) ? 3 : 0 )\
    : 0 )                                                                   \
: ((e)-(s) > 1) ?                                                           \
    ( ( ( ( ((const U8*)s)[0] & 0xAF ) == 'a' ) || ( ( ((const U8*)s)[0] & 0xBE ) == 'h' ) || ( ( ((const U8*)s)[0] & 0xBE ) == 's' ) || ( ( ((const U8*)s)[0] & 0xBF ) == 'w' ) || ( ( ((const U8*)s)[0] & 0xBF ) == 'y' ) ) ? 1\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'f' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xBF ) == 'f' ) ? 2 : 1 )                 \
    : ( 0x8F == ((const U8*)s)[0] ) ?                                       \
	( ( 0x73 == ((const U8*)s)[1] ) ? 2 : 0 )                           \
    : ( 0xAB == ((const U8*)s)[0] ) ?                                       \
	( ( 0x70 == ((const U8*)s)[1] ) ? 2 : 0 )                           \
    : ( 0xB4 == ((const U8*)s)[0] ) ?                                       \
	( ( ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[1]) & 0xFD ) == 0xAC ) || ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[1]) & 0xF7 ) == 0xB1 ) || ((const U8*)s)[1] == 0x66 ) ? 2 : 0 )\
    : ( ( 0xB5 == ((const U8*)s)[0] ) && ( ( ( ((const U8*)s)[1] & 0xFB ) == 0x42 ) || ((const U8*)s)[1] == 0x4A || ((const U8*)s)[1] == 0x55 ) ) ? 2 : 0 )\
: ((e)-(s) > 0) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xAF ) == 'a' ) || ( ( ((const U8*)s)[0] & 0x9F ) == 'f' ) || ( ( ((const U8*)s)[0] & 0xBE ) == 'h' ) || ( ( ((const U8*)s)[0] & 0xBE ) == 's' ) || ( ( ((const U8*)s)[0] & 0xBF ) == 'y' ) )\
: 0 )

/*
	THREE_CHAR_FOLD_HEAD: The first two of three-character multi-char folds

	%regcharclass_multi_char_folds::multi_char_folds('l', 'h')
*/
/*** GENERATED CODE ***/
#define is_THREE_CHAR_FOLD_HEAD_latin1_safe(s,e)                            \
( ((e)-(s) > 1) ?                                                           \
    ( ( ( ( ((const U8*)s)[0] & 0xAF ) == 'a' ) || ( ( ((const U8*)s)[0] & 0xBE ) == 'h' ) || ( ( ((const U8*)s)[0] & 0xBE ) == 's' ) || ( ( ((const U8*)s)[0] & 0xBF ) == 'w' ) || ( ( ((const U8*)s)[0] & 0xBF ) == 'y' ) ) ? 1\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'f' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xBF ) == 'f' ) ? 2 : 1 )                 \
    : 0 )                                                                   \
: ((e)-(s) > 0) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xAF ) == 'a' ) || ( ( ((const U8*)s)[0] & 0x9F ) == 'f' ) || ( ( ((const U8*)s)[0] & 0xBE ) == 'h' ) || ( ( ((const U8*)s)[0] & 0xBE ) == 's' ) || ( ( ((const U8*)s)[0] & 0xBF ) == 'y' ) )\
: 0 )

/*
	FOLDS_TO_MULTI: characters that fold to multi-char strings

	\p{_Perl_Folds_To_Multi_Char}
*/
/*** GENERATED CODE ***/
#define is_FOLDS_TO_MULTI_utf8(s)                                           \
( ( 0x8A == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x73 == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0x8D == ((const U8*)s)[0] || 0x9C == ((const U8*)s)[0] || inRANGE_helper_(U8, ((const U8*)s)[0], 0xB3, 0xB4) ) ?\
    ( ( 0x57 == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0x8E == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x4A == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xB8 == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x53 == ((const U8*)s)[1] ) && ( 0x48 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xBF == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x63 == ((const U8*)s)[1] ) ?                                       \
	( ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x65, 0x69) || 0x72 == ((const U8*)s)[2] ) ? 3 : 0 )\
    : ( 0x69 == ((const U8*)s)[1] ) ?                                       \
	( ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[2]) & 0xF9 ) == 0xB0 ) ? 3 : 0 )\
    : ( 0x70 == ((const U8*)s)[1] ) ?                                       \
	3                                                                   \
    : ( 0x71 == ((const U8*)s)[1] ) ?                                       \
	( ( ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[2]) & 0xF0 ) == 0xA0 ) || ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[2]) & 0xFA ) == 0xB2 ) || ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[2]) & 0xF7 ) == 0xB4 ) ) ? 3 : 0 )\
    : ( 0x72 == ((const U8*)s)[1] ) ?                                       \
	( ( ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[2]) & 0xEA ) == 0xA2 ) || ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[2]) & 0xF7 ) == 0xA4 ) ) ? 3 : 0 )\
    : ( ( 0x73 == ((const U8*)s)[1] ) && ( ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[2]) & 0xEA ) == 0xA2 ) || ((const U8*)s)[2] == 0x45 || ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[2]) & 0xF7 ) == 0xB4 ) ) ) ? 3 : 0 )\
: ( ( ( ( 0xDD == ((const U8*)s)[0] ) && ( 0x72 == ((const U8*)s)[1] ) ) && ( 0x67 == ((const U8*)s)[2] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[3], 0x41, 0x47) || inRANGE_helper_(U8, ((const U8*)s)[3], 0x62, 0x66) ) ) ? 4 : 0 )

/*
	PROBLEMATIC_LOCALE_FOLD: characters whose fold is problematic under locale

	\p{_Perl_Problematic_Locale_Folds}
*/
/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLD_utf8(s)                                  \
( ( ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[0]) & 0x80 ) == 0x00 ) || ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[0]) & 0xE0 ) == 0x80 ) ) ? 1\
: ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[0]), 0xC5, 0xC7) ) ?\
    2                                                                       \
: ( 0x8D == ((const U8*)s)[0] ) ?                                           \
    ( ( inRANGE_helper_(U8, ((const U8*)s)[1], 0x57, 0x58) ) ? 2 : 0 )      \
: ( 0x8E == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x4A == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0x8F == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x67 == ((const U8*)s)[1] || 0x73 == ((const U8*)s)[1] ) ? 2 : 0 )  \
: ( 0x9C == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x57 == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xAF == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x48 == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( inRANGE_helper_(U8, ((const U8*)s)[0], 0xB3, 0xB4) ) ?                  \
    ( ( 0x70 == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xBF == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x63 == ((const U8*)s)[1] ) && ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x65, 0x69) || 0x72 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xCA == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x4A == ((const U8*)s)[1] ) && ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x51, 0x52) ) ) ? 3 : 0 )\
: ( ( ( ( 0xDD == ((const U8*)s)[0] ) && ( 0x72 == ((const U8*)s)[1] ) ) && ( 0x67 == ((const U8*)s)[2] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[3], 0x41, 0x47) ) ) ? 4 : 0 )

/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLD_cp(cp)                                   \
( cp <= 0xFF || ( 0xFF < cp &&                                              \
( inRANGE_helper_(UV, cp, 0x130, 0x131) || ( 0x131 < cp &&                  \
( 0x149 == cp || ( 0x149 < cp &&                                            \
( 0x178 == cp || ( 0x178 < cp &&                                            \
( 0x17F == cp || ( 0x17F < cp &&                                            \
( 0x1F0 == cp || ( 0x1F0 < cp &&                                            \
( 0x307 == cp || ( 0x307 < cp &&                                            \
( 0x39C == cp || ( 0x39C < cp &&                                            \
( 0x3BC == cp || ( 0x3BC < cp &&                                            \
( inRANGE_helper_(UV, cp, 0x1E96, 0x1E9A) || ( 0x1E9A < cp &&               \
( 0x1E9E == cp || ( 0x1E9E < cp &&                                          \
( inRANGE_helper_(UV, cp, 0x212A, 0x212B) || inRANGE_helper_(UV, cp, 0xFB00, 0xFB06) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) )

/*
	PROBLEMATIC_LOCALE_FOLDEDS_START: The first folded character of folds which are problematic under locale

	\p{_Perl_Problematic_Locale_Foldeds_Start}
*/
/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLDEDS_START_utf8(s)                         \
( ( ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[0]) & 0x80 ) == 0x00 ) || ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[0]) & 0xE0 ) == 0x80 ) ) ? 1\
: ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[0]), 0xC5, 0xC7) ) ?\
    2                                                                       \
: ( 0x8D == ((const U8*)s)[0] ) ?                                           \
    ( ( inRANGE_helper_(U8, ((const U8*)s)[1], 0x57, 0x58) ) ? 2 : 0 )      \
: ( 0x8E == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x4A == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0x8F == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x67 == ((const U8*)s)[1] || 0x73 == ((const U8*)s)[1] ) ? 2 : 0 )  \
: ( 0x9C == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x57 == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xAB == ((const U8*)s)[0] || inRANGE_helper_(U8, ((const U8*)s)[0], 0xB3, 0xB4) ) ?\
    ( ( 0x70 == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xBF == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x63 == ((const U8*)s)[1] ) && ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x65, 0x69) || 0x72 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xCA == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x4A == ((const U8*)s)[1] ) && ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x51, 0x52) ) ) ? 3 : 0 )\
: ( ( ( ( 0xDD == ((const U8*)s)[0] ) && ( 0x72 == ((const U8*)s)[1] ) ) && ( 0x67 == ((const U8*)s)[2] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[3], 0x41, 0x47) ) ) ? 4 : 0 )

/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLDEDS_START_cp(cp)                          \
( cp <= 0xFF || ( 0xFF < cp &&                                              \
( inRANGE_helper_(UV, cp, 0x130, 0x131) || ( 0x131 < cp &&                  \
( 0x149 == cp || ( 0x149 < cp &&                                            \
( 0x178 == cp || ( 0x178 < cp &&                                            \
( 0x17F == cp || ( 0x17F < cp &&                                            \
( 0x1F0 == cp || ( 0x1F0 < cp &&                                            \
( 0x2BC == cp || ( 0x2BC < cp &&                                            \
( 0x39C == cp || ( 0x39C < cp &&                                            \
( 0x3BC == cp || ( 0x3BC < cp &&                                            \
( inRANGE_helper_(UV, cp, 0x1E96, 0x1E9A) || ( 0x1E9A < cp &&               \
( 0x1E9E == cp || ( 0x1E9E < cp &&                                          \
( inRANGE_helper_(UV, cp, 0x212A, 0x212B) || inRANGE_helper_(UV, cp, 0xFB00, 0xFB06) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) )

/*
	PATWS: pattern white space

	\p{_Perl_PatWS}
*/
/*** GENERATED CODE ***/
#define is_PATWS_safe(s,e,is_utf8)                                          \
( ( LIKELY((e) > (s)) ) ?                                                   \
    ( ( '\t' == ((const U8*)s)[0] || inRANGE_helper_(U8, ((const U8*)s)[0], '\v', '\r') || '\n' == ((const U8*)s)[0] || 0x25 == ((const U8*)s)[0] || ' ' == ((const U8*)s)[0] ) ? 1\
    : ( ( is_utf8 && LIKELY(((e) - (s)) >= UTF8SKIP(s)) ) && ( 0xCA == ((const U8*)s)[0] ) ) ? ( ( 0x41 == ((const U8*)s)[1] ) ?\
		    ( ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x55, 0x56) ) ? 3 : 0 )\
		: ( ( 0x42 == ((const U8*)s)[1] ) && ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x49, 0x4A) ) ) ? 3 : 0 ) : 0 )\
: 0 )

/*
	HANGUL_ED: Hangul syllables whose first UTF-8 byte is \xED

	0x1 - 0x0
*/
/*** GENERATED CODE ***/
#define is_HANGUL_ED_utf8_safe(s,e)                                         \
( 0 )

#endif	/* EBCDIC 1047 */

#if 'A' == 193 /* EBCDIC 037 */ \
     && '\\' == 224 && '[' == 186 && ']' == 187 && '{' == 192 && '}' == 208 \
     && '^' == 176 && '~' == 161 && '!' == 90 && '#' == 123 && '|' == 79 \
     && '$' == 91 && '@' == 124 && '`' == 121 && '\n' == 37
/*
	LNBREAK: Line Break: \R

	"\x0D\x0A"      # CRLF - Network (Windows) line ending
	\p{VertSpace}
*/
/*** GENERATED CODE ***/
#define is_LNBREAK_safe(s,e,is_utf8)                                        \
( ((e)-(s) > 2) ?                                                           \
    ( ( inRANGE_helper_(U8, ((const U8*)s)[0], '\v', '\f') || 0x15 == ((const U8*)s)[0] || '\n' == ((const U8*)s)[0] ) ? 1\
    : ( '\r' == ((const U8*)s)[0] ) ?                                       \
	( ( '\n' == ((const U8*)s)[1] ) ? 2 : 1 )                           \
    : ( ( ( ( is_utf8 ) && ( 0xCA == ((const U8*)s)[0] ) ) && ( 0x42 == ((const U8*)s)[1] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x49, 0x4A) ) ) ? 3 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( inRANGE_helper_(U8, ((const U8*)s)[0], '\v', '\f') || 0x15 == ((const U8*)s)[0] || '\n' == ((const U8*)s)[0] ) ? 1\
    : ( '\r' == ((const U8*)s)[0] ) ?                                       \
	( ( '\n' == ((const U8*)s)[1] ) ? 2 : 1 )                           \
    : 0 )                                                                   \
: ((e)-(s) > 0) ?                                                           \
    ( inRANGE_helper_(U8, ((const U8*)s)[0], '\v', '\r') || 0x15 == ((const U8*)s)[0] || '\n' == ((const U8*)s)[0] )\
: 0 )

/*** GENERATED CODE ***/
#define is_LNBREAK_utf8_safe(s,e)                                           \
( ((e)-(s) > 2) ?                                                           \
    ( ( inRANGE_helper_(U8, ((const U8*)s)[0], '\v', '\f') || 0x15 == ((const U8*)s)[0] || '\n' == ((const U8*)s)[0] ) ? 1\
    : ( '\r' == ((const U8*)s)[0] ) ?                                       \
	( ( '\n' == ((const U8*)s)[1] ) ? 2 : 1 )                           \
    : ( ( ( 0xCA == ((const U8*)s)[0] ) && ( 0x42 == ((const U8*)s)[1] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x49, 0x4A) ) ) ? 3 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( inRANGE_helper_(U8, ((const U8*)s)[0], '\v', '\f') || 0x15 == ((const U8*)s)[0] || '\n' == ((const U8*)s)[0] ) ? 1\
    : ( '\r' == ((const U8*)s)[0] ) ?                                       \
	( ( '\n' == ((const U8*)s)[1] ) ? 2 : 1 )                           \
    : 0 )                                                                   \
: ((e)-(s) > 0) ?                                                           \
    ( inRANGE_helper_(U8, ((const U8*)s)[0], '\v', '\r') || 0x15 == ((const U8*)s)[0] || '\n' == ((const U8*)s)[0] )\
: 0 )

/*** GENERATED CODE ***/
#define is_LNBREAK_latin1_safe(s,e)                                         \
( ((e)-(s) > 1) ?                                                           \
    ( ( inRANGE_helper_(U8, ((const U8*)s)[0], '\v', '\f') || 0x15 == ((const U8*)s)[0] || '\n' == ((const U8*)s)[0] ) ? 1\
    : ( '\r' == ((const U8*)s)[0] ) ?                                       \
	( ( '\n' == ((const U8*)s)[1] ) ? 2 : 1 )                           \
    : 0 )                                                                   \
: ((e)-(s) > 0) ?                                                           \
    ( inRANGE_helper_(U8, ((const U8*)s)[0], '\v', '\r') || 0x15 == ((const U8*)s)[0] || '\n' == ((const U8*)s)[0] )\
: 0 )

/*
	HORIZWS: Horizontal Whitespace: \h \H

	\p{HorizSpace}
*/
/*** GENERATED CODE ***/
#define is_HORIZWS_high(s)                                                  \
( ( 0xBD == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x62 == ((const U8*)s)[1] ) && ( 0x41 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xCA == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x41 == ((const U8*)s)[1] ) ?                                       \
	( ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[2]), 0xA0, 0xAA) ) ? 3 : 0 )\
    : ( 0x42 == ((const U8*)s)[1] ) ?                                       \
	( ( 0x56 == ((const U8*)s)[2] ) ? 3 : 0 )                           \
    : ( ( 0x43 == ((const U8*)s)[1] ) && ( 0x72 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( ( ( 0xCE == ((const U8*)s)[0] ) && ( 0x41 == ((const U8*)s)[1] ) ) && ( 0x41 == ((const U8*)s)[2] ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_HORIZWS_cp_high(cp)                                              \
( 0x1680 == cp || ( 0x1680 < cp &&                                          \
( inRANGE_helper_(UV, cp, 0x2000, 0x200A) || ( 0x200A < cp &&               \
( 0x202F == cp || ( 0x202F < cp &&                                          \
( 0x205F == cp || 0x3000 == cp ) ) ) ) ) ) )

/*
	VERTWS: Vertical Whitespace: \v \V

	\p{VertSpace}
*/
/*** GENERATED CODE ***/
#define is_VERTWS_high(s)                                                   \
( ( ( ( 0xCA == ((const U8*)s)[0] ) && ( 0x42 == ((const U8*)s)[1] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x49, 0x4A) ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_VERTWS_cp_high(cp)                                               \
( inRANGE_helper_(UV, cp, 0x2028, 0x2029) )

/*
	XDIGIT: Hexadecimal digits

	\p{XDigit}
*/
/*** GENERATED CODE ***/
#define is_XDIGIT_high(s)                                                   \
( ( ( 0xDD == ((const U8*)s)[0] ) && ( 0x72 == ((const U8*)s)[1] ) ) ? ( ( 0x66 == ((const U8*)s)[2] ) ?\
	    ( ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[3]), 0xB0, 0xB9) ) ? 4 : 0 )\
	: ( ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x67, 0x68) ) && ( inRANGE_helper_(U8, ((const U8*)s)[3], 0x42, 0x47) ) ) ? 4 : 0 ) : 0 )

/*** GENERATED CODE ***/
#define is_XDIGIT_cp_high(cp)                                               \
( inRANGE_helper_(UV, cp, 0xFF10, 0xFF19) || ( 0xFF19 < cp &&               \
( inRANGE_helper_(UV, cp, 0xFF21, 0xFF26) || inRANGE_helper_(UV, cp, 0xFF41, 0xFF46) ) ) )

/*
	XPERLSPACE: \p{XPerlSpace}

	\p{XPerlSpace}
*/
/*** GENERATED CODE ***/
#define is_XPERLSPACE_high(s)                                               \
( ( 0xBD == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x62 == ((const U8*)s)[1] ) && ( 0x41 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xCA == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x41 == ((const U8*)s)[1] ) ?                                       \
	( ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[2]), 0xA0, 0xAA) ) ? 3 : 0 )\
    : ( 0x42 == ((const U8*)s)[1] ) ?                                       \
	( ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x49, 0x4A) || 0x56 == ((const U8*)s)[2] ) ? 3 : 0 )\
    : ( ( 0x43 == ((const U8*)s)[1] ) && ( 0x72 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( ( ( 0xCE == ((const U8*)s)[0] ) && ( 0x41 == ((const U8*)s)[1] ) ) && ( 0x41 == ((const U8*)s)[2] ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_XPERLSPACE_cp_high(cp)                                           \
( 0x1680 == cp || ( 0x1680 < cp &&                                          \
( inRANGE_helper_(UV, cp, 0x2000, 0x200A) || ( 0x200A < cp &&               \
( inRANGE_helper_(UV, cp, 0x2028, 0x2029) || ( 0x2029 < cp &&               \
( 0x202F == cp || ( 0x202F < cp &&                                          \
( 0x205F == cp || 0x3000 == cp ) ) ) ) ) ) ) ) )

/*
	SPACE: Backwards \p{XPerlSpace}

	\p{XPerlSpace}
*/
/*** GENERATED CODE ***/
#define is_SPACE_utf8_safe_backwards(s,e)                                   \
( ((s) - (e) > 2) ?                                                         \
    ( ( '\t' == *((const U8*)s - 1) || inRANGE_helper_(U8, *((const U8*)s - 1), '\v', '\r') || 0x15 == *((const U8*)s - 1) || '\n' == *((const U8*)s - 1) || ' ' == *((const U8*)s - 1) ) ? 1\
    : ( 0x41 == *((const U8*)s - 1) ) ?                                     \
	( ( 0x41 == *((const U8*)s - 2) ) ?                                 \
	    ( ( ( *((const U8*)s - 3) & 0xFB ) == 0xCA ) ? 3 : 0 )          \
	: ( 0x62 == *((const U8*)s - 2) ) ?                                 \
	    ( ( 0xBD == *((const U8*)s - 3) ) ? 3 : 0 )                     \
	: ( 0x78 == *((const U8*)s - 2) ) ? 2 : 0 )                         \
    : ( inRANGE_helper_(U8, *((const U8*)s - 1), 0x42, 0x48) || 0x51 == *((const U8*)s - 1) ) ?\
	( ( ( 0x41 == *((const U8*)s - 2) ) && ( 0xCA == *((const U8*)s - 3) ) ) ? 3 : 0 )\
    : ( inRANGE_helper_(U8, *((const U8*)s - 1), 0x49, 0x4A) ) ?            \
	( ( ( inRANGE_helper_(U8, *((const U8*)s - 2), 0x41, 0x42) ) && ( 0xCA == *((const U8*)s - 3) ) ) ? 3 : 0 )\
    : ( 0x56 == *((const U8*)s - 1) ) ?                                     \
	( ( ( 0x42 == *((const U8*)s - 2) ) && ( 0xCA == *((const U8*)s - 3) ) ) ? 3 : 0 )\
    : ( ( ( 0x72 == *((const U8*)s - 1) ) && ( 0x43 == *((const U8*)s - 2) ) ) && ( 0xCA == *((const U8*)s - 3) ) ) ? 3 : 0 )\
: ((s) - (e) > 1) ?                                                         \
    ( ( '\t' == *((const U8*)s - 1) || inRANGE_helper_(U8, *((const U8*)s - 1), '\v', '\r') || 0x15 == *((const U8*)s - 1) || '\n' == *((const U8*)s - 1) || ' ' == *((const U8*)s - 1) ) ? 1\
    : ( ( 0x41 == *((const U8*)s - 1) ) && ( 0x78 == *((const U8*)s - 2) ) ) ? 2 : 0 )\
: ((s) - (e) > 0) ?                                                         \
    ( '\t' == *((const U8*)s - 1) || inRANGE_helper_(U8, *((const U8*)s - 1), '\v', '\r') || 0x15 == *((const U8*)s - 1) || '\n' == *((const U8*)s - 1) || ' ' == *((const U8*)s - 1) )\
: 0 )

/*
	NONCHAR: Non character code points

	\p{_Perl_Nchar}
*/
/*** GENERATED CODE ***/
#define is_NONCHAR_utf8_safe(s,e)                                           \
( ( ( LIKELY((e) > (s)) ) && ( LIKELY(((e) - (s)) >= UTF8SKIP(s)) ) ) ? ( ( 0xDD == ((const U8*)s)[0] ) ?\
	    ( ( 0x72 == ((const U8*)s)[1] ) ?                               \
		( ( 0x55 == ((const U8*)s)[2] ) ?                           \
		    ( ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[3]), 0xB0, 0xBF) ) ? 4 : 0 )\
		: ( 0x56 == ((const U8*)s)[2] ) ?                           \
		    ( ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[3]), 0xA0, 0xAF) ) ? 4 : 0 )\
		: ( ( 0x72 == ((const U8*)s)[2] ) && ( inRANGE_helper_(U8, ((const U8*)s)[3], 0x71, 0x72) ) ) ? 4 : 0 )\
	    : 0 )                                                           \
	: ( ((const U8*)s)[0] == 0xDF || ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[0]) & 0xFD ) == 0xF5 ) ) ?\
	    ( ( ( ( 0x72 == ((const U8*)s)[1] ) && ( 0x72 == ((const U8*)s)[2] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[3], 0x71, 0x72) ) ) ? 4 : 0 )\
	: ( 0xED == ((const U8*)s)[0] ) ?                                   \
	    ( ( ( ( ( ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[1]) & 0xF9 ) == 0xA9 ) || ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[1]) & 0xF1 ) == 0xB1 ) ) && ( 0x72 == ((const U8*)s)[2] ) ) && ( 0x72 == ((const U8*)s)[3] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[4], 0x71, 0x72) ) ) ? 5 : 0 )\
	: ( ( ( ( ( 0xEE == ((const U8*)s)[0] ) && ( 0x42 == ((const U8*)s)[1] ) ) && ( 0x72 == ((const U8*)s)[2] ) ) && ( 0x72 == ((const U8*)s)[3] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[4], 0x71, 0x72) ) ) ? 5 : 0 ) : 0 )

/*
	SHORTER_NON_CHARS: # 4 bytes

	0xFDD0 - 0xFDEF
	0xFFFE - 0xFFFF
	0x1FFFE - 0x1FFFF
	0x2FFFE - 0x2FFFF
	0x3FFFE - 0x3FFFF
*/
/*** GENERATED CODE ***/
#define is_SHORTER_NON_CHARS_utf8(s)                                        \
( ( 0xDD == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x72 == ((const U8*)s)[1] ) ?                                       \
	( ( 0x55 == ((const U8*)s)[2] ) ?                                   \
	    ( ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[3]), 0xB0, 0xBF) ) ? 4 : 0 )\
	: ( 0x56 == ((const U8*)s)[2] ) ?                                   \
	    ( ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[3]), 0xA0, 0xAF) ) ? 4 : 0 )\
	: ( ( 0x72 == ((const U8*)s)[2] ) && ( inRANGE_helper_(U8, ((const U8*)s)[3], 0x71, 0x72) ) ) ? 4 : 0 )\
    : 0 )                                                                   \
: ( ( ( ( ((const U8*)s)[0] == 0xDF || ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[0]) & 0xFD ) == 0xF5 ) ) && ( 0x72 == ((const U8*)s)[1] ) ) && ( 0x72 == ((const U8*)s)[2] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[3], 0x71, 0x72) ) ) ? 4 : 0 )

/*
	LARGER_NON_CHARS: # 5 bytes

	0x4FFFE - 0x4FFFF
	0x5FFFE - 0x5FFFF
	0x6FFFE - 0x6FFFF
	0x7FFFE - 0x7FFFF
	0x8FFFE - 0x8FFFF
	0x9FFFE - 0x9FFFF
	0xAFFFE - 0xAFFFF
	0xBFFFE - 0xBFFFF
	0xCFFFE - 0xCFFFF
	0xDFFFE - 0xDFFFF
	0xEFFFE - 0xEFFFF
	0xFFFFE - 0xFFFFF
	0x10FFFE - 0x10FFFF
*/
/*** GENERATED CODE ***/
#define is_LARGER_NON_CHARS_utf8(s)                                         \
( ( 0xED == ((const U8*)s)[0] ) ?                                           \
    ( ( ( ( ( ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[1]) & 0xF9 ) == 0xA9 ) || ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[1]) & 0xF1 ) == 0xB1 ) ) && ( 0x72 == ((const U8*)s)[2] ) ) && ( 0x72 == ((const U8*)s)[3] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[4], 0x71, 0x72) ) ) ? 5 : 0 )\
: ( ( ( ( ( 0xEE == ((const U8*)s)[0] ) && ( 0x42 == ((const U8*)s)[1] ) ) && ( 0x72 == ((const U8*)s)[2] ) ) && ( 0x72 == ((const U8*)s)[3] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[4], 0x71, 0x72) ) ) ? 5 : 0 )

/*
	SURROGATE: Surrogate code points

	\p{_Perl_Surrogate}
*/
/*** GENERATED CODE ***/
#define is_SURROGATE_utf8(s)                                                \
( ( ( 0xDD == ((const U8*)s)[0] ) && ( inRANGE_helper_(U8, ((const U8*)s)[1], 0x64, 0x65) ) ) ? 4 : 0 )

/*** GENERATED CODE ***/
#define is_SURROGATE_utf8_safe(s,e)                                         \
( ( ( ( ( ( ((e) - (s)) >= 4 ) && ( 0xDD == ((const U8*)s)[0] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[1], 0x64, 0x65) ) ) && ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[2]), 0xA0, 0xBF) ) ) && ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[3]), 0xA0, 0xBF) ) ) ? 4 : 0 )

/*
	QUOTEMETA: Meta-characters that \Q should quote

	\p{_Perl_Quotemeta}
*/
/*** GENERATED CODE ***/
#define is_QUOTEMETA_high(s)                                                \
( ( 0xAF == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x56 == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xB7 == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x57 == ((const U8*)s)[1] ) && ( 0x6A == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xBC == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x51 == ((const U8*)s)[1] ) ?                                       \
	( ( 0x72 == ((const U8*)s)[2] ) ? 3 : 0 )                           \
    : ( ( 0x52 == ((const U8*)s)[1] ) && ( 0x41 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xBD == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x62 == ((const U8*)s)[1] ) ?                                       \
	( ( 0x41 == ((const U8*)s)[2] ) ? 3 : 0 )                           \
    : ( ( 0x70 == ((const U8*)s)[1] ) && ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x62, 0x63) ) ) ? 3 : 0 )\
: ( 0xBE == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x41 == ((const U8*)s)[1] ) && ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x52, 0x56) ) ) ? 3 : 0 )\
: ( 0xCA == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x41 == ((const U8*)s)[1] || inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[1]), 0xAD, 0xBF) ) ?\
	3                                                                   \
    : ( 0x42 == ((const U8*)s)[1] ) ?                                       \
	( ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[2]), 0xA0, 0xBE) ) ? 3 : 0 )\
    : ( 0x43 == ((const U8*)s)[1] ) ?                                       \
	( ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[2]), 0xA1, 0xB3) || inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[2]), 0xB5, 0xBF) ) ? 3 : 0 )\
    : ( 0x44 == ((const U8*)s)[1] ) ?                                       \
	( ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[2]), 0xA0, 0xAF) ) ? 3 : 0 )\
    : ( ( 0x53 == ((const U8*)s)[1] ) && ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[2]), 0xB0, 0xBF) ) ) ? 3 : 0 )\
: ( 0xCB == ((const U8*)s)[0] ) ?                                           \
    ( ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[1]), 0xA0, 0xA2) || inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[1]), 0xA8, 0xBA) || inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[1]), 0xBD, 0xBF) ) ?\
	3                                                                   \
    : ( 0x69 == ((const U8*)s)[1] ) ?                                       \
	( ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[2]), 0xA0, 0xB5) ) ? 3 : 0 )\
    : ( ( 0x6A == ((const U8*)s)[1] ) && ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[2]), 0xB4, 0xBF) ) ) ? 3 : 0 )\
: ( 0xCC == ((const U8*)s)[0] ) ?                                           \
    3                                                                       \
: ( 0xCD == ((const U8*)s)[0] ) ?                                           \
    ( ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[1]), 0xB0, 0xB3) ) ?\
	3                                                                   \
    : 0 )                                                                   \
: ( 0xCE == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x41 == ((const U8*)s)[1] ) ?                                       \
	( ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[2]), 0xA0, 0xA3) || inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[2]), 0xA8, 0xBF) ) ? 3 : 0 )\
    : ( 0x42 == ((const U8*)s)[1] ) ?                                       \
	( ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[2]) & 0xEF ) == 0xA0 ) ? 3 : 0 )\
    : ( ( 0x52 == ((const U8*)s)[1] ) && ( 0x45 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xDD == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x72 == ((const U8*)s)[1] ) ?                                       \
	( ( 0x4A == ((const U8*)s)[2] ) ?                                   \
	    ( ( inRANGE_helper_(U8, ((const U8*)s)[3], 0x71, 0x72) ) ? 4 : 0 )\
	: ( 0x57 == ((const U8*)s)[2] ) ?                                   \
	    ( ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[3]), 0xA0, 0xAF) ) ? 4 : 0 )\
	: ( 0x59 == ((const U8*)s)[2] ) ?                                   \
	    ( ( inRANGE_helper_(U8, ((const U8*)s)[3], 0x46, 0x47) ) ? 4 : 0 )\
	: ( 0x65 == ((const U8*)s)[2] ) ?                                   \
	    ( ( 0x72 == ((const U8*)s)[3] ) ? 4 : 0 )                       \
	: ( 0x70 == ((const U8*)s)[2] ) ?                                   \
	    ( ( 0x41 == ((const U8*)s)[3] ) ? 4 : 0 )                       \
	: ( ( 0x72 == ((const U8*)s)[2] ) && ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[3]), 0xB0, 0xB8) ) ) ? 4 : 0 )\
    : 0 )                                                                   \
: ( 0xDF == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x56 == ((const U8*)s)[1] ) ?                                       \
	( ( ( 0x46 == ((const U8*)s)[2] ) && ( inRANGE_helper_(U8, ((const U8*)s)[3], 0x41, 0x44) ) ) ? 4 : 0 )\
    : ( ( ( 0x62 == ((const U8*)s)[1] ) && ( 0x52 == ((const U8*)s)[2] ) ) && ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[3]), 0xB3, 0xBA) ) ) ? 4 : 0 )\
: ( ( ( 0xED == ((const U8*)s)[0] ) && ( 0x6A == ((const U8*)s)[1] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x41, 0x44) ) ) ? 5 : 0 )

/*
	MULTI_CHAR_FOLD: multi-char strings that are folded to by a single character

	%regcharclass_multi_char_folds::multi_char_folds('u', 'a')
*/
/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part0_(s,e)                            \
( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x48 == ((const U8*)s)[2] ) ) ? 3 : 0 )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part1_(s,e)                            \
( ( 0x8E == ((const U8*)s)[0] ) ?                                           \
	( ( 0x72 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x8E == ((const U8*)s)[2] ) ?                               \
		( ( 0x72 == ((const U8*)s)[3] ) ? 4 : 0 )                   \
	    : ( ( ((const U8*)s)[2] & 0xBE ) == 's' ) ? 3 : 0 )             \
	: 0 )                                                               \
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'j' ) ?                             \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x53 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 's' ) ?                             \
	( ( 0x8E == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x72 == ((const U8*)s)[2] ) ? 3 : 0 )                       \
	: ( ( ((const U8*)s)[1] & 0xBE ) == 's' ) ? 2 : 0 )                 \
    : ( ( ((const U8*)s)[0] & 0xBF ) == 't' ) ?                             \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x49 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ( ((const U8*)s)[0] & 0xBF ) == 'w' ) || ( ( ((const U8*)s)[0] & 0xBF ) == 'y' ) ) ?\
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x51 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xAA == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0x6A == ((const U8*)s)[1] ) && ( ( ((const U8*)s)[2] & 0xBF ) == 'n' ) ) ? 3 : 0 )\
    : ( 0xB3 == ((const U8*)s)[0] ) ?                                       \
	( ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[1]) & 0xFD ) == 0xAC ) ?     \
	    ( ( ( 0xB3 == ((const U8*)s)[2] ) && ( 0x67 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x58 == ((const U8*)s)[1] || 0x65 == ((const U8*)s)[1] ) ?      \
	    ( ( 0xAF == ((const U8*)s)[2] ) ?                               \
		( ( 0x43 == ((const U8*)s)[3] ) ?                           \
		    ( ( ( 0xB3 == ((const U8*)s)[4] ) && ( 0x67 == ((const U8*)s)[5] ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xB3 == ((const U8*)s)[2] ) && ( 0x67 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x67 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xAD == ((const U8*)s)[2] ) ?                               \
		( ( 0x49 == ((const U8*)s)[3] ) ?                           \
		    ( ( 0xAD == ((const U8*)s)[4] ) ?                       \
			( ( inRANGE_helper_(U8, ((const U8*)s)[5], 0x41, 0x42) ) ? 6 : 0 )\
		    : ( ( 0xAF == ((const U8*)s)[4] ) && ( 0x43 == ((const U8*)s)[5] ) ) ? 6 : 0 )\
		: 0 )                                                       \
	    : ( ( 0xAF == ((const U8*)s)[2] ) && ( 0x43 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: 0 )                                                               \
    : ( 0xB4 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x42 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xAD == ((const U8*)s)[2] ) && ( 0x5F == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x46 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xAD == ((const U8*)s)[2] ) ?                               \
		( ( 0x49 == ((const U8*)s)[3] ) ?                           \
		    ( ( 0xAD == ((const U8*)s)[4] ) ?                       \
			( ( inRANGE_helper_(U8, ((const U8*)s)[5], 0x41, 0x42) ) ? 6 : 0 )\
		    : ( ( 0xAF == ((const U8*)s)[4] ) && ( 0x43 == ((const U8*)s)[5] ) ) ? 6 : 0 )\
		: ( 0x5F == ((const U8*)s)[3] ) ?                           \
		    ( ( 0xAD == ((const U8*)s)[4] ) ?                       \
			( ( inRANGE_helper_(U8, ((const U8*)s)[5], 0x41, 0x42) ) ? 6 : 4 )\
		    : ( ( 0xAF == ((const U8*)s)[4] ) && ( 0x43 == ((const U8*)s)[5] ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xAF == ((const U8*)s)[2] ) && ( 0x43 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x4A == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xAF == ((const U8*)s)[2] ) ?                               \
		( ( 0x43 == ((const U8*)s)[3] ) ?                           \
		    ( ( ( 0xB3 == ((const U8*)s)[4] ) && ( 0x67 == ((const U8*)s)[5] ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xB3 == ((const U8*)s)[2] ) && ( 0x67 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x55 == ((const U8*)s)[1] ) && ( 0xB3 == ((const U8*)s)[2] ) ) && ( 0x67 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xB7 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x52 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x46 == ((const U8*)s)[2] ) ?                               \
		( ( ( ( 0xB7 == ((const U8*)s)[3] ) && ( 0x53 == ((const U8*)s)[4] ) ) && ( 0x43 == ((const U8*)s)[5] ) ) ? 6 : 0 )\
	    : ( 0x62 == ((const U8*)s)[2] ) ?                               \
		( ( ( ( 0xB7 == ((const U8*)s)[3] ) && ( 0x52 == ((const U8*)s)[4] ) ) && ( ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[5]) & 0xF7 ) == 0xA5 ) || ((const U8*)s)[5] == 0x52 || ((const U8*)s)[5] == 0x64 ) ) ? 6 : 0 )\
	    : ( ( ( ( 0x71 == ((const U8*)s)[2] ) && ( 0xB7 == ((const U8*)s)[3] ) ) && ( 0x52 == ((const U8*)s)[4] ) ) && ( 0x64 == ((const U8*)s)[5] ) ) ? 6 : 0 )\
	: 0 )                                                               \
    : ( 0xBF == ((const U8*)s)[0] ) ?                                       \
	( ( inRANGE_helper_(U8, ((const U8*)s)[1], 0x66, 0x67) ) ?          \
	    ( ( ( ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x41, 0x48) ) && ( 0xB3 == ((const U8*)s)[3] ) ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 5 : 0 )\
	: ( ( ( ( 0x69 == ((const U8*)s)[1] ) && ( ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[2]) & 0xF8 ) == 0xA0 ) || ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[2]) & 0xFB ) == 0xB0 ) || ((const U8*)s)[2] == 0x6A ) ) && ( 0xB3 == ((const U8*)s)[3] ) ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 5 : 0 )\
    : 0 )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part2_(s,e)                            \
( ( ( ((const U8*)s)[0] & 0xBF ) == 'a' ) ?                                 \
	( ( ( 0xAA == ((const U8*)s)[1] ) && ( 0x71 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'f' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xBF ) == 'f' ) ?                         \
	    ( ( ( ( ((const U8*)s)[2] & 0xBF ) == 'i' ) || ( ( ((const U8*)s)[2] & 0xBF ) == 'l' ) ) ? 3 : 2 )\
	: ( ( ( ((const U8*)s)[1] & 0xBF ) == 'i' ) || ( ( ((const U8*)s)[1] & 0xBF ) == 'l' ) ) ? 2 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'h' ) ?                             \
	( ( ( 0xAE == ((const U8*)s)[1] ) && ( 0x58 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'i' ) ?                             \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x48 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x8E == ((const U8*)s)[0] ) ?                                       \
	( ( 0x72 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x8E == ((const U8*)s)[2] ) ?                               \
		( ( 0x72 == ((const U8*)s)[3] ) ? 4 : 0 )                   \
	    : ( ( ((const U8*)s)[2] & 0xBE ) == 's' ) ? 3 : 0 )             \
	: 0 )                                                               \
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'j' ) ?                             \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x53 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 's' ) ?                             \
	( ( 0x8E == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x72 == ((const U8*)s)[2] ) ? 3 : 0 )                       \
	: ( ( ((const U8*)s)[1] & 0xBE ) == 's' ) ? 2 : 0 )                 \
    : ( ( ((const U8*)s)[0] & 0xBF ) == 't' ) ?                             \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x49 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ( ((const U8*)s)[0] & 0xBF ) == 'w' ) || ( ( ((const U8*)s)[0] & 0xBF ) == 'y' ) ) ?\
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x51 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xAA == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0x6A == ((const U8*)s)[1] ) && ( ( ((const U8*)s)[2] & 0xBF ) == 'n' ) ) ? 3 : 0 )\
    : ( 0xB3 == ((const U8*)s)[0] ) ?                                       \
	( ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[1]) & 0xFD ) == 0xAC ) ?     \
	    ( ( ( 0xB3 == ((const U8*)s)[2] ) && ( 0x67 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x58 == ((const U8*)s)[1] || 0x65 == ((const U8*)s)[1] ) ?      \
	    ( ( 0xAF == ((const U8*)s)[2] ) ?                               \
		( ( 0x43 == ((const U8*)s)[3] ) ? 4 : 0 )                   \
	    : ( ( 0xB3 == ((const U8*)s)[2] ) && ( 0x67 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x67 == ((const U8*)s)[1] ) && ( 0xAF == ((const U8*)s)[2] ) ) && ( 0x43 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xB4 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x42 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xAD == ((const U8*)s)[2] ) && ( 0x5F == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x46 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xAD == ((const U8*)s)[2] ) ?                               \
		( ( 0x5F == ((const U8*)s)[3] ) ? 4 : 0 )                   \
	    : ( ( 0xAF == ((const U8*)s)[2] ) && ( 0x43 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x4A == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xAF == ((const U8*)s)[2] ) ?                               \
		( ( 0x43 == ((const U8*)s)[3] ) ? 4 : 0 )                   \
	    : ( ( 0xB3 == ((const U8*)s)[2] ) && ( 0x67 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x55 == ((const U8*)s)[1] ) && ( 0xB3 == ((const U8*)s)[2] ) ) && ( 0x67 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xBF == ((const U8*)s)[0] ) ?                                       \
	( ( inRANGE_helper_(U8, ((const U8*)s)[1], 0x66, 0x67) ) ?          \
	    ( ( ( ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x41, 0x48) ) && ( 0xB3 == ((const U8*)s)[3] ) ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 5 : 0 )\
	: ( ( ( ( 0x69 == ((const U8*)s)[1] ) && ( ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[2]) & 0xF8 ) == 0xA0 ) || ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[2]) & 0xFB ) == 0xB0 ) || ((const U8*)s)[2] == 0x6A ) ) && ( 0xB3 == ((const U8*)s)[3] ) ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 5 : 0 )\
    : 0 )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part3_(s,e)                            \
( ((e)-(s) > 3) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xBF ) == 'a' ) ?                             \
	( ( ( 0xAA == ((const U8*)s)[1] ) && ( 0x71 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'f' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xBF ) == 'f' ) ?                         \
	    ( ( ( ( ((const U8*)s)[2] & 0xBF ) == 'i' ) || ( ( ((const U8*)s)[2] & 0xBF ) == 'l' ) ) ? 3 : 2 )\
	: ( ( ( ((const U8*)s)[1] & 0xBF ) == 'i' ) || ( ( ((const U8*)s)[1] & 0xBF ) == 'l' ) ) ? 2 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'h' ) ?                             \
	( ( ( 0xAE == ((const U8*)s)[1] ) && ( 0x58 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'i' ) ?                             \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x48 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x8E == ((const U8*)s)[0] ) ?                                       \
	( ( 0x72 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x8E == ((const U8*)s)[2] ) ?                               \
		( ( 0x72 == ((const U8*)s)[3] ) ? 4 : 0 )                   \
	    : ( ( ((const U8*)s)[2] & 0xBE ) == 's' ) ? 3 : 0 )             \
	: 0 )                                                               \
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'j' ) ?                             \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x53 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 's' ) ?                             \
	( ( 0x8E == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x72 == ((const U8*)s)[2] ) ? 3 : 0 )                       \
	: ( ( ((const U8*)s)[1] & 0xBE ) == 's' ) ? 2 : 0 )                 \
    : ( ( ((const U8*)s)[0] & 0xBF ) == 't' ) ?                             \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x49 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ( ((const U8*)s)[0] & 0xBF ) == 'w' ) || ( ( ((const U8*)s)[0] & 0xBF ) == 'y' ) ) ?\
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x51 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xAA == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0x6A == ((const U8*)s)[1] ) && ( ( ((const U8*)s)[2] & 0xBF ) == 'n' ) ) ? 3 : 0 )\
    : ( 0xB3 == ((const U8*)s)[0] ) ?                                       \
	( ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[1]) & 0xFD ) == 0xAC ) ?     \
	    ( ( ( 0xB3 == ((const U8*)s)[2] ) && ( 0x67 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x58 == ((const U8*)s)[1] || 0x65 == ((const U8*)s)[1] ) ?      \
	    ( ( 0xAF == ((const U8*)s)[2] ) ?                               \
		( ( 0x43 == ((const U8*)s)[3] ) ? 4 : 0 )                   \
	    : ( ( 0xB3 == ((const U8*)s)[2] ) && ( 0x67 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x67 == ((const U8*)s)[1] ) && ( 0xAF == ((const U8*)s)[2] ) ) && ( 0x43 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xB4 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x42 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xAD == ((const U8*)s)[2] ) && ( 0x5F == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x46 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xAD == ((const U8*)s)[2] ) ?                               \
		( ( 0x5F == ((const U8*)s)[3] ) ? 4 : 0 )                   \
	    : ( ( 0xAF == ((const U8*)s)[2] ) && ( 0x43 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x4A == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xAF == ((const U8*)s)[2] ) ?                               \
		( ( 0x43 == ((const U8*)s)[3] ) ? 4 : 0 )                   \
	    : ( ( 0xB3 == ((const U8*)s)[2] ) && ( 0x67 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x55 == ((const U8*)s)[1] ) && ( 0xB3 == ((const U8*)s)[2] ) ) && ( 0x67 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : 0 )                                                                   \
: ((e)-(s) > 2) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xBF ) == 'a' ) ?                             \
	( ( ( 0xAA == ((const U8*)s)[1] ) && ( 0x71 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'f' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xBF ) == 'f' ) ?                         \
	    ( ( ( ( ((const U8*)s)[2] & 0xBF ) == 'i' ) || ( ( ((const U8*)s)[2] & 0xBF ) == 'l' ) ) ? 3 : 2 )\
	: ( ( ( ((const U8*)s)[1] & 0xBF ) == 'i' ) || ( ( ((const U8*)s)[1] & 0xBF ) == 'l' ) ) ? 2 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'h' ) ?                             \
	( ( ( 0xAE == ((const U8*)s)[1] ) && ( 0x58 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'i' ) ?                             \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x48 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x8E == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0x72 == ((const U8*)s)[1] ) && ( ( ((const U8*)s)[2] & 0xBE ) == 's' ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'j' ) ?                             \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x53 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 's' ) ?                             \
	( ( 0x8E == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x72 == ((const U8*)s)[2] ) ? 3 : 0 )                       \
	: ( ( ((const U8*)s)[1] & 0xBE ) == 's' ) ? 2 : 0 )                 \
    : ( ( ((const U8*)s)[0] & 0xBF ) == 't' ) ?                             \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x49 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ( ((const U8*)s)[0] & 0xBF ) == 'w' ) || ( ( ((const U8*)s)[0] & 0xBF ) == 'y' ) ) ?\
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x51 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ( 0xAA == ((const U8*)s)[0] ) && ( 0x6A == ((const U8*)s)[1] ) ) && ( ( ((const U8*)s)[2] & 0xBF ) == 'n' ) ) ? 3 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xBF ) == 'f' ) ?                             \
	( ( ( ( ((const U8*)s)[1] & 0xBF ) == 'f' ) || ( ( ((const U8*)s)[1] & 0xBF ) == 'i' ) || ( ( ((const U8*)s)[1] & 0xBF ) == 'l' ) ) ? 2 : 0 )\
    : ( ( ( ((const U8*)s)[0] & 0xBF ) == 's' ) && ( ( ((const U8*)s)[1] & 0xBE ) == 's' ) ) ? 2 : 0 )\
: 0 )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe(s,e)                                   \
( ((e)-(s) > 5) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xBF ) == 'a' ) ?                             \
	( ( ( 0xAA == ((const U8*)s)[1] ) && ( 0x71 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'f' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xBF ) == 'f' ) ?                         \
	    ( ( ( ( ((const U8*)s)[2] & 0xBF ) == 'i' ) || ( ( ((const U8*)s)[2] & 0xBF ) == 'l' ) ) ? 3 : 2 )\
	: ( ( ( ((const U8*)s)[1] & 0xBF ) == 'i' ) || ( ( ((const U8*)s)[1] & 0xBF ) == 'l' ) ) ? 2 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'h' ) ?                             \
	( ( ( 0xAE == ((const U8*)s)[1] ) && ( 0x58 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'i' ) ? is_MULTI_CHAR_FOLD_utf8_safe_part0_(s,e) : is_MULTI_CHAR_FOLD_utf8_safe_part1_(s,e) )\
: ((e)-(s) > 4) ? is_MULTI_CHAR_FOLD_utf8_safe_part2_(s,e) : is_MULTI_CHAR_FOLD_utf8_safe_part3_(s,e) )

/*** GENERATED CODE ***/
#define what_MULTI_CHAR_FOLD_utf8_safe_part0_(s,e)                          \
( ( 0x52 == ((const U8*)s)[1] ) ?                                           \
	    ( ( 0x46 == ((const U8*)s)[2] ) ?                               \
		( ( ( ( 0xB7 == ((const U8*)s)[3] ) && ( 0x53 == ((const U8*)s)[4] ) ) && ( 0x43 == ((const U8*)s)[5] ) ) ? 0x587 : 0 )\
	    : ( 0x62 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB7 == ((const U8*)s)[3] ) && ( 0x52 == ((const U8*)s)[4] ) ) ? ( ( 0x46 == ((const U8*)s)[5] ) ? 0xFB14\
			: ( 0x52 == ((const U8*)s)[5] ) ? 0xFB15            \
			: ( 0x54 == ((const U8*)s)[5] ) ? 0xFB17            \
			: ( 0x64 == ((const U8*)s)[5] ) ? 0xFB13 : 0 ) : 0 )\
	    : ( ( ( ( 0x71 == ((const U8*)s)[2] ) && ( 0xB7 == ((const U8*)s)[3] ) ) && ( 0x52 == ((const U8*)s)[4] ) ) && ( 0x64 == ((const U8*)s)[5] ) ) ? 0xFB16 : 0 )\
	: 0 )


/*** GENERATED CODE ***/
#define what_MULTI_CHAR_FOLD_utf8_safe_part1_(s,e)                          \
( ( 0xBF == ((const U8*)s)[0] ) ?                                           \
	( ( 0x66 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x41 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1F80 : 0 )\
	    : ( 0x42 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1F81 : 0 )\
	    : ( 0x43 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1F82 : 0 )\
	    : ( 0x44 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1F83 : 0 )\
	    : ( 0x45 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1F84 : 0 )\
	    : ( 0x46 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1F85 : 0 )\
	    : ( 0x47 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1F86 : 0 )\
	    : ( ( ( 0x48 == ((const U8*)s)[2] ) && ( 0xB3 == ((const U8*)s)[3] ) ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1F87 : 0 )\
	: ( 0x67 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x41 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1F90 : 0 )\
	    : ( 0x42 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1F91 : 0 )\
	    : ( 0x43 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1F92 : 0 )\
	    : ( 0x44 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1F93 : 0 )\
	    : ( 0x45 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1F94 : 0 )\
	    : ( 0x46 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1F95 : 0 )\
	    : ( 0x47 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1F96 : 0 )\
	    : ( ( ( 0x48 == ((const U8*)s)[2] ) && ( 0xB3 == ((const U8*)s)[3] ) ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1F97 : 0 )\
	: ( 0x69 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x41 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1FA0 : 0 )\
	    : ( 0x42 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1FA1 : 0 )\
	    : ( 0x43 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1FA2 : 0 )\
	    : ( 0x44 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1FA3 : 0 )\
	    : ( 0x45 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1FA4 : 0 )\
	    : ( 0x46 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1FA5 : 0 )\
	    : ( 0x47 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1FA6 : 0 )\
	    : ( 0x48 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1FA7 : 0 )\
	    : ( 0x57 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1FB2 : 0 )\
	    : ( 0x62 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1FC2 : 0 )\
	    : ( ( ( 0x6A == ((const U8*)s)[2] ) && ( 0xB3 == ((const U8*)s)[3] ) ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1FF2 : 0 )\
	: 0 )                                                               \
    : 0 )


/*** GENERATED CODE ***/
#define what_MULTI_CHAR_FOLD_utf8_safe_part2_(s,e)                          \
( ( ( ((const U8*)s)[1] & 0xBF ) == 'f' ) ?                                 \
	    ( ( ( ((const U8*)s)[2] & 0xBF ) == 'i' ) ? 0xFB03              \
	    : ( ( ((const U8*)s)[2] & 0xBF ) == 'l' ) ? 0xFB04 : 0xFB00 )   \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 'i' ) ? 0xFB01                  \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 'l' ) ? 0xFB02 : 0 )


/*** GENERATED CODE ***/
#define what_MULTI_CHAR_FOLD_utf8_safe_part3_(s,e)                          \
( ( ( ((const U8*)s)[0] & 0xBF ) == 'h' ) ?                                 \
	( ( ( 0xAE == ((const U8*)s)[1] ) && ( 0x58 == ((const U8*)s)[2] ) ) ? 0x1E96 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'i' ) ?                             \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x48 == ((const U8*)s)[2] ) ) ? 0x130 : 0 )\
    : ( 0x8E == ((const U8*)s)[0] ) ?                                       \
	( ( 0x72 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x8E == ((const U8*)s)[2] ) ?                               \
		( ( 0x72 == ((const U8*)s)[3] ) ? 0x59 : 0 )                \
	    : ( ( ((const U8*)s)[2] & 0xBF ) == 's' ) ? 0x59                \
	    : ( ( ((const U8*)s)[2] & 0xBF ) == 't' ) ? 0xFB05 : 0 )        \
	: 0 )                                                               \
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'j' ) ?                             \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x53 == ((const U8*)s)[2] ) ) ? 0x1F0 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 's' ) ?                             \
	( ( 0x8E == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x72 == ((const U8*)s)[2] ) ? 0x59 : 0 )                    \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 's' ) ? 0x59                    \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 't' ) ? 0xFB05 : 0 )            \
    : ( ( ((const U8*)s)[0] & 0xBF ) == 't' ) ?                             \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x49 == ((const U8*)s)[2] ) ) ? 0x1E97 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'w' ) ?                             \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x51 == ((const U8*)s)[2] ) ) ? 0x1E98 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'y' ) ?                             \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x51 == ((const U8*)s)[2] ) ) ? 0x1E99 : 0 )\
    : ( 0xAA == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0x6A == ((const U8*)s)[1] ) && ( ( ((const U8*)s)[2] & 0xBF ) == 'n' ) ) ? 0x149 : 0 )\
    : ( 0xB3 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x53 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xB3 == ((const U8*)s)[2] ) && ( 0x67 == ((const U8*)s)[3] ) ) ? 0x1FB4 : 0 )\
	: ( 0x55 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xB3 == ((const U8*)s)[2] ) && ( 0x67 == ((const U8*)s)[3] ) ) ? 0x1FC4 : 0 )\
	: ( 0x58 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xAF == ((const U8*)s)[2] ) ?                               \
		( ( 0x43 == ((const U8*)s)[3] ) ?                           \
		    ( ( ( 0xB3 == ((const U8*)s)[4] ) && ( 0x67 == ((const U8*)s)[5] ) ) ? 0x1FB7 : 0x1FB6 )\
		: 0 )                                                       \
	    : ( ( 0xB3 == ((const U8*)s)[2] ) && ( 0x67 == ((const U8*)s)[3] ) ) ? 0x1FB3 : 0 )\
	: ( 0x65 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xAF == ((const U8*)s)[2] ) ?                               \
		( ( 0x43 == ((const U8*)s)[3] ) ?                           \
		    ( ( ( 0xB3 == ((const U8*)s)[4] ) && ( 0x67 == ((const U8*)s)[5] ) ) ? 0x1FC7 : 0x1FC6 )\
		: 0 )                                                       \
	    : ( ( 0xB3 == ((const U8*)s)[2] ) && ( 0x67 == ((const U8*)s)[3] ) ) ? 0x1FC3 : 0 )\
	: ( 0x67 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xAD == ((const U8*)s)[2] ) ?                               \
		( ( 0x49 == ((const U8*)s)[3] ) ?                           \
		    ( ( 0xAD == ((const U8*)s)[4] ) ?                       \
			( ( 0x41 == ((const U8*)s)[5] ) ? 0x1FD2            \
			: ( 0x42 == ((const U8*)s)[5] ) ? 0x390 : 0 )       \
		    : ( ( 0xAF == ((const U8*)s)[4] ) && ( 0x43 == ((const U8*)s)[5] ) ) ? 0x1FD7 : 0 )\
		: 0 )                                                       \
	    : ( ( 0xAF == ((const U8*)s)[2] ) && ( 0x43 == ((const U8*)s)[3] ) ) ? 0x1FD6 : 0 )\
	: 0 )                                                               \
    : ( 0xB4 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x42 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xAD == ((const U8*)s)[2] ) && ( 0x5F == ((const U8*)s)[3] ) ) ? 0x1FE4 : 0 )\
	: ( 0x46 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xAD == ((const U8*)s)[2] ) ?                               \
		( ( 0x49 == ((const U8*)s)[3] ) ?                           \
		    ( ( 0xAD == ((const U8*)s)[4] ) ?                       \
			( ( 0x41 == ((const U8*)s)[5] ) ? 0x1FE2            \
			: ( 0x42 == ((const U8*)s)[5] ) ? 0x3B0 : 0 )       \
		    : ( ( 0xAF == ((const U8*)s)[4] ) && ( 0x43 == ((const U8*)s)[5] ) ) ? 0x1FE7 : 0 )\
		: ( 0x5F == ((const U8*)s)[3] ) ?                           \
		    ( ( 0xAD == ((const U8*)s)[4] ) ?                       \
			( ( 0x41 == ((const U8*)s)[5] ) ? 0x1F52            \
			: ( 0x42 == ((const U8*)s)[5] ) ? 0x1F54 : 0x1F50 ) \
		    : ( ( 0xAF == ((const U8*)s)[4] ) && ( 0x43 == ((const U8*)s)[5] ) ) ? 0x1F56 : 0x1F50 )\
		: 0 )                                                       \
	    : ( ( 0xAF == ((const U8*)s)[2] ) && ( 0x43 == ((const U8*)s)[3] ) ) ? 0x1FE6 : 0 )\
	: ( 0x4A == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xAF == ((const U8*)s)[2] ) ?                               \
		( ( 0x43 == ((const U8*)s)[3] ) ?                           \
		    ( ( ( 0xB3 == ((const U8*)s)[4] ) && ( 0x67 == ((const U8*)s)[5] ) ) ? 0x1FF7 : 0x1FF6 )\
		: 0 )                                                       \
	    : ( ( 0xB3 == ((const U8*)s)[2] ) && ( 0x67 == ((const U8*)s)[3] ) ) ? 0x1FF3 : 0 )\
	: ( ( ( 0x55 == ((const U8*)s)[1] ) && ( 0xB3 == ((const U8*)s)[2] ) ) && ( 0x67 == ((const U8*)s)[3] ) ) ? 0x1FF4 : 0 )\
    : ( 0xB7 == ((const U8*)s)[0] ) ? what_MULTI_CHAR_FOLD_utf8_safe_part0_(s,e) : what_MULTI_CHAR_FOLD_utf8_safe_part1_(s,e) )


/*** GENERATED CODE ***/
#define what_MULTI_CHAR_FOLD_utf8_safe_part4_(s,e)                          \
( ( 0x42 == ((const U8*)s)[1] ) ?                                           \
	    ( ( ( 0xAD == ((const U8*)s)[2] ) && ( 0x5F == ((const U8*)s)[3] ) ) ? 0x1FE4 : 0 )\
	: ( 0x46 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xAD == ((const U8*)s)[2] ) ?                               \
		( ( 0x5F == ((const U8*)s)[3] ) ? 0x1F50 : 0 )              \
	    : ( ( 0xAF == ((const U8*)s)[2] ) && ( 0x43 == ((const U8*)s)[3] ) ) ? 0x1FE6 : 0 )\
	: ( 0x4A == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xAF == ((const U8*)s)[2] ) ?                               \
		( ( 0x43 == ((const U8*)s)[3] ) ? 0x1FF6 : 0 )              \
	    : ( ( 0xB3 == ((const U8*)s)[2] ) && ( 0x67 == ((const U8*)s)[3] ) ) ? 0x1FF3 : 0 )\
	: ( ( ( 0x55 == ((const U8*)s)[1] ) && ( 0xB3 == ((const U8*)s)[2] ) ) && ( 0x67 == ((const U8*)s)[3] ) ) ? 0x1FF4 : 0 )


/*** GENERATED CODE ***/
#define what_MULTI_CHAR_FOLD_utf8_safe_part5_(s,e)                          \
( ( 0xBF == ((const U8*)s)[0] ) ?                                           \
	( ( 0x66 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x41 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1F80 : 0 )\
	    : ( 0x42 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1F81 : 0 )\
	    : ( 0x43 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1F82 : 0 )\
	    : ( 0x44 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1F83 : 0 )\
	    : ( 0x45 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1F84 : 0 )\
	    : ( 0x46 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1F85 : 0 )\
	    : ( 0x47 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1F86 : 0 )\
	    : ( ( ( 0x48 == ((const U8*)s)[2] ) && ( 0xB3 == ((const U8*)s)[3] ) ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1F87 : 0 )\
	: ( 0x67 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x41 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1F90 : 0 )\
	    : ( 0x42 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1F91 : 0 )\
	    : ( 0x43 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1F92 : 0 )\
	    : ( 0x44 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1F93 : 0 )\
	    : ( 0x45 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1F94 : 0 )\
	    : ( 0x46 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1F95 : 0 )\
	    : ( 0x47 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1F96 : 0 )\
	    : ( ( ( 0x48 == ((const U8*)s)[2] ) && ( 0xB3 == ((const U8*)s)[3] ) ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1F97 : 0 )\
	: ( 0x69 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x41 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1FA0 : 0 )\
	    : ( 0x42 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1FA1 : 0 )\
	    : ( 0x43 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1FA2 : 0 )\
	    : ( 0x44 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1FA3 : 0 )\
	    : ( 0x45 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1FA4 : 0 )\
	    : ( 0x46 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1FA5 : 0 )\
	    : ( 0x47 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1FA6 : 0 )\
	    : ( 0x48 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1FA7 : 0 )\
	    : ( 0x57 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1FB2 : 0 )\
	    : ( 0x62 == ((const U8*)s)[2] ) ?                               \
		( ( ( 0xB3 == ((const U8*)s)[3] ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1FC2 : 0 )\
	    : ( ( ( 0x6A == ((const U8*)s)[2] ) && ( 0xB3 == ((const U8*)s)[3] ) ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 0x1FF2 : 0 )\
	: 0 )                                                               \
    : 0 )


/*** GENERATED CODE ***/
#define what_MULTI_CHAR_FOLD_utf8_safe_part6_(s,e)                          \
( ( ( ((const U8*)s)[0] & 0xBF ) == 'a' ) ?                                 \
	( ( ( 0xAA == ((const U8*)s)[1] ) && ( 0x71 == ((const U8*)s)[2] ) ) ? 0x1E9A : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'f' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xBF ) == 'f' ) ?                         \
	    ( ( ( ((const U8*)s)[2] & 0xBF ) == 'i' ) ? 0xFB03              \
	    : ( ( ((const U8*)s)[2] & 0xBF ) == 'l' ) ? 0xFB04 : 0xFB00 )   \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 'i' ) ? 0xFB01                  \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 'l' ) ? 0xFB02 : 0 )            \
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'h' ) ?                             \
	( ( ( 0xAE == ((const U8*)s)[1] ) && ( 0x58 == ((const U8*)s)[2] ) ) ? 0x1E96 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'i' ) ?                             \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x48 == ((const U8*)s)[2] ) ) ? 0x130 : 0 )\
    : ( 0x8E == ((const U8*)s)[0] ) ?                                       \
	( ( 0x72 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x8E == ((const U8*)s)[2] ) ?                               \
		( ( 0x72 == ((const U8*)s)[3] ) ? 0x59 : 0 )                \
	    : ( ( ((const U8*)s)[2] & 0xBF ) == 's' ) ? 0x59                \
	    : ( ( ((const U8*)s)[2] & 0xBF ) == 't' ) ? 0xFB05 : 0 )        \
	: 0 )                                                               \
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'j' ) ?                             \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x53 == ((const U8*)s)[2] ) ) ? 0x1F0 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 's' ) ?                             \
	( ( 0x8E == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x72 == ((const U8*)s)[2] ) ? 0x59 : 0 )                    \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 's' ) ? 0x59                    \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 't' ) ? 0xFB05 : 0 )            \
    : ( ( ((const U8*)s)[0] & 0xBF ) == 't' ) ?                             \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x49 == ((const U8*)s)[2] ) ) ? 0x1E97 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'w' ) ?                             \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x51 == ((const U8*)s)[2] ) ) ? 0x1E98 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'y' ) ?                             \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x51 == ((const U8*)s)[2] ) ) ? 0x1E99 : 0 )\
    : ( 0xAA == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0x6A == ((const U8*)s)[1] ) && ( ( ((const U8*)s)[2] & 0xBF ) == 'n' ) ) ? 0x149 : 0 )\
    : ( 0xB3 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x53 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xB3 == ((const U8*)s)[2] ) && ( 0x67 == ((const U8*)s)[3] ) ) ? 0x1FB4 : 0 )\
	: ( 0x55 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xB3 == ((const U8*)s)[2] ) && ( 0x67 == ((const U8*)s)[3] ) ) ? 0x1FC4 : 0 )\
	: ( 0x58 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xAF == ((const U8*)s)[2] ) ?                               \
		( ( 0x43 == ((const U8*)s)[3] ) ? 0x1FB6 : 0 )              \
	    : ( ( 0xB3 == ((const U8*)s)[2] ) && ( 0x67 == ((const U8*)s)[3] ) ) ? 0x1FB3 : 0 )\
	: ( 0x65 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xAF == ((const U8*)s)[2] ) ?                               \
		( ( 0x43 == ((const U8*)s)[3] ) ? 0x1FC6 : 0 )              \
	    : ( ( 0xB3 == ((const U8*)s)[2] ) && ( 0x67 == ((const U8*)s)[3] ) ) ? 0x1FC3 : 0 )\
	: ( ( ( 0x67 == ((const U8*)s)[1] ) && ( 0xAF == ((const U8*)s)[2] ) ) && ( 0x43 == ((const U8*)s)[3] ) ) ? 0x1FD6 : 0 )\
    : ( 0xB4 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x42 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xAD == ((const U8*)s)[2] ) && ( 0x5F == ((const U8*)s)[3] ) ) ? 0x1FE4 : 0 )\
	: ( 0x46 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xAD == ((const U8*)s)[2] ) ?                               \
		( ( 0x5F == ((const U8*)s)[3] ) ? 0x1F50 : 0 )              \
	    : ( ( 0xAF == ((const U8*)s)[2] ) && ( 0x43 == ((const U8*)s)[3] ) ) ? 0x1FE6 : 0 )\
	: ( 0x4A == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xAF == ((const U8*)s)[2] ) ?                               \
		( ( 0x43 == ((const U8*)s)[3] ) ? 0x1FF6 : 0 )              \
	    : ( ( 0xB3 == ((const U8*)s)[2] ) && ( 0x67 == ((const U8*)s)[3] ) ) ? 0x1FF3 : 0 )\
	: ( ( ( 0x55 == ((const U8*)s)[1] ) && ( 0xB3 == ((const U8*)s)[2] ) ) && ( 0x67 == ((const U8*)s)[3] ) ) ? 0x1FF4 : 0 )\
    : 0 )


/*** GENERATED CODE ***/
#define what_MULTI_CHAR_FOLD_utf8_safe_part7_(s,e)                          \
( ((e)-(s) > 2) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xBF ) == 'a' ) ?                             \
	( ( ( 0xAA == ((const U8*)s)[1] ) && ( 0x71 == ((const U8*)s)[2] ) ) ? 0x1E9A : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'f' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xBF ) == 'f' ) ?                         \
	    ( ( ( ((const U8*)s)[2] & 0xBF ) == 'i' ) ? 0xFB03              \
	    : ( ( ((const U8*)s)[2] & 0xBF ) == 'l' ) ? 0xFB04 : 0xFB00 )   \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 'i' ) ? 0xFB01                  \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 'l' ) ? 0xFB02 : 0 )            \
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'h' ) ?                             \
	( ( ( 0xAE == ((const U8*)s)[1] ) && ( 0x58 == ((const U8*)s)[2] ) ) ? 0x1E96 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'i' ) ?                             \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x48 == ((const U8*)s)[2] ) ) ? 0x130 : 0 )\
    : ( 0x8E == ((const U8*)s)[0] ) ?                                       \
	( ( 0x72 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( ((const U8*)s)[2] & 0xBF ) == 's' ) ? 0x59                \
	    : ( ( ((const U8*)s)[2] & 0xBF ) == 't' ) ? 0xFB05 : 0 )        \
	: 0 )                                                               \
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'j' ) ?                             \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x53 == ((const U8*)s)[2] ) ) ? 0x1F0 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 's' ) ?                             \
	( ( 0x8E == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x72 == ((const U8*)s)[2] ) ? 0x59 : 0 )                    \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 's' ) ? 0x59                    \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 't' ) ? 0xFB05 : 0 )            \
    : ( ( ((const U8*)s)[0] & 0xBF ) == 't' ) ?                             \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x49 == ((const U8*)s)[2] ) ) ? 0x1E97 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'w' ) ?                             \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x51 == ((const U8*)s)[2] ) ) ? 0x1E98 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'y' ) ?                             \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x51 == ((const U8*)s)[2] ) ) ? 0x1E99 : 0 )\
    : ( ( ( 0xAA == ((const U8*)s)[0] ) && ( 0x6A == ((const U8*)s)[1] ) ) && ( ( ((const U8*)s)[2] & 0xBF ) == 'n' ) ) ? 0x149 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xBF ) == 'f' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xBF ) == 'f' ) ? 0xFB00                  \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 'i' ) ? 0xFB01                  \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 'l' ) ? 0xFB02 : 0 )            \
    : ( ( ((const U8*)s)[0] & 0xBF ) == 's' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xBF ) == 's' ) ? 0x59                    \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 't' ) ? 0xFB05 : 0 )            \
    : 0 )                                                                   \
: 0 )


/*** GENERATED CODE ***/
#define what_MULTI_CHAR_FOLD_utf8_safe(s,e)                                 \
( ((e)-(s) > 5) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xBF ) == 'a' ) ?                             \
	( ( ( 0xAA == ((const U8*)s)[1] ) && ( 0x71 == ((const U8*)s)[2] ) ) ? 0x1E9A : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'f' ) ? what_MULTI_CHAR_FOLD_utf8_safe_part2_(s,e) : what_MULTI_CHAR_FOLD_utf8_safe_part3_(s,e) )\
: ((e)-(s) > 4) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xBF ) == 'a' ) ?                             \
	( ( ( 0xAA == ((const U8*)s)[1] ) && ( 0x71 == ((const U8*)s)[2] ) ) ? 0x1E9A : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'f' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xBF ) == 'f' ) ?                         \
	    ( ( ( ((const U8*)s)[2] & 0xBF ) == 'i' ) ? 0xFB03              \
	    : ( ( ((const U8*)s)[2] & 0xBF ) == 'l' ) ? 0xFB04 : 0xFB00 )   \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 'i' ) ? 0xFB01                  \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 'l' ) ? 0xFB02 : 0 )            \
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'h' ) ?                             \
	( ( ( 0xAE == ((const U8*)s)[1] ) && ( 0x58 == ((const U8*)s)[2] ) ) ? 0x1E96 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'i' ) ?                             \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x48 == ((const U8*)s)[2] ) ) ? 0x130 : 0 )\
    : ( 0x8E == ((const U8*)s)[0] ) ?                                       \
	( ( 0x72 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x8E == ((const U8*)s)[2] ) ?                               \
		( ( 0x72 == ((const U8*)s)[3] ) ? 0x59 : 0 )                \
	    : ( ( ((const U8*)s)[2] & 0xBF ) == 's' ) ? 0x59                \
	    : ( ( ((const U8*)s)[2] & 0xBF ) == 't' ) ? 0xFB05 : 0 )        \
	: 0 )                                                               \
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'j' ) ?                             \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x53 == ((const U8*)s)[2] ) ) ? 0x1F0 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 's' ) ?                             \
	( ( 0x8E == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x72 == ((const U8*)s)[2] ) ? 0x59 : 0 )                    \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 's' ) ? 0x59                    \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 't' ) ? 0xFB05 : 0 )            \
    : ( ( ((const U8*)s)[0] & 0xBF ) == 't' ) ?                             \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x49 == ((const U8*)s)[2] ) ) ? 0x1E97 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'w' ) ?                             \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x51 == ((const U8*)s)[2] ) ) ? 0x1E98 : 0 )\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'y' ) ?                             \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x51 == ((const U8*)s)[2] ) ) ? 0x1E99 : 0 )\
    : ( 0xAA == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0x6A == ((const U8*)s)[1] ) && ( ( ((const U8*)s)[2] & 0xBF ) == 'n' ) ) ? 0x149 : 0 )\
    : ( 0xB3 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x53 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xB3 == ((const U8*)s)[2] ) && ( 0x67 == ((const U8*)s)[3] ) ) ? 0x1FB4 : 0 )\
	: ( 0x55 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xB3 == ((const U8*)s)[2] ) && ( 0x67 == ((const U8*)s)[3] ) ) ? 0x1FC4 : 0 )\
	: ( 0x58 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xAF == ((const U8*)s)[2] ) ?                               \
		( ( 0x43 == ((const U8*)s)[3] ) ? 0x1FB6 : 0 )              \
	    : ( ( 0xB3 == ((const U8*)s)[2] ) && ( 0x67 == ((const U8*)s)[3] ) ) ? 0x1FB3 : 0 )\
	: ( 0x65 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xAF == ((const U8*)s)[2] ) ?                               \
		( ( 0x43 == ((const U8*)s)[3] ) ? 0x1FC6 : 0 )              \
	    : ( ( 0xB3 == ((const U8*)s)[2] ) && ( 0x67 == ((const U8*)s)[3] ) ) ? 0x1FC3 : 0 )\
	: ( ( ( 0x67 == ((const U8*)s)[1] ) && ( 0xAF == ((const U8*)s)[2] ) ) && ( 0x43 == ((const U8*)s)[3] ) ) ? 0x1FD6 : 0 )\
    : ( 0xB4 == ((const U8*)s)[0] ) ? what_MULTI_CHAR_FOLD_utf8_safe_part4_(s,e) : what_MULTI_CHAR_FOLD_utf8_safe_part5_(s,e) )\
: ((e)-(s) > 3) ? what_MULTI_CHAR_FOLD_utf8_safe_part6_(s,e) : what_MULTI_CHAR_FOLD_utf8_safe_part7_(s,e) )

/*
	MULTI_CHAR_FOLD: multi-char strings that are folded to by a single character

	%regcharclass_multi_char_folds::multi_char_folds('l', 'a')
*/
/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_latin1_safe(s,e)                                 \
( ((e)-(s) > 2) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xBF ) == 'f' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xBF ) == 'f' ) ?                         \
	    ( ( ( ( ((const U8*)s)[2] & 0xBF ) == 'i' ) || ( ( ((const U8*)s)[2] & 0xBF ) == 'l' ) ) ? 3 : 2 )\
	: ( ( ( ((const U8*)s)[1] & 0xBF ) == 'i' ) || ( ( ((const U8*)s)[1] & 0xBF ) == 'l' ) ) ? 2 : 0 )\
    : ( ( ( ((const U8*)s)[0] & 0xBF ) == 's' ) && ( ( ((const U8*)s)[1] & 0xBE ) == 's' ) ) ? 2 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xBF ) == 'f' ) ?                             \
	( ( ( ( ((const U8*)s)[1] & 0xBF ) == 'f' ) || ( ( ((const U8*)s)[1] & 0xBF ) == 'i' ) || ( ( ((const U8*)s)[1] & 0xBF ) == 'l' ) ) ? 2 : 0 )\
    : ( ( ( ((const U8*)s)[0] & 0xBF ) == 's' ) && ( ( ((const U8*)s)[1] & 0xBE ) == 's' ) ) ? 2 : 0 )\
: 0 )

/*** GENERATED CODE ***/
#define what_MULTI_CHAR_FOLD_latin1_safe(s,e)                               \
( ((e)-(s) > 2) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xBF ) == 'f' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xBF ) == 'f' ) ?                         \
	    ( ( ( ((const U8*)s)[2] & 0xBF ) == 'i' ) ? 0xFB03              \
	    : ( ( ((const U8*)s)[2] & 0xBF ) == 'l' ) ? 0xFB04 : 0xFB00 )   \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 'i' ) ? 0xFB01                  \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 'l' ) ? 0xFB02 : 0 )            \
    : ( ( ((const U8*)s)[0] & 0xBF ) == 's' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xBF ) == 's' ) ? 0x59                    \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 't' ) ? 0xFB05 : 0 )            \
    : 0 )                                                                   \
: ((e)-(s) > 1) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xBF ) == 'f' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xBF ) == 'f' ) ? 0xFB00                  \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 'i' ) ? 0xFB01                  \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 'l' ) ? 0xFB02 : 0 )            \
    : ( ( ((const U8*)s)[0] & 0xBF ) == 's' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xBF ) == 's' ) ? 0x59                    \
	: ( ( ((const U8*)s)[1] & 0xBF ) == 't' ) ? 0xFB05 : 0 )            \
    : 0 )                                                                   \
: 0 )

/*
	THREE_CHAR_FOLD: A three-character multi-char fold

	%regcharclass_multi_char_folds::multi_char_folds('u', '3')
*/
/*** GENERATED CODE ***/
#define is_THREE_CHAR_FOLD_utf8_safe(s,e)                                   \
( ((e)-(s) > 5) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xBF ) == 'f' ) ?                             \
	( ( ( ( ((const U8*)s)[1] & 0xBF ) == 'f' ) && ( ( ( ((const U8*)s)[2] & 0xBF ) == 'i' ) || ( ( ((const U8*)s)[2] & 0xBF ) == 'l' ) ) ) ? 3 : 0 )\
    : ( 0xB3 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x58 == ((const U8*)s)[1] || 0x65 == ((const U8*)s)[1] ) ?      \
	    ( ( ( ( ( 0xAF == ((const U8*)s)[2] ) && ( 0x43 == ((const U8*)s)[3] ) ) && ( 0xB3 == ((const U8*)s)[4] ) ) && ( 0x67 == ((const U8*)s)[5] ) ) ? 6 : 0 )\
	: ( ( ( 0x67 == ((const U8*)s)[1] ) && ( 0xAD == ((const U8*)s)[2] ) ) && ( 0x49 == ((const U8*)s)[3] ) ) ? ( ( 0xAD == ((const U8*)s)[4] ) ?\
			( ( inRANGE_helper_(U8, ((const U8*)s)[5], 0x41, 0x42) ) ? 6 : 0 )\
		    : ( ( 0xAF == ((const U8*)s)[4] ) && ( 0x43 == ((const U8*)s)[5] ) ) ? 6 : 0 ) : 0 )\
    : ( 0xB4 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x46 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xAD == ((const U8*)s)[2] ) && ( 0x49 == ((const U8*)s)[3] || 0x5F == ((const U8*)s)[3] ) ) ? ( ( 0xAD == ((const U8*)s)[4] ) ?\
			( ( inRANGE_helper_(U8, ((const U8*)s)[5], 0x41, 0x42) ) ? 6 : 0 )\
		    : ( ( 0xAF == ((const U8*)s)[4] ) && ( 0x43 == ((const U8*)s)[5] ) ) ? 6 : 0 ) : 0 )\
	: ( ( ( ( ( 0x4A == ((const U8*)s)[1] ) && ( 0xAF == ((const U8*)s)[2] ) ) && ( 0x43 == ((const U8*)s)[3] ) ) && ( 0xB3 == ((const U8*)s)[4] ) ) && ( 0x67 == ((const U8*)s)[5] ) ) ? 6 : 0 )\
    : 0 )                                                                   \
: ( ( ( ((e)-(s) > 2) && ( ( ((const U8*)s)[0] & 0xBF ) == 'f' ) ) && ( ( ((const U8*)s)[1] & 0xBF ) == 'f' ) ) && ( ( ( ((const U8*)s)[2] & 0xBF ) == 'i' ) || ( ( ((const U8*)s)[2] & 0xBF ) == 'l' ) ) ) ? 3 : 0 )

/*
	THREE_CHAR_FOLD: A three-character multi-char fold

	%regcharclass_multi_char_folds::multi_char_folds('l', '3')
*/
/*** GENERATED CODE ***/
#define is_THREE_CHAR_FOLD_latin1_safe(s,e)                                 \
( ( ( ( ( ((e) - (s)) >= 3 ) && ( ( ((const U8*)s)[0] & 0xBF ) == 'f' ) ) && ( ( ((const U8*)s)[1] & 0xBF ) == 'f' ) ) && ( ( ( ((const U8*)s)[2] & 0xBF ) == 'i' ) || ( ( ((const U8*)s)[2] & 0xBF ) == 'l' ) ) ) ? 3 : 0 )

/*
	THREE_CHAR_FOLD_HEAD: The first two of three-character multi-char folds

	%regcharclass_multi_char_folds::multi_char_folds('u', 'h')
*/
/*** GENERATED CODE ***/
#define is_THREE_CHAR_FOLD_HEAD_utf8_safe(s,e)                              \
( ((e)-(s) > 3) ?                                                           \
    ( ( ( ( ((const U8*)s)[0] & 0xAF ) == 'a' ) || ( ( ((const U8*)s)[0] & 0xBE ) == 'h' ) || ( ( ((const U8*)s)[0] & 0xBE ) == 's' ) || ( ( ((const U8*)s)[0] & 0xBF ) == 'w' ) || ( ( ((const U8*)s)[0] & 0xBF ) == 'y' ) ) ? 1\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'f' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xBF ) == 'f' ) ? 2 : 1 )                 \
    : ( 0x8E == ((const U8*)s)[0] ) ?                                       \
	( ( 0x72 == ((const U8*)s)[1] ) ? 2 : 0 )                           \
    : ( 0xAA == ((const U8*)s)[0] ) ?                                       \
	( ( 0x6A == ((const U8*)s)[1] ) ? 2 : 0 )                           \
    : ( 0xB3 == ((const U8*)s)[0] ) ?                                       \
	( ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[1]) & 0xFD ) == 0xAC ) ? 2   \
	: ( 0x58 == ((const U8*)s)[1] || 0x65 == ((const U8*)s)[1] ) ?      \
	    ( ( ( 0xAF == ((const U8*)s)[2] ) && ( 0x43 == ((const U8*)s)[3] ) ) ? 4 : 2 )\
	: ( 0x67 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xAD == ((const U8*)s)[2] ) && ( 0x49 == ((const U8*)s)[3] ) ) ? 4 : 2 )\
	: 0 )                                                               \
    : ( 0xB4 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x42 == ((const U8*)s)[1] || 0x55 == ((const U8*)s)[1] ) ? 2    \
	: ( 0x46 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xAD == ((const U8*)s)[2] ) && ( 0x49 == ((const U8*)s)[3] || 0x5F == ((const U8*)s)[3] ) ) ? 4 : 2 )\
	: ( 0x4A == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xAF == ((const U8*)s)[2] ) && ( 0x43 == ((const U8*)s)[3] ) ) ? 4 : 2 )\
	: 0 )                                                               \
    : ( 0xB7 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0x52 == ((const U8*)s)[1] ) && ( 0x46 == ((const U8*)s)[2] || 0x62 == ((const U8*)s)[2] || 0x71 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xBF == ((const U8*)s)[0] ) ?                                       \
	( ( inRANGE_helper_(U8, ((const U8*)s)[1], 0x66, 0x67) ) ?          \
	    ( ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x41, 0x48) ) ? 3 : 0 )\
	: ( ( 0x69 == ((const U8*)s)[1] ) && ( ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[2]) & 0xF8 ) == 0xA0 ) || ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[2]) & 0xFB ) == 0xB0 ) || ((const U8*)s)[2] == 0x6A ) ) ? 3 : 0 )\
    : 0 )                                                                   \
: ((e)-(s) > 2) ?                                                           \
    ( ( ( ( ((const U8*)s)[0] & 0xAF ) == 'a' ) || ( ( ((const U8*)s)[0] & 0xBE ) == 'h' ) || ( ( ((const U8*)s)[0] & 0xBE ) == 's' ) || ( ( ((const U8*)s)[0] & 0xBF ) == 'w' ) || ( ( ((const U8*)s)[0] & 0xBF ) == 'y' ) ) ? 1\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'f' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xBF ) == 'f' ) ? 2 : 1 )                 \
    : ( 0x8E == ((const U8*)s)[0] ) ?                                       \
	( ( 0x72 == ((const U8*)s)[1] ) ? 2 : 0 )                           \
    : ( 0xAA == ((const U8*)s)[0] ) ?                                       \
	( ( 0x6A == ((const U8*)s)[1] ) ? 2 : 0 )                           \
    : ( 0xB3 == ((const U8*)s)[0] ) ?                                       \
	( ( ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[1]) & 0xFD ) == 0xAC ) || ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[1]) & 0xF7 ) == 0xB1 ) || ((const U8*)s)[1] == 0x65 ) ? 2 : 0 )\
    : ( 0xB4 == ((const U8*)s)[0] ) ?                                       \
	( ( ( ( ((const U8*)s)[1] & 0xFB ) == 0x42 ) || ((const U8*)s)[1] == 0x4A || ((const U8*)s)[1] == 0x55 ) ? 2 : 0 )\
    : ( 0xB7 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0x52 == ((const U8*)s)[1] ) && ( 0x46 == ((const U8*)s)[2] || 0x62 == ((const U8*)s)[2] || 0x71 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xBF == ((const U8*)s)[0] ) ?                                       \
	( ( inRANGE_helper_(U8, ((const U8*)s)[1], 0x66, 0x67) ) ?          \
	    ( ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x41, 0x48) ) ? 3 : 0 )\
	: ( ( 0x69 == ((const U8*)s)[1] ) && ( ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[2]) & 0xF8 ) == 0xA0 ) || ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[2]) & 0xFB ) == 0xB0 ) || ((const U8*)s)[2] == 0x6A ) ) ? 3 : 0 )\
    : 0 )                                                                   \
: ((e)-(s) > 1) ?                                                           \
    ( ( ( ( ((const U8*)s)[0] & 0xAF ) == 'a' ) || ( ( ((const U8*)s)[0] & 0xBE ) == 'h' ) || ( ( ((const U8*)s)[0] & 0xBE ) == 's' ) || ( ( ((const U8*)s)[0] & 0xBF ) == 'w' ) || ( ( ((const U8*)s)[0] & 0xBF ) == 'y' ) ) ? 1\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'f' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xBF ) == 'f' ) ? 2 : 1 )                 \
    : ( 0x8E == ((const U8*)s)[0] ) ?                                       \
	( ( 0x72 == ((const U8*)s)[1] ) ? 2 : 0 )                           \
    : ( 0xAA == ((const U8*)s)[0] ) ?                                       \
	( ( 0x6A == ((const U8*)s)[1] ) ? 2 : 0 )                           \
    : ( 0xB3 == ((const U8*)s)[0] ) ?                                       \
	( ( ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[1]) & 0xFD ) == 0xAC ) || ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[1]) & 0xF7 ) == 0xB1 ) || ((const U8*)s)[1] == 0x65 ) ? 2 : 0 )\
    : ( ( 0xB4 == ((const U8*)s)[0] ) && ( ( ( ((const U8*)s)[1] & 0xFB ) == 0x42 ) || ((const U8*)s)[1] == 0x4A || ((const U8*)s)[1] == 0x55 ) ) ? 2 : 0 )\
: ((e)-(s) > 0) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xAF ) == 'a' ) || ( ( ((const U8*)s)[0] & 0x9F ) == 'f' ) || ( ( ((const U8*)s)[0] & 0xBE ) == 'h' ) || ( ( ((const U8*)s)[0] & 0xBE ) == 's' ) || ( ( ((const U8*)s)[0] & 0xBF ) == 'y' ) )\
: 0 )

/*
	THREE_CHAR_FOLD_HEAD: The first two of three-character multi-char folds

	%regcharclass_multi_char_folds::multi_char_folds('l', 'h')
*/
/*** GENERATED CODE ***/
#define is_THREE_CHAR_FOLD_HEAD_latin1_safe(s,e)                            \
( ((e)-(s) > 1) ?                                                           \
    ( ( ( ( ((const U8*)s)[0] & 0xAF ) == 'a' ) || ( ( ((const U8*)s)[0] & 0xBE ) == 'h' ) || ( ( ((const U8*)s)[0] & 0xBE ) == 's' ) || ( ( ((const U8*)s)[0] & 0xBF ) == 'w' ) || ( ( ((const U8*)s)[0] & 0xBF ) == 'y' ) ) ? 1\
    : ( ( ((const U8*)s)[0] & 0xBF ) == 'f' ) ?                             \
	( ( ( ((const U8*)s)[1] & 0xBF ) == 'f' ) ? 2 : 1 )                 \
    : 0 )                                                                   \
: ((e)-(s) > 0) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xAF ) == 'a' ) || ( ( ((const U8*)s)[0] & 0x9F ) == 'f' ) || ( ( ((const U8*)s)[0] & 0xBE ) == 'h' ) || ( ( ((const U8*)s)[0] & 0xBE ) == 's' ) || ( ( ((const U8*)s)[0] & 0xBF ) == 'y' ) )\
: 0 )

/*
	FOLDS_TO_MULTI: characters that fold to multi-char strings

	\p{_Perl_Folds_To_Multi_Char}
*/
/*** GENERATED CODE ***/
#define is_FOLDS_TO_MULTI_utf8(s)                                           \
( ( 0x80 == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x72 == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0x8C == ((const U8*)s)[0] || 0x9B == ((const U8*)s)[0] || inRANGE_helper_(U8, ((const U8*)s)[0], 0xB2, 0xB3) ) ?\
    ( ( 0x57 == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0x8D == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x4A == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xB7 == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x53 == ((const U8*)s)[1] ) && ( 0x48 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xBF == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x62 == ((const U8*)s)[1] ) ?                                       \
	( ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x64, 0x68) || 0x71 == ((const U8*)s)[2] ) ? 3 : 0 )\
    : ( 0x68 == ((const U8*)s)[1] ) ?                                       \
	( ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[2]) & 0xF9 ) == 0xB0 ) ? 3 : 0 )\
    : ( 0x6A == ((const U8*)s)[1] ) ?                                       \
	3                                                                   \
    : ( 0x70 == ((const U8*)s)[1] ) ?                                       \
	( ( ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[2]) & 0xF0 ) == 0xA0 ) || ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[2]) & 0xFA ) == 0xB2 ) || ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[2]) & 0xF7 ) == 0xB4 ) ) ? 3 : 0 )\
    : ( 0x71 == ((const U8*)s)[1] ) ?                                       \
	( ( ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[2]) & 0xEA ) == 0xA2 ) || ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[2]) & 0xF7 ) == 0xA4 ) ) ? 3 : 0 )\
    : ( ( 0x72 == ((const U8*)s)[1] ) && ( ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[2]) & 0xEA ) == 0xA2 ) || ((const U8*)s)[2] == 0x45 || ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[2]) & 0xF7 ) == 0xB4 ) ) ) ? 3 : 0 )\
: ( ( ( ( 0xDD == ((const U8*)s)[0] ) && ( 0x71 == ((const U8*)s)[1] ) ) && ( 0x66 == ((const U8*)s)[2] ) ) && ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[3]), 0xA0, 0xA6) || inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[3]), 0xB3, 0xB7) ) ) ? 4 : 0 )

/*
	PROBLEMATIC_LOCALE_FOLD: characters whose fold is problematic under locale

	\p{_Perl_Problematic_Locale_Folds}
*/
/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLD_utf8(s)                                  \
( ( ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[0]) & 0x80 ) == 0x00 ) || ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[0]) & 0xE0 ) == 0x80 ) ) ? 1\
: ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[0]), 0xC5, 0xC7) ) ?\
    2                                                                       \
: ( 0x8C == ((const U8*)s)[0] ) ?                                           \
    ( ( inRANGE_helper_(U8, ((const U8*)s)[1], 0x57, 0x58) ) ? 2 : 0 )      \
: ( 0x8D == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x4A == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0x8E == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x66 == ((const U8*)s)[1] || 0x72 == ((const U8*)s)[1] ) ? 2 : 0 )  \
: ( 0x9B == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x57 == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xAD == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x48 == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( inRANGE_helper_(U8, ((const U8*)s)[0], 0xB2, 0xB3) ) ?                  \
    ( ( 0x6A == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xBF == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x62 == ((const U8*)s)[1] ) && ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x64, 0x68) || 0x71 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xCA == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x4A == ((const U8*)s)[1] ) && ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x51, 0x52) ) ) ? 3 : 0 )\
: ( ( ( ( 0xDD == ((const U8*)s)[0] ) && ( 0x71 == ((const U8*)s)[1] ) ) && ( 0x66 == ((const U8*)s)[2] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[3], 0x41, 0x47) ) ) ? 4 : 0 )

/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLD_cp(cp)                                   \
( cp <= 0xFF || ( 0xFF < cp &&                                              \
( inRANGE_helper_(UV, cp, 0x130, 0x131) || ( 0x131 < cp &&                  \
( 0x149 == cp || ( 0x149 < cp &&                                            \
( 0x178 == cp || ( 0x178 < cp &&                                            \
( 0x17F == cp || ( 0x17F < cp &&                                            \
( 0x1F0 == cp || ( 0x1F0 < cp &&                                            \
( 0x307 == cp || ( 0x307 < cp &&                                            \
( 0x39C == cp || ( 0x39C < cp &&                                            \
( 0x3BC == cp || ( 0x3BC < cp &&                                            \
( inRANGE_helper_(UV, cp, 0x1E96, 0x1E9A) || ( 0x1E9A < cp &&               \
( 0x1E9E == cp || ( 0x1E9E < cp &&                                          \
( inRANGE_helper_(UV, cp, 0x212A, 0x212B) || inRANGE_helper_(UV, cp, 0xFB00, 0xFB06) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) )

/*
	PROBLEMATIC_LOCALE_FOLDEDS_START: The first folded character of folds which are problematic under locale

	\p{_Perl_Problematic_Locale_Foldeds_Start}
*/
/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLDEDS_START_utf8(s)                         \
( ( ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[0]) & 0x80 ) == 0x00 ) || ( ( NATIVE_UTF8_TO_I8(((const U8*)s)[0]) & 0xE0 ) == 0x80 ) ) ? 1\
: ( inRANGE_helper_(U8, NATIVE_UTF8_TO_I8(((const U8*)s)[0]), 0xC5, 0xC7) ) ?\
    2                                                                       \
: ( 0x8C == ((const U8*)s)[0] ) ?                                           \
    ( ( inRANGE_helper_(U8, ((const U8*)s)[1], 0x57, 0x58) ) ? 2 : 0 )      \
: ( 0x8D == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x4A == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0x8E == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x66 == ((const U8*)s)[1] || 0x72 == ((const U8*)s)[1] ) ? 2 : 0 )  \
: ( 0x9B == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x57 == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xAA == ((const U8*)s)[0] || inRANGE_helper_(U8, ((const U8*)s)[0], 0xB2, 0xB3) ) ?\
    ( ( 0x6A == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xBF == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x62 == ((const U8*)s)[1] ) && ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x64, 0x68) || 0x71 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xCA == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x4A == ((const U8*)s)[1] ) && ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x51, 0x52) ) ) ? 3 : 0 )\
: ( ( ( ( 0xDD == ((const U8*)s)[0] ) && ( 0x71 == ((const U8*)s)[1] ) ) && ( 0x66 == ((const U8*)s)[2] ) ) && ( inRANGE_helper_(U8, ((const U8*)s)[3], 0x41, 0x47) ) ) ? 4 : 0 )

/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLDEDS_START_cp(cp)                          \
( cp <= 0xFF || ( 0xFF < cp &&                                              \
( inRANGE_helper_(UV, cp, 0x130, 0x131) || ( 0x131 < cp &&                  \
( 0x149 == cp || ( 0x149 < cp &&                                            \
( 0x178 == cp || ( 0x178 < cp &&                                            \
( 0x17F == cp || ( 0x17F < cp &&                                            \
( 0x1F0 == cp || ( 0x1F0 < cp &&                                            \
( 0x2BC == cp || ( 0x2BC < cp &&                                            \
( 0x39C == cp || ( 0x39C < cp &&                                            \
( 0x3BC == cp || ( 0x3BC < cp &&                                            \
( inRANGE_helper_(UV, cp, 0x1E96, 0x1E9A) || ( 0x1E9A < cp &&               \
( 0x1E9E == cp || ( 0x1E9E < cp &&                                          \
( inRANGE_helper_(UV, cp, 0x212A, 0x212B) || inRANGE_helper_(UV, cp, 0xFB00, 0xFB06) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) )

/*
	PATWS: pattern white space

	\p{_Perl_PatWS}
*/
/*** GENERATED CODE ***/
#define is_PATWS_safe(s,e,is_utf8)                                          \
( ( LIKELY((e) > (s)) ) ?                                                   \
    ( ( '\t' == ((const U8*)s)[0] || inRANGE_helper_(U8, ((const U8*)s)[0], '\v', '\r') || 0x15 == ((const U8*)s)[0] || '\n' == ((const U8*)s)[0] || ' ' == ((const U8*)s)[0] ) ? 1\
    : ( ( is_utf8 && LIKELY(((e) - (s)) >= UTF8SKIP(s)) ) && ( 0xCA == ((const U8*)s)[0] ) ) ? ( ( 0x41 == ((const U8*)s)[1] ) ?\
		    ( ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x55, 0x56) ) ? 3 : 0 )\
		: ( ( 0x42 == ((const U8*)s)[1] ) && ( inRANGE_helper_(U8, ((const U8*)s)[2], 0x49, 0x4A) ) ) ? 3 : 0 ) : 0 )\
: 0 )

/*
	HANGUL_ED: Hangul syllables whose first UTF-8 byte is \xED

	0x1 - 0x0
*/
/*** GENERATED CODE ***/
#define is_HANGUL_ED_utf8_safe(s,e)                                         \
( 0 )

#endif	/* EBCDIC 037 */

#endif /* PERL_REGCHARCLASS_H_ */

/* Generated from:
 * 198105a1b3637a4bc7240628bae2f65f6d0c31df2cee4f0242c2561421ea2e75 lib/Unicode/UCD.pm
 * 39afa01e680e27d0fd10b67a9b27be13fbaa3d0efecfb5be45991de9a0d267d0 lib/unicore/ArabicShaping.txt
 * dadbaf38a0d0246e5b805bf8725cb81b7c621f93d030595635f5ba2c2f179428 lib/unicore/BidiBrackets.txt
 * a2f16fb873ab4fcdf3221cb1a8a85a134ddd6ed03603181823ff5206af3741ce lib/unicore/BidiMirroring.txt
 * c0edefaf1a19771e830a82735472716af6bf3c3975f6c2a23ffbe2580fbbcb15 lib/unicore/Blocks.txt
 * ff8d8fefbf123574205085d6714c36149eb946d717a0c585c27f0f4ef58c4183 lib/unicore/CaseFolding.txt
 * 5e6e9c8f8e76561da04cb1703a9306c63707be2ed8ff2eb12cd3a942368a6f72 lib/unicore/CompositionExclusions.txt
 * f8ecdf768bdc210f201abd271d9bc587825618a86a7046a8146cc816393f1998 lib/unicore/DAge.txt
 * 24c7fed1195c482faaefd5c1e7eb821c5ee1fb6de07ecdbaa64b56a99da22c08 lib/unicore/DCoreProperties.txt
 * 71fd6a206a2c0cdd41feb6b7f656aa31091db45e9cedc926985d718397f9e488 lib/unicore/DNormalizationProps.txt
 * ea7ce50f3444a050333448dffef1cadd9325af55cbb764b4a2280faf52170a33 lib/unicore/EastAsianWidth.txt
 * 38619c05a17e771554000fe604afee92e10eb49e0616ecf0c87af3c1eb0f4320 lib/unicore/EquivalentUnifiedIdeograph.txt
 * 5a57450afde0d082bc5026f7458649eac3b615490cc7e3d916b0367f1593c0e3 lib/unicore/HangulSyllableType.txt
 * 617228a16da13850bf8af28b6cd08f5e9b6595d2eb60404fe6eee2c85b4e4a35 lib/unicore/IdStatus.txt
 * 924ac63faa97ed73420d6ac48d08279d90968c7da0502ab701e08bfbb9683c22 lib/unicore/IdType.txt
 * 68cedc29a7e57f984d90fe2c7712f2e6d0c717e253db219607daea8997d6c480 lib/unicore/IndicPositionalCategory.txt
 * 3fc122f4cf58b0c19268d5f810263b04ab4e1e67743386ec0e0ada9c76aec5be lib/unicore/IndicSyllabicCategory.txt
 * 17bb07f5e37f995351ddcef393c04464a9e3891ed0c0bd56a03a5c5e400a6326 lib/unicore/Jamo.txt
 * e6a18fa91f8f6a6f8e534b1d3f128c21ada45bfe152eb6b1bcc5e15fd8ac92e6 lib/unicore/LineBreak.txt
 * 793f6f1e4d15fd90f05ae66460191dc4d75d1fea90136a25f30dd6a4cb950eac lib/unicore/NameAliases.txt
 * 360dac27d5abafdcd8c03a8597f47acf92e8ebf7f6ee28020c173ed8b2ed0cc5 lib/unicore/NamedSequences.txt
 * 5019ffd530751a741900c849c0e010332f142a3612234639bd200b82138a87db lib/unicore/NormTest.txt
 * 130dcddcaadaf071008bdfce1e7743e04fdfbc910886f017d9f9ac931d8c64dd lib/unicore/PropList.txt
 * 670d2bebb48649c04fabfbf033308073dcff47946324a8033237254c048b3b01 lib/unicore/PropValueAliases.txt
 * 4441f573caf952ffece1d7c892e7715bd7136dfc26f96eb6f268bf1e474715fb lib/unicore/PropertyAliases.txt
 * ec2107e58825a1586acee8e0911ce18260394ac8b87e535ca325f1ccbeb06bc6 lib/unicore/ScriptExtensions.txt
 * 9f5e50d3abaee7d6ce09480f325c706f485ae3240912527e651954d2d6b035bf lib/unicore/Scripts.txt
 * efc25faf19de21b92c1194c111c932e03d2a5eaf18194e33f1156e96de4c9588 lib/unicore/SpecialCasing.txt
 * 2e1efc1dcb59c575eedf5ccae60f95229f706ee6d031835247d843c11d96470c lib/unicore/UnicodeData.txt
 * 76a3081265e6eb673873f9c93d6f36062e82c7ed027c5c1a592accfbe48c20a5 lib/unicore/Unikemet.txt
 * dcef09c3fb24d356b042569c328ec341efc5b53447700d799f2fb4834c3cd3cd lib/unicore/VerticalOrientation.txt
 * e2d134d2c52919bace503ebb6a551c1855fe1a1faec18478c78fff254a1793ec lib/unicore/auxiliary/GCBTest.txt
 * d6b51d1d2ae5c33b451b7ed994b48f1f4dc62b2272a5831e7fd418514a6bae89 lib/unicore/auxiliary/GraphemeBreakProperty.txt
 * e69884e0dde6a8724873f885d68c52dc14518abf9ae4ca9e2283b8773db3b752 lib/unicore/auxiliary/LBTest.txt
 * 12cb47d028ded0c1cb8a28558f95479cbcd24559c46977015c82f3b50a1cc6e4 lib/unicore/auxiliary/SBTest.txt
 * 871c0c985ad95125e25b302414065a10839d068970bceb383ecec138f22a0a18 lib/unicore/auxiliary/SentenceBreakProperty.txt
 * 1de23a75f37904abc7d206239ee8d34f8fdf0fb4ab32a7174dfbabbde25419b2 lib/unicore/auxiliary/WBTest.txt
 * 72274cac1e6b919507db35655c3e175aa27274668a1ece95c28d2069f2ad9852 lib/unicore/auxiliary/WordBreakProperty.txt
 * 2cb2bb9455cda83e8481541ecf5b6dfda66a3bb89efa3fa7c5297eccf607b72b lib/unicore/emoji/emoji.txt
 * 4867b4b7f0731ed1bfcd34cc6251211ff1542541fce0734b6fbda139ee80b3a4 lib/unicore/extracted/DBidiClass.txt
 * 13dd09d35a9377e33eb388a01e6581d4bfec6b2685316078c341982fa444071a lib/unicore/extracted/DBinaryProperties.txt
 * 191463abfbd202703c6fd6776a92a23ac44ec65e0476a7f95aa91ca492cef29b lib/unicore/extracted/DCombiningClass.txt
 * f44e5ceaf40edc1fe06ea0404e8bebc7d356dcc38aac076543b6874008a06e3e lib/unicore/extracted/DDecompositionType.txt
 * 0b5523a2217cb318d20b329a05d31eec5af5686ba09d263b85bb75a28989a3a8 lib/unicore/extracted/DEastAsianWidth.txt
 * d62e5bab70ca74f099343f71224fa051cb1fdd61a1ab45c0488c44cfc0b6102e lib/unicore/extracted/DGeneralCategory.txt
 * bb67e0c00b88acfa5be633967b66b23326844a86e49c6fde7b57960d3af66cae lib/unicore/extracted/DJoinGroup.txt
 * f39ebe974825d6736aee15582250307aa532b2cfab3caf3f86bd23fddc9c5c4d lib/unicore/extracted/DJoinType.txt
 * dad3ef492d198d6f1dde4922b175f7371a27dfe62fce489f3e04807015a4c682 lib/unicore/extracted/DLineBreak.txt
 * 7c83684d3336b698381745b78a971c3e1242cb3fcac58604469086c19b6edcee lib/unicore/extracted/DNumType.txt
 * 139b976bdc288be01c80f018523da769cf2845109b5a7f0f8a432db64bfedcfa lib/unicore/extracted/DNumValues.txt
 * 03640d8ad18fc65de766f2034a927f7442960e998d3243845ca9b9fe31bfe1ab lib/unicore/mktables
 * 8c30575264b2772c7a69c5bb6069a28f0e0a7a0df735871bde2d99ee674316ac lib/unicore/version
 * 0a6b5ab33bb1026531f816efe81aea1a8ffcd34a27cbea37dd6a70a63d73c844 regen/charset_translations.pl
 * 38d9a9c62ad1d5ec57c14db96c218daf68576d2e675605d84f96829c2da3e590 regen/regcharclass.pl
 * b2f896452d2b30da3e04800f478c60c1fd0b03d6b668689b020f1e3cf1f1cdd9 regen/regcharclass_multi_char_folds.pl
 * ex: set ro ft=c: */
