/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services;

import io.opentelemetry.api.trace.Span;
import jakarta.ws.rs.core.HttpHeaders;
import java.net.URI;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.keycloak.Token;
import org.keycloak.common.ClientConnection;
import org.keycloak.http.HttpRequest;
import org.keycloak.http.HttpResponse;
import org.keycloak.locale.LocaleSelectorProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakUriInfo;
import org.keycloak.models.OrganizationModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;
import org.keycloak.theme.Theme;
import org.keycloak.tracing.TracingAttributes;
import org.keycloak.tracing.TracingProvider;
import org.keycloak.urls.UrlType;

public abstract class DefaultKeycloakContext
implements KeycloakContext {
    private RealmModel realm;
    private ClientModel client;
    private OrganizationModel organization;
    protected KeycloakSession session;
    private Map<UrlType, KeycloakUriInfo> uriInfo;
    private AuthenticationSessionModel authenticationSession;
    private UserSessionModel userSession;
    private HttpRequest request;
    private HttpResponse response;
    private ClientConnection clientConnection;
    private Token bearerToken;

    public DefaultKeycloakContext(KeycloakSession session) {
        this.session = session;
    }

    public URI getAuthServerUrl() {
        return this.getUri(UrlType.FRONTEND).getBaseUri();
    }

    public String getContextPath() {
        return this.getUri(UrlType.FRONTEND).getBaseUri().getPath();
    }

    public KeycloakUriInfo getUri(UrlType type) {
        if (this.uriInfo == null || !this.uriInfo.containsKey(type)) {
            if (this.uriInfo == null) {
                this.uriInfo = new HashMap<UrlType, KeycloakUriInfo>();
            }
            this.uriInfo.put(type, new KeycloakUriInfo(this.session, type, this.getHttpRequest().getUri()));
        }
        return this.uriInfo.get(type);
    }

    public KeycloakUriInfo getUri() {
        return this.getUri(UrlType.FRONTEND);
    }

    @Deprecated
    public HttpHeaders getRequestHeaders() {
        return this.getHttpRequest().getHttpHeaders();
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public void setRealm(RealmModel realm) {
        this.realm = realm;
        this.uriInfo = null;
        this.trace(this.realm);
    }

    public ClientModel getClient() {
        if (this.client == null) {
            this.client = Optional.ofNullable(this.authenticationSession).map(CommonClientSessionModel::getClient).orElse(null);
        }
        return this.client;
    }

    public void setClient(ClientModel client) {
        this.client = client;
        this.trace(this.client);
    }

    public OrganizationModel getOrganization() {
        return this.organization;
    }

    public void setOrganization(OrganizationModel organization) {
        this.organization = organization;
    }

    public ClientConnection getConnection() {
        if (this.clientConnection == null) {
            this.clientConnection = this.createClientConnection();
        }
        return this.clientConnection;
    }

    public Locale resolveLocale(UserModel user) {
        return ((LocaleSelectorProvider)this.session.getProvider(LocaleSelectorProvider.class)).resolveLocale(this.getRealm(), user);
    }

    public Locale resolveLocale(UserModel user, Theme.Type themeType) {
        return ((LocaleSelectorProvider)this.session.getProvider(LocaleSelectorProvider.class)).resolveLocale(this.getRealm(), user, themeType);
    }

    public AuthenticationSessionModel getAuthenticationSession() {
        return this.authenticationSession;
    }

    public void setAuthenticationSession(AuthenticationSessionModel authenticationSession) {
        this.authenticationSession = authenticationSession;
        this.trace(this.authenticationSession);
    }

    public HttpRequest getHttpRequest() {
        if (this.request == null) {
            this.request = this.createHttpRequest();
        }
        return this.request;
    }

    public HttpResponse getHttpResponse() {
        if (this.response == null) {
            this.response = this.createHttpResponse();
        }
        return this.response;
    }

    protected ClientConnection createClientConnection() {
        return null;
    }

    protected abstract HttpRequest createHttpRequest();

    protected abstract HttpResponse createHttpResponse();

    protected KeycloakSession getSession() {
        return this.session;
    }

    public void setConnection(ClientConnection clientConnection) {
        this.clientConnection = clientConnection;
    }

    public void setHttpRequest(HttpRequest httpRequest) {
        this.request = httpRequest;
    }

    public void setHttpResponse(HttpResponse httpResponse) {
        this.response = httpResponse;
    }

    public UserSessionModel getUserSession() {
        return this.userSession;
    }

    public void setUserSession(UserSessionModel userSession) {
        this.userSession = userSession;
        this.trace(this.userSession);
    }

    private Span getCurrentSpan() {
        return ((TracingProvider)this.session.getProvider(TracingProvider.class)).getCurrentSpan();
    }

    private void trace(AuthenticationSessionModel session) {
        if (session != null) {
            Span span = this.getCurrentSpan();
            if (!span.isRecording()) {
                return;
            }
            if (session.getParentSession() != null) {
                span.setAttribute(TracingAttributes.AUTH_SESSION_ID, (Object)session.getParentSession().getId());
            }
            if (session.getTabId() != null) {
                span.setAttribute(TracingAttributes.AUTH_TAB_ID, (Object)session.getTabId());
            }
        }
    }

    private void trace(RealmModel realm) {
        Span span;
        if (realm != null && (span = this.getCurrentSpan()).isRecording()) {
            span.setAttribute(TracingAttributes.REALM_NAME, (Object)realm.getName());
        }
    }

    private void trace(ClientModel client) {
        Span span;
        if (client != null && (span = this.getCurrentSpan()).isRecording()) {
            span.setAttribute(TracingAttributes.CLIENT_ID, (Object)client.getClientId());
        }
    }

    private void trace(UserSessionModel userSession) {
        Span span;
        if (userSession != null && (span = this.getCurrentSpan()).isRecording()) {
            span.setAttribute(TracingAttributes.SESSION_ID, (Object)userSession.getId());
        }
    }

    public void setBearerToken(Token token) {
        this.bearerToken = token;
    }

    public Token getBearerToken() {
        return this.bearerToken;
    }
}

