/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.broker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.keycloak.Config;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.authentication.authenticators.broker.IdpReviewProfileAuthenticator;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;

public class IdpReviewProfileAuthenticatorFactory
implements AuthenticatorFactory {
    public static final String PROVIDER_ID = "idp-review-profile";
    static IdpReviewProfileAuthenticator SINGLETON = new IdpReviewProfileAuthenticator();
    public static final String UPDATE_PROFILE_ON_FIRST_LOGIN = "update.profile.on.first.login";
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();

    public Authenticator create(KeycloakSession session) {
        return SINGLETON;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getReferenceCategory() {
        return "reviewProfile";
    }

    public boolean isConfigurable() {
        return true;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public String getDisplayType() {
        return "Review Profile";
    }

    public String getHelpText() {
        return "User reviews and updates profile data retrieved from Identity Provider in the displayed form";
    }

    public boolean isUserSetupAllowed() {
        return false;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    static {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName(UPDATE_PROFILE_ON_FIRST_LOGIN);
        property.setLabel("Update Profile on First Login");
        property.setType("List");
        List<String> updateProfileValues = Arrays.asList("on", "missing", "off");
        property.setOptions(updateProfileValues);
        property.setDefaultValue((Object)"missing");
        property.setHelpText("Define conditions under which a user has to review and update his profile after first-time login. Value 'On' means that page for reviewing profile will be displayed and user can review and update his profile. Value 'off' means that page won't be displayed. Value 'missing' means that page is displayed just when some required attribute is missing (wasn't downloaded from identity provider). Value 'missing' is the default one. WARN: In case that user clicks 'Review profile info' on link duplications page, the update page will be always displayed. You would need to disable this authenticator to never display the page.");
        configProperties.add(property);
    }
}

