/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.jdbc.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.instrumentation.jdbc.internal.dbinfo.DbInfo;
import javax.annotation.Nullable;
import javax.sql.DataSource;

enum DataSourceDbAttributesExtractor implements AttributesExtractor<DataSource, DbInfo>
{
    INSTANCE;

    private static final AttributeKey<String> DB_NAME;
    private static final AttributeKey<String> DB_SYSTEM;
    private static final AttributeKey<String> DB_USER;
    private static final AttributeKey<String> DB_CONNECTION_STRING;

    public void onStart(AttributesBuilder attributes, Context parentContext, DataSource dataSource) {
    }

    public void onEnd(AttributesBuilder attributes, Context context, DataSource dataSource, @Nullable DbInfo dbInfo, @Nullable Throwable error) {
        if (dbInfo == null) {
            return;
        }
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, DB_SYSTEM, (Object)dbInfo.getSystem());
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, DB_USER, (Object)dbInfo.getUser());
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, DB_NAME, (Object)DataSourceDbAttributesExtractor.getName(dbInfo));
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, DB_CONNECTION_STRING, (Object)dbInfo.getShortUrl());
    }

    private static String getName(DbInfo dbInfo) {
        String name = dbInfo.getName();
        return name == null ? dbInfo.getDb() : name;
    }

    static {
        DB_NAME = AttributeKey.stringKey((String)"db.name");
        DB_SYSTEM = AttributeKey.stringKey((String)"db.system");
        DB_USER = AttributeKey.stringKey((String)"db.user");
        DB_CONNECTION_STRING = AttributeKey.stringKey((String)"db.connection_string");
    }
}

