/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.context.impl;

import io.reactivex.rxjava3.core.Flowable;
import java.util.Collection;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.remoting.transport.Address;
import org.reactivestreams.Publisher;

public abstract class AbstractInvocationContext
implements InvocationContext {
    private final Address origin;

    protected AbstractInvocationContext(Address origin) {
        this.origin = origin;
    }

    @Override
    public final Address getOrigin() {
        return this.origin;
    }

    @Override
    public boolean isOriginLocal() {
        return this.origin == null;
    }

    @Override
    public boolean hasLockedKey(Object key) {
        return this.getLockedKeys().contains(key);
    }

    @Override
    public boolean isEntryRemovedInContext(Object key) {
        CacheEntry ce = this.lookupEntry(key);
        return ce != null && ce.isRemoved() && ce.isChanged();
    }

    @Override
    public InvocationContext clone() {
        try {
            return (InvocationContext)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Impossible!", e);
        }
    }

    @Override
    public <K, V> Publisher<CacheEntry<K, V>> publisher() {
        if (this.lookedUpEntriesCount() == 0) {
            return Flowable.empty();
        }
        Collection<CacheEntry> collection = this.getLookedUpEntries().values();
        return Flowable.fromIterable(collection).filter(ce -> !ce.isRemoved() && !ce.isNull());
    }
}

