/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeParser;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.TracingConfiguration;
import org.infinispan.telemetry.SpanCategory;
import org.infinispan.util.logging.Log;

public class TracingConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<TracingConfiguration> {
    private final AttributeSet attributes = TracingConfiguration.attributeDefinitionSet();

    protected TracingConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public TracingConfigurationBuilder enable() {
        this.attributes.attribute(TracingConfiguration.ENABLED).set((Object)true);
        return this;
    }

    public TracingConfigurationBuilder disable() {
        this.attributes.attribute(TracingConfiguration.ENABLED).set((Object)false);
        return this;
    }

    public TracingConfigurationBuilder enabled(boolean enabled) {
        this.attributes.attribute(TracingConfiguration.ENABLED).set((Object)enabled);
        return this;
    }

    public TracingConfigurationBuilder enableCategory(SpanCategory category) {
        Attribute attribute = this.attributes.attribute(TracingConfiguration.CATEGORIES);
        Set policies = (Set)attribute.get();
        boolean added = policies.add(category);
        if (added) {
            attribute.set((Object)policies);
        }
        return this;
    }

    public TracingConfigurationBuilder disableCategory(SpanCategory category) {
        Attribute attribute = this.attributes.attribute(TracingConfiguration.CATEGORIES);
        Set policies = (Set)attribute.get();
        boolean removed = policies.remove((Object)category);
        if (removed) {
            attribute.set((Object)policies);
        }
        return this;
    }

    public TracingConfiguration create() {
        return new TracingConfiguration(this.attributes.protect());
    }

    public Builder<?> read(TracingConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        return this;
    }

    public String toString() {
        return "TracingConfigurationBuilder{attributes=" + String.valueOf(this.attributes) + "}";
    }

    public void validate() {
        Set spanCategories = (Set)this.attributes.attribute(TracingConfiguration.CATEGORIES).get();
        if (spanCategories.contains((Object)SpanCategory.SECURITY)) {
            throw Log.CONFIG.securityCacheTracing();
        }
    }

    static enum CategoriesAttributeParser implements AttributeParser<Set<SpanCategory>>
    {
        INSTANCE;


        public Set<SpanCategory> parse(Class klass, String value) {
            LinkedHashSet spanCategories = ((Stream)Arrays.stream(value.split(",")).sequential()).map(String::trim).map(SpanCategory::fromString).collect(Collectors.toCollection(LinkedHashSet::new));
            if (spanCategories.contains((Object)SpanCategory.SECURITY)) {
                throw Log.CONFIG.securityCacheTracing();
            }
            return spanCategories;
        }
    }
}

