/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.util;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class DeploymentUtil {
    public static final String DEPLOY = "quarkus.%s.deploy";
    private static final Pattern QUARKUS_DEPLOY_PATTERN = Pattern.compile("quarkus\\.([^\\.]+)\\.deploy");

    public static List<String> getDeployers() {
        Config config = ConfigProvider.getConfig();
        return StreamSupport.stream(config.getPropertyNames().spliterator(), false).map(QUARKUS_DEPLOY_PATTERN::matcher).filter(Matcher::matches).map(m -> m.group(1)).collect(Collectors.toList());
    }

    public static Predicate<String> isDeployExplicitlyEnabled() {
        return deployer -> ConfigProvider.getConfig().getOptionalValue(String.format(DEPLOY, deployer), Boolean.class).orElse(false);
    }

    public static Optional<String> getEnabledDeployer() {
        return DeploymentUtil.getDeployers().stream().filter(DeploymentUtil.isDeployExplicitlyEnabled()).findFirst();
    }

    public static boolean isDeploymentEnabled(String ... deployers) {
        if (deployers == null) {
            return false;
        }
        return DeploymentUtil.getDeployers().stream().filter(DeploymentUtil.isDeployExplicitlyEnabled()).anyMatch(d -> Arrays.asList(deployers).contains(d));
    }

    public static boolean isDeploymentEnabled() {
        return DeploymentUtil.getEnabledDeployer().isPresent();
    }
}

