/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import jakarta.persistence.TemporalType;
import java.lang.reflect.Type;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.OffsetTime;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.internal.JdbcLiteralFormatterTemporal;
import org.hibernate.type.spi.TypeConfiguration;

public class TimeWithTimeZoneJdbcType
implements JdbcType {
    public static final TimeWithTimeZoneJdbcType INSTANCE = new TimeWithTimeZoneJdbcType();

    @Override
    public int getJdbcTypeCode() {
        return 2013;
    }

    @Override
    public String getFriendlyName() {
        return "TIME_WITH_TIMEZONE";
    }

    public String toString() {
        return "TimeWithTimezoneDescriptor";
    }

    @Override
    public <T> JavaType<T> getJdbcRecommendedJavaTypeMapping(Integer length, Integer scale, TypeConfiguration typeConfiguration) {
        return typeConfiguration.getJavaTypeRegistry().getDescriptor((Type)((Object)OffsetTime.class));
    }

    @Override
    public Class<?> getPreferredJavaTypeClass(WrapperOptions options) {
        return OffsetTime.class;
    }

    @Override
    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaType) {
        return new JdbcLiteralFormatterTemporal<T>(javaType, TemporalType.TIME);
    }

    @Override
    public <X> ValueBinder<X> getBinder(final JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                OffsetTime offsetTime = javaType.unwrap(value, OffsetTime.class, options);
                st.setObject(index, (Object)offsetTime, 2013);
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                OffsetTime offsetTime = javaType.unwrap(value, OffsetTime.class, options);
                st.setObject(name, (Object)offsetTime, 2013);
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(final JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return javaType.wrap(rs.getObject(paramIndex, OffsetTime.class), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return javaType.wrap(statement.getObject(index, OffsetTime.class), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return javaType.wrap(statement.getObject(name, OffsetTime.class), options);
            }
        };
    }
}

