/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment.devui;

import io.quarkus.arc.deployment.CompletedApplicationClassPredicateBuildItem;
import io.quarkus.arc.deployment.devui.DevBeanKind;
import io.quarkus.arc.deployment.devui.Name;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InterceptorInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class DevBeanInfo
implements Comparable<DevBeanInfo> {
    private final String id;
    private final DevBeanKind kind;
    private final boolean isApplicationBean;
    private final Name providerType;
    private final String memberName;
    private final Set<Name> types;
    private final Set<Name> qualifiers;
    private final Name scope;
    private final Name declaringClass;
    private final List<String> interceptors;
    private final boolean isGenerated;

    public static DevBeanInfo from(BeanInfo bean, CompletedApplicationClassPredicateBuildItem predicate) {
        List<String> interceptors;
        HashSet<Name> qualifiers = new HashSet<Name>();
        for (Object qualifier : bean.getQualifiers()) {
            qualifiers.add(Name.from((AnnotationInstance)qualifier));
        }
        HashSet<Name> types = new HashSet<Name>();
        for (Type beanType : bean.getTypes()) {
            types.add(Name.from(beanType));
        }
        Name scope = Name.from(bean.getScope().getDotName());
        Name providerType = Name.from(bean.getProviderType());
        List boundInterceptors = bean.getBoundInterceptors();
        if (boundInterceptors.isEmpty()) {
            interceptors = List.of();
        } else {
            interceptors = new ArrayList();
            for (InterceptorInfo interceptor : boundInterceptors) {
                interceptors.add(interceptor.getIdentifier());
            }
        }
        if (bean.getTarget().isPresent()) {
            Name declaringClass;
            boolean isApplicationBean;
            DevBeanKind kind;
            String memberName;
            AnnotationTarget target = (AnnotationTarget)bean.getTarget().get();
            boolean isGenerated = false;
            if (target.kind() == AnnotationTarget.Kind.METHOD) {
                MethodInfo method = target.asMethod();
                memberName = method.name();
                kind = DevBeanKind.METHOD;
                isApplicationBean = predicate.test(bean.getDeclaringBean().getBeanClass());
                declaringClass = Name.from(bean.getDeclaringBean().getBeanClass());
                isGenerated = bean.getDeclaringBean().getImplClazz().isSynthetic();
            } else if (target.kind() == AnnotationTarget.Kind.FIELD) {
                FieldInfo field = target.asField();
                memberName = field.name();
                kind = DevBeanKind.FIELD;
                isApplicationBean = predicate.test(bean.getDeclaringBean().getBeanClass());
                declaringClass = Name.from(bean.getDeclaringBean().getBeanClass());
                isGenerated = bean.getDeclaringBean().getImplClazz().isSynthetic();
            } else if (target.kind() == AnnotationTarget.Kind.CLASS) {
                ClassInfo clazz = target.asClass();
                kind = DevBeanKind.CLASS;
                memberName = null;
                isApplicationBean = predicate.test(clazz.name());
                isGenerated = clazz.isSynthetic();
                declaringClass = null;
            } else {
                throw new IllegalArgumentException("Invalid annotation target: " + String.valueOf(target));
            }
            return new DevBeanInfo(bean.getIdentifier(), kind, isApplicationBean, providerType, memberName, types, qualifiers, scope, declaringClass, interceptors, isGenerated);
        }
        return new DevBeanInfo(bean.getIdentifier(), DevBeanKind.SYNTHETIC, false, providerType, null, types, qualifiers, scope, null, interceptors, bean.getImplClazz().isSynthetic());
    }

    public DevBeanInfo(String id, DevBeanKind kind, boolean isApplicationBean, Name providerType, String memberName, Set<Name> types, Set<Name> qualifiers, Name scope, Name declaringClass, List<String> boundInterceptors, boolean isGenerated) {
        this.id = id;
        this.kind = kind;
        this.isApplicationBean = isApplicationBean;
        this.providerType = providerType;
        this.memberName = memberName;
        this.types = types;
        this.qualifiers = qualifiers;
        this.scope = scope;
        this.declaringClass = declaringClass;
        this.interceptors = boundInterceptors;
        this.isGenerated = isGenerated;
    }

    public String getId() {
        return this.id;
    }

    public DevBeanKind getKind() {
        return this.kind;
    }

    public Name getScope() {
        return this.scope;
    }

    public Set<Name> getQualifiers() {
        return this.qualifiers;
    }

    public Set<Name> getNonDefaultQualifiers() {
        HashSet<Name> nonDefault = new HashSet<Name>();
        String atDefault = DotNames.DEFAULT.toString();
        String atAny = DotNames.ANY.toString();
        for (Name qualifier : this.qualifiers) {
            if (qualifier.toString().endsWith(atDefault) || qualifier.toString().endsWith(atAny)) continue;
            nonDefault.add(qualifier);
        }
        return nonDefault;
    }

    public Set<Name> getTypes() {
        return this.types;
    }

    public Name getProviderType() {
        return this.providerType;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public boolean isApplicationBean() {
        return this.isApplicationBean;
    }

    public Name getDeclaringClass() {
        return this.declaringClass;
    }

    public List<String> getInterceptors() {
        return this.interceptors;
    }

    public boolean isGenerated() {
        return this.isGenerated;
    }

    public String getDescription() {
        return this.description(false);
    }

    public String getSimpleDescription() {
        return this.description(true);
    }

    private String description(boolean simple) {
        String typeInfo = this.typeInfo(simple);
        switch (this.kind) {
            case FIELD: {
                return typeInfo + "#" + this.memberName;
            }
            case METHOD: {
                return typeInfo + "#" + this.memberName + "()";
            }
            case SYNTHETIC: {
                return "Synthetic: " + typeInfo;
            }
        }
        return typeInfo;
    }

    public String typeInfo(boolean simple) {
        String type = switch (this.kind) {
            case DevBeanKind.FIELD, DevBeanKind.METHOD -> this.declaringClass.toString();
            default -> this.providerType.toString();
        };
        if (simple) {
            int idx = type.lastIndexOf(".");
            return idx != -1 && type.length() > 1 ? type.substring(idx + 1) : type;
        }
        return type;
    }

    @Override
    public int compareTo(DevBeanInfo o) {
        int result = Boolean.compare(o.isApplicationBean, this.isApplicationBean);
        if (result != 0) {
            return result;
        }
        result = Boolean.compare(this.isGenerated, o.isGenerated);
        if (result != 0) {
            return result;
        }
        return this.providerType.compareTo(o.providerType);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DevBeanInfo other = (DevBeanInfo)obj;
        return Objects.equals(this.id, other.id);
    }
}

