/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli.command;

import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.keycloak.config.OptionCategory;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.cli.command.AbstractCommand;
import org.keycloak.quarkus.runtime.cli.command.DryRunMixin;
import org.keycloak.quarkus.runtime.configuration.mappers.HostnameV2PropertyMappers;
import org.keycloak.quarkus.runtime.configuration.mappers.HttpPropertyMappers;
import picocli.CommandLine;

public abstract class AbstractStartCommand
extends AbstractCommand
implements Runnable {
    public static final String OPTIMIZED_BUILD_OPTION_LONG = "--optimized";
    @CommandLine.Mixin
    DryRunMixin dryRunMixin = new DryRunMixin();

    @Override
    public void run() {
        this.doBeforeRun();
        this.validateConfig();
        if (Environment.isDevProfile()) {
            this.picocli.getOutWriter().println(CommandLine.Help.Ansi.AUTO.string("@|bold,red Running the server in development mode. DO NOT use this configuration in production.|@"));
        }
        if (!Boolean.TRUE.equals(this.dryRunMixin.dryRun)) {
            this.picocli.start();
        }
    }

    protected void doBeforeRun() {
    }

    @Override
    protected void validateConfig() {
        super.validateConfig();
        HttpPropertyMappers.validateConfig();
        HostnameV2PropertyMappers.validateConfig();
    }

    @Override
    public List<OptionCategory> getOptionCategories() {
        EnumSet<OptionCategory> excludedCategories = this.excludedCategories();
        return super.getOptionCategories().stream().filter(optionCategory -> !excludedCategories.contains(optionCategory)).collect(Collectors.toList());
    }

    protected EnumSet<OptionCategory> excludedCategories() {
        return EnumSet.of(OptionCategory.IMPORT, OptionCategory.EXPORT);
    }
}

