/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.common.process;

import java.time.Duration;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.api.common.Flags;

public interface CacheProcessorOptions
extends CacheOptions {
    public static final CacheProcessorOptions DEFAULT = new Impl();

    public static Builder processorOptions() {
        return new Builder();
    }

    public Object[] arguments();

    public static class Builder
    extends CacheOptions.Builder {
        private Object[] arguments;

        public Builder arguments(Object ... arguments) {
            this.arguments = arguments;
            return this;
        }

        @Override
        public Builder timeout(Duration timeout) {
            super.timeout(timeout);
            return this;
        }

        @Override
        public Builder flags(Flags<?, ?> flags) {
            super.flags(flags);
            return this;
        }

        @Override
        public CacheProcessorOptions build() {
            return new Impl(this.timeout, this.flags, this.arguments);
        }
    }

    public static class Impl
    extends CacheOptions.Impl
    implements CacheProcessorOptions {
        final Object[] arguments;

        public Impl() {
            this(null, null, null);
        }

        private Impl(Duration timeout, Flags<?, ?> flags, Object[] arguments) {
            super(timeout, flags);
            this.arguments = arguments;
        }

        @Override
        public Object[] arguments() {
            return this.arguments;
        }
    }
}

