/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.saml.metadata;

import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import org.keycloak.dom.saml.v2.metadata.AuthnAuthorityDescriptorType;
import org.keycloak.dom.saml.v2.metadata.EndpointType;
import org.keycloak.dom.saml.v2.metadata.RoleDescriptorType;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.saml.metadata.SAMLAssertinIDRequestServiceParser;
import org.keycloak.saml.processing.core.parsers.saml.metadata.SAMLAuthnQueryServiceParser;
import org.keycloak.saml.processing.core.parsers.saml.metadata.SAMLMetadataQNames;
import org.keycloak.saml.processing.core.parsers.saml.metadata.SAMLRoleDecriptorTypeParser;

public class SAMLAuthnAuthorityDescriptorParser
extends SAMLRoleDecriptorTypeParser<AuthnAuthorityDescriptorType> {
    private static final SAMLAuthnAuthorityDescriptorParser INSTANCE = new SAMLAuthnAuthorityDescriptorParser();

    public SAMLAuthnAuthorityDescriptorParser() {
        super(SAMLMetadataQNames.AUTHN_AUTHORITY_DESCRIPTOR);
    }

    public static SAMLAuthnAuthorityDescriptorParser getInstance() {
        return INSTANCE;
    }

    @Override
    protected AuthnAuthorityDescriptorType instantiateElement(XMLEventReader xmlEventReader, StartElement element) throws ParsingException {
        List<String> protocolEnum = StaxParserUtil.getRequiredStringListAttributeValue(element, SAMLMetadataQNames.ATTR_PROTOCOL_SUPPORT_ENUMERATION);
        AuthnAuthorityDescriptorType descriptor = new AuthnAuthorityDescriptorType(protocolEnum);
        this.parseOptionalArguments(element, (RoleDescriptorType)descriptor);
        return descriptor;
    }

    @Override
    protected void processSubElement(XMLEventReader xmlEventReader, AuthnAuthorityDescriptorType target, SAMLMetadataQNames element, StartElement elementDetail) throws ParsingException {
        switch (element) {
            case AUTHN_QUERY_SERVICE: {
                target.addAuthnQueryService((EndpointType)SAMLAuthnQueryServiceParser.getInstance().parse(xmlEventReader));
                break;
            }
            case ASSERTION_ID_REQUEST_SERVICE: {
                target.addAssertionIDRequestService((EndpointType)SAMLAssertinIDRequestServiceParser.getInstance().parse(xmlEventReader));
                break;
            }
            case NAMEID_FORMAT: {
                StaxParserUtil.advance(xmlEventReader);
                target.addNameIDFormat(StaxParserUtil.getElementText(xmlEventReader));
                break;
            }
            default: {
                super.processSubElement(xmlEventReader, target, element, elementDetail);
            }
        }
    }
}

