/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.pool;

import io.agroal.pool.MetricsRepository;
import io.agroal.pool.Pool;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.atomic.LongAdder;

public final class DefaultMetricsRepository
implements MetricsRepository {
    private static final String FORMAT_1 = "Connections: {0} created | {1} invalid | {2} reap | {3} flush | {4} destroyed";
    private static final String FORMAT_2 = "Pool: {0} available | {1} active | {2} max | {3} acquired | {4} returned";
    private static final String FORMAT_3 = "Created duration: {0,number,000.000}ms average | {1}ms max | {2}ms total";
    private static final String FORMAT_4 = "Acquire duration: {0,number,000.000}ms average | {1}ms max | {2}ms total";
    private static final String FORMAT_5 = "Threads awaiting: {0}";
    private final Pool connectionPool;
    private final LongAdder creationCount = new LongAdder();
    private final LongAdder creationTotalTime = new LongAdder();
    private final LongAdder acquireCount = new LongAdder();
    private final LongAdder returnCount = new LongAdder();
    private final LongAdder acquireTotalTime = new LongAdder();
    private final LongAdder leakDetectionCount = new LongAdder();
    private final LongAdder invalidCount = new LongAdder();
    private final LongAdder flushCount = new LongAdder();
    private final LongAdder reapCount = new LongAdder();
    private final LongAdder destroyCount = new LongAdder();
    private final LongAccumulator maxCreatedDuration = new LongAccumulator(Long::max, 0L);
    private final LongAccumulator maxAcquireDuration = new LongAccumulator(Long::max, 0L);

    public DefaultMetricsRepository(Pool pool) {
        this.connectionPool = pool;
    }

    @Override
    public long beforeConnectionCreation() {
        return System.nanoTime();
    }

    @Override
    public void afterConnectionCreation(long timestamp) {
        long duration = System.nanoTime() - timestamp;
        this.creationCount.increment();
        this.creationTotalTime.add(duration);
        this.maxCreatedDuration.accumulate(duration);
    }

    @Override
    public long beforeConnectionAcquire() {
        return System.nanoTime();
    }

    @Override
    public void afterConnectionAcquire(long timestamp) {
        long duration = System.nanoTime() - timestamp;
        this.acquireCount.increment();
        this.acquireTotalTime.add(duration);
        this.maxAcquireDuration.accumulate(duration);
    }

    @Override
    public void afterConnectionReturn() {
        this.returnCount.increment();
    }

    @Override
    public void afterLeakDetection() {
        this.leakDetectionCount.increment();
    }

    @Override
    public void afterConnectionInvalid() {
        this.invalidCount.increment();
    }

    @Override
    public void afterConnectionFlush() {
        this.flushCount.increment();
    }

    @Override
    public void afterConnectionReap() {
        this.reapCount.increment();
    }

    @Override
    public void afterConnectionDestroy() {
        this.destroyCount.increment();
    }

    public long creationCount() {
        return this.creationCount.longValue();
    }

    public Duration creationTimeAverage() {
        if (this.creationCount.longValue() == 0L) {
            return Duration.ZERO;
        }
        return Duration.ofNanos(this.creationTotalTime.longValue() / this.creationCount.longValue());
    }

    public Duration creationTimeMax() {
        return Duration.ofNanos(this.maxCreatedDuration.get());
    }

    public Duration creationTimeTotal() {
        return Duration.ofNanos(this.creationTotalTime.longValue());
    }

    public long acquireCount() {
        return this.acquireCount.longValue();
    }

    public long leakDetectionCount() {
        return this.leakDetectionCount.longValue();
    }

    public long invalidCount() {
        return this.invalidCount.longValue();
    }

    public long flushCount() {
        return this.flushCount.longValue();
    }

    public long reapCount() {
        return this.reapCount.longValue();
    }

    public long destroyCount() {
        return this.destroyCount.longValue();
    }

    public long activeCount() {
        return this.connectionPool.activeCount();
    }

    public long maxUsedCount() {
        return this.connectionPool.maxUsedCount();
    }

    public long availableCount() {
        return this.connectionPool.availableCount();
    }

    public Duration blockingTimeAverage() {
        if (this.acquireCount.longValue() == 0L) {
            return Duration.ZERO;
        }
        return Duration.ofNanos(this.acquireTotalTime.longValue() / this.acquireCount.longValue());
    }

    public Duration blockingTimeMax() {
        return Duration.ofNanos(this.maxAcquireDuration.get());
    }

    public Duration blockingTimeTotal() {
        return Duration.ofNanos(this.acquireTotalTime.longValue());
    }

    public long awaitingCount() {
        return this.connectionPool.awaitingCount();
    }

    public void reset() {
        this.creationCount.reset();
        this.creationTotalTime.reset();
        this.acquireCount.reset();
        this.acquireTotalTime.reset();
        this.leakDetectionCount.reset();
        this.invalidCount.reset();
        this.maxCreatedDuration.reset();
        this.maxAcquireDuration.reset();
        this.connectionPool.resetMaxUsedCount();
    }

    public String toString() {
        double avgCreationMs = (double)this.creationTimeAverage().toNanos() / (double)TimeUnit.MILLISECONDS.toNanos(1L);
        double avgBlockingMs = (double)this.blockingTimeAverage().toNanos() / (double)TimeUnit.MILLISECONDS.toNanos(1L);
        String nl = System.lineSeparator();
        StringBuffer buffer = new StringBuffer(500);
        buffer.append(nl).append("===").append(nl);
        new MessageFormat(FORMAT_1, Locale.ROOT).format(new Object[]{this.creationCount, this.invalidCount, this.reapCount, this.flushCount, this.destroyCount}, buffer, (FieldPosition)null).append(nl);
        new MessageFormat(FORMAT_2, Locale.ROOT).format(new Object[]{this.availableCount(), this.activeCount(), this.maxUsedCount(), this.acquireCount, this.returnCount}, buffer, (FieldPosition)null).append(nl);
        new MessageFormat(FORMAT_3, Locale.ROOT).format(new Object[]{avgCreationMs, this.creationTimeMax().toMillis(), this.creationTimeTotal().toMillis()}, buffer, (FieldPosition)null).append(nl);
        new MessageFormat(FORMAT_4, Locale.ROOT).format(new Object[]{avgBlockingMs, this.blockingTimeMax().toMillis(), this.blockingTimeTotal().toMillis()}, buffer, (FieldPosition)null).append(nl);
        new MessageFormat(FORMAT_5, Locale.ROOT).format(new Object[]{this.awaitingCount()}, buffer, (FieldPosition)null).append(nl);
        return buffer.append("===").toString();
    }
}

