/*	$OpenBSD: fchown.c,v 1.1 2018/07/22 06:37:46 anton Exp $	*/
/*
 * Copyright (c) 2018 Anton Lindqvist <anton@openbsd.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * Regression test for NULL-deref inside sys_fchown().
 */

#include <err.h>
#include <fcntl.h>
#include <unistd.h>

int
main(void)
{
	const char *path = "/dev/bpf";
	int fd;

	fd = open(path, O_WRONLY);
	if (fd == -1)
		err(1, "open: %s", path);
	if (fchown(fd, 0, -1) == -1)
		err(1, "fchown");
	close(fd);

	return 0;
}
