/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.plugin.common.control.icons;

import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0012\u001a\u00020\u0005H\u0016J\b\u0010\u0013\u001a\u00020\u0005H\u0016J*\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005H\u0016R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/intellij/cwm/plugin/common/control/icons/CircleIcon;", "Ljavax/swing/Icon;", "color", "Ljava/awt/Color;", "unscaledDiameter", "", "unscaledInset", "<init>", "(Ljava/awt/Color;II)V", "getColor", "()Ljava/awt/Color;", "setColor", "(Ljava/awt/Color;)V", "inset", "getInset", "()I", "diameter", "getDiameter", "getIconHeight", "getIconWidth", "paintIcon", "", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "y", "intellij.cwm.plugin.common"})
public final class CircleIcon
implements Icon {
    @Nullable
    private Color color;
    private final int unscaledDiameter;
    private final int unscaledInset;

    public CircleIcon(@Nullable Color color, int unscaledDiameter, int unscaledInset) {
        this.color = color;
        this.unscaledDiameter = unscaledDiameter;
        this.unscaledInset = unscaledInset;
    }

    @Nullable
    public final Color getColor() {
        return this.color;
    }

    public final void setColor(@Nullable Color color) {
        this.color = color;
    }

    private final int getInset() {
        return JBUI.scale((int)this.unscaledInset);
    }

    private final int getDiameter() {
        return JBUI.scale((int)this.unscaledDiameter);
    }

    @Override
    public int getIconHeight() {
        return this.getDiameter() + this.getInset() * 2;
    }

    @Override
    public int getIconWidth() {
        return this.getIconHeight();
    }

    @Override
    public void paintIcon(@Nullable Component c, @NotNull Graphics g, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int x1 = x + this.getInset();
        int y1 = y + this.getInset();
        float cx = x1;
        float cy = y1;
        float cd = this.getDiameter();
        Ellipse2D.Float circle = new Ellipse2D.Float(cx, cy, cd, cd);
        Color color = this.color;
        if (color == null) {
            color = Color.GRAY;
        }
        g2d.setColor(color);
        g2d.fill(circle);
        g2d.dispose();
    }
}

