/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.zxcvbn.matchers;

import com.nulabinc.zxcvbn.Context;
import com.nulabinc.zxcvbn.WipeableString;
import com.nulabinc.zxcvbn.matchers.BaseMatcher;
import com.nulabinc.zxcvbn.matchers.DictionaryMatcher;
import com.nulabinc.zxcvbn.matchers.L33tSubDict;
import com.nulabinc.zxcvbn.matchers.Match;
import com.nulabinc.zxcvbn.matchers.MatchFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class L33tMatcher
extends BaseMatcher {
    private final Map<String, Map<String, Integer>> rankedDictionaries;
    private static final Map<Character, List<Character>> L33T_TABLE;

    public L33tMatcher(Context context, Map<String, Map<String, Integer>> rankedDictionaries) {
        super(context);
        this.rankedDictionaries = rankedDictionaries;
    }

    public Map<Character, List<Character>> relevantL33tSubTable(CharSequence password) {
        return this.relevantL33tSubTable(password, L33T_TABLE);
    }

    public Map<Character, List<Character>> relevantL33tSubTable(CharSequence password, Map<Character, List<Character>> table) {
        HashSet<Character> passwordChars = new HashSet<Character>();
        for (int n = 0; n < password.length(); ++n) {
            passwordChars.add(Character.valueOf(password.charAt(n)));
        }
        HashMap<Character, List<Character>> subTable = new HashMap<Character, List<Character>>();
        for (Map.Entry<Character, List<Character>> l33tRowRef : table.entrySet()) {
            Character letter = l33tRowRef.getKey();
            List<Character> subs = l33tRowRef.getValue();
            ArrayList<Character> relevantSubs = new ArrayList<Character>();
            for (Character sub : subs) {
                if (!passwordChars.contains(sub)) continue;
                relevantSubs.add(sub);
            }
            if (relevantSubs.isEmpty()) continue;
            subTable.put(letter, relevantSubs);
        }
        return subTable;
    }

    @Override
    public List<Match> execute(CharSequence password) {
        ArrayList<Match> matches = new ArrayList<Match>();
        Map<Character, List<Character>> subTable = this.relevantL33tSubTable(password);
        L33tSubDict l33tSubs = new L33tSubDict(subTable);
        DictionaryMatcher dictionaryMatcher = new DictionaryMatcher(this.getContext(), this.rankedDictionaries);
        for (Map<Character, Character> sub : l33tSubs) {
            if (sub.isEmpty()) break;
            CharSequence subbedPassword = this.decodeL33tSpeak(password, sub);
            for (Match match : dictionaryMatcher.execute(subbedPassword)) {
                WipeableString token = WipeableString.copy(password, match.i, match.j + 1);
                WipeableString lower = WipeableString.lowerCase(token);
                if (lower.equals(match.matchedWord)) {
                    token.wipe();
                    lower.wipe();
                    continue;
                }
                Map<Character, Character> matchSub = this.extractMatchSub(token, sub);
                String subDisplay = this.generateSubDisplay(matchSub);
                matches.add(MatchFactory.createDictionaryL33tMatch(match.i, match.j, token, match.matchedWord, match.rank, match.dictionaryName, match.reversed, matchSub, subDisplay));
                lower.wipe();
            }
        }
        return this.filterMatches(matches);
    }

    private Map<Character, Character> extractMatchSub(WipeableString token, Map<Character, Character> sub) {
        HashMap<Character, Character> matchSub = new HashMap<Character, Character>();
        for (Map.Entry<Character, Character> subRef : sub.entrySet()) {
            Character subbedChr = subRef.getKey();
            Character chr = subRef.getValue();
            if (token.indexOf(subbedChr.charValue()) == -1) continue;
            matchSub.put(subbedChr, chr);
        }
        return matchSub;
    }

    private String generateSubDisplay(Map<Character, Character> matchSub) {
        ArrayList<String> subDisplays = new ArrayList<String>();
        for (Map.Entry<Character, Character> matchSubRef : matchSub.entrySet()) {
            Character k = matchSubRef.getKey();
            Character v = matchSubRef.getValue();
            subDisplays.add(String.format("%s -> %s", k, v));
        }
        return Arrays.toString(subDisplays.toArray(new String[0]));
    }

    private List<Match> filterMatches(List<Match> matches) {
        ArrayList<Match> filteredMatches = new ArrayList<Match>();
        for (Match match : matches) {
            if (match.tokenLength() <= 1) continue;
            filteredMatches.add(match);
        }
        return this.sorted(filteredMatches);
    }

    private CharSequence decodeL33tSpeak(CharSequence password, Map<Character, Character> l33tToRegularMapping) {
        StringBuilder sb = new StringBuilder(password.length());
        for (int charIndex = 0; charIndex < password.length(); ++charIndex) {
            char curChar = password.charAt(charIndex);
            Character replacement = l33tToRegularMapping.get(Character.valueOf(curChar));
            sb.append(replacement != null ? replacement.charValue() : curChar);
        }
        WipeableString result = new WipeableString(sb);
        WipeableString.wipeIfPossible(sb);
        return result;
    }

    static {
        HashMap<Character, List<Character>> table = new HashMap<Character, List<Character>>();
        table.put(Character.valueOf('a'), Arrays.asList(Character.valueOf('4'), Character.valueOf('@')));
        table.put(Character.valueOf('b'), Collections.singletonList(Character.valueOf('8')));
        table.put(Character.valueOf('c'), Arrays.asList(Character.valueOf('('), Character.valueOf('{'), Character.valueOf('['), Character.valueOf('<')));
        table.put(Character.valueOf('e'), Collections.singletonList(Character.valueOf('3')));
        table.put(Character.valueOf('g'), Arrays.asList(Character.valueOf('6'), Character.valueOf('9')));
        table.put(Character.valueOf('i'), Arrays.asList(Character.valueOf('1'), Character.valueOf('!'), Character.valueOf('|')));
        table.put(Character.valueOf('l'), Arrays.asList(Character.valueOf('1'), Character.valueOf('|'), Character.valueOf('7')));
        table.put(Character.valueOf('o'), Collections.singletonList(Character.valueOf('0')));
        table.put(Character.valueOf('s'), Arrays.asList(Character.valueOf('$'), Character.valueOf('5')));
        table.put(Character.valueOf('t'), Arrays.asList(Character.valueOf('+'), Character.valueOf('7')));
        table.put(Character.valueOf('x'), Collections.singletonList(Character.valueOf('%')));
        table.put(Character.valueOf('z'), Collections.singletonList(Character.valueOf('2')));
        L33T_TABLE = Collections.unmodifiableMap(table);
    }
}

