/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.rest;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.searchrelevance.model.QueryWithReference;
import org.opensearch.searchrelevance.settings.SearchRelevanceSettingsAccessor;
import org.opensearch.searchrelevance.transport.queryset.PutQuerySetAction;
import org.opensearch.searchrelevance.transport.queryset.PutQuerySetRequest;
import org.opensearch.searchrelevance.utils.TextValidationUtil;
import org.opensearch.transport.client.node.NodeClient;

public class RestPutQuerySetAction
extends BaseRestHandler {
    private static final Logger LOGGER = LogManager.getLogger(RestPutQuerySetAction.class);
    private static final String PUT_QUERYSET_ACTION = "put_queryset_action";
    private SearchRelevanceSettingsAccessor settingsAccessor;

    public String getName() {
        return PUT_QUERYSET_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.PUT, "/_plugins/_search_relevance/query_sets"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        PutQuerySetRequest putRequest;
        List<QueryWithReference> querySetQueries;
        if (!this.settingsAccessor.isWorkbenchEnabled()) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.FORBIDDEN, "Search Relevance Workbench is disabled"));
        }
        XContentParser parser = request.contentParser();
        Map source = parser.map();
        String name = (String)source.get("name");
        BaseRestHandler.RestChannelConsumer errorResponse = this.validateField(name, "name");
        if (errorResponse != null) {
            return errorResponse;
        }
        String description = (String)source.get("description");
        if (description != null && (errorResponse = this.validateField(description, "description")) != null) {
            return errorResponse;
        }
        String sampling = source.getOrDefault("sampling", "manual");
        if (sampling.equals("manual")) {
            List rawQueries = (List)source.get("querySetQueries");
            if (rawQueries.size() > this.settingsAccessor.getMaxQuerySetAllowed()) {
                return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.FORBIDDEN, "Query Set Limit Exceeded."));
            }
            try {
                querySetQueries = rawQueries.stream().map(obj -> {
                    TextValidationUtil.ValidationResult referenceAnswerValidation;
                    Map queryMap = (Map)obj;
                    String queryText = (String)queryMap.get("queryText");
                    String referenceAnswer = queryMap.getOrDefault("referenceAnswer", "");
                    TextValidationUtil.ValidationResult queryTextValidation = TextValidationUtil.validateText(queryText);
                    if (!queryTextValidation.isValid()) {
                        throw new IllegalArgumentException("Invalid queryText: " + queryTextValidation.getErrorMessage());
                    }
                    if (!referenceAnswer.isEmpty() && !(referenceAnswerValidation = TextValidationUtil.validateText(referenceAnswer)).isValid()) {
                        throw new IllegalArgumentException("Invalid referenceAnswer: " + referenceAnswerValidation.getErrorMessage());
                    }
                    return new QueryWithReference(queryText, referenceAnswer);
                }).collect(Collectors.toList());
            }
            catch (IllegalArgumentException e) {
                return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, e.getMessage()));
            }
        } else {
            querySetQueries = Collections.emptyList();
        }
        try {
            putRequest = new PutQuerySetRequest(name, description, sampling, querySetQueries);
        }
        catch (IllegalArgumentException e) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, e.getMessage()));
        }
        return channel -> client.execute((ActionType)PutQuerySetAction.INSTANCE, (ActionRequest)putRequest, (ActionListener)new ActionListener<IndexResponse>(){

            public void onResponse(IndexResponse response) {
                try {
                    XContentBuilder builder = channel.newBuilder();
                    builder.startObject();
                    builder.field("query_set_id", response.getId());
                    builder.field("query_set_result", (Object)response.getResult());
                    builder.endObject();
                    channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, builder));
                }
                catch (IOException e) {
                    this.onFailure(e);
                }
            }

            public void onFailure(Exception e) {
                try {
                    channel.sendResponse((RestResponse)new BytesRestResponse(channel, ExceptionsHelper.status((Throwable)e), e));
                }
                catch (IOException ex) {
                    LOGGER.error("Failed to send error response", (Throwable)ex);
                }
            }
        });
    }

    private BaseRestHandler.RestChannelConsumer validateField(String fieldValue, String fieldName) {
        TextValidationUtil.ValidationResult validation = "name".equals(fieldName) ? TextValidationUtil.validateName(fieldValue) : ("description".equals(fieldName) ? TextValidationUtil.validateDescription(fieldValue) : TextValidationUtil.validateText(fieldValue));
        if (!validation.isValid()) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, "Invalid " + fieldName + ": " + validation.getErrorMessage()));
        }
        return null;
    }

    @Generated
    public RestPutQuerySetAction(SearchRelevanceSettingsAccessor settingsAccessor) {
        this.settingsAccessor = settingsAccessor;
    }
}

