/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.tasks;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ResourceStats;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.tasks.Status;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

public abstract class TaskInfoBase
implements PlainJsonSerializable {
    @Nonnull
    private final String action;
    private final boolean cancellable;
    @Nullable
    private final Long cancellationTimeMillis;
    @Nullable
    private final Boolean cancelled;
    @Nullable
    private final String description;
    @Nonnull
    private final Map<String, String> headers;
    private final long id;
    @Nonnull
    private final String node;
    @Nullable
    private final String parentTaskId;
    @Nullable
    private final ResourceStats resourceStats;
    @Nullable
    private final Time runningTime;
    private final long runningTimeInNanos;
    private final long startTimeInMillis;
    @Nullable
    private final Status status;
    @Nonnull
    private final String type;

    protected TaskInfoBase(AbstractBuilder<?> builder) {
        this.action = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).action, this, "action");
        this.cancellable = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).cancellable, this, "cancellable");
        this.cancellationTimeMillis = ((AbstractBuilder)builder).cancellationTimeMillis;
        this.cancelled = ((AbstractBuilder)builder).cancelled;
        this.description = ((AbstractBuilder)builder).description;
        this.headers = ApiTypeHelper.unmodifiableRequired(((AbstractBuilder)builder).headers, (Object)this, "headers");
        this.id = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).id, this, "id");
        this.node = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).node, this, "node");
        this.parentTaskId = ((AbstractBuilder)builder).parentTaskId;
        this.resourceStats = ((AbstractBuilder)builder).resourceStats;
        this.runningTime = ((AbstractBuilder)builder).runningTime;
        this.runningTimeInNanos = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).runningTimeInNanos, this, "runningTimeInNanos");
        this.startTimeInMillis = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).startTimeInMillis, this, "startTimeInMillis");
        this.status = ((AbstractBuilder)builder).status;
        this.type = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).type, this, "type");
    }

    @Nonnull
    public final String action() {
        return this.action;
    }

    public final boolean cancellable() {
        return this.cancellable;
    }

    @Nullable
    public final Long cancellationTimeMillis() {
        return this.cancellationTimeMillis;
    }

    @Nullable
    public final Boolean cancelled() {
        return this.cancelled;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    @Nonnull
    public final Map<String, String> headers() {
        return this.headers;
    }

    public final long id() {
        return this.id;
    }

    @Nonnull
    public final String node() {
        return this.node;
    }

    @Nullable
    public final String parentTaskId() {
        return this.parentTaskId;
    }

    @Nullable
    public final ResourceStats resourceStats() {
        return this.resourceStats;
    }

    @Nullable
    public final Time runningTime() {
        return this.runningTime;
    }

    public final long runningTimeInNanos() {
        return this.runningTimeInNanos;
    }

    public final long startTimeInMillis() {
        return this.startTimeInMillis;
    }

    @Nullable
    public final Status status() {
        return this.status;
    }

    @Nonnull
    public final String type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("action");
        generator.write(this.action);
        generator.writeKey("cancellable");
        generator.write(this.cancellable);
        if (this.cancellationTimeMillis != null) {
            generator.writeKey("cancellation_time_millis");
            generator.write(this.cancellationTimeMillis.longValue());
        }
        if (this.cancelled != null) {
            generator.writeKey("cancelled");
            generator.write(this.cancelled.booleanValue());
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        generator.writeKey("headers");
        generator.writeStartObject();
        for (Map.Entry<String, String> item0 : this.headers.entrySet()) {
            generator.writeKey(item0.getKey());
            generator.write(item0.getValue());
        }
        generator.writeEnd();
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("node");
        generator.write(this.node);
        if (this.parentTaskId != null) {
            generator.writeKey("parent_task_id");
            generator.write(this.parentTaskId);
        }
        if (this.resourceStats != null) {
            generator.writeKey("resource_stats");
            this.resourceStats.serialize(generator, mapper);
        }
        if (this.runningTime != null) {
            generator.writeKey("running_time");
            this.runningTime.serialize(generator, mapper);
        }
        generator.writeKey("running_time_in_nanos");
        generator.write(this.runningTimeInNanos);
        generator.writeKey("start_time_in_millis");
        generator.write(this.startTimeInMillis);
        if (this.status != null) {
            generator.writeKey("status");
            this.status.serialize(generator, mapper);
        }
        generator.writeKey("type");
        generator.write(this.type);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupTaskInfoBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::action, JsonpDeserializer.stringDeserializer(), "action");
        op.add(AbstractBuilder::cancellable, JsonpDeserializer.booleanDeserializer(), "cancellable");
        op.add(AbstractBuilder::cancellationTimeMillis, JsonpDeserializer.longDeserializer(), "cancellation_time_millis");
        op.add(AbstractBuilder::cancelled, JsonpDeserializer.booleanDeserializer(), "cancelled");
        op.add(AbstractBuilder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(AbstractBuilder::headers, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "headers");
        op.add(AbstractBuilder::id, JsonpDeserializer.longDeserializer(), "id");
        op.add(AbstractBuilder::node, JsonpDeserializer.stringDeserializer(), "node");
        op.add(AbstractBuilder::parentTaskId, JsonpDeserializer.stringDeserializer(), "parent_task_id");
        op.add(AbstractBuilder::resourceStats, ResourceStats._DESERIALIZER, "resource_stats");
        op.add(AbstractBuilder::runningTime, Time._DESERIALIZER, "running_time");
        op.add(AbstractBuilder::runningTimeInNanos, JsonpDeserializer.longDeserializer(), "running_time_in_nanos");
        op.add(AbstractBuilder::startTimeInMillis, JsonpDeserializer.longDeserializer(), "start_time_in_millis");
        op.add(AbstractBuilder::status, Status._DESERIALIZER, "status");
        op.add(AbstractBuilder::type, JsonpDeserializer.stringDeserializer(), "type");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.action.hashCode();
        result = 31 * result + Boolean.hashCode(this.cancellable);
        result = 31 * result + Objects.hashCode(this.cancellationTimeMillis);
        result = 31 * result + Objects.hashCode(this.cancelled);
        result = 31 * result + Objects.hashCode(this.description);
        result = 31 * result + this.headers.hashCode();
        result = 31 * result + Long.hashCode(this.id);
        result = 31 * result + this.node.hashCode();
        result = 31 * result + Objects.hashCode(this.parentTaskId);
        result = 31 * result + Objects.hashCode(this.resourceStats);
        result = 31 * result + Objects.hashCode(this.runningTime);
        result = 31 * result + Long.hashCode(this.runningTimeInNanos);
        result = 31 * result + Long.hashCode(this.startTimeInMillis);
        result = 31 * result + Objects.hashCode(this.status);
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskInfoBase other = (TaskInfoBase)o;
        return this.action.equals(other.action) && this.cancellable == other.cancellable && Objects.equals(this.cancellationTimeMillis, other.cancellationTimeMillis) && Objects.equals(this.cancelled, other.cancelled) && Objects.equals(this.description, other.description) && this.headers.equals(other.headers) && this.id == other.id && this.node.equals(other.node) && Objects.equals(this.parentTaskId, other.parentTaskId) && Objects.equals(this.resourceStats, other.resourceStats) && Objects.equals(this.runningTime, other.runningTime) && this.runningTimeInNanos == other.runningTimeInNanos && this.startTimeInMillis == other.startTimeInMillis && Objects.equals(this.status, other.status) && this.type.equals(other.type);
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends ObjectBuilderBase {
        private String action;
        private Boolean cancellable;
        @Nullable
        private Long cancellationTimeMillis;
        @Nullable
        private Boolean cancelled;
        @Nullable
        private String description;
        private Map<String, String> headers;
        private Long id;
        private String node;
        @Nullable
        private String parentTaskId;
        @Nullable
        private ResourceStats resourceStats;
        @Nullable
        private Time runningTime;
        private Long runningTimeInNanos;
        private Long startTimeInMillis;
        @Nullable
        private Status status;
        private String type;

        protected AbstractBuilder() {
        }

        protected AbstractBuilder(TaskInfoBase o) {
            this.action = o.action;
            this.cancellable = o.cancellable;
            this.cancellationTimeMillis = o.cancellationTimeMillis;
            this.cancelled = o.cancelled;
            this.description = o.description;
            this.headers = AbstractBuilder._mapCopy(o.headers);
            this.id = o.id;
            this.node = o.node;
            this.parentTaskId = o.parentTaskId;
            this.resourceStats = o.resourceStats;
            this.runningTime = o.runningTime;
            this.runningTimeInNanos = o.runningTimeInNanos;
            this.startTimeInMillis = o.startTimeInMillis;
            this.status = o.status;
            this.type = o.type;
        }

        protected AbstractBuilder(AbstractBuilder<BuilderT> o) {
            this.action = o.action;
            this.cancellable = o.cancellable;
            this.cancellationTimeMillis = o.cancellationTimeMillis;
            this.cancelled = o.cancelled;
            this.description = o.description;
            this.headers = AbstractBuilder._mapCopy(o.headers);
            this.id = o.id;
            this.node = o.node;
            this.parentTaskId = o.parentTaskId;
            this.resourceStats = o.resourceStats;
            this.runningTime = o.runningTime;
            this.runningTimeInNanos = o.runningTimeInNanos;
            this.startTimeInMillis = o.startTimeInMillis;
            this.status = o.status;
            this.type = o.type;
        }

        @Nonnull
        protected abstract BuilderT self();

        @Nonnull
        public final BuilderT action(String value) {
            this.action = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT cancellable(boolean value) {
            this.cancellable = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT cancellationTimeMillis(@Nullable Long value) {
            this.cancellationTimeMillis = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT cancelled(@Nullable Boolean value) {
            this.cancelled = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT description(@Nullable String value) {
            this.description = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT headers(Map<String, String> map) {
            this.headers = AbstractBuilder._mapPutAll(this.headers, map);
            return this.self();
        }

        @Nonnull
        public final BuilderT headers(String key, String value) {
            this.headers = AbstractBuilder._mapPut(this.headers, key, value);
            return this.self();
        }

        @Nonnull
        public final BuilderT id(long value) {
            this.id = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT node(String value) {
            this.node = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT parentTaskId(@Nullable String value) {
            this.parentTaskId = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT resourceStats(@Nullable ResourceStats value) {
            this.resourceStats = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT resourceStats(Function<ResourceStats.Builder, ObjectBuilder<ResourceStats>> fn) {
            return this.resourceStats(fn.apply(new ResourceStats.Builder()).build());
        }

        @Nonnull
        public final BuilderT runningTime(@Nullable Time value) {
            this.runningTime = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT runningTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.runningTime(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final BuilderT runningTimeInNanos(long value) {
            this.runningTimeInNanos = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT startTimeInMillis(long value) {
            this.startTimeInMillis = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT status(@Nullable Status value) {
            this.status = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT status(Function<Status.Builder, ObjectBuilder<Status>> fn) {
            return this.status(fn.apply(new Status.Builder()).build());
        }

        @Nonnull
        public final BuilderT type(String value) {
            this.type = value;
            return this.self();
        }
    }
}

