/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.core.metrics;

import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.opensearch.plugin.insights.core.metrics.OperationalMetric;
import org.opensearch.telemetry.metrics.Counter;
import org.opensearch.telemetry.metrics.MetricsRegistry;
import org.opensearch.telemetry.metrics.tags.Tags;

public final class OperationalMetricsCounter {
    private static final String PREFIX = "search.insights.";
    private static final String CLUSTER_NAME_TAG = "cluster_name";
    private static final String UNIT = "1";
    private final String clusterName;
    private final MetricsRegistry metricsRegistry;
    private final ConcurrentHashMap<OperationalMetric, Counter> metricCounterMap;
    private static OperationalMetricsCounter instance;

    private OperationalMetricsCounter(String clusterName, MetricsRegistry metricsRegistry) {
        this.clusterName = clusterName;
        this.metricsRegistry = metricsRegistry;
        this.metricCounterMap = new ConcurrentHashMap();
        Stream.of(OperationalMetric.values()).forEach(name -> this.metricCounterMap.computeIfAbsent((OperationalMetric)((Object)name), this::createMetricCounter));
    }

    public static synchronized void initialize(String clusterName, MetricsRegistry metricsRegistry) {
        instance = new OperationalMetricsCounter(clusterName, metricsRegistry);
    }

    public static synchronized OperationalMetricsCounter getInstance() {
        if (instance == null) {
            throw new IllegalStateException("OperationalMetricsCounter is not initialized. Call initialize() first.");
        }
        return instance;
    }

    public void incrementCounter(OperationalMetric metricName, Tags customTags) {
        Counter counter = this.metricCounterMap.computeIfAbsent(metricName, this::createMetricCounter);
        Tags metricsTags = (customTags == null ? Tags.create() : customTags).addTag(CLUSTER_NAME_TAG, this.clusterName);
        counter.add(1.0, metricsTags);
    }

    public void incrementCounter(OperationalMetric metricName) {
        this.incrementCounter(metricName, null);
    }

    private Counter createMetricCounter(OperationalMetric metricName) {
        return this.metricsRegistry.createCounter(PREFIX + metricName.toString().toLowerCase(Locale.ROOT) + ".count", metricName.getDescription(), UNIT);
    }
}

