/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

public enum CertificateType {
    X_509(0, true),
    OPEN_PGP(1, false),
    RAW_PUBLIC_KEY(2, true);

    private final int code;
    private final boolean isSupported;

    private CertificateType(int code, boolean isSupported) {
        this.code = code;
        this.isSupported = isSupported;
    }

    public static CertificateType getTypeFromCode(int code) {
        switch (code) {
            case 0: {
                return X_509;
            }
            case 1: {
                return OPEN_PGP;
            }
            case 2: {
                return RAW_PUBLIC_KEY;
            }
        }
        return null;
    }

    public final int getCode() {
        return this.code;
    }

    public final boolean isSupported() {
        return this.isSupported;
    }
}

