/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.core;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.pcap4j.Pcap4jPropertiesLoader;
import org.pcap4j.core.NativeMappings;
import org.pcap4j.util.ByteArrays;

public final class Inets {
    public static final short AF_UNSPEC = 0;
    public static final short AF_INET = Pcap4jPropertiesLoader.getInstance().getAfInet().shortValue();
    public static final short AF_INET6 = Pcap4jPropertiesLoader.getInstance().getAfInet6().shortValue();
    public static final short AF_PACKET = Pcap4jPropertiesLoader.getInstance().getAfPacket().shortValue();
    public static final short AF_LINK = Pcap4jPropertiesLoader.getInstance().getAfLink().shortValue();

    private Inets() {
        throw new AssertionError();
    }

    static Inet4Address ntoInetAddress(NativeMappings.in_addr in) {
        if (in == null) {
            return null;
        }
        return Inets.itoInetAddress(in.s_addr);
    }

    static Inet4Address itoInetAddress(int i) {
        return ByteArrays.getInet4Address(ByteArrays.toByteArray(i, NativeMappings.NATIVE_BYTE_ORDER), 0);
    }

    static Inet6Address ntoInetAddress(NativeMappings.in6_addr in6) {
        if (in6 == null) {
            return null;
        }
        try {
            return (Inet6Address)InetAddress.getByAddress(in6.s6_addr);
        }
        catch (UnknownHostException e) {
            throw new AssertionError();
        }
    }
}

