/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.Parser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ExtensionParser<T extends ExtensionMessage>
extends Parser<T> {
    private static final Logger LOGGER = LogManager.getLogger();

    public ExtensionParser(int startposition, byte[] array) {
        super(startposition, array);
    }

    @Override
    public final T parse() {
        LOGGER.debug("Parsing ExtensionMessage");
        T msg = this.createExtensionMessage();
        this.parseExtensionType((ExtensionMessage)msg);
        this.parseExtensionLength((ExtensionMessage)msg);
        this.parseExtensionMessageContent(msg);
        this.setExtensionBytes((ExtensionMessage)msg);
        return msg;
    }

    public abstract void parseExtensionMessageContent(T var1);

    protected abstract T createExtensionMessage();

    private void parseExtensionLength(ExtensionMessage msg) {
        msg.setExtensionLength(this.parseIntField(2));
        LOGGER.debug("ExtensionLength: " + msg.getExtensionLength().getValue());
    }

    private void parseExtensionType(ExtensionMessage msg) {
        msg.setExtensionType(this.parseByteArrayField(2));
        LOGGER.debug("ExtensionType: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getExtensionType().getValue())));
    }

    protected boolean hasExtensionData(ExtensionMessage message) {
        return (Integer)message.getExtensionLength().getValue() > 0;
    }

    protected void setExtensionBytes(ExtensionMessage msg) {
        msg.setExtensionBytes(this.getAlreadyParsed());
        LOGGER.debug("ExtensionBytes: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getExtensionBytes().getValue())));
    }
}

