/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import org.openide.util.Utilities;

public final class Mnemonics {
    private Mnemonics() {
    }

    private static void setLocalizedText2(Object object, String string) {
        if (string == null) {
            Mnemonics.setText(object, null);
            return;
        }
        int n = Mnemonics.findMnemonicAmpersand(string);
        if (n < 0) {
            Mnemonics.setText(object, string);
            Mnemonics.setMnemonic(object, 0);
        } else {
            Mnemonics.setText(object, string.substring(0, n) + string.substring(n + 1));
            if (Utilities.isMac()) {
                Mnemonics.setMnemonic(object, 0);
            } else {
                char c = string.charAt(n + 1);
                if (string.startsWith("<html>")) {
                    Mnemonics.setText(object, string.substring(0, n) + "<u>" + c + "</u>" + string.substring(n + 2));
                    n += 3;
                }
                if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') {
                    Mnemonics.setMnemonic(object, c);
                    Mnemonics.setMnemonicIndex(object, n);
                } else {
                    try {
                        int n2 = Mnemonics.getLatinKeycode(c);
                        Mnemonics.setMnemonic(object, n2);
                        Mnemonics.setMnemonicIndex(object, n);
                    }
                    catch (MissingResourceException missingResourceException) {
                        Logger.getLogger(Mnemonics.class.getName()).info("Mapping from a non-Latin character '" + c + "' not found in a localized (branded) version of " + "openide/awt/src/org/openide/awt/Mnemonics.properties - " + "mnemonic cannot be assigned in " + string);
                    }
                }
            }
        }
    }

    public static void setLocalizedText(AbstractButton abstractButton, String string) {
        Mnemonics.setLocalizedText2(abstractButton, string);
    }

    public static void setLocalizedText(JLabel jLabel, String string) {
        Mnemonics.setLocalizedText2(jLabel, string);
    }

    public static int findMnemonicAmpersand(String string) {
        int n = -1;
        boolean bl = string.startsWith("<html>");
        do {
            if ((n = string.indexOf(38, n + 1)) < 0 || n + 1 >= string.length()) continue;
            if (bl) {
                boolean bl2 = false;
                for (int i = n + 1; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (c == ';') {
                        bl2 = true;
                        break;
                    }
                    if (!Character.isLetterOrDigit(c)) break;
                }
                if (bl2) continue;
                return n;
            }
            if (string.charAt(n + 1) == ' ' || string.charAt(n + 1) == '\'' && n > 0 && string.charAt(n - 1) == '\'') continue;
            return n;
        } while (n >= 0);
        return -1;
    }

    private static int getLatinKeycode(char c) throws MissingResourceException {
        String string = Mnemonics.getBundle().getString("MNEMONIC_" + c);
        if (string.length() == 1) {
            return string.charAt(0);
        }
        return Integer.parseInt(string);
    }

    private static void setMnemonicIndex(Object object, int n) {
        if (object instanceof AbstractButton) {
            ((AbstractButton)object).setDisplayedMnemonicIndex(n);
        } else if (object instanceof JLabel) {
            ((JLabel)object).setDisplayedMnemonicIndex(n);
        }
    }

    private static void setText(Object object, String string) {
        if (object instanceof AbstractButton) {
            ((AbstractButton)object).setText(string);
        } else {
            ((JLabel)object).setText(string);
        }
    }

    private static void setMnemonic(Object object, int n) {
        if (Utilities.isMac()) {
            return;
        }
        if (n >= 97 && n <= 122) {
            n += -32;
        }
        if (object instanceof AbstractButton) {
            ((AbstractButton)object).setMnemonic(n);
        } else {
            ((JLabel)object).setDisplayedMnemonic(n);
        }
    }

    private static ResourceBundle getBundle() {
        return ResourceBundle.getBundle("org.openide.awt.Mnemonics");
    }
}

