/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.nlp.similarity;

import ai.grazie.nlp.similarity.TextSimilarity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lai/grazie/nlp/similarity/JaroWinkler;", "Lai/grazie/nlp/similarity/TextSimilarity;", "()V", "JW_COEF", "", "WINKLER_THRESHOLD", "matches", "", "s1", "", "s2", "similarity", "first", "second", "nlp-similarity"})
public final class JaroWinkler
implements TextSimilarity {
    @NotNull
    public static final JaroWinkler INSTANCE = new JaroWinkler();
    private static final double WINKLER_THRESHOLD = 0.7;
    private static final double JW_COEF = 0.1;

    private JaroWinkler() {
    }

    @Override
    public double similarity(@NotNull String first, @NotNull String second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        if (Intrinsics.areEqual((Object)first, (Object)second)) {
            return 1.0;
        }
        int[] mtp = this.matches(first, second);
        float m = mtp[0];
        if (m == 0.0f) {
            return 0.0;
        }
        double jaro = (m / (float)first.length() + m / (float)second.length() + (m - (float)mtp[1]) / m) / (float)3;
        return jaro > 0.7 ? jaro + Math.min(0.1, 1.0 / (double)mtp[3]) * (double)mtp[2] * (1.0 - jaro) : jaro;
    }

    private final int[] matches(String s1, String s2) {
        int n;
        String max = null;
        String min = null;
        if (s1.length() > s2.length()) {
            max = s1;
            min = s2;
        } else {
            max = s2;
            min = s1;
        }
        int range = Math.max(max.length() / 2 - 1, 0);
        int n2 = 0;
        int n3 = min.length();
        int[] nArray = new int[n3];
        while (n2 < n3) {
            n = n2++;
            nArray[n] = -1;
        }
        int[] matchIndexes = nArray;
        boolean[] matchFlags = new boolean[max.length()];
        int matches = 0;
        n = min.length();
        block1: for (int mi = 0; mi < n; ++mi) {
            char c1 = min.charAt(mi);
            int xn = Math.min(mi + range + 1, max.length());
            for (int xi = Math.max(mi - range, 0); xi < xn; ++xi) {
                if (matchFlags[xi] || c1 != max.charAt(xi)) continue;
                matchIndexes[mi] = xi;
                matchFlags[xi] = true;
                ++matches;
                continue block1;
            }
        }
        char[] ms1 = new char[matches];
        char[] ms2 = new char[matches];
        JaroWinkler $this$matches_u24lambda_u240 = this;
        boolean bl = false;
        int si = 0;
        for (int i = 0; i < min.length(); ++i) {
            if (matchIndexes[i] == -1) continue;
            ms1[si] = min.charAt(i);
            ++si;
        }
        int si2 = 0;
        for (int i = 0; i < max.length(); ++i) {
            if (!matchFlags[i]) continue;
            ms2[si2] = max.charAt(i);
            ++si2;
        }
        int transpositions = 0;
        si = ms1.length;
        for (int mi = 0; mi < si; ++mi) {
            if (ms1[mi] == ms2[mi]) continue;
            ++transpositions;
        }
        int prefix = 0;
        int n4 = min.length();
        for (int mi = 0; mi < n4 && s1.charAt(mi) == s2.charAt(mi); ++mi) {
            ++prefix;
        }
        int[] nArray2 = new int[]{matches, transpositions / 2, prefix, max.length()};
        return nArray2;
    }
}

