/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index;

import com.intellij.diff.DiffApplicationSettings;
import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffManager;
import com.intellij.diff.comparison.ByWord;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.LineStatusMarkerColorScheme;
import com.intellij.openapi.diff.LineStatusMarkerDrawUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.MarkupEditorFilterFactory;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalSeparatorComponent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ex.BlockI;
import com.intellij.openapi.vcs.ex.ChangedLines;
import com.intellij.openapi.vcs.ex.ChangesBlock;
import com.intellij.openapi.vcs.ex.DocumentTracker;
import com.intellij.openapi.vcs.ex.LineStatusMarkerPopupActions;
import com.intellij.openapi.vcs.ex.LineStatusMarkerPopupPanel;
import com.intellij.openapi.vcs.ex.LineStatusMarkerRangesSource;
import com.intellij.openapi.vcs.ex.LineStatusMarkerRendererWithPopupController;
import com.intellij.openapi.vcs.ex.LineStatusTrackerBase;
import com.intellij.openapi.vcs.ex.LineStatusTrackerBlockOperations;
import com.intellij.openapi.vcs.ex.LineStatusTrackerI;
import com.intellij.openapi.vcs.ex.LineStatusTrackerKt;
import com.intellij.openapi.vcs.ex.LineStatusTrackerListener;
import com.intellij.openapi.vcs.ex.LineStatusTrackerMarkerRenderer;
import com.intellij.openapi.vcs.ex.LocalLineStatusTracker;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.ex.RangeExclusionState;
import com.intellij.openapi.vcs.ex.RollbackLineStatusAction;
import com.intellij.openapi.vcs.ex.VisibleRangeMerger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.EventDispatcher;
import com.intellij.util.IntPair;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.PeekableIteratorWrapper;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import git4idea.i18n.GitBundle;
import git4idea.index.BlockMerger;
import git4idea.index.StagePopupVerticalLayout;
import git4idea.index.StagedRange;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.locks.Lock;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0005vwxyzB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\bH\u0007J\b\u0010:\u001a\u000206H\u0007J\b\u0010;\u001a\u000206H\u0016J3\u0010<\u001a\u00020$2\u0006\u0010=\u001a\u00020>2\r\u0010?\u001a\t\u0018\u00010@\u00a2\u0006\u0002\bA2\u0012\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002060CH\u0003J\b\u0010I\u001a\u000206H\u0002J\b\u0010J\u001a\u00020$H\u0016J\b\u0010K\u001a\u00020$H\u0016J\u0010\u0010L\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010EH\u0016J\u0012\u0010M\u001a\u0004\u0018\u00010\u00022\u0006\u0010N\u001a\u00020\u001fH\u0016J\u0012\u0010O\u001a\u0004\u0018\u00010\u00022\u0006\u0010P\u001a\u00020QH\u0016J\u0012\u0010R\u001a\u0004\u0018\u00010\u00022\u0006\u0010P\u001a\u00020QH\u0016J\u0018\u0010S\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010E2\u0006\u0010T\u001a\u00020UH\u0016J\u0012\u0010V\u001a\u0004\u0018\u00010\u00022\u0006\u0010P\u001a\u00020QH\u0016J\u0010\u0010W\u001a\u00020$2\u0006\u0010P\u001a\u00020QH\u0016J\u0018\u0010X\u001a\u00020$2\u0006\u0010Y\u001a\u00020Q2\u0006\u0010Z\u001a\u00020QH\u0016J\u0018\u0010[\u001a\u00020Q2\u0006\u0010P\u001a\u00020Q2\u0006\u0010\\\u001a\u00020$H\u0016J\u0018\u0010]\u001a\u00020Q2\u0006\u0010P\u001a\u00020Q2\u0006\u0010\\\u001a\u00020$H\u0016J\u0016\u0010^\u001a\u00020Q2\u0006\u0010P\u001a\u00020Q2\u0006\u0010\\\u001a\u00020$J\u0016\u0010_\u001a\u00020Q2\u0006\u0010P\u001a\u00020Q2\u0006\u0010\\\u001a\u00020$J\u0018\u0010`\u001a\u0002062\u0006\u0010N\u001a\u00020\u001f2\u0006\u0010a\u001a\u00020bH\u0016J\u0018\u0010c\u001a\u0002062\u0006\u0010N\u001a\u00020\u001f2\u0006\u0010a\u001a\u00020bH\u0016J!\u0010d\u001a\u0002He\"\u0004\b\u0000\u0010e2\f\u0010B\u001a\b\u0012\u0004\u0012\u0002He0fH\u0016\u00a2\u0006\u0002\u0010gJ\u0010\u0010h\u001a\u0002062\u0006\u0010B\u001a\u00020iH\u0016J\b\u0010j\u001a\u000206H\u0016J\b\u0010k\u001a\u000206H\u0016J\u0010\u0010l\u001a\u0002062\u0006\u0010N\u001a\u00020\u001fH\u0016J\u0010\u0010l\u001a\u0002062\u0006\u0010T\u001a\u00020UH\u0016J\u0016\u0010m\u001a\u0002062\f\u0010n\u001a\b\u0012\u0004\u0012\u00020\u00020EH\u0003J\u000e\u0010o\u001a\u0002062\u0006\u0010N\u001a\u00020\u001fJ\u0016\u0010p\u001a\u0002062\f\u0010n\u001a\b\u0012\u0004\u0012\u00020\u00020EH\u0003J\u000e\u0010q\u001a\u0002062\u0006\u0010N\u001a\u00020\u001fJ\u0016\u0010r\u001a\u0002062\f\u0010n\u001a\b\u0012\u0004\u0012\u00020\u00020EH\u0003J\u0010\u0010s\u001a\u0002062\u0006\u0010t\u001a\u00020,H\u0016J\u0010\u0010u\u001a\u0002062\u0006\u0010t\u001a\u00020,H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u001e\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010%\u001a\u00020$2\u0006\u0010\u0013\u001a\u00020$@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001e\u0010'\u001a\u00020$2\u0006\u0010\u0013\u001a\u00020$@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010&R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010*\u001a\u0015\u0012\f\u0012\n -*\u0004\u0018\u00010,0,0+\u00a2\u0006\u0002\b.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010/\u001a\u000200X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u0016\u0010D\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010EX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00020E8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u0010H\u00a8\u0006{"}, d2={"Lgit4idea/index/GitStageLineStatusTracker;", "Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker;", "Lgit4idea/index/StagedRange;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "document", "Lcom/intellij/openapi/editor/Document;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/editor/Document;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "vcsDocument", "getVcsDocument", "value", "stagedDocument", "getStagedDocument", "disposable", "Lcom/intellij/openapi/Disposable;", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "LOCK", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Lock;", "blockOperations", "Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBlockOperations;", "stagedBlockOperations", "Lcom/intellij/openapi/vcs/ex/Range;", "Lcom/intellij/openapi/vcs/ex/BlockI;", "stagedTracker", "Lcom/intellij/openapi/vcs/ex/DocumentTracker;", "unstagedTracker", "", "isReleased", "()Z", "isInitialized", "renderer", "Lgit4idea/index/GitStageLineStatusTracker$MyLineStatusMarkerPopupRenderer;", "listeners", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/openapi/vcs/ex/LineStatusTrackerListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "mode", "Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker$Mode;", "getMode", "()Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker$Mode;", "setMode", "(Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker$Mode;)V", "setBaseRevision", "", "vcsContent", "", "newStagedDocument", "dropBaseRevision", "release", "updateDocument", "side", "Lcom/intellij/diff/util/ThreeSide;", "commandName", "", "Lcom/intellij/openapi/util/NlsContexts$Command;", "task", "Lkotlin/Function1;", "cachedBlocks", "", "blocks", "getBlocks", "()Ljava/util/List;", "updateHighlighters", "isOperational", "isValid", "getRanges", "findRange", "range", "getNextRange", "line", "", "getPrevRange", "getRangesForLines", "lines", "Ljava/util/BitSet;", "getRangeForLine", "isLineModified", "isRangeModified", "startLine", "endLine", "transferLineFromVcs", "approximate", "transferLineToVcs", "transferLineFromLocalToStaged", "transferLineFromStagedToLocal", "scrollAndShowHint", "editor", "Lcom/intellij/openapi/editor/Editor;", "showHint", "readLock", "T", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "doFrozen", "Ljava/lang/Runnable;", "freeze", "unfreeze", "rollbackChanges", "runBulkRollback", "toRevert", "stageChanges", "runBulkStage", "unstageChanges", "runBulkUnstage", "addListener", "listener", "removeListener", "BlockFilter", "MyDocumentTrackerHandler", "MyLineStatusMarkerPopupRenderer", "MyBlockOperations", "MyStagedBlockOperations", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitStageLineStatusTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitStageLineStatusTracker.kt\ngit4idea/index/GitStageLineStatusTracker\n+ 2 DocumentTracker.kt\ncom/intellij/openapi/vcs/ex/DocumentTracker\n+ 3 DocumentTracker.kt\ncom/intellij/openapi/vcs/ex/DocumentTracker$Lock\n*L\n1#1,975:1\n134#2,8:976\n125#2,12:987\n125#2,17:999\n128#2:1016\n139#2,3:1017\n129#2,2:1020\n530#3:984\n530#3:985\n530#3:986\n*S KotlinDebug\n*F\n+ 1 GitStageLineStatusTracker.kt\ngit4idea/index/GitStageLineStatusTracker\n*L\n118#1:976,8\n214#1:987,12\n215#1:999,17\n214#1:1016\n214#1:1017,3\n214#1:1020,2\n177#1:984\n181#1:985\n208#1:986\n*E\n"})
public final class GitStageLineStatusTracker
implements LocalLineStatusTracker<StagedRange> {
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile virtualFile;
    @NotNull
    private final Document document;
    @NotNull
    private final Document vcsDocument;
    @NotNull
    private Document stagedDocument;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final DocumentTracker.Lock LOCK;
    @NotNull
    private final LineStatusTrackerBlockOperations<StagedRange, StagedRange> blockOperations;
    @NotNull
    private final LineStatusTrackerBlockOperations<Range, BlockI> stagedBlockOperations;
    @NotNull
    private final DocumentTracker stagedTracker;
    @NotNull
    private final DocumentTracker unstagedTracker;
    private boolean isReleased;
    private boolean isInitialized;
    @NotNull
    private final MyLineStatusMarkerPopupRenderer renderer;
    @NotNull
    private final EventDispatcher<LineStatusTrackerListener> listeners;
    @NotNull
    private LocalLineStatusTracker.Mode mode;
    @Nullable
    private List<StagedRange> cachedBlocks;

    public GitStageLineStatusTracker(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.project = project;
        this.virtualFile = virtualFile;
        this.document = document;
        this.vcsDocument = LineStatusTrackerBase.Companion.createVcsDocument(this.getDocument());
        this.stagedDocument = LineStatusTrackerBase.Companion.createVcsDocument(this.getDocument());
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.disposable = disposable;
        this.LOCK = new DocumentTracker.Lock();
        this.blockOperations = new MyBlockOperations(this.LOCK);
        this.stagedBlockOperations = new MyStagedBlockOperations(this.LOCK);
        this.renderer = new MyLineStatusMarkerPopupRenderer(this);
        EventDispatcher eventDispatcher = EventDispatcher.create(LineStatusTrackerListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.listeners = eventDispatcher;
        this.mode = new LocalLineStatusTracker.Mode(true, true, false);
        this.stagedTracker = new DocumentTracker(this.getVcsDocument(), this.stagedDocument, this.LOCK);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)((Disposable)this.stagedTracker));
        this.unstagedTracker = new DocumentTracker(this.stagedDocument, this.getDocument(), this.LOCK);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)((Disposable)this.unstagedTracker));
        this.stagedTracker.addHandler((DocumentTracker.Handler)new MyDocumentTrackerHandler(false));
        this.unstagedTracker.addHandler((DocumentTracker.Handler)new MyDocumentTrackerHandler(true));
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        return this.virtualFile;
    }

    @NotNull
    public Document getDocument() {
        return this.document;
    }

    @NotNull
    public Document getVcsDocument() {
        return this.vcsDocument;
    }

    @NotNull
    public final Document getStagedDocument() {
        return this.stagedDocument;
    }

    @NotNull
    public Disposable getDisposable() {
        return this.disposable;
    }

    public boolean isReleased() {
        return this.isReleased;
    }

    protected final boolean isInitialized() {
        return this.isInitialized;
    }

    @NotNull
    public LocalLineStatusTracker.Mode getMode() {
        return this.mode;
    }

    public void setMode(@NotNull LocalLineStatusTracker.Mode mode) {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"<set-?>");
        this.mode = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @RequiresEdt
    public final void setBaseRevision(@NotNull CharSequence vcsContent, @NotNull Document newStagedDocument) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)vcsContent, (String)"vcsContent");
        Intrinsics.checkNotNullParameter((Object)newStagedDocument, (String)"newStagedDocument");
        ThreadingAssertions.assertEventDispatchThread();
        if (this.isReleased()) {
            return;
        }
        if (!Intrinsics.areEqual((Object)this.stagedDocument, (Object)newStagedDocument)) {
            this.stagedTracker.replaceDocument(Side.RIGHT, newStagedDocument);
            this.unstagedTracker.replaceDocument(Side.LEFT, newStagedDocument);
            this.stagedDocument = newStagedDocument;
        }
        DocumentTracker documentTracker = this.stagedTracker;
        Side side$iv = Side.LEFT;
        boolean $i$f$doFrozen = false;
        this_$iv.freeze(side$iv);
        try {
            boolean bl = false;
            this.updateDocument(ThreeSide.LEFT, null, (Function1<? super Document, Unit>)((Function1)arg_0 -> GitStageLineStatusTracker.setBaseRevision$lambda$1$lambda$0(this, vcsContent, arg_0)));
        }
        finally {
            this_$iv.unfreeze(side$iv);
        }
        if (!this.isInitialized) {
            this.isInitialized = true;
            this.updateHighlighters();
        }
    }

    @RequiresEdt
    public final void dropBaseRevision() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.isReleased()) {
            return;
        }
        this.isInitialized = false;
        this.updateHighlighters();
    }

    public void release() {
        Runnable runnable = () -> GitStageLineStatusTracker.release$lambda$2(this);
        if (!ApplicationManager.getApplication().isDispatchThread() || this.LOCK.isHeldByCurrentThread()) {
            ApplicationManager.getApplication().invokeLater(runnable);
        } else {
            runnable.run();
        }
    }

    @RequiresEdt
    private final boolean updateDocument(ThreeSide side, String commandName, Function1<? super Document, Unit> task) {
        Object object = side.selectNotNull((Object)this.getVcsDocument(), (Object)this.stagedDocument, (Object)this.getDocument());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"selectNotNull(...)");
        Document affectedDocument = (Document)object;
        return LineStatusTrackerBase.Companion.updateDocument(this.getProject(), affectedDocument, commandName, task);
    }

    private final List<StagedRange> getBlocks() {
        List<StagedRange> blocks = this.cachedBlocks;
        if (blocks == null) {
            this.cachedBlocks = blocks = new BlockMerger(this.stagedTracker.getBlocks(), this.unstagedTracker.getBlocks()).run();
        }
        return blocks;
    }

    private final void updateHighlighters() {
        this.renderer.scheduleUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOperational() {
        DocumentTracker.Lock this_$iv = this.LOCK;
        boolean $i$f$read = false;
        Lock lock = this_$iv.getMyLock();
        lock.lock();
        try {
            boolean bl = false;
            boolean bl2 = this.isInitialized && !this.isReleased();
            return bl2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        boolean bl;
        DocumentTracker.Lock this_$iv = this.LOCK;
        boolean $i$f$read = false;
        Lock lock = this_$iv.getMyLock();
        lock.lock();
        try {
            boolean bl2 = false;
            bl = this.isOperational() && !this.stagedTracker.isFrozen() && !this.unstagedTracker.isFrozen();
        }
        finally {
            lock.unlock();
        }
        return bl;
    }

    @Nullable
    public List<StagedRange> getRanges() {
        return this.blockOperations.getRanges();
    }

    @Nullable
    public StagedRange findRange(@NotNull Range range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return (StagedRange)this.blockOperations.findRange(range);
    }

    @Nullable
    public StagedRange getNextRange(int line) {
        return (StagedRange)this.blockOperations.getNextRange(line);
    }

    @Nullable
    public StagedRange getPrevRange(int line) {
        return (StagedRange)this.blockOperations.getPrevRange(line);
    }

    @Nullable
    public List<StagedRange> getRangesForLines(@NotNull BitSet lines) {
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        return this.blockOperations.getRangesForLines(lines);
    }

    @Nullable
    public StagedRange getRangeForLine(int line) {
        return (StagedRange)this.blockOperations.getRangeForLine(line);
    }

    public boolean isLineModified(int line) {
        return this.blockOperations.isLineModified(line);
    }

    public boolean isRangeModified(int startLine, int endLine) {
        return this.blockOperations.isRangeModified(startLine, endLine);
    }

    public int transferLineFromVcs(int line, boolean approximate) {
        return this.blockOperations.transferLineFromVcs(line, approximate);
    }

    public int transferLineToVcs(int line, boolean approximate) {
        return this.blockOperations.transferLineToVcs(line, approximate);
    }

    public final int transferLineFromLocalToStaged(int line, boolean approximate) {
        return this.stagedBlockOperations.transferLineToVcs(line, approximate);
    }

    public final int transferLineFromStagedToLocal(int line, boolean approximate) {
        return this.stagedBlockOperations.transferLineFromVcs(line, approximate);
    }

    public void scrollAndShowHint(@NotNull Range range, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.renderer.scrollAndShow(editor2, range);
    }

    public void showHint(@NotNull Range range, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.renderer.showAfterScroll(editor2, range);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readLock(@NotNull Function0<? extends T> task) {
        Intrinsics.checkNotNullParameter(task, (String)"task");
        DocumentTracker.Lock this_$iv = this.LOCK;
        boolean $i$f$read = false;
        Lock lock = this_$iv.getMyLock();
        lock.lock();
        try {
            boolean bl = false;
            Object object = task.invoke();
            return (T)object;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void doFrozen(@NotNull Runnable task) {
        void this_$iv$iv;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        DocumentTracker this_$iv = this.stagedTracker;
        boolean $i$f$doFrozen = false;
        DocumentTracker documentTracker = this_$iv;
        Side side$iv$iv = Side.LEFT;
        boolean $i$f$doFrozen2 = false;
        this_$iv$iv.freeze(side$iv$iv);
        try {
            void this_$iv$iv2;
            boolean bl = false;
            DocumentTracker documentTracker2 = this_$iv;
            Side side$iv$iv2 = Side.RIGHT;
            boolean $i$f$doFrozen3 = false;
            this_$iv$iv2.freeze(side$iv$iv2);
            try {
                void this_$iv$iv3;
                boolean bl2 = false;
                boolean bl3 = false;
                DocumentTracker this_$iv2 = this.unstagedTracker;
                boolean $i$f$doFrozen4 = false;
                DocumentTracker documentTracker3 = this_$iv2;
                Side side$iv$iv3 = Side.LEFT;
                boolean $i$f$doFrozen5 = false;
                this_$iv$iv3.freeze(side$iv$iv3);
                try {
                    void this_$iv$iv4;
                    $i$a$-doFrozen-DocumentTracker$doFrozen$1$iv = false;
                    DocumentTracker documentTracker4 = this_$iv2;
                    Side side$iv$iv4 = Side.RIGHT;
                    boolean $i$f$doFrozen6 = false;
                    this_$iv$iv4.freeze(side$iv$iv4);
                    try {
                        $i$a$-doFrozen-DocumentTracker$doFrozen$1$1$iv = false;
                        boolean bl4 = false;
                        task.run();
                    }
                    finally {
                        this_$iv$iv4.unfreeze(side$iv$iv4);
                    }
                }
                finally {
                    this_$iv$iv3.unfreeze(side$iv$iv3);
                }
            }
            finally {
                this_$iv$iv2.unfreeze(side$iv$iv2);
            }
        }
        finally {
            this_$iv$iv.unfreeze(side$iv$iv);
        }
    }

    public void freeze() {
        this.unstagedTracker.freeze(Side.LEFT);
        this.unstagedTracker.freeze(Side.RIGHT);
        this.stagedTracker.freeze(Side.LEFT);
        this.stagedTracker.freeze(Side.RIGHT);
    }

    public void unfreeze() {
        this.unstagedTracker.unfreeze(Side.LEFT);
        this.unstagedTracker.unfreeze(Side.RIGHT);
        this.stagedTracker.unfreeze(Side.LEFT);
        this.stagedTracker.unfreeze(Side.RIGHT);
    }

    public void rollbackChanges(@NotNull Range range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        StagedRange stagedRange = (StagedRange)this.blockOperations.findBlock(range);
        if (stagedRange == null) {
            return;
        }
        StagedRange newRange = stagedRange;
        this.runBulkRollback(CollectionsKt.listOf((Object)((Object)newRange)));
    }

    public void rollbackChanges(@NotNull BitSet lines) {
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        List list = this.blockOperations.getRangesForLines(lines);
        if (list == null) {
            return;
        }
        List toRevert = list;
        this.runBulkRollback(toRevert);
    }

    @RequiresEdt
    private final void runBulkRollback(List<StagedRange> toRevert) {
        if (!this.isValid()) {
            return;
        }
        BlockFilter filter = BlockFilter.Companion.create(toRevert, Side.RIGHT);
        this.updateDocument(ThreeSide.RIGHT, GitBundle.message("stage.revert.unstaged.range.command.name", new Object[0]), (Function1<? super Document, Unit>)((Function1)arg_0 -> GitStageLineStatusTracker.runBulkRollback$lambda$9(this, filter, arg_0)));
    }

    public final void stageChanges(@NotNull Range range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        StagedRange stagedRange = (StagedRange)this.blockOperations.findBlock(range);
        if (stagedRange == null) {
            return;
        }
        StagedRange newRange = stagedRange;
        this.runBulkStage(CollectionsKt.listOf((Object)((Object)newRange)));
    }

    @RequiresEdt
    private final void runBulkStage(List<StagedRange> toRevert) {
        if (!this.isValid()) {
            return;
        }
        BlockFilter filter = BlockFilter.Companion.create(toRevert, Side.RIGHT);
        this.updateDocument(ThreeSide.BASE, GitBundle.message("stage.add.range.command.name", new Object[0]), (Function1<? super Document, Unit>)((Function1)arg_0 -> GitStageLineStatusTracker.runBulkStage$lambda$11(this, filter, arg_0)));
    }

    public final void unstageChanges(@NotNull Range range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        StagedRange stagedRange = (StagedRange)this.blockOperations.findBlock(range);
        if (stagedRange == null) {
            return;
        }
        StagedRange newRange = stagedRange;
        this.runBulkUnstage(CollectionsKt.listOf((Object)((Object)newRange)));
    }

    @RequiresEdt
    private final void runBulkUnstage(List<StagedRange> toRevert) {
        if (!this.isValid()) {
            return;
        }
        BlockFilter filter = BlockFilter.Companion.create(toRevert, Side.LEFT);
        this.updateDocument(ThreeSide.BASE, GitBundle.message("stage.revert.staged.range.command.name", new Object[0]), (Function1<? super Document, Unit>)((Function1)arg_0 -> GitStageLineStatusTracker.runBulkUnstage$lambda$13(this, filter, arg_0)));
    }

    public void addListener(@NotNull LineStatusTrackerListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.addListener((EventListener)listener2);
    }

    public void removeListener(@NotNull LineStatusTrackerListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.removeListener((EventListener)listener2);
    }

    private static final Unit setBaseRevision$lambda$1$lambda$0(GitStageLineStatusTracker this$0, CharSequence $vcsContent, Document it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.getVcsDocument().setText($vcsContent);
        return Unit.INSTANCE;
    }

    private static final void release$lambda$2(GitStageLineStatusTracker this$0) {
        if (this$0.isReleased()) {
            return;
        }
        this$0.isReleased = true;
        Disposer.dispose((Disposable)this$0.getDisposable());
    }

    private static final RangeExclusionState runBulkRollback$lambda$9$lambda$8(BlockFilter $filter, DocumentTracker.Block it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $filter.asExclusionState(it);
    }

    private static final Unit runBulkRollback$lambda$9(GitStageLineStatusTracker this$0, BlockFilter $filter, Document it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.unstagedTracker.partiallyApplyBlocks(Side.RIGHT, arg_0 -> GitStageLineStatusTracker.runBulkRollback$lambda$9$lambda$8($filter, arg_0));
        return Unit.INSTANCE;
    }

    private static final RangeExclusionState runBulkStage$lambda$11$lambda$10(BlockFilter $filter, DocumentTracker.Block it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $filter.asExclusionState(it);
    }

    private static final Unit runBulkStage$lambda$11(GitStageLineStatusTracker this$0, BlockFilter $filter, Document it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.unstagedTracker.partiallyApplyBlocks(Side.LEFT, arg_0 -> GitStageLineStatusTracker.runBulkStage$lambda$11$lambda$10($filter, arg_0));
        return Unit.INSTANCE;
    }

    private static final RangeExclusionState runBulkUnstage$lambda$13$lambda$12(BlockFilter $filter, DocumentTracker.Block it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $filter.asExclusionState(it);
    }

    private static final Unit runBulkUnstage$lambda$13(GitStageLineStatusTracker this$0, BlockFilter $filter, Document it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.stagedTracker.partiallyApplyBlocks(Side.RIGHT, arg_0 -> GitStageLineStatusTracker.runBulkUnstage$lambda$13$lambda$12($filter, arg_0));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nJ \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lgit4idea/index/GitStageLineStatusTracker$BlockFilter;", "", "bitSet1", "Ljava/util/BitSet;", "bitSet2", "<init>", "(Ljava/util/BitSet;Ljava/util/BitSet;)V", "matches", "", "block", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "asExclusionState", "Lcom/intellij/openapi/vcs/ex/RangeExclusionState;", "blockSide", "Lcom/intellij/diff/util/Side;", "bitSet", "Companion", "intellij.vcs.git"})
    private static final class BlockFilter {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final BitSet bitSet1;
        @NotNull
        private final BitSet bitSet2;

        public BlockFilter(@NotNull BitSet bitSet1, @NotNull BitSet bitSet2) {
            Intrinsics.checkNotNullParameter((Object)bitSet1, (String)"bitSet1");
            Intrinsics.checkNotNullParameter((Object)bitSet2, (String)"bitSet2");
            this.bitSet1 = bitSet1;
            this.bitSet2 = bitSet2;
        }

        public final boolean matches(@NotNull DocumentTracker.Block block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            return this.matches(block, Side.LEFT, this.bitSet1) || this.matches(block, Side.RIGHT, this.bitSet2);
        }

        @NotNull
        public final RangeExclusionState asExclusionState(@NotNull DocumentTracker.Block block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            return this.matches(block) ? (RangeExclusionState)RangeExclusionState.Included.INSTANCE : (RangeExclusionState)RangeExclusionState.Excluded.INSTANCE;
        }

        private final boolean matches(DocumentTracker.Block block, Side blockSide, BitSet bitSet) {
            int start = blockSide.select(block.getRange().start1, block.getRange().start2);
            int end = blockSide.select(block.getRange().end1, block.getRange().end2);
            int next = bitSet.nextSetBit(start);
            return next != -1 && next < end;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u000b\u001a\u00020\f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lgit4idea/index/GitStageLineStatusTracker$BlockFilter$Companion;", "", "<init>", "()V", "create", "Lgit4idea/index/GitStageLineStatusTracker$BlockFilter;", "ranges", "", "Lgit4idea/index/StagedRange;", "targetTracker", "Lcom/intellij/diff/util/Side;", "collectAffectedLines", "Ljava/util/BitSet;", "side", "Lcom/intellij/diff/util/ThreeSide;", "intellij.vcs.git"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final BlockFilter create(@NotNull List<StagedRange> ranges, @NotNull Side targetTracker) {
                Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
                Intrinsics.checkNotNullParameter((Object)targetTracker, (String)"targetTracker");
                Object object = targetTracker.selectNotNull((Object)ThreeSide.LEFT, (Object)ThreeSide.BASE);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"selectNotNull(...)");
                BitSet bitSet1 = this.collectAffectedLines(ranges, (ThreeSide)object);
                Object object2 = targetTracker.selectNotNull((Object)ThreeSide.BASE, (Object)ThreeSide.RIGHT);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"selectNotNull(...)");
                BitSet bitSet2 = this.collectAffectedLines(ranges, (ThreeSide)object2);
                return new BlockFilter(bitSet1, bitSet2);
            }

            private final BitSet collectAffectedLines(List<StagedRange> ranges, ThreeSide side) {
                BitSet bitSet;
                BitSet $this$collectAffectedLines_u24lambda_u240 = bitSet = new BitSet();
                boolean bl = false;
                for (StagedRange stagedRange : ranges) {
                    int line1 = side.select(stagedRange.getVcsLine1(), stagedRange.getStagedLine1(), stagedRange.getLine1());
                    int line2 = side.select(stagedRange.getVcsLine2(), stagedRange.getStagedLine2(), stagedRange.getLine2());
                    $this$collectAffectedLines_u24lambda_u240.set(line1, line2);
                }
                return bitSet;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\bH\u0014J\f\u0010\t\u001a\u00020\u0002*\u00020\u0002H\u0014\u00a8\u0006\n"}, d2={"Lgit4idea/index/GitStageLineStatusTracker$MyBlockOperations;", "Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBlockOperations;", "Lgit4idea/index/StagedRange;", "lock", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Lock;", "<init>", "(Lgit4idea/index/GitStageLineStatusTracker;Lcom/intellij/openapi/vcs/ex/DocumentTracker$Lock;)V", "getBlocks", "", "toRange", "intellij.vcs.git"})
    private final class MyBlockOperations
    extends LineStatusTrackerBlockOperations<StagedRange, StagedRange> {
        public MyBlockOperations(DocumentTracker.Lock lock) {
            Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
            super(lock);
        }

        @Nullable
        protected List<StagedRange> getBlocks() {
            return GitStageLineStatusTracker.this.isValid() ? GitStageLineStatusTracker.this.getBlocks() : null;
        }

        @NotNull
        protected StagedRange toRange(@NotNull StagedRange $this$toRange) {
            Intrinsics.checkNotNullParameter((Object)((Object)$this$toRange), (String)"<this>");
            return $this$toRange;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lgit4idea/index/GitStageLineStatusTracker$MyDocumentTrackerHandler;", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Handler;", "unstaged", "", "<init>", "(Lgit4idea/index/GitStageLineStatusTracker;Z)V", "wasEmpty", "afterBulkRangeChange", "", "isDirty", "onUnfreeze", "side", "Lcom/intellij/diff/util/Side;", "isTrackerEmpty", "intellij.vcs.git"})
    private final class MyDocumentTrackerHandler
    implements DocumentTracker.Handler {
        private final boolean unstaged;
        private boolean wasEmpty;

        public MyDocumentTrackerHandler(boolean unstaged) {
            this.unstaged = unstaged;
            this.wasEmpty = this.isTrackerEmpty();
        }

        public void afterBulkRangeChange(boolean isDirty) {
            boolean isEmpty;
            GitStageLineStatusTracker.this.cachedBlocks = null;
            GitStageLineStatusTracker.this.updateHighlighters();
            if (!isDirty) {
                ((LineStatusTrackerListener)GitStageLineStatusTracker.this.listeners.getMulticaster()).onRangesChanged();
            }
            if (GitStageLineStatusTracker.this.isOperational() && this.wasEmpty != (isEmpty = this.isTrackerEmpty())) {
                this.wasEmpty = isEmpty;
                if (isEmpty && this.unstaged) {
                    LineStatusTrackerKt.saveDocumentWhenUnchanged((Project)GitStageLineStatusTracker.this.getProject(), (Document)GitStageLineStatusTracker.this.getDocument());
                }
                LineStatusTrackerKt.saveDocumentWhenUnchanged((Project)GitStageLineStatusTracker.this.getProject(), (Document)GitStageLineStatusTracker.this.getStagedDocument());
            }
        }

        public void onUnfreeze(@NotNull Side side) {
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            GitStageLineStatusTracker.this.updateHighlighters();
            ((LineStatusTrackerListener)GitStageLineStatusTracker.this.listeners.getMulticaster()).onRangesChanged();
        }

        private final boolean isTrackerEmpty() {
            if (this.unstaged) {
                return GitStageLineStatusTracker.this.unstagedTracker.getBlocks().isEmpty();
            }
            return GitStageLineStatusTracker.this.stagedTracker.getBlocks().isEmpty();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001:\u0005VWXYZB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\b\u0010\b\u001a\u00020\u0007H\u0014J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J,\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u000eH\u0002JL\u0010\u0017\u001a\u00020\n*\u00020\u00132\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u001cH\u0002J>\u0010!\u001a\u00020\n*\u00020\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u001cH\u0002J<\u0010!\u001a\u00020\n*\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020'2\u0006\u0010#\u001a\u00020'2\u0006\u0010$\u001a\u00020'2\u0006\u0010%\u001a\u00020'2\u0006\u0010&\u001a\u00020'H\u0002JD\u0010(\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010)\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\u001cH\u0002J,\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010-\u001a\u00020\u000f2\b\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u000201H\u0014J\"\u00102\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010-\u001a\u00020\u000f2\b\u0010.\u001a\u0004\u0018\u00010/H\u0016J\u001e\u00103\u001a\u00020,2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000205J*\u00107\u001a\u00020,2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u00108\u001a\u0002092\u0006\u0010:\u001a\u0002052\u0006\u0010;\u001a\u00020\u0007H\u0002J(\u0010<\u001a\u0002052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\u001c2\u0006\u0010@\u001a\u00020\u001cH\u0002J0\u0010A\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002052\u0006\u0010-\u001a\u00020B2\u0006\u00100\u001a\u000201H\u0002JD\u0010C\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010D\u001a\u00020\u001c2\u0006\u0010E\u001a\u00020\u001c2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020G0\u000e2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020G0\u000e2\u0006\u0010I\u001a\u000201H\u0002J,\u0010J\u001a\u0004\u0018\u00010,2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010-\u001a\u00020\u000f2\b\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u000201H\u0002JQ\u0010K\u001a\u0006\u0012\u0002\b\u00030L2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00100\u001a\u0002012\u000b\u0010M\u001a\u000709\u00a2\u0006\u0002\bN2\u000b\u00108\u001a\u000709\u00a2\u0006\u0002\bO2\u000b\u0010P\u001a\u000709\u00a2\u0006\u0002\bO2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020\n0RH\u0002J(\u0010S\u001a\b\u0012\u0004\u0012\u00020T0\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010-\u001a\u00020\u000f2\b\u0010.\u001a\u0004\u0018\u00010/H\u0014J\b\u0010U\u001a\u000209H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006["}, d2={"Lgit4idea/index/GitStageLineStatusTracker$MyLineStatusMarkerPopupRenderer;", "Lcom/intellij/openapi/vcs/ex/LineStatusTrackerMarkerRenderer;", "tracker", "Lgit4idea/index/GitStageLineStatusTracker;", "<init>", "(Lgit4idea/index/GitStageLineStatusTracker;)V", "shouldPaintGutter", "", "shouldPaintErrorStripeMarkers", "paintGutterMarkers", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "ranges", "", "Lcom/intellij/openapi/vcs/ex/Range;", "g", "Ljava/awt/Graphics;", "paintStageLines", "Ljava/awt/Graphics2D;", "block", "Lcom/intellij/openapi/vcs/ex/ChangedLines;", "Lgit4idea/index/GitStageLineStatusTracker$MyLineStatusMarkerPopupRenderer$StageLineFlags;", "paintUnStagedChange", "change", "color", "Ljava/awt/Color;", "x", "", "endX", "midX", "start", "end", "paintHalfRoundedRect", "x1", "y1", "x2", "y2", "arc", "", "paintStripeTriangle", "borderColor", "y", "createAdditionalInfoPanel", "Ljavax/swing/JComponent;", "range", "mousePosition", "Ljava/awt/Point;", "disposable", "Lcom/intellij/openapi/Disposable;", "showHintAt", "createEditorComponent", "stagedTextField", "Lcom/intellij/ui/EditorTextField;", "vcsTextField", "createEditorPane", "text", "", "textField", "topBorder", "createTextField", "document", "Lcom/intellij/openapi/editor/Document;", "line1", "line2", "installWordDiff", "Lgit4idea/index/StagedRange;", "installMasterEditorWordHighlighters", "startLine", "endLine", "wordDiff1", "Lcom/intellij/diff/fragments/DiffFragment;", "wordDiff2", "parentDisposable", "createStageLinksPanel", "createStageLinkButton", "Lcom/intellij/ui/components/labels/LinkLabel;", "actionId", "Lorg/jetbrains/annotations/NonNls;", "Lorg/jetbrains/annotations/Nls;", "tooltipText", "callback", "Lkotlin/Function0;", "createToolbarActions", "Lcom/intellij/openapi/actionSystem/AnAction;", "toString", "StageLineFlags", "MyLineFlagProvider", "WordDiffMerger", "RollbackLineStatusRangeAction", "StageShowDiffAction", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitStageLineStatusTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitStageLineStatusTracker.kt\ngit4idea/index/GitStageLineStatusTracker$MyLineStatusMarkerPopupRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,975:1\n1863#2,2:976\n*S KotlinDebug\n*F\n+ 1 GitStageLineStatusTracker.kt\ngit4idea/index/GitStageLineStatusTracker$MyLineStatusMarkerPopupRenderer\n*L\n652#1:976,2\n*E\n"})
    private static final class MyLineStatusMarkerPopupRenderer
    extends LineStatusTrackerMarkerRenderer {
        @NotNull
        private final GitStageLineStatusTracker tracker;

        public MyLineStatusMarkerPopupRenderer(@NotNull GitStageLineStatusTracker tracker) {
            Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
            super((LineStatusTrackerI)tracker, MarkupEditorFilterFactory.createIsNotDiffFilter());
            this.tracker = tracker;
        }

        protected boolean shouldPaintGutter() {
            return this.tracker.getMode().isVisible();
        }

        protected boolean shouldPaintErrorStripeMarkers() {
            return this.tracker.getMode().isVisible() && this.tracker.getMode().getShowErrorStripeMarkers();
        }

        protected void paintGutterMarkers(@NotNull Editor editor2, @NotNull List<? extends Range> ranges, @NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            List list = VisibleRangeMerger.merge((Editor)editor2, ranges, (VisibleRangeMerger.FlagsProvider)MyLineFlagProvider.INSTANCE, (Rectangle)g.getClipBounds());
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"merge(...)");
            List blocks = list;
            for (ChangesBlock block : blocks) {
                Graphics2D graphics2D = (Graphics2D)g;
                List list2 = block.changes;
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"changes");
                this.paintStageLines(graphics2D, editor2, list2);
            }
        }

        private final void paintStageLines(Graphics2D g, Editor editor2, List<? extends ChangedLines<StageLineFlags>> block) {
            Color stagedBorderColor;
            int end;
            int start;
            boolean isNewUi = ExperimentalUI.Companion.isNewUI();
            Color borderColor = LineStatusMarkerColorScheme.DEFAULT.getBorderColor(editor2);
            IntPair intPair = LineStatusMarkerDrawUtil.getGutterArea((Editor)editor2);
            Intrinsics.checkNotNullExpressionValue((Object)intPair, (String)"getGutterArea(...)");
            IntPair area = intPair;
            int x = area.first;
            int endX = area.second;
            int midX = isNewUi ? (endX + x) / 2 : (endX + x + 3) / 2;
            int y = ((ChangedLines)CollectionsKt.first(block)).y1;
            int endY = ((ChangedLines)CollectionsKt.last(block)).y2;
            Intrinsics.checkNotNull((Object)editor2, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
            int hoveredLine = ((EditorEx)editor2).getGutterComponentEx().getHoveredFreeMarkersLine();
            for (ChangedLines<StageLineFlags> changedLines : block) {
                if (changedLines.y1 == changedLines.y2 || !((StageLineFlags)changedLines.flags).isUnstaged()) continue;
                start = changedLines.y1;
                end = changedLines.y2;
                Color gutterColor = LineStatusMarkerColorScheme.DEFAULT.getColor(editor2, changedLines.type);
                if (isNewUi && LineStatusMarkerDrawUtil.isRangeHovered((Editor)editor2, (int)hoveredLine, (int)x, (int)start, (int)end)) {
                    this.paintUnStagedChange(g, changedLines, gutterColor, x - 1, endX + 1, midX, start, end);
                    continue;
                }
                this.paintUnStagedChange(g, changedLines, gutterColor, x, endX, midX, start, end);
            }
            if (borderColor == null) {
                for (ChangedLines<StageLineFlags> changedLines : block) {
                    if (changedLines.y1 == changedLines.y2 || !((StageLineFlags)changedLines.flags).isStaged()) continue;
                    start = changedLines.y1;
                    end = changedLines.y2;
                    stagedBorderColor = LineStatusMarkerColorScheme.DEFAULT.getIgnoredBorderColor(editor2, changedLines.type);
                    if (isNewUi && LineStatusMarkerDrawUtil.isRangeHovered((Editor)editor2, (int)hoveredLine, (int)x, (int)start, (int)end)) {
                        LineStatusMarkerDrawUtil.paintRect((Graphics2D)g, null, (Color)stagedBorderColor, (int)(x - 1), (int)start, (int)(endX + 1), (int)end);
                        continue;
                    }
                    LineStatusMarkerDrawUtil.paintRect((Graphics2D)g, null, (Color)stagedBorderColor, (int)x, (int)start, (int)endX, (int)end);
                }
            } else if (y != endY) {
                if (isNewUi && LineStatusMarkerDrawUtil.isRangeHovered((Editor)editor2, (int)hoveredLine, (int)x, (int)y, (int)endY)) {
                    LineStatusMarkerDrawUtil.paintRect((Graphics2D)g, null, (Color)borderColor, (int)(x - 1), (int)y, (int)(endX + 1), (int)endY);
                } else {
                    LineStatusMarkerDrawUtil.paintRect((Graphics2D)g, null, (Color)borderColor, (int)x, (int)y, (int)endX, (int)endY);
                }
            }
            for (ChangedLines<StageLineFlags> changedLines : block) {
                if (changedLines.y1 != changedLines.y2) continue;
                start = changedLines.y1;
                Color gutterColor = LineStatusMarkerColorScheme.DEFAULT.getColor(editor2, changedLines.type);
                Color color = borderColor;
                if (color == null) {
                    color = stagedBorderColor = LineStatusMarkerColorScheme.DEFAULT.getIgnoredBorderColor(editor2, changedLines.type);
                }
                if (((StageLineFlags)changedLines.flags).isUnstaged() && ((StageLineFlags)changedLines.flags).isStaged()) {
                    this.paintStripeTriangle(g, editor2, gutterColor, stagedBorderColor, x, endX, start);
                    continue;
                }
                if (((StageLineFlags)changedLines.flags).isStaged()) {
                    LineStatusMarkerDrawUtil.paintTriangle((Graphics2D)g, (Editor)editor2, null, (Color)stagedBorderColor, (int)x, (int)endX, (int)start);
                    continue;
                }
                LineStatusMarkerDrawUtil.paintTriangle((Graphics2D)g, (Editor)editor2, (Color)gutterColor, (Color)borderColor, (int)x, (int)endX, (int)start);
            }
        }

        private final void paintUnStagedChange(Graphics2D $this$paintUnStagedChange, ChangedLines<StageLineFlags> change, Color color, int x, int endX, int midX, int start, int end) {
            if (((StageLineFlags)change.flags).isStaged()) {
                if (ExperimentalUI.Companion.isNewUI()) {
                    this.paintHalfRoundedRect($this$paintUnStagedChange, color, x, start + 1, midX, end - 1, endX - x);
                } else {
                    LineStatusMarkerDrawUtil.paintRect((Graphics2D)$this$paintUnStagedChange, (Color)color, null, (int)x, (int)start, (int)midX, (int)end);
                }
            } else {
                LineStatusMarkerDrawUtil.paintRect((Graphics2D)$this$paintUnStagedChange, (Color)color, null, (int)x, (int)start, (int)endX, (int)end);
            }
        }

        private final void paintHalfRoundedRect(Graphics2D $this$paintHalfRoundedRect, Color color, int x1, int y1, int x2, int y2, int arc) {
            if (color == null) {
                return;
            }
            this.paintHalfRoundedRect($this$paintHalfRoundedRect, color, (double)x1, (double)y1, (double)x2, (double)y2, (double)arc);
        }

        private final void paintHalfRoundedRect(Graphics2D $this$paintHalfRoundedRect, Color color, double x1, double y1, double x2, double y2, double arc) {
            Path2D.Double path = new Path2D.Double();
            path.moveTo(x1, y1 + arc);
            path.quadTo(x1, y1, x1 + arc, y1);
            path.lineTo(x2, y1);
            path.lineTo(x2, y2);
            path.lineTo(x1 + arc, y2);
            path.quadTo(x1, y2, x1, y2 - arc);
            path.closePath();
            $this$paintHalfRoundedRect.setColor(color);
            PaintUtil.paintWithAA((Graphics2D)$this$paintHalfRoundedRect, (Object)RenderingHints.VALUE_ANTIALIAS_DEFAULT, () -> MyLineStatusMarkerPopupRenderer.paintHalfRoundedRect$lambda$0($this$paintHalfRoundedRect, path));
        }

        private final void paintStripeTriangle(Graphics2D g, Editor editor2, Color color, Color borderColor, int x1, int x2, int y) {
            int y2 = y;
            float editorScale = editor2 instanceof EditorImpl ? ((EditorImpl)editor2).getScale() : 1.0f;
            int size = (int)JBUIScale.scale((float)((float)5 * editorScale));
            if (y2 < size) {
                y2 = size;
            }
            int[] nArray = new int[]{x1, x1, x2};
            int[] xPoints = nArray;
            int[] nArray2 = new int[]{y2 - size, y2 + size, y2};
            int[] yPointsBorder = nArray2;
            int[] nArray3 = new int[]{y2 - size, y2, y2};
            int[] yPointsFill = nArray3;
            if (color != null) {
                g.setColor(color);
                g.fillPolygon(xPoints, yPointsFill, xPoints.length);
            }
            if (borderColor != null) {
                g.setColor(borderColor);
                Stroke oldStroke = g.getStroke();
                g.setStroke(new BasicStroke(JBUIScale.scale((int)1)));
                g.drawPolygon(xPoints, yPointsBorder, xPoints.length);
                g.setStroke(oldStroke);
            }
        }

        @Nullable
        protected JComponent createAdditionalInfoPanel(@NotNull Editor editor2, @NotNull Range range, @Nullable Point mousePosition, @NotNull Disposable disposable) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            return this.createStageLinksPanel(editor2, range, mousePosition, disposable);
        }

        public void showHintAt(@NotNull Editor editor2, @NotNull Range range, @Nullable Point mousePosition) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            if (!this.tracker.isValid()) {
                return;
            }
            StagedRange cfr_ignored_0 = (StagedRange)range;
            if (!((StagedRange)range).getHasStaged() || !((StagedRange)range).getHasUnstaged()) {
                super.showHintAt(editor2, range, mousePosition);
                return;
            }
            Disposable disposable = Disposer.newDisposable((Disposable)this.tracker.getDisposable());
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
            Disposable popupDisposable = disposable;
            EditorTextField stagedTextField = this.createTextField(editor2, this.tracker.getStagedDocument(), ((StagedRange)range).getStagedLine1(), ((StagedRange)range).getStagedLine2());
            EditorTextField vcsTextField = this.createTextField(editor2, this.tracker.getVcsDocument(), range.getVcsLine1(), range.getVcsLine2());
            this.installWordDiff(editor2, stagedTextField, vcsTextField, (StagedRange)range, popupDisposable);
            JComponent editorsPanel = this.createEditorComponent(editor2, stagedTextField, vcsTextField);
            List<AnAction> actions2 = this.createToolbarActions(editor2, range, mousePosition);
            ActionToolbar actionToolbar = LineStatusMarkerPopupPanel.buildToolbar((Editor)editor2, actions2, (Disposable)popupDisposable);
            Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"buildToolbar(...)");
            ActionToolbar toolbar = actionToolbar;
            JComponent additionalPanel = this.createStageLinksPanel(editor2, range, mousePosition, popupDisposable);
            LineStatusMarkerPopupPanel lineStatusMarkerPopupPanel = LineStatusMarkerPopupPanel.create((Editor)editor2, (ActionToolbar)toolbar, (JComponent)editorsPanel, (JComponent)additionalPanel);
            Intrinsics.checkNotNullExpressionValue((Object)lineStatusMarkerPopupPanel, (String)"create(...)");
            LineStatusMarkerPopupPanel popupPanel = lineStatusMarkerPopupPanel;
            toolbar.setTargetComponent((JComponent)popupPanel);
            LineStatusMarkerPopupPanel.showPopupAt((Editor)editor2, (LineStatusMarkerPopupPanel)popupPanel, (Point)mousePosition, (Disposable)popupDisposable);
        }

        @NotNull
        public final JComponent createEditorComponent(@NotNull Editor editor2, @NotNull EditorTextField stagedTextField, @NotNull EditorTextField vcsTextField) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)stagedTextField, (String)"stagedTextField");
            Intrinsics.checkNotNullParameter((Object)vcsTextField, (String)"vcsTextField");
            String string = GitBundle.message("stage.content.staged", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            JComponent stagedEditorPane = this.createEditorPane(editor2, string, stagedTextField, true);
            JComponent vcsEditorPane = this.createEditorPane(editor2, "HEAD", vcsTextField, false);
            JPanel editorsPanel = new JPanel(new StagePopupVerticalLayout());
            editorsPanel.add(stagedEditorPane);
            editorsPanel.add(vcsEditorPane);
            editorsPanel.setBackground(LineStatusMarkerPopupPanel.getEditorBackgroundColor((Editor)editor2));
            return editorsPanel;
        }

        private final JComponent createEditorPane(Editor editor2, @Nls String text2, EditorTextField textField, boolean topBorder) {
            JBLabel label = new JBLabel(text2);
            label.setBorder((Border)JBUI.Borders.emptyBottom((int)2));
            label.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
            label.setForeground(UIUtil.getLabelDisabledForeground());
            Color color = LineStatusMarkerPopupPanel.getBorderColor();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getBorderColor(...)");
            Color borderColor = color;
            Border border = JBUI.Borders.customLine((Color)borderColor, (int)(topBorder ? 1 : 0), (int)1, (int)1, (int)1);
            Intrinsics.checkNotNullExpressionValue((Object)border, (String)"customLine(...)");
            Border outerLineBorder = border;
            Border border2 = JBUI.Borders.empty((int)2);
            Intrinsics.checkNotNullExpressionValue((Object)border2, (String)"empty(...)");
            Border innerEmptyBorder = border2;
            CompoundBorder border3 = BorderFactory.createCompoundBorder(outerLineBorder, innerEmptyBorder);
            JBPanel jBPanel = ((BorderLayoutPanel)JBUI.Panels.simplePanel((Component)((Component)textField)).addToTop((Component)label).withBackground(LineStatusMarkerPopupPanel.getEditorBackgroundColor((Editor)editor2))).withBorder((Border)border3);
            Intrinsics.checkNotNullExpressionValue((Object)jBPanel, (String)"withBorder(...)");
            return (JComponent)jBPanel;
        }

        private final EditorTextField createTextField(Editor editor2, Document document, int line1, int line2) {
            TextRange textRange = DiffUtil.getLinesRange((Document)document, (int)line1, (int)line2);
            String content = ((Object)textRange.subSequence(document.getImmutableCharSequence())).toString();
            EditorTextField editorTextField = LineStatusMarkerPopupPanel.createTextField((Editor)editor2, (String)content);
            Intrinsics.checkNotNullExpressionValue((Object)editorTextField, (String)"createTextField(...)");
            EditorTextField textField = editorTextField;
            LineStatusMarkerPopupPanel.installBaseEditorSyntaxHighlighters((Project)this.tracker.getProject(), (EditorTextField)textField, (Document)document, (TextRange)textRange, (FileType)this.getFileType());
            return textField;
        }

        private final void installWordDiff(Editor editor2, EditorTextField stagedTextField, EditorTextField vcsTextField, StagedRange range, Disposable disposable) {
            if (!DiffApplicationSettings.getInstance().SHOW_LST_WORD_DIFFERENCES) {
                return;
            }
            if (!range.hasLines()) {
                return;
            }
            CharSequence charSequence = DiffUtil.getLinesContent((Document)this.tracker.getDocument(), (int)range.getLine1(), (int)range.getLine2());
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getLinesContent(...)");
            CharSequence currentContent = charSequence;
            CharSequence charSequence2 = DiffUtil.getLinesContent((Document)this.tracker.getStagedDocument(), (int)range.getStagedLine1(), (int)range.getStagedLine2());
            Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"getLinesContent(...)");
            CharSequence stagedContent = charSequence2;
            CharSequence charSequence3 = DiffUtil.getLinesContent((Document)this.tracker.getVcsDocument(), (int)range.getVcsLine1(), (int)range.getVcsLine2());
            Intrinsics.checkNotNullExpressionValue((Object)charSequence3, (String)"getLinesContent(...)");
            CharSequence vcsContent = charSequence3;
            Pair pair = (Pair)BackgroundTaskUtil.tryComputeFast(arg_0 -> MyLineStatusMarkerPopupRenderer.installWordDiff$lambda$2(arg_0 -> MyLineStatusMarkerPopupRenderer.installWordDiff$lambda$1(range, stagedContent, currentContent, vcsContent, arg_0), arg_0), (long)200L);
            if (pair == null) {
                return;
            }
            Pair pair2 = pair;
            List stagedWordDiff = (List)pair2.component1();
            List vcsWordDiff = (List)pair2.component2();
            if (stagedWordDiff != null) {
                LineStatusMarkerPopupPanel.installPopupEditorWordHighlighters((EditorTextField)stagedTextField, (List)stagedWordDiff);
            }
            if (vcsWordDiff != null) {
                LineStatusMarkerPopupPanel.installPopupEditorWordHighlighters((EditorTextField)vcsTextField, (List)vcsWordDiff);
            }
            if (stagedWordDiff != null || vcsWordDiff != null) {
                List list;
                int n = range.getLine1();
                int n2 = range.getLine2();
                List list2 = stagedWordDiff;
                if (list2 == null) {
                    list2 = CollectionsKt.emptyList();
                }
                if ((list = vcsWordDiff) == null) {
                    list = CollectionsKt.emptyList();
                }
                this.installMasterEditorWordHighlighters(editor2, n, n2, list2, list, disposable);
            }
        }

        private final void installMasterEditorWordHighlighters(Editor editor2, int startLine, int endLine, List<? extends DiffFragment> wordDiff1, List<? extends DiffFragment> wordDiff2, Disposable parentDisposable) {
            TextRange currentTextRange = DiffUtil.getLinesRange((Document)editor2.getDocument(), (int)startLine, (int)endLine);
            DiffDrawUtil.setupLayeredRendering((Editor)editor2, (int)startLine, (int)endLine, (int)1, (Disposable)parentDisposable);
            List highlighters = new ArrayList();
            Collection collection = highlighters;
            List list = new DiffDrawUtil.LineHighlighterBuilder(editor2, startLine, endLine, TextDiffType.MODIFIED).withLayerPriority(1).withIgnored(true).withHideStripeMarkers(true).withHideGutterMarkers(true).done();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"done(...)");
            Iterable iterable = list;
            CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
            CollectionsKt.addAll((Collection)highlighters, (Iterable)new WordDiffMerger(editor2, currentTextRange.getStartOffset(), wordDiff1, wordDiff2).run());
            Disposer.register((Disposable)parentDisposable, () -> MyLineStatusMarkerPopupRenderer.installMasterEditorWordHighlighters$lambda$3(highlighters));
        }

        private final JComponent createStageLinksPanel(Editor editor2, Range range, Point mousePosition, Disposable disposable) {
            if (!(range instanceof StagedRange)) {
                return null;
            }
            JPanel panel2 = new JPanel();
            panel2.setLayout(new BoxLayout(panel2, 0));
            panel2.setBorder((Border)JBUI.Borders.emptyRight((int)10));
            panel2.setOpaque(false);
            panel2.add((Component)new VerticalSeparatorComponent());
            panel2.add(Box.createHorizontalStrut(JBUI.scale((int)10)));
            if (((StagedRange)range).getHasUnstaged()) {
                String string = GitBundle.message("action.label.add.unstaged.range", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String string2 = GitBundle.message("action.label.add.unstaged.range.tooltip", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                LinkLabel<?> stageLink = this.createStageLinkButton(editor2, disposable, "Git.Stage.Add", string, string2, (Function0<Unit>)((Function0)() -> MyLineStatusMarkerPopupRenderer.createStageLinksPanel$lambda$4(this, range, editor2, mousePosition)));
                panel2.add((Component)stageLink);
            }
            if (((StagedRange)range).getHasStaged()) {
                if (((StagedRange)range).getHasUnstaged()) {
                    panel2.add(Box.createHorizontalStrut(JBUI.scale((int)16)));
                }
                String string = GitBundle.message("action.label.reset.staged.range", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String string3 = GitBundle.message("action.label.reset.staged.range.tooltip", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                LinkLabel<?> unstageLink = this.createStageLinkButton(editor2, disposable, "Git.Stage.Reset", string, string3, (Function0<Unit>)((Function0)() -> MyLineStatusMarkerPopupRenderer.createStageLinksPanel$lambda$5(this, range, editor2, mousePosition)));
                panel2.add((Component)unstageLink);
            }
            return panel2;
        }

        private final LinkLabel<?> createStageLinkButton(Editor editor2, Disposable disposable, String actionId, String text2, String tooltipText, Function0<Unit> callback) {
            ShortcutSet shortcutSet = ActionManager.getInstance().getAction(actionId).getShortcutSet();
            Intrinsics.checkNotNullExpressionValue((Object)shortcutSet, (String)"getShortcutSet(...)");
            ShortcutSet shortcut = shortcutSet;
            Shortcut[] shortcutArray = shortcut.getShortcuts();
            Intrinsics.checkNotNullExpressionValue((Object)shortcutArray, (String)"getShortcuts(...)");
            Shortcut[] shortcuts = shortcutArray;
            LinkLabel linkLabel = LinkLabel.create((String)text2, () -> MyLineStatusMarkerPopupRenderer.createStageLinkButton$lambda$6(callback));
            Intrinsics.checkNotNullExpressionValue((Object)linkLabel, (String)"create(...)");
            LinkLabel link = linkLabel;
            link.setToolTipText(DiffUtil.createTooltipText((String)tooltipText, (String)StringUtil.nullize((String)KeymapUtil.getShortcutsText((Shortcut[])shortcuts))));
            if (!(shortcuts.length == 0)) {
                new DumbAwareAction(link){
                    final /* synthetic */ LinkLabel<?> $link;
                    {
                        this.$link = $link;
                    }

                    public void actionPerformed(AnActionEvent e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        this.$link.doClick();
                    }
                }.registerCustomShortcutSet(shortcut, editor2.getComponent(), disposable);
            }
            return link;
        }

        @NotNull
        protected List<AnAction> createToolbarActions(@NotNull Editor editor2, @NotNull Range range, @Nullable Point mousePosition) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            ArrayList<Object> actions2 = new ArrayList<Object>();
            actions2.add(new LineStatusMarkerPopupActions.ShowPrevChangeMarkerAction(editor2, (LineStatusTrackerI)this.tracker, range, (LineStatusMarkerRendererWithPopupController)this));
            actions2.add(new LineStatusMarkerPopupActions.ShowNextChangeMarkerAction(editor2, (LineStatusTrackerI)this.tracker, range, (LineStatusMarkerRendererWithPopupController)this));
            actions2.add((Object)new RollbackLineStatusRangeAction(editor2, range));
            actions2.add((Object)new StageShowDiffAction(editor2, range));
            actions2.add(new LineStatusMarkerPopupActions.CopyLineStatusRangeAction(editor2, (LineStatusTrackerI)this.tracker, range));
            actions2.add(new LineStatusMarkerPopupActions.ToggleByWordDiffAction(editor2, (LineStatusTrackerI)this.tracker, range, mousePosition, (LineStatusMarkerRendererWithPopupController)this));
            return actions2;
        }

        @NotNull
        public String toString() {
            return "GitStageLineStatusTracker.MyLineStatusMarkerPopupRenderer(tracker=" + this.tracker + ")";
        }

        private static final void paintHalfRoundedRect$lambda$0(Graphics2D $this_paintHalfRoundedRect, Path2D.Double $path) {
            $this_paintHalfRoundedRect.fill($path);
        }

        private static final Pair installWordDiff$lambda$1(StagedRange $range, CharSequence $stagedContent, CharSequence $currentContent, CharSequence $vcsContent, ProgressIndicator indicator) {
            return new Pair((Object)($range.hasStagedLines() ? ByWord.compare((CharSequence)$stagedContent, (CharSequence)$currentContent, (ComparisonPolicy)ComparisonPolicy.DEFAULT, (ProgressIndicator)indicator) : null), $range.hasVcsLines() ? ByWord.compare((CharSequence)$vcsContent, (CharSequence)$currentContent, (ComparisonPolicy)ComparisonPolicy.DEFAULT, (ProgressIndicator)indicator) : null);
        }

        private static final Pair installWordDiff$lambda$2(Function1 $tmp0, Object p0) {
            return (Pair)$tmp0.invoke(p0);
        }

        private static final void installMasterEditorWordHighlighters$lambda$3(List $highlighters) {
            Iterable $this$forEach$iv = $highlighters;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RangeHighlighter p0 = (RangeHighlighter)element$iv;
                boolean bl = false;
                boolean $i$f$installMasterEditorWordHighlighters$lambda$3$stub_for_inlining = false;
                p0.dispose();
            }
        }

        private static final Unit createStageLinksPanel$lambda$4(MyLineStatusMarkerPopupRenderer this$0, Range $range, Editor $editor, Point $mousePosition) {
            this$0.tracker.stageChanges($range);
            this$0.reopenRange($editor, $range, $mousePosition);
            return Unit.INSTANCE;
        }

        private static final Unit createStageLinksPanel$lambda$5(MyLineStatusMarkerPopupRenderer this$0, Range $range, Editor $editor, Point $mousePosition) {
            this$0.tracker.unstageChanges($range);
            this$0.reopenRange($editor, $range, $mousePosition);
            return Unit.INSTANCE;
        }

        private static final void createStageLinkButton$lambda$6(Function0 $tmp0) {
            $tmp0.invoke();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lgit4idea/index/GitStageLineStatusTracker$MyLineStatusMarkerPopupRenderer$MyLineFlagProvider;", "Lcom/intellij/openapi/vcs/ex/VisibleRangeMerger$FlagsProvider;", "Lgit4idea/index/GitStageLineStatusTracker$MyLineStatusMarkerPopupRenderer$StageLineFlags;", "<init>", "()V", "getFlags", "range", "Lcom/intellij/openapi/vcs/ex/Range;", "mergeFlags", "flags1", "flags2", "intellij.vcs.git"})
        public static final class MyLineFlagProvider
        implements VisibleRangeMerger.FlagsProvider<StageLineFlags> {
            @NotNull
            public static final MyLineFlagProvider INSTANCE = new MyLineFlagProvider();

            private MyLineFlagProvider() {
            }

            @NotNull
            public StageLineFlags getFlags(@NotNull Range range) {
                Intrinsics.checkNotNullParameter((Object)range, (String)"range");
                StagedRange cfr_ignored_0 = (StagedRange)range;
                return new StageLineFlags(((StagedRange)range).getHasStaged(), ((StagedRange)range).getHasUnstaged());
            }

            @NotNull
            public StageLineFlags mergeFlags(@NotNull StageLineFlags flags1, @NotNull StageLineFlags flags2) {
                Intrinsics.checkNotNullParameter((Object)flags1, (String)"flags1");
                Intrinsics.checkNotNullParameter((Object)flags2, (String)"flags2");
                return new StageLineFlags(flags1.isStaged() || flags2.isStaged(), flags1.isUnstaged() || flags2.isUnstaged());
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0014J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\f"}, d2={"Lgit4idea/index/GitStageLineStatusTracker$MyLineStatusMarkerPopupRenderer$RollbackLineStatusRangeAction;", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerPopupActions$RangeMarkerAction;", "editor", "Lcom/intellij/openapi/editor/Editor;", "range", "Lcom/intellij/openapi/vcs/ex/Range;", "<init>", "(Lgit4idea/index/GitStageLineStatusTracker$MyLineStatusMarkerPopupRenderer;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/vcs/ex/Range;)V", "isEnabled", "", "actionPerformed", "", "intellij.vcs.git"})
        private final class RollbackLineStatusRangeAction
        extends LineStatusMarkerPopupActions.RangeMarkerAction {
            public RollbackLineStatusRangeAction(@NotNull Editor editor2, Range range) {
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)range, (String)"range");
                super(editor2, (LineStatusMarkerRangesSource)MyLineStatusMarkerPopupRenderer.this.tracker, range, "Vcs.RollbackChangedLines");
            }

            protected boolean isEnabled(@NotNull Editor editor2, @NotNull Range range) {
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)range, (String)"range");
                return ((StagedRange)range).getHasUnstaged();
            }

            protected void actionPerformed(@NotNull Editor editor2, @NotNull Range range) {
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)range, (String)"range");
                RollbackLineStatusAction.rollback((LineStatusTrackerI)((LineStatusTrackerI)MyLineStatusMarkerPopupRenderer.this.tracker), (Range)range, (Editor)editor2);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007\u00a8\u0006\b"}, d2={"Lgit4idea/index/GitStageLineStatusTracker$MyLineStatusMarkerPopupRenderer$StageLineFlags;", "", "isStaged", "", "isUnstaged", "<init>", "(ZZ)V", "()Z", "intellij.vcs.git"})
        public static final class StageLineFlags {
            private final boolean isStaged;
            private final boolean isUnstaged;

            public StageLineFlags(boolean isStaged, boolean isUnstaged) {
                this.isStaged = isStaged;
                this.isUnstaged = isUnstaged;
            }

            public final boolean isStaged() {
                return this.isStaged;
            }

            public final boolean isUnstaged() {
                return this.isUnstaged;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J0\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\nH\u0002\u00a8\u0006\u0016"}, d2={"Lgit4idea/index/GitStageLineStatusTracker$MyLineStatusMarkerPopupRenderer$StageShowDiffAction;", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerPopupActions$RangeMarkerAction;", "Lcom/intellij/ide/lightEdit/LightEditCompatible;", "editor", "Lcom/intellij/openapi/editor/Editor;", "range", "Lcom/intellij/openapi/vcs/ex/Range;", "<init>", "(Lgit4idea/index/GitStageLineStatusTracker$MyLineStatusMarkerPopupRenderer;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/vcs/ex/Range;)V", "isEnabled", "", "actionPerformed", "", "createDiffContent", "Lcom/intellij/diff/contents/DiffContent;", "document", "Lcom/intellij/openapi/editor/Document;", "line1", "", "line2", "canExpandBefore", "canExpandAfter", "intellij.vcs.git"})
        private final class StageShowDiffAction
        extends LineStatusMarkerPopupActions.RangeMarkerAction
        implements LightEditCompatible {
            public StageShowDiffAction(@NotNull Editor editor2, Range range) {
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)range, (String)"range");
                super(editor2, (LineStatusMarkerRangesSource)MyLineStatusMarkerPopupRenderer.this.tracker, range, "Diff.ShowDiff");
            }

            protected boolean isEnabled(@NotNull Editor editor2, @NotNull Range range) {
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)range, (String)"range");
                return true;
            }

            protected void actionPerformed(@NotNull Editor editor2, @NotNull Range range) {
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)range, (String)"range");
                StagedRange cfr_ignored_0 = (StagedRange)range;
                boolean canExpandBefore = range.getLine1() != 0 && ((StagedRange)range).getStagedLine1() != 0 && range.getVcsLine1() != 0;
                boolean canExpandAfter = range.getLine2() < DiffUtil.getLineCount((Document)MyLineStatusMarkerPopupRenderer.this.tracker.getDocument()) && ((StagedRange)range).getStagedLine2() < DiffUtil.getLineCount((Document)MyLineStatusMarkerPopupRenderer.this.tracker.getStagedDocument()) && range.getVcsLine2() < DiffUtil.getLineCount((Document)MyLineStatusMarkerPopupRenderer.this.tracker.getVcsDocument());
                DiffContent currentContent = this.createDiffContent(MyLineStatusMarkerPopupRenderer.this.tracker.getDocument(), range.getLine1(), range.getLine2(), canExpandBefore, canExpandAfter);
                DiffContent stagedContent = this.createDiffContent(MyLineStatusMarkerPopupRenderer.this.tracker.getStagedDocument(), ((StagedRange)range).getStagedLine1(), ((StagedRange)range).getStagedLine2(), canExpandBefore, canExpandAfter);
                DiffContent vcsContent = this.createDiffContent(MyLineStatusMarkerPopupRenderer.this.tracker.getVcsDocument(), range.getVcsLine1(), range.getVcsLine2(), canExpandBefore, canExpandAfter);
                SimpleDiffRequest request = new SimpleDiffRequest(DiffBundle.message((String)"dialog.title.diff.for.range", (Object[])new Object[0]), vcsContent, stagedContent, currentContent, "HEAD", GitBundle.message("stage.content.staged", new Object[0]), GitBundle.message("stage.content.local", new Object[0]));
                request.putUserData(DiffUserDataKeysEx.VCS_DIFF_ACCEPT_RIGHT_TO_BASE_ACTION_TEXT, (Object)GitBundle.message("action.label.add.unstaged.range", new Object[0]));
                request.putUserData(DiffUserDataKeysEx.VCS_DIFF_ACCEPT_BASE_TO_RIGHT_ACTION_TEXT, (Object)DiffBundle.message((String)"action.presentation.diff.revert.text", (Object[])new Object[0]));
                request.putUserData(DiffUserDataKeysEx.VCS_DIFF_ACCEPT_LEFT_TO_BASE_ACTION_TEXT, (Object)GitBundle.message("action.label.reset.staged.range", new Object[0]));
                DiffManager.getInstance().showDiff(MyLineStatusMarkerPopupRenderer.this.tracker.getProject(), (DiffRequest)request);
            }

            private final DiffContent createDiffContent(Document document, int line1, int line2, boolean canExpandBefore, boolean canExpandAfter) {
                TextRange textRange = DiffUtil.getLinesRange((Document)document, (int)(line1 - (canExpandBefore ? 1 : 0)), (int)(line2 + (canExpandAfter ? 1 : 0)));
                DocumentContent documentContent = DiffContentFactory.getInstance().create(MyLineStatusMarkerPopupRenderer.this.tracker.getProject(), document, MyLineStatusMarkerPopupRenderer.this.tracker.getVirtualFile());
                Intrinsics.checkNotNullExpressionValue((Object)documentContent, (String)"create(...)");
                DocumentContent content = documentContent;
                DocumentContent documentContent2 = DiffContentFactory.getInstance().createFragment(MyLineStatusMarkerPopupRenderer.this.tracker.getProject(), content, textRange);
                Intrinsics.checkNotNullExpressionValue((Object)documentContent2, (String)"createFragment(...)");
                return (DiffContent)documentContent2;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\bH\u0002J\u0018\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lgit4idea/index/GitStageLineStatusTracker$MyLineStatusMarkerPopupRenderer$WordDiffMerger;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "currentStartOffset", "", "wordDiff1", "", "Lcom/intellij/diff/fragments/DiffFragment;", "wordDiff2", "<init>", "(Lcom/intellij/openapi/editor/Editor;ILjava/util/List;Ljava/util/List;)V", "highlighters", "", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "getHighlighters", "()Ljava/util/List;", "dirtyStart", "dirtyEnd", "affectedFragments", "run", "handleFragment", "", "fragment", "markDirtyRange", "start", "end", "flush", "nextLine", "intellij.vcs.git"})
        @SourceDebugExtension(value={"SMAP\nGitStageLineStatusTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitStageLineStatusTracker.kt\ngit4idea/index/GitStageLineStatusTracker$MyLineStatusMarkerPopupRenderer$WordDiffMerger\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,975:1\n1557#2:976\n1628#2,3:977\n*S KotlinDebug\n*F\n+ 1 GitStageLineStatusTracker.kt\ngit4idea/index/GitStageLineStatusTracker$MyLineStatusMarkerPopupRenderer$WordDiffMerger\n*L\n715#1:976\n715#1:977,3\n*E\n"})
        private static final class WordDiffMerger {
            @NotNull
            private final Editor editor;
            private final int currentStartOffset;
            @NotNull
            private final List<DiffFragment> wordDiff1;
            @NotNull
            private final List<DiffFragment> wordDiff2;
            @NotNull
            private final List<RangeHighlighter> highlighters;
            private int dirtyStart;
            private int dirtyEnd;
            @NotNull
            private final List<DiffFragment> affectedFragments;

            public WordDiffMerger(@NotNull Editor editor2, int currentStartOffset, @NotNull List<? extends DiffFragment> wordDiff1, @NotNull List<? extends DiffFragment> wordDiff2) {
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                Intrinsics.checkNotNullParameter(wordDiff1, (String)"wordDiff1");
                Intrinsics.checkNotNullParameter(wordDiff2, (String)"wordDiff2");
                this.editor = editor2;
                this.currentStartOffset = currentStartOffset;
                this.wordDiff1 = wordDiff1;
                this.wordDiff2 = wordDiff2;
                this.highlighters = new ArrayList();
                this.dirtyStart = -1;
                this.dirtyEnd = -1;
                this.affectedFragments = new ArrayList();
            }

            @NotNull
            public final List<RangeHighlighter> getHighlighters() {
                return this.highlighters;
            }

            @NotNull
            public final List<RangeHighlighter> run() {
                PeekableIteratorWrapper it1 = new PeekableIteratorWrapper(this.wordDiff1.iterator());
                PeekableIteratorWrapper it2 = new PeekableIteratorWrapper(this.wordDiff2.iterator());
                while (it1.hasNext() || it2.hasNext()) {
                    if (!it2.hasNext()) {
                        Object object = it1.next();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"next(...)");
                        this.handleFragment((DiffFragment)object);
                        continue;
                    }
                    if (!it1.hasNext()) {
                        Object object = it2.next();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"next(...)");
                        this.handleFragment((DiffFragment)object);
                        continue;
                    }
                    DiffFragment fragment1 = (DiffFragment)it1.peek();
                    DiffFragment fragment2 = (DiffFragment)it2.peek();
                    if (fragment1.getStartOffset2() <= fragment2.getStartOffset2()) {
                        Object object = it1.next();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"next(...)");
                        this.handleFragment((DiffFragment)object);
                        continue;
                    }
                    Object object = it2.next();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"next(...)");
                    this.handleFragment((DiffFragment)object);
                }
                this.flush(Integer.MAX_VALUE);
                return this.highlighters;
            }

            private final void handleFragment(DiffFragment fragment) {
                this.flush(fragment.getStartOffset2());
                this.markDirtyRange(fragment.getStartOffset2(), fragment.getEndOffset2());
                this.affectedFragments.add(fragment);
            }

            private final void markDirtyRange(int start, int end) {
                if (this.dirtyEnd == -1) {
                    this.dirtyStart = start;
                    this.dirtyEnd = end;
                } else {
                    this.dirtyEnd = Math.max(this.dirtyEnd, end);
                }
            }

            /*
             * WARNING - void declaration
             */
            private final void flush(int nextLine) {
                if (this.dirtyEnd != -1 && this.dirtyEnd < nextLine) {
                    void $this$mapTo$iv$iv;
                    int currentStart = this.currentStartOffset + this.dirtyStart;
                    int currentEnd = this.currentStartOffset + this.dirtyEnd;
                    Iterable $this$map$iv = this.affectedFragments;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        DiffFragment diffFragment = (DiffFragment)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(DiffUtil.getDiffType((DiffFragment)it));
                    }
                    TextDiffType textDiffType = (TextDiffType)CollectionsKt.singleOrNull((List)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
                    if (textDiffType == null) {
                        TextDiffType textDiffType2 = TextDiffType.MODIFIED;
                        textDiffType = textDiffType2;
                        Intrinsics.checkNotNullExpressionValue((Object)textDiffType2, (String)"MODIFIED");
                    }
                    TextDiffType type = textDiffType;
                    List list = new DiffDrawUtil.InlineHighlighterBuilder(this.editor, currentStart, currentEnd, type).withLayerPriority(1).done();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"done(...)");
                    this.highlighters.addAll(list);
                    this.dirtyStart = -1;
                    this.dirtyEnd = -1;
                    this.affectedFragments.clear();
                }
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\tH\u0014J\f\u0010\n\u001a\u00020\u0002*\u00020\u0003H\u0014\u00a8\u0006\u000b"}, d2={"Lgit4idea/index/GitStageLineStatusTracker$MyStagedBlockOperations;", "Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBlockOperations;", "Lcom/intellij/openapi/vcs/ex/Range;", "Lcom/intellij/openapi/vcs/ex/BlockI;", "lock", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Lock;", "<init>", "(Lgit4idea/index/GitStageLineStatusTracker;Lcom/intellij/openapi/vcs/ex/DocumentTracker$Lock;)V", "getBlocks", "", "toRange", "intellij.vcs.git"})
    private final class MyStagedBlockOperations
    extends LineStatusTrackerBlockOperations<Range, BlockI> {
        public MyStagedBlockOperations(DocumentTracker.Lock lock) {
            Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
            super(lock);
        }

        @Nullable
        protected List<BlockI> getBlocks() {
            return GitStageLineStatusTracker.this.isValid() ? GitStageLineStatusTracker.this.unstagedTracker.getBlocks() : null;
        }

        @NotNull
        protected Range toRange(@NotNull BlockI $this$toRange) {
            Intrinsics.checkNotNullParameter((Object)$this$toRange, (String)"<this>");
            return new Range($this$toRange.getStart(), $this$toRange.getEnd(), $this$toRange.getVcsStart(), $this$toRange.getVcsEnd());
        }
    }
}

