/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.graphic.views;

import com.projectlibre1.configuration.Dictionary;
import com.projectlibre1.field.FieldContext;
import com.projectlibre1.graphic.configuration.CellStyle;
import com.projectlibre1.graphic.configuration.GraphicConfiguration;
import com.projectlibre1.graphic.configuration.SpreadSheetFieldArray;
import com.projectlibre1.grouping.core.Node;
import com.projectlibre1.grouping.core.transform.ViewTransformer;
import com.projectlibre1.grouping.core.transform.filtering.NodeFilter;
import com.projectlibre1.grouping.core.transform.filtering.SelectionFilter;
import com.projectlibre1.help.HelpUtil;
import com.projectlibre1.menu.MenuManager;
import com.projectlibre1.pm.graphic.frames.DocumentFrame;
import com.projectlibre1.pm.graphic.model.cache.NodeModelCache;
import com.projectlibre1.pm.graphic.model.cache.NodeModelCacheFactory;
import com.projectlibre1.pm.graphic.model.cache.ReferenceNodeModelCache;
import com.projectlibre1.pm.graphic.model.transform.NodeCacheTransformer;
import com.projectlibre1.pm.graphic.spreadsheet.SpreadSheet;
import com.projectlibre1.pm.graphic.spreadsheet.SpreadSheetModel;
import com.projectlibre1.pm.graphic.spreadsheet.SpreadSheetUtils;
import com.projectlibre1.pm.graphic.spreadsheet.common.CommonSpreadSheet;
import com.projectlibre1.pm.graphic.spreadsheet.common.CommonSpreadSheetModel;
import com.projectlibre1.pm.graphic.spreadsheet.selection.event.SelectionNodeEvent;
import com.projectlibre1.pm.graphic.spreadsheet.selection.event.SelectionNodeListener;
import com.projectlibre1.pm.graphic.spreadsheet.time.FieldArrayEvent;
import com.projectlibre1.pm.graphic.spreadsheet.time.FieldArrayListener;
import com.projectlibre1.pm.graphic.spreadsheet.time.TimeSpreadSheet;
import com.projectlibre1.pm.graphic.spreadsheet.time.TimeSpreadSheetModel;
import com.projectlibre1.pm.graphic.timescale.CoordinatesConverter;
import com.projectlibre1.pm.graphic.timescale.ScaledScrollPane;
import com.projectlibre1.pm.graphic.views.BaseView;
import com.projectlibre1.pm.graphic.views.SplittedView;
import com.projectlibre1.pm.graphic.views.synchro.Synchronizer;
import com.projectlibre1.pm.resource.Resource;
import com.projectlibre1.pm.task.Project;
import com.projectlibre1.strings.Messages;
import com.projectlibre1.undo.UndoController;
import com.projectlibre1.workspace.WorkspaceSetting;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JScrollPane;
import org.apache.commons.collections.Closure;

public class UsageDetailView
extends SplittedView
implements BaseView,
FieldArrayListener,
SelectionNodeListener {
    private static final long serialVersionUID = 8603734334991284800L;
    protected SpreadSheet spreadSheet;
    protected TimeSpreadSheet timeSpreadSheet;
    protected ReferenceNodeModelCache refCache;
    protected NodeModelCache cache;
    protected CoordinatesConverter coord;
    private Project project;
    DocumentFrame documentFrame;
    protected boolean taskUsage;
    FieldContext fieldContext;
    protected ScaledScrollPane timeScrollPane;
    protected CellStyle cellStyle;
    protected String viewName;
    protected boolean hasEmptyRows;
    private boolean subView;

    public UsageDetailView(DocumentFrame documentFrame, MenuManager menuManager, Synchronizer synchronizer) {
        super(synchronizer);
        this.documentFrame = documentFrame;
        this.project = documentFrame.getProject();
        this.setNeedVoidBar(true);
        this.setDeltaDivider(GraphicConfiguration.getInstance().getRowHeaderWidth());
    }

    public void init(ReferenceNodeModelCache referenceNodeModelCache, boolean bl, CoordinatesConverter coordinatesConverter, boolean bl2, String string, Closure closure) {
        this.coord = coordinatesConverter;
        this.subView = bl2;
        this.hasEmptyRows = !bl2;
        this.viewName = string;
        this.cache = NodeModelCacheFactory.getInstance().createFilteredCache(referenceNodeModelCache, string, closure);
        this.taskUsage = bl;
        this.fieldContext = new FieldContext();
        this.fieldContext.setLeftAssociation(bl);
        HelpUtil.addDocHelp(this, bl ? (bl2 ? "Task_Usage" : "Task_Usage_Detail") : (bl2 ? "Resource_Usage" : "Resource_Usage_Detail"));
        super.init();
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.coord.removeTimeScaleListener(this.timeScrollPane);
        ((TimeSpreadSheetModel)this.timeSpreadSheet.getModel()).removeFieldArrayListener(this);
        this.spreadSheet.cleanUp();
        this.timeSpreadSheet.cleanUp();
        this.spreadSheet = null;
        this.timeSpreadSheet = null;
        this.refCache = null;
        this.cache = null;
        this.coord = null;
        this.project = null;
        this.documentFrame = null;
        this.fieldContext = null;
        this.timeScrollPane = null;
        this.cellStyle = null;
        this.viewName = null;
    }

    @Override
    protected JScrollPane createLeftScrollPane() {
        this.spreadSheet = new SpreadSheet(){
            private static final long serialVersionUID = 1996911145637609217L;

            @Override
            public boolean isNodeDeletable(Node node) {
                return !(node.getImpl() instanceof Resource);
            }
        };
        this.spreadSheet.setSpreadSheetCategory(this.taskUsage ? "taskAssignmentSpreadsheet" : "resourceAssignmentSpreadsheet");
        SpreadSheetFieldArray spreadSheetFieldArray = this.getFields();
        this.spreadSheet.setCache(this.cache, spreadSheetFieldArray, spreadSheetFieldArray.getCellStyle(), spreadSheetFieldArray.getActionList());
        ((SpreadSheetModel)this.spreadSheet.getModel()).setFieldContext(this.fieldContext);
        this.cache.update();
        if (this.project.isReadOnly()) {
            this.spreadSheet.setReadOnly(true);
        }
        return SpreadSheetUtils.makeSpreadsheetScrollPane(this.spreadSheet);
    }

    @Override
    protected JScrollPane createRightScrollPane() {
        this.timeSpreadSheet = new TimeSpreadSheet(this.project);
        this.timeSpreadSheet.setSpreadSheetCategory("distributionSpreadsheet");
        SpreadSheetFieldArray spreadSheetFieldArray = this.getDistributionFields();
        this.timeSpreadSheet.setCache(this.cache, spreadSheetFieldArray, spreadSheetFieldArray.getCellStyle(), spreadSheetFieldArray.getActionList());
        ((TimeSpreadSheetModel)this.timeSpreadSheet.getModel()).addFieldArrayListener(this);
        this.timeScrollPane = new ScaledScrollPane(this.timeSpreadSheet, this.coord, this.documentFrame, this.timeSpreadSheet.getRowHeight());
        this.timeSpreadSheet.createDefaultColumnsFromModel();
        if (this.project.isReadOnly()) {
            this.timeSpreadSheet.setEnabled(false);
        }
        return this.timeScrollPane;
    }

    private SpreadSheetFieldArray getFields() {
        if (this.taskUsage) {
            return (SpreadSheetFieldArray)Dictionary.get("taskAssignmentSpreadsheet", Messages.getString("Spreadsheet.Assignment.taskUsage"));
        }
        return (SpreadSheetFieldArray)Dictionary.get("resourceAssignmentSpreadsheet", Messages.getString("Spreadsheet.Assignment.resourceUsage"));
    }

    private SpreadSheetFieldArray getDistributionFields() {
        return (SpreadSheetFieldArray)Dictionary.get("distributionSpreadsheet", Messages.getString(this.taskUsage ? "Spreadsheet.TaskUsage.default" : "Spreadsheet.ResourceUsage.default"));
    }

    @Override
    public SpreadSheet getSpreadSheet() {
        return this.spreadSheet;
    }

    public TimeSpreadSheet getTimeSpreadSheet() {
        return this.timeSpreadSheet;
    }

    public void forceUpdateOfTimeSpreadSheet() {
        int n = ((CommonSpreadSheetModel)this.spreadSheet.getModel()).getRowCount() * ((TimeSpreadSheetModel)this.timeSpreadSheet.getModel()).getRowMultiple() * GraphicConfiguration.getInstance().getRowHeight();
        this.timeSpreadSheet.setPreferredSize(new Dimension((int)this.coord.toW(this.coord.getEnd() - this.coord.getOrigin()), n));
        this.timeSpreadSheet.setSize(this.timeSpreadSheet.getPreferredSize());
        this.timeSpreadSheet.revalidate();
    }

    @Override
    public void fieldArrayChanged(FieldArrayEvent fieldArrayEvent) {
        int n = fieldArrayEvent.getFieldArray().size();
        int n2 = GraphicConfiguration.getInstance().getRowHeight() * n;
        this.spreadSheet.setRowHeight(n2);
        this.forceUpdateOfTimeSpreadSheet();
    }

    @Override
    public void selectionChanged(SelectionNodeEvent selectionNodeEvent) {
        boolean bl;
        if (selectionNodeEvent.getSource() == this.spreadSheet || !(selectionNodeEvent.getSource() instanceof CommonSpreadSheet)) {
            return;
        }
        CommonSpreadSheet commonSpreadSheet = (CommonSpreadSheet)selectionNodeEvent.getSource();
        if ("taskSpreadsheet".equals(commonSpreadSheet.getSpreadSheetCategory()) || "taskAssignmentSpreadsheet".equals(commonSpreadSheet.getSpreadSheetCategory())) {
            bl = true;
        } else if ("resourceSpreadsheet".equals(commonSpreadSheet.getSpreadSheetCategory()) || "resourceAssignmentSpreadsheet".equals(commonSpreadSheet.getSpreadSheetCategory())) {
            bl = false;
        } else {
            return;
        }
        ViewTransformer viewTransformer = ((NodeCacheTransformer)this.cache.getVisibleNodes().getTransformer()).getTransformer();
        NodeFilter nodeFilter = viewTransformer.getHiddenFilter();
        if (nodeFilter instanceof SelectionFilter) {
            ((SelectionFilter)nodeFilter).setSelectedNodesImpl(this.documentFrame.getTopSpreadSheet().getSelectedNodesImpl(), bl);
            this.forceUpdateOfTimeSpreadSheet();
        }
    }

    @Override
    public UndoController getUndoController() {
        if (this.showsTasks()) {
            return this.project.getUndoController();
        }
        return this.project.getResourcePool().getUndoController();
    }

    @Override
    public void zoomIn() {
        this.coord.zoomIn();
    }

    @Override
    public void zoomOut() {
        this.coord.zoomOut();
    }

    @Override
    public boolean canZoomIn() {
        return this.coord.canZoomIn();
    }

    @Override
    public boolean canZoomOut() {
        return this.coord.canZoomOut();
    }

    @Override
    public int getScale() {
        return this.coord.getTimescaleManager().getCurrentScaleIndex();
    }

    @Override
    public boolean hasNormalMinWidth() {
        return false;
    }

    @Override
    public String getViewName() {
        return this.viewName;
    }

    @Override
    public boolean showsTasks() {
        return this.taskUsage;
    }

    @Override
    public boolean showsResources() {
        return !this.taskUsage;
    }

    @Override
    public void onActivate(boolean bl) {
    }

    @Override
    public boolean isPrintable() {
        return false;
    }

    @Override
    public void restoreWorkspace(WorkspaceSetting workspaceSetting, int n) {
        Workspace workspace = (Workspace)workspaceSetting;
        this.spreadSheet.restoreWorkspace(workspace.spreadSheet, n);
        this.timeSpreadSheet.restoreWorkspace(workspace.timeSpreadSheet, n);
        this.timeSpreadSheet.setSelectedFieldArray((ArrayList)SpreadSheetFieldArray.fromIdArray(workspace.selectedFieldArray));
        this.timeScrollPane.restoreWorkspace(workspace.scrollPane, n);
        this.setDividerLocation(workspace.dividerLocation);
    }

    @Override
    public WorkspaceSetting createWorkspace(int n) {
        Workspace workspace = new Workspace();
        workspace.spreadSheet = this.spreadSheet.createWorkspace(n);
        workspace.timeSpreadSheet = this.timeSpreadSheet.createWorkspace(n);
        workspace.selectedFieldArray = SpreadSheetFieldArray.toIdArray(this.timeSpreadSheet.getSelectedFieldArray());
        workspace.scrollPane = this.timeScrollPane.createWorkspace(n);
        workspace.dividerLocation = this.getDividerLocation();
        return workspace;
    }

    @Override
    public boolean canScrollToTask() {
        return false;
    }

    @Override
    public void scrollToTask() {
    }

    @Override
    public NodeModelCache getCache() {
        return this.cache;
    }

    public static class Workspace
    implements WorkspaceSetting {
        private static final long serialVersionUID = 8588696931239304763L;
        WorkspaceSetting spreadSheet;
        WorkspaceSetting timeSpreadSheet;
        Collection selectedFieldArray;
        WorkspaceSetting scrollPane;
        int dividerLocation;

        public WorkspaceSetting getSpreadSheet() {
            return this.spreadSheet;
        }

        public void setSpreadSheet(WorkspaceSetting workspaceSetting) {
            this.spreadSheet = workspaceSetting;
        }

        public Collection getSelectedFieldArray() {
            return this.selectedFieldArray;
        }

        public void setSelectedFieldArray(Collection collection) {
            this.selectedFieldArray = collection;
        }

        public WorkspaceSetting getTimeSpreadSheet() {
            return this.timeSpreadSheet;
        }

        public void setTimeSpreadSheet(WorkspaceSetting workspaceSetting) {
            this.timeSpreadSheet = workspaceSetting;
        }

        public WorkspaceSetting getScrollPane() {
            return this.scrollPane;
        }

        public void setScrollPane(WorkspaceSetting workspaceSetting) {
            this.scrollPane = workspaceSetting;
        }

        public int getDividerLocation() {
            return this.dividerLocation;
        }

        public void setDividerLocation(int n) {
            this.dividerLocation = n;
        }
    }
}

