/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.wimpi.modbus.ModbusIOException;
import net.wimpi.modbus.io.BytesInputStream;
import net.wimpi.modbus.io.BytesOutputStream;
import net.wimpi.modbus.io.ModbusSerialTransport;
import net.wimpi.modbus.msg.ModbusMessage;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.util.ModbusUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusRTUTransport
extends ModbusSerialTransport {
    private static final Logger logger = LoggerFactory.getLogger(ModbusRTUTransport.class);
    private InputStream m_InputStream;
    private OutputStream m_OutputStream;
    private byte[] m_InBuffer;
    private BytesInputStream m_ByteIn;
    private BytesOutputStream m_ByteInOut;
    private BytesOutputStream m_ByteOut;
    private byte[] lastRequest = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeMessage(ModbusMessage msg) throws ModbusIOException {
        try {
            BytesOutputStream bytesOutputStream = this.m_ByteOut;
            synchronized (bytesOutputStream) {
                this.clearInput();
                this.m_ByteOut.reset();
                msg.setHeadless();
                msg.writeTo(this.m_ByteOut);
                int len = this.m_ByteOut.size();
                int[] crc = ModbusUtil.calculateCRC(this.m_ByteOut.getBuffer(), 0, len);
                this.m_ByteOut.writeByte(crc[0]);
                this.m_ByteOut.writeByte(crc[1]);
                len = this.m_ByteOut.size();
                byte[] buf = this.m_ByteOut.getBuffer();
                this.m_OutputStream.write(buf, 0, len);
                this.m_OutputStream.flush();
                logger.debug("Sent: {}", (Object)ModbusUtil.toHex(buf, 0, len));
                if (this.m_Echo) {
                    this.readEcho(len);
                }
                this.lastRequest = new byte[len];
                System.arraycopy(buf, 0, this.lastRequest, 0, len);
            }
        }
        catch (Exception ex) {
            throw new ModbusIOException("I/O failed to write");
        }
    }

    @Override
    public ModbusRequest readRequest() throws ModbusIOException {
        throw new RuntimeException("Operation not supported.");
    }

    public void clearInput() throws IOException {
        if (this.m_InputStream.available() > 0) {
            int len = this.m_InputStream.available();
            byte[] buf = new byte[len];
            this.m_InputStream.read(buf, 0, len);
            logger.debug("Clear input: {}", (Object)ModbusUtil.toHex(buf, 0, len));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModbusResponse readResponse() throws ModbusIOException {
        boolean done = false;
        ModbusResponse response = null;
        int dlength = 0;
        try {
            Object object;
            do {
                object = this.m_ByteIn;
                synchronized (object) {
                    this.m_CommPort.enableReceiveThreshold(1);
                    int uid = this.m_InputStream.read();
                    logger.trace("Managed to read at least one byte");
                    if (uid != -1) {
                        int fc = this.m_InputStream.read();
                        this.m_ByteInOut.reset();
                        this.m_ByteInOut.writeByte(uid);
                        this.m_ByteInOut.writeByte(fc);
                        response = ModbusResponse.createModbusResponse(fc);
                        response.setHeadless();
                        this.getResponse(fc, this.m_ByteInOut);
                        dlength = this.m_ByteInOut.size() - 2;
                        this.m_ByteIn.reset(this.m_InBuffer, dlength);
                        int[] crc = ModbusUtil.calculateCRC(this.m_InBuffer, 0, dlength);
                        if (ModbusUtil.unsignedByteToInt(this.m_InBuffer[dlength]) != crc[0] || ModbusUtil.unsignedByteToInt(this.m_InBuffer[dlength + 1]) != crc[1]) {
                            logger.debug("Response (CRC error): {}", (Object)ModbusUtil.toHex(this.m_ByteInOut.getBuffer(), 0, dlength + 2));
                            throw new IOException("CRC Error in received frame. " + dlength + " bytes of payload (" + ModbusUtil.toHex(this.m_ByteInOut.getBuffer(), 0, dlength) + ") with invalid CRC of " + ModbusUtil.toHex(this.m_InBuffer, dlength, 2));
                        }
                    } else {
                        throw new IOException("Error reading response (EOF)");
                    }
                    logger.debug("Response (CRC OK): {}", (Object)ModbusUtil.toHex(this.m_ByteInOut.getBuffer(), 0, dlength + 2));
                    this.m_ByteIn.reset(this.m_InBuffer, dlength);
                    if (response != null) {
                        response.readFrom(this.m_ByteIn);
                    }
                    done = true;
                }
            } while (!done);
            object = response;
            return object;
        }
        catch (Exception ex) {
            String errMsg = "failed to read";
            logger.debug("Last request: {}", (Object)ModbusUtil.toHex(this.lastRequest));
            logger.debug("{}: {}", (Object)"failed to read", (Object)ex.getMessage());
            throw new ModbusIOException(String.format("I/O exception: %s %s", ex.getClass().getSimpleName(), ex.getMessage()));
        }
        finally {
            this.m_CommPort.disableReceiveThreshold();
        }
    }

    @Override
    public void prepareStreams(InputStream in, OutputStream out) throws IOException {
        this.m_InputStream = in;
        this.m_OutputStream = out;
        this.m_ByteOut = new BytesOutputStream(256);
        this.m_InBuffer = new byte[256];
        this.m_ByteIn = new BytesInputStream(this.m_InBuffer);
        this.m_ByteInOut = new BytesOutputStream(this.m_InBuffer);
    }

    @Override
    public void close() throws IOException {
        if (this.m_InputStream != null) {
            try {
                this.m_InputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.m_OutputStream != null) {
            try {
                this.m_OutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.close();
    }

    private void getResponse(int fn, BytesOutputStream out) throws IOException {
        int bc = -1;
        int bc2 = -1;
        int bcw = -1;
        int inpBytes = 0;
        byte[] inpBuf = new byte[256];
        try {
            switch (fn) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 12: 
                case 17: 
                case 20: 
                case 21: 
                case 23: {
                    this.setReceiveThreshold(1);
                    bc = this.m_InputStream.read();
                    out.write(bc);
                    int awaitChars = bc + 2;
                    this.setReceiveThreshold(awaitChars);
                    inpBytes = this.m_InputStream.read(inpBuf, 0, awaitChars);
                    out.write(inpBuf, 0, inpBytes);
                    this.m_CommPort.disableReceiveThreshold();
                    if (inpBytes == awaitChars) break;
                    throw new IOException(String.format("Truncated response: awaited {} bytes, but received {}", awaitChars, inpBytes));
                }
                case 5: 
                case 6: 
                case 11: 
                case 15: 
                case 16: {
                    int awaitChars = 6;
                    this.setReceiveThreshold(awaitChars);
                    inpBytes = this.m_InputStream.read(inpBuf, 0, awaitChars);
                    out.write(inpBuf, 0, inpBytes);
                    this.m_CommPort.disableReceiveThreshold();
                    if (inpBytes == awaitChars) break;
                    throw new IOException(String.format("Truncated response: awaited {} bytes, but received {}", awaitChars, inpBytes));
                }
                case 7: 
                case 8: {
                    int awaitChars = 3;
                    this.setReceiveThreshold(awaitChars);
                    inpBytes = this.m_InputStream.read(inpBuf, 0, awaitChars);
                    out.write(inpBuf, 0, inpBytes);
                    this.m_CommPort.disableReceiveThreshold();
                    if (inpBytes == awaitChars) break;
                    throw new IOException(String.format("Truncated response: awaited {} bytes, but received {}", awaitChars, inpBytes));
                }
                case 22: {
                    int awaitChars = 8;
                    this.setReceiveThreshold(awaitChars);
                    inpBytes = this.m_InputStream.read(inpBuf, 0, awaitChars);
                    out.write(inpBuf, 0, inpBytes);
                    this.m_CommPort.disableReceiveThreshold();
                    if (inpBytes == awaitChars) break;
                    throw new IOException(String.format("Truncated response: awaited {} bytes, but received {}", awaitChars, inpBytes));
                }
                case 24: {
                    this.setReceiveThreshold(1);
                    bc = this.m_InputStream.read();
                    out.write(bc);
                    bc2 = this.m_InputStream.read();
                    out.write(bc2);
                    bcw = ModbusUtil.makeWord(bc, bc2);
                    int awaitChars = bcw + 2;
                    this.setReceiveThreshold(awaitChars);
                    inpBytes = this.m_InputStream.read(inpBuf, 0, awaitChars);
                    out.write(inpBuf, 0, inpBytes);
                    this.m_CommPort.disableReceiveThreshold();
                    if (inpBytes == awaitChars) break;
                    throw new IOException(String.format("Truncated response: awaited {} bytes, but received {}", awaitChars, inpBytes));
                }
            }
        }
        catch (IOException e) {
            this.m_CommPort.disableReceiveThreshold();
            throw e;
        }
    }
}

