/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.model;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CredentialBuildConfig {
    public static final String MULTIVALUED_STRING_SEPARATOR = ",";
    private static final String TOKEN_JWS_TYPE_KEY = "token_jws_type";
    private static final String HASH_ALGORITHM_KEY = "hash_algorithm";
    private static final String VISIBLE_CLAIMS_KEY = "visible_claims";
    private static final String NUMBER_OF_DECOYS_KEY = "decoys";
    private String credentialId;
    private String credentialType;
    private String tokenJwsType;
    private String hashAlgorithm;
    private List<String> visibleClaims;
    private Integer numberOfDecoys;

    public String getCredentialId() {
        return this.credentialId;
    }

    public CredentialBuildConfig setCredentialId(String credentialId) {
        this.credentialId = credentialId;
        return this;
    }

    public String getTokenJwsType() {
        return this.tokenJwsType;
    }

    public CredentialBuildConfig setTokenJwsType(String tokenJwsType) {
        this.tokenJwsType = tokenJwsType;
        return this;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public CredentialBuildConfig setHashAlgorithm(String hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
        return this;
    }

    public List<String> getVisibleClaims() {
        return this.visibleClaims;
    }

    public CredentialBuildConfig setVisibleClaims(List<String> visibleClaims) {
        this.visibleClaims = visibleClaims;
        return this;
    }

    public int getNumberOfDecoys() {
        return this.numberOfDecoys;
    }

    public CredentialBuildConfig setNumberOfDecoys(int numberOfDecoys) {
        this.numberOfDecoys = numberOfDecoys;
        return this;
    }

    public String getCredentialType() {
        return this.credentialType;
    }

    public CredentialBuildConfig setCredentialType(String credentialType) {
        this.credentialType = credentialType;
        return this;
    }

    public Map<String, String> toDotNotation() {
        HashMap<String, String> dotNotation = new HashMap<String, String>();
        String prefix = CredentialBuildConfig.getDotNotationPrefix(this.credentialId);
        Optional.ofNullable(this.tokenJwsType).ifPresent(tokenJwsType -> dotNotation.put(prefix + TOKEN_JWS_TYPE_KEY, (String)tokenJwsType));
        Optional.ofNullable(this.hashAlgorithm).ifPresent(hashAlgorithm -> dotNotation.put(prefix + HASH_ALGORITHM_KEY, (String)hashAlgorithm));
        Optional.ofNullable(this.numberOfDecoys).ifPresent(numberOfDecoys -> dotNotation.put(prefix + NUMBER_OF_DECOYS_KEY, String.valueOf(numberOfDecoys)));
        Optional.ofNullable(this.visibleClaims).ifPresent(claims -> dotNotation.put(prefix + VISIBLE_CLAIMS_KEY, String.join((CharSequence)MULTIVALUED_STRING_SEPARATOR, claims)));
        return dotNotation;
    }

    public static CredentialBuildConfig fromDotNotation(String credentialId, Map<String, String> dotNotated) {
        String prefix = CredentialBuildConfig.getDotNotationPrefix(credentialId);
        if (dotNotated.keySet().stream().noneMatch(key -> key.startsWith(prefix))) {
            return null;
        }
        CredentialBuildConfig credentialBuildConfig = new CredentialBuildConfig().setCredentialId(credentialId);
        Optional.ofNullable(dotNotated.get(credentialId + ".vct")).ifPresent(credentialBuildConfig::setCredentialType);
        Optional.ofNullable(dotNotated.get(prefix + TOKEN_JWS_TYPE_KEY)).ifPresent(credentialBuildConfig::setTokenJwsType);
        Optional.ofNullable(dotNotated.get(prefix + HASH_ALGORITHM_KEY)).ifPresent(credentialBuildConfig::setHashAlgorithm);
        Optional.ofNullable(dotNotated.get(prefix + NUMBER_OF_DECOYS_KEY)).map(Integer::parseInt).ifPresent(credentialBuildConfig::setNumberOfDecoys);
        Optional.ofNullable(dotNotated.get(prefix + VISIBLE_CLAIMS_KEY)).map(cbms -> cbms.split(MULTIVALUED_STRING_SEPARATOR)).map(Arrays::asList).ifPresent(credentialBuildConfig::setVisibleClaims);
        return credentialBuildConfig;
    }

    private static String getDotNotationPrefix(String credentialId) {
        return credentialId + ".credential_build_config.";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CredentialBuildConfig that = (CredentialBuildConfig)o;
        return Objects.equals(this.credentialId, that.credentialId) && Objects.equals(this.credentialType, that.credentialType) && Objects.equals(this.tokenJwsType, that.tokenJwsType) && Objects.equals(this.hashAlgorithm, that.hashAlgorithm) && Objects.equals(this.visibleClaims, that.visibleClaims) && Objects.equals(this.numberOfDecoys, that.numberOfDecoys);
    }

    public int hashCode() {
        return Objects.hash(this.credentialType, this.tokenJwsType, this.hashAlgorithm, this.visibleClaims, this.numberOfDecoys, this.credentialId);
    }
}

