/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.io.IOException;
import java.io.StringWriter;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.util.test.FreeColTestCase;

public class MonarchTest
extends FreeColTestCase {
    public void testSerialize() {
        Game game = MonarchTest.getStandardGame();
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        try (StringWriter sw = new StringWriter();
             FreeColXMLWriter xw = new FreeColXMLWriter(sw);){
            dutch.getMonarch().toXML(xw);
        }
        catch (IOException | XMLStreamException ex) {
            MonarchTest.fail((String)ex.toString());
        }
    }

    public void testTaxActionChoices() {
        Game game = MonarchTest.getStandardGame();
        game.changeMap(MonarchTest.getTestMap());
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        List<RandomChoice<Monarch.MonarchAction>> choices = dutch.getMonarch().getActionChoices();
        MonarchTest.assertTrue((boolean)choices.isEmpty());
        Colony colony = this.getStandardColony();
        game.setTurn(new Turn(100));
        dutch.setTax(10);
        choices = dutch.getMonarch().getActionChoices();
        MonarchTest.assertTrue((boolean)this.choicesContain(choices, Monarch.MonarchAction.RAISE_TAX_WAR));
        MonarchTest.assertTrue((boolean)this.choicesContain(choices, Monarch.MonarchAction.RAISE_TAX_ACT));
        MonarchTest.assertFalse((boolean)this.choicesContain(choices, Monarch.MonarchAction.LOWER_TAX_WAR));
        MonarchTest.assertFalse((boolean)this.choicesContain(choices, Monarch.MonarchAction.LOWER_TAX_OTHER));
        int maximumTax = MonarchTest.spec().getInteger("model.option.maximumTax");
        dutch.setTax(maximumTax / 2);
        choices = dutch.getMonarch().getActionChoices();
        MonarchTest.assertTrue((boolean)this.choicesContain(choices, Monarch.MonarchAction.RAISE_TAX_WAR));
        MonarchTest.assertTrue((boolean)this.choicesContain(choices, Monarch.MonarchAction.RAISE_TAX_ACT));
        MonarchTest.assertTrue((boolean)this.choicesContain(choices, Monarch.MonarchAction.LOWER_TAX_WAR));
        MonarchTest.assertTrue((boolean)this.choicesContain(choices, Monarch.MonarchAction.LOWER_TAX_OTHER));
        dutch.setTax(maximumTax + 2);
        choices = dutch.getMonarch().getActionChoices();
        MonarchTest.assertFalse((boolean)this.choicesContain(choices, Monarch.MonarchAction.RAISE_TAX_WAR));
        MonarchTest.assertFalse((boolean)this.choicesContain(choices, Monarch.MonarchAction.RAISE_TAX_ACT));
        MonarchTest.assertTrue((boolean)this.choicesContain(choices, Monarch.MonarchAction.LOWER_TAX_WAR));
        MonarchTest.assertTrue((boolean)this.choicesContain(choices, Monarch.MonarchAction.LOWER_TAX_OTHER));
        dutch.changePlayerType(Player.PlayerType.REBEL);
        choices = dutch.getMonarch().getActionChoices();
        MonarchTest.assertTrue((boolean)choices.isEmpty());
    }

    private boolean choicesContain(List<RandomChoice<Monarch.MonarchAction>> choices, Monarch.MonarchAction action) {
        for (RandomChoice<Monarch.MonarchAction> choice : choices) {
            if (choice.getObject() != action) continue;
            return true;
        }
        return false;
    }
}

