# Copyright 1999-2026 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

DISTUTILS_USE_PEP517=setuptools
PYTHON_COMPAT=( python3_{10..14} )

inherit distutils-r1 eapi9-ver optfeature systemd

MY_P=${P^}
DESCRIPTION="A simple CalDAV calendar server"
HOMEPAGE="https://radicale.org/"
SRC_URI="
	https://github.com/Kozea/Radicale/archive/refs/tags/v${PV}.tar.gz
		-> ${MY_P}.gh.tar.gz
"
S=${WORKDIR}/${MY_P}

LICENSE="GPL-3+"
SLOT="0"
KEYWORDS="~amd64 ~arm ~x86"

RDEPEND="
	>=acct-user/radicale-0-r2
	acct-group/radicale
	dev-python/defusedxml[${PYTHON_USEDEP}]
	dev-python/passlib[${PYTHON_USEDEP}]
	dev-python/vobject[${PYTHON_USEDEP}]
	sys-apps/util-linux
"

# was optfeature but need to stay below version 5
# https://github.com/Kozea/Radicale/issues/1980
RDEPEND="${RDEPEND}
	<dev-python/bcrypt-5[${PYTHON_USEDEP}]
"

BDEPEND="
	test? (
		dev-python/pytest[${PYTHON_USEDEP}]
		dev-python/waitress[${PYTHON_USEDEP}]
	)
"

distutils_enable_tests pytest

RDIR=/var/lib/"${PN}"

DOCS=( DOCUMENTATION.md CHANGELOG.md )

src_prepare() {
	default

	# use passlib over libpass
	# https://github.com/Kozea/Radicale/issues/1980
	sed -i -e 's|libpass[^"]*|passlib|' pyproject.toml || die
}

python_test() {
	epytest -o addopts= radicale/tests/
}

python_install_all() {
	rm README* || die
	# init file
	newinitd "${FILESDIR}"/radicale-r4.init.d radicale
	systemd_dounit "${FILESDIR}/${PN}.service"

	# directories
	keepdir "${RDIR}"
	fperms 0750 "${RDIR}"
	fowners "${PN}:${PN}" "${RDIR}"

	# config file
	insinto /etc/"${PN}"
	doins config

	# fcgi and wsgi files
	exeinto /usr/share/"${PN}"
	doexe radicale.wsgi

	distutils-r1_python_install_all
}

pkg_postinst() {
	local _erdir="${EROOT}${RDIR}"

	if ver_replacing -lt "3.5.0"; then
		ewarn ""
		ewarn "Since 3.5.0 the default [auth] type is \"denyall\". You need to"
		ewarn "change your config if you used the default type so far!"
		ewarn ""
	fi
	einfo "A sample WSGI script has been put into ${EROOT}/usr/share/${PN}."
	einfo "You will also find there an example FastCGI script."
	if [[ $(stat --format="%U:%G:%a" "${_erdir}") != "${PN}:${PN}:750" ]]
	then
		ewarn ""
		ewarn "Unsafe file permissions detected on ${_erdir}."
		ewarn "This probably comes from an earlier version of this ebuild."
		ewarn "To fix run:"
		ewarn "#  \`chown -R ${PN}:${PN} ${_erdir}\`"
		ewarn "#  \`chmod 0750 ${_erdir}\`"
		ewarn "#  \`chmod -R o= ${_erdir}\`"
	fi

	optfeature "Publish changes to rabbitmq" dev-python/pika
	optfeature "LDAP/LDAPS authentication" dev-python/ldap3 dev-python/python-ldap
	## TODO make that an optfeature again after libpass/passlib takeover
	# optfeature "bcrypt password hashing" dev-python/bcrypt
	optfeature "argon2 password hashing" dev-python/argon2-cffi
}
