# Copyright 1999-2023 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit autotools bash-completion-r1

DESCRIPTION="Console ftp client with a lot of nifty features"
HOMEPAGE="https://github.com/sebastinas/yafc"
SRC_URI="https://github.com/sebastinas/yafc/archive/v${PV}.tar.gz -> ${P}.tar.gz"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~amd64 ~arm ~ppc ~sparc ~x86"
IUSE="kerberos readline socks5 ssh"

RDEPEND="
	sys-libs/ncurses:=
	dev-libs/libbsd
	dev-libs/openssl:0=
	kerberos? ( virtual/krb5 )
	readline? ( >=sys-libs/readline-6:0= )
	socks5? ( net-proxy/dante )
	ssh? ( net-libs/libssh )
"
BDEPEND="
	virtual/pkgconfig
	sys-devel/gettext
	sys-apps/texinfo
"
DEPEND="${RDEPEND}"

DOCS=( BUGS NEWS README.md THANKS TODO )

PATCHES=( "${FILESDIR}/${P}-fix-autoreconf.patch" )

src_prepare() {
	default
	eautoreconf
}

src_configure() {
	export ac_cv_ipv6=yes
	local myeconfargs=(
		$(use_with readline readline /usr)
		$(use_with socks5 socks /usr)
		$(use_with socks5 socks5 /usr)
		$(use_with kerberos krb5)
		$(use_with ssh)
		--with-bash-completion="$(get_bashcompdir)"
	)
	econf "${myeconfargs[@]}"
}

src_install() {
	default
	dodoc -r samples
}
