# Copyright 1999-2024 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit vdr-plugin-2

DESCRIPTION="VDR plugin: play 'Freecell' on the On Screen Display"
HOMEPAGE="https://wiki.gentoo.org/wiki/No_homepage"
SRC_URI="http://vdr.websitec.de/download/${PN}/${P}.tgz"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="amd64 x86"

DEPEND="media-video/vdr"
RDEPEND="${DEPEND}"

src_prepare() {
	vdr-plugin-2_src_prepare

	sed -e "s:RegisterI18n://RegisterI18n:" -i freecell.c || die

	eapply -p2 "${FILESDIR}/gcc-3.4.patch"
	eapply "${FILESDIR}/${P}-gentoo.diff"
	eapply "${FILESDIR}/${P}_vdr-1.5.4-compile.diff"
	eapply "${FILESDIR}/${P}_compilefix.patch"

	# do not call g++ directly, Bug #934766
	sed -e 's|MAKEDEP = g++ -MM -MG|MAKEDEP = $(CXX) -MM -MG|' -i Makefile || die
}

src_install() {
	vdr-plugin-2_src_install

	insopts -m0644 -ovdr -gvdr
	insinto /usr/share/vdr/freecell
	doins "${S}/${VDRPLUGIN}"/*
}
