# Copyright 1999-2023 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=7

DESCRIPTION="COIN-OR lightweight API for COIN-OR libraries CLP, CBC, and CGL"
HOMEPAGE="https://projects.coin-or.org/CoinMP/"
SRC_URI="https://github.com/coin-or/CoinMP/archive/releases/${PV}.tar.gz -> ${P}.tar.gz"
S="${WORKDIR}/CoinMP-releases-${PV}/CoinMP"

LICENSE="CPL-1.0"
SLOT="0/1"
KEYWORDS="~amd64 ~loong ~riscv ~x86 ~amd64-linux ~x86-linux"

RDEPEND="
	sci-libs/coinor-cbc:=
	sci-libs/coinor-cgl:=
	sci-libs/coinor-clp:=
	sci-libs/coinor-osi:=
	sci-libs/coinor-utils:="
DEPEND="${RDEPEND}"
BDEPEND="virtual/pkgconfig"

src_prepare() {
	default
	# Prevent unneeded call to pkg-config that needs ${ED}'s in path.
	# Also installation of unneeded files in a double ${D}.
	sed -i '/--libs.*addlibs.txt/d; s/ install-addlibsDATA//' \
		Makefile.in || die
}

src_test() {
	emake -j1 test
}

src_install() {
	default
	dodoc -r examples

	# Duplicate or irrelevant files.
	rm -r "${ED}"/usr/share/coin/doc || die
	find "${ED}" -name '*.la' -delete || die
}
