set(vcProjectFile "${RunCMake_TEST_BINARY_DIR}/foo.vcxproj")
if(NOT EXISTS "${vcProjectFile}")
  set(RunCMake_TEST_FAILED "Project file ${vcProjectFile} does not exist.")
  return()
endif()

set(foundCMakeLists 0)
file(STRINGS "${vcProjectFile}" lines)
foreach(line IN LISTS lines)
  if(line MATCHES "<([A-Za-z0-9_]+) +Include=.*CMakeLists.txt")
    set(rule "${CMAKE_MATCH_1}")
    if(NOT rule STREQUAL "CustomBuild")
      set(RunCMake_TEST_FAILED "CMakeLists.txt referenced as ${rule} instead of CustomBuild")
      return()
    endif()
    if(foundCMakeLists)
      set(RunCMake_TEST_FAILED "CMakeLists.txt referenced multiple times")
      return()
    endif()
    set(foundCMakeLists 1)
  endif()
endforeach()
if(NOT foundCMakeLists)
  set(RunCMake_TEST_FAILED "CMakeLists.txt not referenced")
endif()
