//=============================================================================
//  MuseScore
//  Music Composition & Notation
//
//  Copyright (C) 2013 Werner Schweer
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License version 2
//  as published by the Free Software Foundation and appearing in
//  the file LICENCE.GPL
//=============================================================================

#ifndef __XMLWRITER_H__
#define __XMLWRITER_H__

#include <QIODevice>
#include <QTextStream>
#include <QList>
#include <QString>
#include <QVariant>

//---------------------------------------------------------
//   XmlWriter
//---------------------------------------------------------

class XmlWriter : public QTextStream
{
    static const int BS = 2048;

    QList<QString> stack;
    void putLevel();

public:
    XmlWriter(QIODevice* dev);
    XmlWriter();

    void header();

    void stag(const QString&);
    void etag();

    void tagE(const QString&);
    void tagE(const char* format, ...);
    void ntag(const char* name);
    void netag(const char* name);

    void tag(const QString&, QVariant data);
    void tag(const char* name, const char* s) { tag(name, QVariant(s)); }
    void tag(const char* name, const QString& s) { tag(name, QVariant(s)); }

    static QString xmlString(const QString&);
};

#endif
