// Copyright © Advanced Micro Devices, Inc., or its affiliates.
// SPDX-License-Identifier:  MIT

#pragma once

typedef enum
{
    HIPDNN_ATTR_ENGINEHEUR_MODE = 100,
    HIPDNN_ATTR_ENGINEHEUR_OPERATION_GRAPH = 101,
    HIPDNN_ATTR_ENGINEHEUR_RESULTS = 102,
    HIPDNN_ATTR_ENGINEHEUR_SM_COUNT_TARGET = 103,
    HIPDNN_ATTR_ENGINEHEUR_DEVICEPROP = 104,

    HIPDNN_ATTR_ENGINECFG_ENGINE = 200,
    HIPDNN_ATTR_ENGINECFG_INTERMEDIATE_INFO = 201,
    HIPDNN_ATTR_ENGINECFG_KNOB_CHOICES = 202,
    HIPDNN_ATTR_ENGINECFG_WORKSPACE_SIZE = 203,

    HIPDNN_ATTR_EXECUTION_PLAN_HANDLE = 300, // Deprecated
    HIPDNN_ATTR_EXECUTION_PLAN_ENGINE_CONFIG = 301,
    HIPDNN_ATTR_EXECUTION_PLAN_WORKSPACE_SIZE = 302,
    HIPDNN_ATTR_EXECUTION_PLAN_COMPUTED_INTERMEDIATE_UIDS = 303,
    HIPDNN_ATTR_EXECUTION_PLAN_RUN_ONLY_INTERMEDIATE_UIDS = 304,
    HIPDNN_ATTR_EXECUTION_PLAN_JSON_REPRESENTATION = 305,
    HIPDNN_ATTR_EXECUTION_PLAN_KERNEL_CACHE = 306,
    HIPDNN_ATTR_EXECUTION_PLAN_DEVICEPROP = 307,

    HIPDNN_ATTR_INTERMEDIATE_INFO_UNIQUE_ID = 400,
    HIPDNN_ATTR_INTERMEDIATE_INFO_SIZE = 401,
    HIPDNN_ATTR_INTERMEDIATE_INFO_DEPENDENT_DATA_UIDS = 402,
    HIPDNN_ATTR_INTERMEDIATE_INFO_DEPENDENT_ATTRIBUTES = 403,

    HIPDNN_ATTR_KNOB_CHOICE_KNOB_TYPE = 500,
    HIPDNN_ATTR_KNOB_CHOICE_KNOB_VALUE = 501,

    HIPDNN_ATTR_OPERATIONGRAPH_HANDLE = 600,
    HIPDNN_ATTR_OPERATIONGRAPH_OPS = 601,
    HIPDNN_ATTR_OPERATIONGRAPH_ENGINE_GLOBAL_COUNT = 602,
    HIPDNN_ATTR_OPERATIONGRAPH_IS_DYNAMIC_SHAPE_ENABLED = 603,

    HIPDNN_ATTR_VARIANT_PACK_UNIQUE_IDS = 700,
    HIPDNN_ATTR_VARIANT_PACK_DATA_POINTERS = 701,
    HIPDNN_ATTR_VARIANT_PACK_INTERMEDIATES = 702,
    HIPDNN_ATTR_VARIANT_PACK_WORKSPACE = 703,

    HIPDNN_ATTR_LAYOUT_INFO_TENSOR_UID = 800,
    HIPDNN_ATTR_LAYOUT_INFO_TYPES = 801,

    HIPDNN_ATTR_KNOB_INFO_TYPE = 900,
    HIPDNN_ATTR_KNOB_INFO_MAXIMUM_VALUE = 901,
    HIPDNN_ATTR_KNOB_INFO_MINIMUM_VALUE = 902,
    HIPDNN_ATTR_KNOB_INFO_STRIDE = 903,

    HIPDNN_ATTR_ENGINE_OPERATION_GRAPH = 1000,
    HIPDNN_ATTR_ENGINE_GLOBAL_INDEX = 1001,
    HIPDNN_ATTR_ENGINE_KNOB_INFO = 1002,
    HIPDNN_ATTR_ENGINE_NUMERICAL_NOTE = 1003,
    HIPDNN_ATTR_ENGINE_LAYOUT_INFO = 1004,
    HIPDNN_ATTR_ENGINE_BEHAVIOR_NOTE = 1005,
    HIPDNN_ATTR_ENGINE_SM_COUNT_TARGET = 1006,
    HIPDNN_ATTR_ENGINE_DEVICEPROP = 1007,

    HIPDNN_ATTR_KERNEL_CACHE_IS_ENGINECFG_KERNEL_CACHED = 1100,

    HIPDNN_ATTR_DEVICEPROP_DEVICE_ID = 1200,
    HIPDNN_ATTR_DEVICEPROP_HANDLE = 1201,
    HIPDNN_ATTR_DEVICEPROP_JSON_REPRESENTATION = 1202,

} hipdnnBackendAttributeName_t;
