/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// UpdateRDPTargetDetails struct for UpdateRDPTargetDetails
type UpdateRDPTargetDetails struct {
	// The admin name
	AdminName *string `json:"admin_name,omitempty"`
	// The admin password
	AdminPwd *string `json:"admin_pwd,omitempty"`
	// The rdp host name
	HostName *string `json:"host_name,omitempty"`
	// The rdp port
	HostPort *string `json:"host_port,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Whether to keep previous version [true/false]. If not set, use default according to account settings
	KeepPrevVersion *string `json:"keep-prev-version,omitempty"`
	// Target name
	Name string `json:"name"`
	// Deprecated
	NewVersion *bool `json:"new-version,omitempty"`
	// The name of a key that used to encrypt the target secret value (if empty, the account default protectionKey key will be used)
	ProtectionKey *string `json:"protection_key,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewUpdateRDPTargetDetails instantiates a new UpdateRDPTargetDetails object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewUpdateRDPTargetDetails(name string, ) *UpdateRDPTargetDetails {
	this := UpdateRDPTargetDetails{}
	var hostPort string = "22"
	this.HostPort = &hostPort
	var json bool = false
	this.Json = &json
	this.Name = name
	return &this
}

// NewUpdateRDPTargetDetailsWithDefaults instantiates a new UpdateRDPTargetDetails object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewUpdateRDPTargetDetailsWithDefaults() *UpdateRDPTargetDetails {
	this := UpdateRDPTargetDetails{}
	var hostPort string = "22"
	this.HostPort = &hostPort
	var json bool = false
	this.Json = &json
	return &this
}

// GetAdminName returns the AdminName field value if set, zero value otherwise.
func (o *UpdateRDPTargetDetails) GetAdminName() string {
	if o == nil || o.AdminName == nil {
		var ret string
		return ret
	}
	return *o.AdminName
}

// GetAdminNameOk returns a tuple with the AdminName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateRDPTargetDetails) GetAdminNameOk() (*string, bool) {
	if o == nil || o.AdminName == nil {
		return nil, false
	}
	return o.AdminName, true
}

// HasAdminName returns a boolean if a field has been set.
func (o *UpdateRDPTargetDetails) HasAdminName() bool {
	if o != nil && o.AdminName != nil {
		return true
	}

	return false
}

// SetAdminName gets a reference to the given string and assigns it to the AdminName field.
func (o *UpdateRDPTargetDetails) SetAdminName(v string) {
	o.AdminName = &v
}

// GetAdminPwd returns the AdminPwd field value if set, zero value otherwise.
func (o *UpdateRDPTargetDetails) GetAdminPwd() string {
	if o == nil || o.AdminPwd == nil {
		var ret string
		return ret
	}
	return *o.AdminPwd
}

// GetAdminPwdOk returns a tuple with the AdminPwd field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateRDPTargetDetails) GetAdminPwdOk() (*string, bool) {
	if o == nil || o.AdminPwd == nil {
		return nil, false
	}
	return o.AdminPwd, true
}

// HasAdminPwd returns a boolean if a field has been set.
func (o *UpdateRDPTargetDetails) HasAdminPwd() bool {
	if o != nil && o.AdminPwd != nil {
		return true
	}

	return false
}

// SetAdminPwd gets a reference to the given string and assigns it to the AdminPwd field.
func (o *UpdateRDPTargetDetails) SetAdminPwd(v string) {
	o.AdminPwd = &v
}

// GetHostName returns the HostName field value if set, zero value otherwise.
func (o *UpdateRDPTargetDetails) GetHostName() string {
	if o == nil || o.HostName == nil {
		var ret string
		return ret
	}
	return *o.HostName
}

// GetHostNameOk returns a tuple with the HostName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateRDPTargetDetails) GetHostNameOk() (*string, bool) {
	if o == nil || o.HostName == nil {
		return nil, false
	}
	return o.HostName, true
}

// HasHostName returns a boolean if a field has been set.
func (o *UpdateRDPTargetDetails) HasHostName() bool {
	if o != nil && o.HostName != nil {
		return true
	}

	return false
}

// SetHostName gets a reference to the given string and assigns it to the HostName field.
func (o *UpdateRDPTargetDetails) SetHostName(v string) {
	o.HostName = &v
}

// GetHostPort returns the HostPort field value if set, zero value otherwise.
func (o *UpdateRDPTargetDetails) GetHostPort() string {
	if o == nil || o.HostPort == nil {
		var ret string
		return ret
	}
	return *o.HostPort
}

// GetHostPortOk returns a tuple with the HostPort field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateRDPTargetDetails) GetHostPortOk() (*string, bool) {
	if o == nil || o.HostPort == nil {
		return nil, false
	}
	return o.HostPort, true
}

// HasHostPort returns a boolean if a field has been set.
func (o *UpdateRDPTargetDetails) HasHostPort() bool {
	if o != nil && o.HostPort != nil {
		return true
	}

	return false
}

// SetHostPort gets a reference to the given string and assigns it to the HostPort field.
func (o *UpdateRDPTargetDetails) SetHostPort(v string) {
	o.HostPort = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *UpdateRDPTargetDetails) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateRDPTargetDetails) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *UpdateRDPTargetDetails) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *UpdateRDPTargetDetails) SetJson(v bool) {
	o.Json = &v
}

// GetKeepPrevVersion returns the KeepPrevVersion field value if set, zero value otherwise.
func (o *UpdateRDPTargetDetails) GetKeepPrevVersion() string {
	if o == nil || o.KeepPrevVersion == nil {
		var ret string
		return ret
	}
	return *o.KeepPrevVersion
}

// GetKeepPrevVersionOk returns a tuple with the KeepPrevVersion field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateRDPTargetDetails) GetKeepPrevVersionOk() (*string, bool) {
	if o == nil || o.KeepPrevVersion == nil {
		return nil, false
	}
	return o.KeepPrevVersion, true
}

// HasKeepPrevVersion returns a boolean if a field has been set.
func (o *UpdateRDPTargetDetails) HasKeepPrevVersion() bool {
	if o != nil && o.KeepPrevVersion != nil {
		return true
	}

	return false
}

// SetKeepPrevVersion gets a reference to the given string and assigns it to the KeepPrevVersion field.
func (o *UpdateRDPTargetDetails) SetKeepPrevVersion(v string) {
	o.KeepPrevVersion = &v
}

// GetName returns the Name field value
func (o *UpdateRDPTargetDetails) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *UpdateRDPTargetDetails) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *UpdateRDPTargetDetails) SetName(v string) {
	o.Name = v
}

// GetNewVersion returns the NewVersion field value if set, zero value otherwise.
func (o *UpdateRDPTargetDetails) GetNewVersion() bool {
	if o == nil || o.NewVersion == nil {
		var ret bool
		return ret
	}
	return *o.NewVersion
}

// GetNewVersionOk returns a tuple with the NewVersion field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateRDPTargetDetails) GetNewVersionOk() (*bool, bool) {
	if o == nil || o.NewVersion == nil {
		return nil, false
	}
	return o.NewVersion, true
}

// HasNewVersion returns a boolean if a field has been set.
func (o *UpdateRDPTargetDetails) HasNewVersion() bool {
	if o != nil && o.NewVersion != nil {
		return true
	}

	return false
}

// SetNewVersion gets a reference to the given bool and assigns it to the NewVersion field.
func (o *UpdateRDPTargetDetails) SetNewVersion(v bool) {
	o.NewVersion = &v
}

// GetProtectionKey returns the ProtectionKey field value if set, zero value otherwise.
func (o *UpdateRDPTargetDetails) GetProtectionKey() string {
	if o == nil || o.ProtectionKey == nil {
		var ret string
		return ret
	}
	return *o.ProtectionKey
}

// GetProtectionKeyOk returns a tuple with the ProtectionKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateRDPTargetDetails) GetProtectionKeyOk() (*string, bool) {
	if o == nil || o.ProtectionKey == nil {
		return nil, false
	}
	return o.ProtectionKey, true
}

// HasProtectionKey returns a boolean if a field has been set.
func (o *UpdateRDPTargetDetails) HasProtectionKey() bool {
	if o != nil && o.ProtectionKey != nil {
		return true
	}

	return false
}

// SetProtectionKey gets a reference to the given string and assigns it to the ProtectionKey field.
func (o *UpdateRDPTargetDetails) SetProtectionKey(v string) {
	o.ProtectionKey = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *UpdateRDPTargetDetails) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateRDPTargetDetails) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *UpdateRDPTargetDetails) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *UpdateRDPTargetDetails) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *UpdateRDPTargetDetails) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateRDPTargetDetails) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *UpdateRDPTargetDetails) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *UpdateRDPTargetDetails) SetUidToken(v string) {
	o.UidToken = &v
}

func (o UpdateRDPTargetDetails) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AdminName != nil {
		toSerialize["admin_name"] = o.AdminName
	}
	if o.AdminPwd != nil {
		toSerialize["admin_pwd"] = o.AdminPwd
	}
	if o.HostName != nil {
		toSerialize["host_name"] = o.HostName
	}
	if o.HostPort != nil {
		toSerialize["host_port"] = o.HostPort
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.KeepPrevVersion != nil {
		toSerialize["keep-prev-version"] = o.KeepPrevVersion
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.NewVersion != nil {
		toSerialize["new-version"] = o.NewVersion
	}
	if o.ProtectionKey != nil {
		toSerialize["protection_key"] = o.ProtectionKey
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableUpdateRDPTargetDetails struct {
	value *UpdateRDPTargetDetails
	isSet bool
}

func (v NullableUpdateRDPTargetDetails) Get() *UpdateRDPTargetDetails {
	return v.value
}

func (v *NullableUpdateRDPTargetDetails) Set(val *UpdateRDPTargetDetails) {
	v.value = val
	v.isSet = true
}

func (v NullableUpdateRDPTargetDetails) IsSet() bool {
	return v.isSet
}

func (v *NullableUpdateRDPTargetDetails) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableUpdateRDPTargetDetails(val *UpdateRDPTargetDetails) *NullableUpdateRDPTargetDetails {
	return &NullableUpdateRDPTargetDetails{value: val, isSet: true}
}

func (v NullableUpdateRDPTargetDetails) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableUpdateRDPTargetDetails) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


