/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// TargetUpdateHashiVault struct for TargetUpdateHashiVault
type TargetUpdateHashiVault struct {
	// Description of the object
	Description *string `json:"description,omitempty"`
	// HashiCorp Vault API URL, e.g. https://vault-mgr01:8200
	HashiUrl *string `json:"hashi-url,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Whether to keep previous version [true/false]. If not set, use default according to account settings
	KeepPrevVersion *string `json:"keep-prev-version,omitempty"`
	// The name of a key that used to encrypt the target secret value (if empty, the account default protectionKey key will be used)
	Key *string `json:"key,omitempty"`
	// Set the maximum number of versions, limited by the account settings defaults.
	MaxVersions *string `json:"max-versions,omitempty"`
	// Target name
	Name string `json:"name"`
	// Comma-separated list of vault namespaces
	Namespace *[]string `json:"namespace,omitempty"`
	// New target name
	NewName *string `json:"new-name,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// Vault access token with sufficient permissions
	VaultToken *string `json:"vault-token,omitempty"`
}

// NewTargetUpdateHashiVault instantiates a new TargetUpdateHashiVault object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewTargetUpdateHashiVault(name string, ) *TargetUpdateHashiVault {
	this := TargetUpdateHashiVault{}
	var json bool = false
	this.Json = &json
	this.Name = name
	return &this
}

// NewTargetUpdateHashiVaultWithDefaults instantiates a new TargetUpdateHashiVault object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewTargetUpdateHashiVaultWithDefaults() *TargetUpdateHashiVault {
	this := TargetUpdateHashiVault{}
	var json bool = false
	this.Json = &json
	return &this
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *TargetUpdateHashiVault) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetUpdateHashiVault) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *TargetUpdateHashiVault) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *TargetUpdateHashiVault) SetDescription(v string) {
	o.Description = &v
}

// GetHashiUrl returns the HashiUrl field value if set, zero value otherwise.
func (o *TargetUpdateHashiVault) GetHashiUrl() string {
	if o == nil || o.HashiUrl == nil {
		var ret string
		return ret
	}
	return *o.HashiUrl
}

// GetHashiUrlOk returns a tuple with the HashiUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetUpdateHashiVault) GetHashiUrlOk() (*string, bool) {
	if o == nil || o.HashiUrl == nil {
		return nil, false
	}
	return o.HashiUrl, true
}

// HasHashiUrl returns a boolean if a field has been set.
func (o *TargetUpdateHashiVault) HasHashiUrl() bool {
	if o != nil && o.HashiUrl != nil {
		return true
	}

	return false
}

// SetHashiUrl gets a reference to the given string and assigns it to the HashiUrl field.
func (o *TargetUpdateHashiVault) SetHashiUrl(v string) {
	o.HashiUrl = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *TargetUpdateHashiVault) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetUpdateHashiVault) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *TargetUpdateHashiVault) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *TargetUpdateHashiVault) SetJson(v bool) {
	o.Json = &v
}

// GetKeepPrevVersion returns the KeepPrevVersion field value if set, zero value otherwise.
func (o *TargetUpdateHashiVault) GetKeepPrevVersion() string {
	if o == nil || o.KeepPrevVersion == nil {
		var ret string
		return ret
	}
	return *o.KeepPrevVersion
}

// GetKeepPrevVersionOk returns a tuple with the KeepPrevVersion field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetUpdateHashiVault) GetKeepPrevVersionOk() (*string, bool) {
	if o == nil || o.KeepPrevVersion == nil {
		return nil, false
	}
	return o.KeepPrevVersion, true
}

// HasKeepPrevVersion returns a boolean if a field has been set.
func (o *TargetUpdateHashiVault) HasKeepPrevVersion() bool {
	if o != nil && o.KeepPrevVersion != nil {
		return true
	}

	return false
}

// SetKeepPrevVersion gets a reference to the given string and assigns it to the KeepPrevVersion field.
func (o *TargetUpdateHashiVault) SetKeepPrevVersion(v string) {
	o.KeepPrevVersion = &v
}

// GetKey returns the Key field value if set, zero value otherwise.
func (o *TargetUpdateHashiVault) GetKey() string {
	if o == nil || o.Key == nil {
		var ret string
		return ret
	}
	return *o.Key
}

// GetKeyOk returns a tuple with the Key field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetUpdateHashiVault) GetKeyOk() (*string, bool) {
	if o == nil || o.Key == nil {
		return nil, false
	}
	return o.Key, true
}

// HasKey returns a boolean if a field has been set.
func (o *TargetUpdateHashiVault) HasKey() bool {
	if o != nil && o.Key != nil {
		return true
	}

	return false
}

// SetKey gets a reference to the given string and assigns it to the Key field.
func (o *TargetUpdateHashiVault) SetKey(v string) {
	o.Key = &v
}

// GetMaxVersions returns the MaxVersions field value if set, zero value otherwise.
func (o *TargetUpdateHashiVault) GetMaxVersions() string {
	if o == nil || o.MaxVersions == nil {
		var ret string
		return ret
	}
	return *o.MaxVersions
}

// GetMaxVersionsOk returns a tuple with the MaxVersions field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetUpdateHashiVault) GetMaxVersionsOk() (*string, bool) {
	if o == nil || o.MaxVersions == nil {
		return nil, false
	}
	return o.MaxVersions, true
}

// HasMaxVersions returns a boolean if a field has been set.
func (o *TargetUpdateHashiVault) HasMaxVersions() bool {
	if o != nil && o.MaxVersions != nil {
		return true
	}

	return false
}

// SetMaxVersions gets a reference to the given string and assigns it to the MaxVersions field.
func (o *TargetUpdateHashiVault) SetMaxVersions(v string) {
	o.MaxVersions = &v
}

// GetName returns the Name field value
func (o *TargetUpdateHashiVault) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *TargetUpdateHashiVault) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *TargetUpdateHashiVault) SetName(v string) {
	o.Name = v
}

// GetNamespace returns the Namespace field value if set, zero value otherwise.
func (o *TargetUpdateHashiVault) GetNamespace() []string {
	if o == nil || o.Namespace == nil {
		var ret []string
		return ret
	}
	return *o.Namespace
}

// GetNamespaceOk returns a tuple with the Namespace field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetUpdateHashiVault) GetNamespaceOk() (*[]string, bool) {
	if o == nil || o.Namespace == nil {
		return nil, false
	}
	return o.Namespace, true
}

// HasNamespace returns a boolean if a field has been set.
func (o *TargetUpdateHashiVault) HasNamespace() bool {
	if o != nil && o.Namespace != nil {
		return true
	}

	return false
}

// SetNamespace gets a reference to the given []string and assigns it to the Namespace field.
func (o *TargetUpdateHashiVault) SetNamespace(v []string) {
	o.Namespace = &v
}

// GetNewName returns the NewName field value if set, zero value otherwise.
func (o *TargetUpdateHashiVault) GetNewName() string {
	if o == nil || o.NewName == nil {
		var ret string
		return ret
	}
	return *o.NewName
}

// GetNewNameOk returns a tuple with the NewName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetUpdateHashiVault) GetNewNameOk() (*string, bool) {
	if o == nil || o.NewName == nil {
		return nil, false
	}
	return o.NewName, true
}

// HasNewName returns a boolean if a field has been set.
func (o *TargetUpdateHashiVault) HasNewName() bool {
	if o != nil && o.NewName != nil {
		return true
	}

	return false
}

// SetNewName gets a reference to the given string and assigns it to the NewName field.
func (o *TargetUpdateHashiVault) SetNewName(v string) {
	o.NewName = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *TargetUpdateHashiVault) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetUpdateHashiVault) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *TargetUpdateHashiVault) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *TargetUpdateHashiVault) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *TargetUpdateHashiVault) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetUpdateHashiVault) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *TargetUpdateHashiVault) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *TargetUpdateHashiVault) SetUidToken(v string) {
	o.UidToken = &v
}

// GetVaultToken returns the VaultToken field value if set, zero value otherwise.
func (o *TargetUpdateHashiVault) GetVaultToken() string {
	if o == nil || o.VaultToken == nil {
		var ret string
		return ret
	}
	return *o.VaultToken
}

// GetVaultTokenOk returns a tuple with the VaultToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetUpdateHashiVault) GetVaultTokenOk() (*string, bool) {
	if o == nil || o.VaultToken == nil {
		return nil, false
	}
	return o.VaultToken, true
}

// HasVaultToken returns a boolean if a field has been set.
func (o *TargetUpdateHashiVault) HasVaultToken() bool {
	if o != nil && o.VaultToken != nil {
		return true
	}

	return false
}

// SetVaultToken gets a reference to the given string and assigns it to the VaultToken field.
func (o *TargetUpdateHashiVault) SetVaultToken(v string) {
	o.VaultToken = &v
}

func (o TargetUpdateHashiVault) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if o.HashiUrl != nil {
		toSerialize["hashi-url"] = o.HashiUrl
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.KeepPrevVersion != nil {
		toSerialize["keep-prev-version"] = o.KeepPrevVersion
	}
	if o.Key != nil {
		toSerialize["key"] = o.Key
	}
	if o.MaxVersions != nil {
		toSerialize["max-versions"] = o.MaxVersions
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.Namespace != nil {
		toSerialize["namespace"] = o.Namespace
	}
	if o.NewName != nil {
		toSerialize["new-name"] = o.NewName
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if o.VaultToken != nil {
		toSerialize["vault-token"] = o.VaultToken
	}
	return json.Marshal(toSerialize)
}

type NullableTargetUpdateHashiVault struct {
	value *TargetUpdateHashiVault
	isSet bool
}

func (v NullableTargetUpdateHashiVault) Get() *TargetUpdateHashiVault {
	return v.value
}

func (v *NullableTargetUpdateHashiVault) Set(val *TargetUpdateHashiVault) {
	v.value = val
	v.isSet = true
}

func (v NullableTargetUpdateHashiVault) IsSet() bool {
	return v.isSet
}

func (v *NullableTargetUpdateHashiVault) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableTargetUpdateHashiVault(val *TargetUpdateHashiVault) *NullableTargetUpdateHashiVault {
	return &NullableTargetUpdateHashiVault{value: val, isSet: true}
}

func (v NullableTargetUpdateHashiVault) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableTargetUpdateHashiVault) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


