/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// ImportPasswords importPasswords is a command that import passwords
type ImportPasswords struct {
	// for personal password manager
	Accessibility *string `json:"accessibility,omitempty"`
	// Password format type [LastPass/Chrome/Firefox/1password/keeper/bitwarden/dashlane]
	Format *string `json:"format,omitempty"`
	// File path
	ImportPath string `json:"import-path"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// The name of a key that used to encrypt the secret value (if empty, the account default protectionKey key will be used)
	ProtectionKey *string `json:"protection_key,omitempty"`
	// Target folder for imported passwords
	TargetFolder *string `json:"target-folder,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	UpdateMode *string `json:"update-mode,omitempty"`
}

// NewImportPasswords instantiates a new ImportPasswords object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewImportPasswords(importPath string, ) *ImportPasswords {
	this := ImportPasswords{}
	var accessibility string = "personal"
	this.Accessibility = &accessibility
	var format string = "LastPass"
	this.Format = &format
	this.ImportPath = importPath
	var json bool = false
	this.Json = &json
	var targetFolder string = "/"
	this.TargetFolder = &targetFolder
	return &this
}

// NewImportPasswordsWithDefaults instantiates a new ImportPasswords object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewImportPasswordsWithDefaults() *ImportPasswords {
	this := ImportPasswords{}
	var accessibility string = "personal"
	this.Accessibility = &accessibility
	var format string = "LastPass"
	this.Format = &format
	var json bool = false
	this.Json = &json
	var targetFolder string = "/"
	this.TargetFolder = &targetFolder
	return &this
}

// GetAccessibility returns the Accessibility field value if set, zero value otherwise.
func (o *ImportPasswords) GetAccessibility() string {
	if o == nil || o.Accessibility == nil {
		var ret string
		return ret
	}
	return *o.Accessibility
}

// GetAccessibilityOk returns a tuple with the Accessibility field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ImportPasswords) GetAccessibilityOk() (*string, bool) {
	if o == nil || o.Accessibility == nil {
		return nil, false
	}
	return o.Accessibility, true
}

// HasAccessibility returns a boolean if a field has been set.
func (o *ImportPasswords) HasAccessibility() bool {
	if o != nil && o.Accessibility != nil {
		return true
	}

	return false
}

// SetAccessibility gets a reference to the given string and assigns it to the Accessibility field.
func (o *ImportPasswords) SetAccessibility(v string) {
	o.Accessibility = &v
}

// GetFormat returns the Format field value if set, zero value otherwise.
func (o *ImportPasswords) GetFormat() string {
	if o == nil || o.Format == nil {
		var ret string
		return ret
	}
	return *o.Format
}

// GetFormatOk returns a tuple with the Format field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ImportPasswords) GetFormatOk() (*string, bool) {
	if o == nil || o.Format == nil {
		return nil, false
	}
	return o.Format, true
}

// HasFormat returns a boolean if a field has been set.
func (o *ImportPasswords) HasFormat() bool {
	if o != nil && o.Format != nil {
		return true
	}

	return false
}

// SetFormat gets a reference to the given string and assigns it to the Format field.
func (o *ImportPasswords) SetFormat(v string) {
	o.Format = &v
}

// GetImportPath returns the ImportPath field value
func (o *ImportPasswords) GetImportPath() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.ImportPath
}

// GetImportPathOk returns a tuple with the ImportPath field value
// and a boolean to check if the value has been set.
func (o *ImportPasswords) GetImportPathOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.ImportPath, true
}

// SetImportPath sets field value
func (o *ImportPasswords) SetImportPath(v string) {
	o.ImportPath = v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *ImportPasswords) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ImportPasswords) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *ImportPasswords) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *ImportPasswords) SetJson(v bool) {
	o.Json = &v
}

// GetProtectionKey returns the ProtectionKey field value if set, zero value otherwise.
func (o *ImportPasswords) GetProtectionKey() string {
	if o == nil || o.ProtectionKey == nil {
		var ret string
		return ret
	}
	return *o.ProtectionKey
}

// GetProtectionKeyOk returns a tuple with the ProtectionKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ImportPasswords) GetProtectionKeyOk() (*string, bool) {
	if o == nil || o.ProtectionKey == nil {
		return nil, false
	}
	return o.ProtectionKey, true
}

// HasProtectionKey returns a boolean if a field has been set.
func (o *ImportPasswords) HasProtectionKey() bool {
	if o != nil && o.ProtectionKey != nil {
		return true
	}

	return false
}

// SetProtectionKey gets a reference to the given string and assigns it to the ProtectionKey field.
func (o *ImportPasswords) SetProtectionKey(v string) {
	o.ProtectionKey = &v
}

// GetTargetFolder returns the TargetFolder field value if set, zero value otherwise.
func (o *ImportPasswords) GetTargetFolder() string {
	if o == nil || o.TargetFolder == nil {
		var ret string
		return ret
	}
	return *o.TargetFolder
}

// GetTargetFolderOk returns a tuple with the TargetFolder field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ImportPasswords) GetTargetFolderOk() (*string, bool) {
	if o == nil || o.TargetFolder == nil {
		return nil, false
	}
	return o.TargetFolder, true
}

// HasTargetFolder returns a boolean if a field has been set.
func (o *ImportPasswords) HasTargetFolder() bool {
	if o != nil && o.TargetFolder != nil {
		return true
	}

	return false
}

// SetTargetFolder gets a reference to the given string and assigns it to the TargetFolder field.
func (o *ImportPasswords) SetTargetFolder(v string) {
	o.TargetFolder = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *ImportPasswords) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ImportPasswords) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *ImportPasswords) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *ImportPasswords) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *ImportPasswords) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ImportPasswords) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *ImportPasswords) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *ImportPasswords) SetUidToken(v string) {
	o.UidToken = &v
}

// GetUpdateMode returns the UpdateMode field value if set, zero value otherwise.
func (o *ImportPasswords) GetUpdateMode() string {
	if o == nil || o.UpdateMode == nil {
		var ret string
		return ret
	}
	return *o.UpdateMode
}

// GetUpdateModeOk returns a tuple with the UpdateMode field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ImportPasswords) GetUpdateModeOk() (*string, bool) {
	if o == nil || o.UpdateMode == nil {
		return nil, false
	}
	return o.UpdateMode, true
}

// HasUpdateMode returns a boolean if a field has been set.
func (o *ImportPasswords) HasUpdateMode() bool {
	if o != nil && o.UpdateMode != nil {
		return true
	}

	return false
}

// SetUpdateMode gets a reference to the given string and assigns it to the UpdateMode field.
func (o *ImportPasswords) SetUpdateMode(v string) {
	o.UpdateMode = &v
}

func (o ImportPasswords) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Accessibility != nil {
		toSerialize["accessibility"] = o.Accessibility
	}
	if o.Format != nil {
		toSerialize["format"] = o.Format
	}
	if true {
		toSerialize["import-path"] = o.ImportPath
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.ProtectionKey != nil {
		toSerialize["protection_key"] = o.ProtectionKey
	}
	if o.TargetFolder != nil {
		toSerialize["target-folder"] = o.TargetFolder
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if o.UpdateMode != nil {
		toSerialize["update-mode"] = o.UpdateMode
	}
	return json.Marshal(toSerialize)
}

type NullableImportPasswords struct {
	value *ImportPasswords
	isSet bool
}

func (v NullableImportPasswords) Get() *ImportPasswords {
	return v.value
}

func (v *NullableImportPasswords) Set(val *ImportPasswords) {
	v.value = val
	v.isSet = true
}

func (v NullableImportPasswords) IsSet() bool {
	return v.isSet
}

func (v *NullableImportPasswords) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableImportPasswords(val *ImportPasswords) *NullableImportPasswords {
	return &NullableImportPasswords{value: val, isSet: true}
}

func (v NullableImportPasswords) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableImportPasswords) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


