/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// DynamicSecretUpdateMsSql dynamicSecretUpdateMsSql is a command that updates mssql dynamic secret
type DynamicSecretUpdateMsSql struct {
	// Protection from accidental deletion of this object [true/false]
	DeleteProtection *string `json:"delete_protection,omitempty"`
	// Description of the object
	Description *string `json:"description,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// MSSQL Creation statements
	MssqlCreateStatements *string `json:"mssql-create-statements,omitempty"`
	// MSSQL Name
	MssqlDbname *string `json:"mssql-dbname,omitempty"`
	// MSSQL Host
	MssqlHost *string `json:"mssql-host,omitempty"`
	// MSSQL Password
	MssqlPassword *string `json:"mssql-password,omitempty"`
	// MSSQL Port
	MssqlPort *string `json:"mssql-port,omitempty"`
	// MSSQL Revocation statements
	MssqlRevocationStatements *string `json:"mssql-revocation-statements,omitempty"`
	// MSSQL Username
	MssqlUsername *string `json:"mssql-username,omitempty"`
	// Dynamic secret name
	Name string `json:"name"`
	// Dynamic secret name
	NewName *string `json:"new-name,omitempty"`
	// The length of the password to be generated
	PasswordLength *string `json:"password-length,omitempty"`
	// Dynamic producer encryption key
	ProducerEncryptionKeyName *string `json:"producer-encryption-key-name,omitempty"`
	// Path to the SSH Certificate Issuer for your Akeyless Bastion
	SecureAccessBastionIssuer *string `json:"secure-access-bastion-issuer,omitempty"`
	// The DB schema
	SecureAccessDbSchema *string `json:"secure-access-db-schema,omitempty"`
	// Enable/Disable secure remote access [true/false]
	SecureAccessEnable *string `json:"secure-access-enable,omitempty"`
	// Target DB servers for connections (In case of Linked Target association, host(s) will inherit Linked Target hosts)
	SecureAccessHost *[]string `json:"secure-access-host,omitempty"`
	// Enable Web Secure Remote Access
	SecureAccessWeb *bool `json:"secure-access-web,omitempty"`
	// Add tags attached to this object
	Tags *[]string `json:"tags,omitempty"`
	// Target name
	TargetName *string `json:"target-name,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// User TTL
	UserTtl *string `json:"user-ttl,omitempty"`
}

// NewDynamicSecretUpdateMsSql instantiates a new DynamicSecretUpdateMsSql object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDynamicSecretUpdateMsSql(name string, ) *DynamicSecretUpdateMsSql {
	this := DynamicSecretUpdateMsSql{}
	var json bool = false
	this.Json = &json
	var mssqlHost string = "127.0.0.1"
	this.MssqlHost = &mssqlHost
	var mssqlPort string = "1433"
	this.MssqlPort = &mssqlPort
	this.Name = name
	var secureAccessWeb bool = false
	this.SecureAccessWeb = &secureAccessWeb
	var userTtl string = "60m"
	this.UserTtl = &userTtl
	return &this
}

// NewDynamicSecretUpdateMsSqlWithDefaults instantiates a new DynamicSecretUpdateMsSql object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDynamicSecretUpdateMsSqlWithDefaults() *DynamicSecretUpdateMsSql {
	this := DynamicSecretUpdateMsSql{}
	var json bool = false
	this.Json = &json
	var mssqlHost string = "127.0.0.1"
	this.MssqlHost = &mssqlHost
	var mssqlPort string = "1433"
	this.MssqlPort = &mssqlPort
	var secureAccessWeb bool = false
	this.SecureAccessWeb = &secureAccessWeb
	var userTtl string = "60m"
	this.UserTtl = &userTtl
	return &this
}

// GetDeleteProtection returns the DeleteProtection field value if set, zero value otherwise.
func (o *DynamicSecretUpdateMsSql) GetDeleteProtection() string {
	if o == nil || o.DeleteProtection == nil {
		var ret string
		return ret
	}
	return *o.DeleteProtection
}

// GetDeleteProtectionOk returns a tuple with the DeleteProtection field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateMsSql) GetDeleteProtectionOk() (*string, bool) {
	if o == nil || o.DeleteProtection == nil {
		return nil, false
	}
	return o.DeleteProtection, true
}

// HasDeleteProtection returns a boolean if a field has been set.
func (o *DynamicSecretUpdateMsSql) HasDeleteProtection() bool {
	if o != nil && o.DeleteProtection != nil {
		return true
	}

	return false
}

// SetDeleteProtection gets a reference to the given string and assigns it to the DeleteProtection field.
func (o *DynamicSecretUpdateMsSql) SetDeleteProtection(v string) {
	o.DeleteProtection = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *DynamicSecretUpdateMsSql) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateMsSql) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *DynamicSecretUpdateMsSql) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *DynamicSecretUpdateMsSql) SetDescription(v string) {
	o.Description = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *DynamicSecretUpdateMsSql) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateMsSql) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *DynamicSecretUpdateMsSql) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *DynamicSecretUpdateMsSql) SetJson(v bool) {
	o.Json = &v
}

// GetMssqlCreateStatements returns the MssqlCreateStatements field value if set, zero value otherwise.
func (o *DynamicSecretUpdateMsSql) GetMssqlCreateStatements() string {
	if o == nil || o.MssqlCreateStatements == nil {
		var ret string
		return ret
	}
	return *o.MssqlCreateStatements
}

// GetMssqlCreateStatementsOk returns a tuple with the MssqlCreateStatements field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateMsSql) GetMssqlCreateStatementsOk() (*string, bool) {
	if o == nil || o.MssqlCreateStatements == nil {
		return nil, false
	}
	return o.MssqlCreateStatements, true
}

// HasMssqlCreateStatements returns a boolean if a field has been set.
func (o *DynamicSecretUpdateMsSql) HasMssqlCreateStatements() bool {
	if o != nil && o.MssqlCreateStatements != nil {
		return true
	}

	return false
}

// SetMssqlCreateStatements gets a reference to the given string and assigns it to the MssqlCreateStatements field.
func (o *DynamicSecretUpdateMsSql) SetMssqlCreateStatements(v string) {
	o.MssqlCreateStatements = &v
}

// GetMssqlDbname returns the MssqlDbname field value if set, zero value otherwise.
func (o *DynamicSecretUpdateMsSql) GetMssqlDbname() string {
	if o == nil || o.MssqlDbname == nil {
		var ret string
		return ret
	}
	return *o.MssqlDbname
}

// GetMssqlDbnameOk returns a tuple with the MssqlDbname field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateMsSql) GetMssqlDbnameOk() (*string, bool) {
	if o == nil || o.MssqlDbname == nil {
		return nil, false
	}
	return o.MssqlDbname, true
}

// HasMssqlDbname returns a boolean if a field has been set.
func (o *DynamicSecretUpdateMsSql) HasMssqlDbname() bool {
	if o != nil && o.MssqlDbname != nil {
		return true
	}

	return false
}

// SetMssqlDbname gets a reference to the given string and assigns it to the MssqlDbname field.
func (o *DynamicSecretUpdateMsSql) SetMssqlDbname(v string) {
	o.MssqlDbname = &v
}

// GetMssqlHost returns the MssqlHost field value if set, zero value otherwise.
func (o *DynamicSecretUpdateMsSql) GetMssqlHost() string {
	if o == nil || o.MssqlHost == nil {
		var ret string
		return ret
	}
	return *o.MssqlHost
}

// GetMssqlHostOk returns a tuple with the MssqlHost field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateMsSql) GetMssqlHostOk() (*string, bool) {
	if o == nil || o.MssqlHost == nil {
		return nil, false
	}
	return o.MssqlHost, true
}

// HasMssqlHost returns a boolean if a field has been set.
func (o *DynamicSecretUpdateMsSql) HasMssqlHost() bool {
	if o != nil && o.MssqlHost != nil {
		return true
	}

	return false
}

// SetMssqlHost gets a reference to the given string and assigns it to the MssqlHost field.
func (o *DynamicSecretUpdateMsSql) SetMssqlHost(v string) {
	o.MssqlHost = &v
}

// GetMssqlPassword returns the MssqlPassword field value if set, zero value otherwise.
func (o *DynamicSecretUpdateMsSql) GetMssqlPassword() string {
	if o == nil || o.MssqlPassword == nil {
		var ret string
		return ret
	}
	return *o.MssqlPassword
}

// GetMssqlPasswordOk returns a tuple with the MssqlPassword field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateMsSql) GetMssqlPasswordOk() (*string, bool) {
	if o == nil || o.MssqlPassword == nil {
		return nil, false
	}
	return o.MssqlPassword, true
}

// HasMssqlPassword returns a boolean if a field has been set.
func (o *DynamicSecretUpdateMsSql) HasMssqlPassword() bool {
	if o != nil && o.MssqlPassword != nil {
		return true
	}

	return false
}

// SetMssqlPassword gets a reference to the given string and assigns it to the MssqlPassword field.
func (o *DynamicSecretUpdateMsSql) SetMssqlPassword(v string) {
	o.MssqlPassword = &v
}

// GetMssqlPort returns the MssqlPort field value if set, zero value otherwise.
func (o *DynamicSecretUpdateMsSql) GetMssqlPort() string {
	if o == nil || o.MssqlPort == nil {
		var ret string
		return ret
	}
	return *o.MssqlPort
}

// GetMssqlPortOk returns a tuple with the MssqlPort field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateMsSql) GetMssqlPortOk() (*string, bool) {
	if o == nil || o.MssqlPort == nil {
		return nil, false
	}
	return o.MssqlPort, true
}

// HasMssqlPort returns a boolean if a field has been set.
func (o *DynamicSecretUpdateMsSql) HasMssqlPort() bool {
	if o != nil && o.MssqlPort != nil {
		return true
	}

	return false
}

// SetMssqlPort gets a reference to the given string and assigns it to the MssqlPort field.
func (o *DynamicSecretUpdateMsSql) SetMssqlPort(v string) {
	o.MssqlPort = &v
}

// GetMssqlRevocationStatements returns the MssqlRevocationStatements field value if set, zero value otherwise.
func (o *DynamicSecretUpdateMsSql) GetMssqlRevocationStatements() string {
	if o == nil || o.MssqlRevocationStatements == nil {
		var ret string
		return ret
	}
	return *o.MssqlRevocationStatements
}

// GetMssqlRevocationStatementsOk returns a tuple with the MssqlRevocationStatements field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateMsSql) GetMssqlRevocationStatementsOk() (*string, bool) {
	if o == nil || o.MssqlRevocationStatements == nil {
		return nil, false
	}
	return o.MssqlRevocationStatements, true
}

// HasMssqlRevocationStatements returns a boolean if a field has been set.
func (o *DynamicSecretUpdateMsSql) HasMssqlRevocationStatements() bool {
	if o != nil && o.MssqlRevocationStatements != nil {
		return true
	}

	return false
}

// SetMssqlRevocationStatements gets a reference to the given string and assigns it to the MssqlRevocationStatements field.
func (o *DynamicSecretUpdateMsSql) SetMssqlRevocationStatements(v string) {
	o.MssqlRevocationStatements = &v
}

// GetMssqlUsername returns the MssqlUsername field value if set, zero value otherwise.
func (o *DynamicSecretUpdateMsSql) GetMssqlUsername() string {
	if o == nil || o.MssqlUsername == nil {
		var ret string
		return ret
	}
	return *o.MssqlUsername
}

// GetMssqlUsernameOk returns a tuple with the MssqlUsername field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateMsSql) GetMssqlUsernameOk() (*string, bool) {
	if o == nil || o.MssqlUsername == nil {
		return nil, false
	}
	return o.MssqlUsername, true
}

// HasMssqlUsername returns a boolean if a field has been set.
func (o *DynamicSecretUpdateMsSql) HasMssqlUsername() bool {
	if o != nil && o.MssqlUsername != nil {
		return true
	}

	return false
}

// SetMssqlUsername gets a reference to the given string and assigns it to the MssqlUsername field.
func (o *DynamicSecretUpdateMsSql) SetMssqlUsername(v string) {
	o.MssqlUsername = &v
}

// GetName returns the Name field value
func (o *DynamicSecretUpdateMsSql) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateMsSql) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *DynamicSecretUpdateMsSql) SetName(v string) {
	o.Name = v
}

// GetNewName returns the NewName field value if set, zero value otherwise.
func (o *DynamicSecretUpdateMsSql) GetNewName() string {
	if o == nil || o.NewName == nil {
		var ret string
		return ret
	}
	return *o.NewName
}

// GetNewNameOk returns a tuple with the NewName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateMsSql) GetNewNameOk() (*string, bool) {
	if o == nil || o.NewName == nil {
		return nil, false
	}
	return o.NewName, true
}

// HasNewName returns a boolean if a field has been set.
func (o *DynamicSecretUpdateMsSql) HasNewName() bool {
	if o != nil && o.NewName != nil {
		return true
	}

	return false
}

// SetNewName gets a reference to the given string and assigns it to the NewName field.
func (o *DynamicSecretUpdateMsSql) SetNewName(v string) {
	o.NewName = &v
}

// GetPasswordLength returns the PasswordLength field value if set, zero value otherwise.
func (o *DynamicSecretUpdateMsSql) GetPasswordLength() string {
	if o == nil || o.PasswordLength == nil {
		var ret string
		return ret
	}
	return *o.PasswordLength
}

// GetPasswordLengthOk returns a tuple with the PasswordLength field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateMsSql) GetPasswordLengthOk() (*string, bool) {
	if o == nil || o.PasswordLength == nil {
		return nil, false
	}
	return o.PasswordLength, true
}

// HasPasswordLength returns a boolean if a field has been set.
func (o *DynamicSecretUpdateMsSql) HasPasswordLength() bool {
	if o != nil && o.PasswordLength != nil {
		return true
	}

	return false
}

// SetPasswordLength gets a reference to the given string and assigns it to the PasswordLength field.
func (o *DynamicSecretUpdateMsSql) SetPasswordLength(v string) {
	o.PasswordLength = &v
}

// GetProducerEncryptionKeyName returns the ProducerEncryptionKeyName field value if set, zero value otherwise.
func (o *DynamicSecretUpdateMsSql) GetProducerEncryptionKeyName() string {
	if o == nil || o.ProducerEncryptionKeyName == nil {
		var ret string
		return ret
	}
	return *o.ProducerEncryptionKeyName
}

// GetProducerEncryptionKeyNameOk returns a tuple with the ProducerEncryptionKeyName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateMsSql) GetProducerEncryptionKeyNameOk() (*string, bool) {
	if o == nil || o.ProducerEncryptionKeyName == nil {
		return nil, false
	}
	return o.ProducerEncryptionKeyName, true
}

// HasProducerEncryptionKeyName returns a boolean if a field has been set.
func (o *DynamicSecretUpdateMsSql) HasProducerEncryptionKeyName() bool {
	if o != nil && o.ProducerEncryptionKeyName != nil {
		return true
	}

	return false
}

// SetProducerEncryptionKeyName gets a reference to the given string and assigns it to the ProducerEncryptionKeyName field.
func (o *DynamicSecretUpdateMsSql) SetProducerEncryptionKeyName(v string) {
	o.ProducerEncryptionKeyName = &v
}

// GetSecureAccessBastionIssuer returns the SecureAccessBastionIssuer field value if set, zero value otherwise.
func (o *DynamicSecretUpdateMsSql) GetSecureAccessBastionIssuer() string {
	if o == nil || o.SecureAccessBastionIssuer == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessBastionIssuer
}

// GetSecureAccessBastionIssuerOk returns a tuple with the SecureAccessBastionIssuer field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateMsSql) GetSecureAccessBastionIssuerOk() (*string, bool) {
	if o == nil || o.SecureAccessBastionIssuer == nil {
		return nil, false
	}
	return o.SecureAccessBastionIssuer, true
}

// HasSecureAccessBastionIssuer returns a boolean if a field has been set.
func (o *DynamicSecretUpdateMsSql) HasSecureAccessBastionIssuer() bool {
	if o != nil && o.SecureAccessBastionIssuer != nil {
		return true
	}

	return false
}

// SetSecureAccessBastionIssuer gets a reference to the given string and assigns it to the SecureAccessBastionIssuer field.
func (o *DynamicSecretUpdateMsSql) SetSecureAccessBastionIssuer(v string) {
	o.SecureAccessBastionIssuer = &v
}

// GetSecureAccessDbSchema returns the SecureAccessDbSchema field value if set, zero value otherwise.
func (o *DynamicSecretUpdateMsSql) GetSecureAccessDbSchema() string {
	if o == nil || o.SecureAccessDbSchema == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessDbSchema
}

// GetSecureAccessDbSchemaOk returns a tuple with the SecureAccessDbSchema field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateMsSql) GetSecureAccessDbSchemaOk() (*string, bool) {
	if o == nil || o.SecureAccessDbSchema == nil {
		return nil, false
	}
	return o.SecureAccessDbSchema, true
}

// HasSecureAccessDbSchema returns a boolean if a field has been set.
func (o *DynamicSecretUpdateMsSql) HasSecureAccessDbSchema() bool {
	if o != nil && o.SecureAccessDbSchema != nil {
		return true
	}

	return false
}

// SetSecureAccessDbSchema gets a reference to the given string and assigns it to the SecureAccessDbSchema field.
func (o *DynamicSecretUpdateMsSql) SetSecureAccessDbSchema(v string) {
	o.SecureAccessDbSchema = &v
}

// GetSecureAccessEnable returns the SecureAccessEnable field value if set, zero value otherwise.
func (o *DynamicSecretUpdateMsSql) GetSecureAccessEnable() string {
	if o == nil || o.SecureAccessEnable == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessEnable
}

// GetSecureAccessEnableOk returns a tuple with the SecureAccessEnable field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateMsSql) GetSecureAccessEnableOk() (*string, bool) {
	if o == nil || o.SecureAccessEnable == nil {
		return nil, false
	}
	return o.SecureAccessEnable, true
}

// HasSecureAccessEnable returns a boolean if a field has been set.
func (o *DynamicSecretUpdateMsSql) HasSecureAccessEnable() bool {
	if o != nil && o.SecureAccessEnable != nil {
		return true
	}

	return false
}

// SetSecureAccessEnable gets a reference to the given string and assigns it to the SecureAccessEnable field.
func (o *DynamicSecretUpdateMsSql) SetSecureAccessEnable(v string) {
	o.SecureAccessEnable = &v
}

// GetSecureAccessHost returns the SecureAccessHost field value if set, zero value otherwise.
func (o *DynamicSecretUpdateMsSql) GetSecureAccessHost() []string {
	if o == nil || o.SecureAccessHost == nil {
		var ret []string
		return ret
	}
	return *o.SecureAccessHost
}

// GetSecureAccessHostOk returns a tuple with the SecureAccessHost field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateMsSql) GetSecureAccessHostOk() (*[]string, bool) {
	if o == nil || o.SecureAccessHost == nil {
		return nil, false
	}
	return o.SecureAccessHost, true
}

// HasSecureAccessHost returns a boolean if a field has been set.
func (o *DynamicSecretUpdateMsSql) HasSecureAccessHost() bool {
	if o != nil && o.SecureAccessHost != nil {
		return true
	}

	return false
}

// SetSecureAccessHost gets a reference to the given []string and assigns it to the SecureAccessHost field.
func (o *DynamicSecretUpdateMsSql) SetSecureAccessHost(v []string) {
	o.SecureAccessHost = &v
}

// GetSecureAccessWeb returns the SecureAccessWeb field value if set, zero value otherwise.
func (o *DynamicSecretUpdateMsSql) GetSecureAccessWeb() bool {
	if o == nil || o.SecureAccessWeb == nil {
		var ret bool
		return ret
	}
	return *o.SecureAccessWeb
}

// GetSecureAccessWebOk returns a tuple with the SecureAccessWeb field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateMsSql) GetSecureAccessWebOk() (*bool, bool) {
	if o == nil || o.SecureAccessWeb == nil {
		return nil, false
	}
	return o.SecureAccessWeb, true
}

// HasSecureAccessWeb returns a boolean if a field has been set.
func (o *DynamicSecretUpdateMsSql) HasSecureAccessWeb() bool {
	if o != nil && o.SecureAccessWeb != nil {
		return true
	}

	return false
}

// SetSecureAccessWeb gets a reference to the given bool and assigns it to the SecureAccessWeb field.
func (o *DynamicSecretUpdateMsSql) SetSecureAccessWeb(v bool) {
	o.SecureAccessWeb = &v
}

// GetTags returns the Tags field value if set, zero value otherwise.
func (o *DynamicSecretUpdateMsSql) GetTags() []string {
	if o == nil || o.Tags == nil {
		var ret []string
		return ret
	}
	return *o.Tags
}

// GetTagsOk returns a tuple with the Tags field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateMsSql) GetTagsOk() (*[]string, bool) {
	if o == nil || o.Tags == nil {
		return nil, false
	}
	return o.Tags, true
}

// HasTags returns a boolean if a field has been set.
func (o *DynamicSecretUpdateMsSql) HasTags() bool {
	if o != nil && o.Tags != nil {
		return true
	}

	return false
}

// SetTags gets a reference to the given []string and assigns it to the Tags field.
func (o *DynamicSecretUpdateMsSql) SetTags(v []string) {
	o.Tags = &v
}

// GetTargetName returns the TargetName field value if set, zero value otherwise.
func (o *DynamicSecretUpdateMsSql) GetTargetName() string {
	if o == nil || o.TargetName == nil {
		var ret string
		return ret
	}
	return *o.TargetName
}

// GetTargetNameOk returns a tuple with the TargetName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateMsSql) GetTargetNameOk() (*string, bool) {
	if o == nil || o.TargetName == nil {
		return nil, false
	}
	return o.TargetName, true
}

// HasTargetName returns a boolean if a field has been set.
func (o *DynamicSecretUpdateMsSql) HasTargetName() bool {
	if o != nil && o.TargetName != nil {
		return true
	}

	return false
}

// SetTargetName gets a reference to the given string and assigns it to the TargetName field.
func (o *DynamicSecretUpdateMsSql) SetTargetName(v string) {
	o.TargetName = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *DynamicSecretUpdateMsSql) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateMsSql) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *DynamicSecretUpdateMsSql) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *DynamicSecretUpdateMsSql) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *DynamicSecretUpdateMsSql) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateMsSql) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *DynamicSecretUpdateMsSql) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *DynamicSecretUpdateMsSql) SetUidToken(v string) {
	o.UidToken = &v
}

// GetUserTtl returns the UserTtl field value if set, zero value otherwise.
func (o *DynamicSecretUpdateMsSql) GetUserTtl() string {
	if o == nil || o.UserTtl == nil {
		var ret string
		return ret
	}
	return *o.UserTtl
}

// GetUserTtlOk returns a tuple with the UserTtl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateMsSql) GetUserTtlOk() (*string, bool) {
	if o == nil || o.UserTtl == nil {
		return nil, false
	}
	return o.UserTtl, true
}

// HasUserTtl returns a boolean if a field has been set.
func (o *DynamicSecretUpdateMsSql) HasUserTtl() bool {
	if o != nil && o.UserTtl != nil {
		return true
	}

	return false
}

// SetUserTtl gets a reference to the given string and assigns it to the UserTtl field.
func (o *DynamicSecretUpdateMsSql) SetUserTtl(v string) {
	o.UserTtl = &v
}

func (o DynamicSecretUpdateMsSql) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.DeleteProtection != nil {
		toSerialize["delete_protection"] = o.DeleteProtection
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.MssqlCreateStatements != nil {
		toSerialize["mssql-create-statements"] = o.MssqlCreateStatements
	}
	if o.MssqlDbname != nil {
		toSerialize["mssql-dbname"] = o.MssqlDbname
	}
	if o.MssqlHost != nil {
		toSerialize["mssql-host"] = o.MssqlHost
	}
	if o.MssqlPassword != nil {
		toSerialize["mssql-password"] = o.MssqlPassword
	}
	if o.MssqlPort != nil {
		toSerialize["mssql-port"] = o.MssqlPort
	}
	if o.MssqlRevocationStatements != nil {
		toSerialize["mssql-revocation-statements"] = o.MssqlRevocationStatements
	}
	if o.MssqlUsername != nil {
		toSerialize["mssql-username"] = o.MssqlUsername
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.NewName != nil {
		toSerialize["new-name"] = o.NewName
	}
	if o.PasswordLength != nil {
		toSerialize["password-length"] = o.PasswordLength
	}
	if o.ProducerEncryptionKeyName != nil {
		toSerialize["producer-encryption-key-name"] = o.ProducerEncryptionKeyName
	}
	if o.SecureAccessBastionIssuer != nil {
		toSerialize["secure-access-bastion-issuer"] = o.SecureAccessBastionIssuer
	}
	if o.SecureAccessDbSchema != nil {
		toSerialize["secure-access-db-schema"] = o.SecureAccessDbSchema
	}
	if o.SecureAccessEnable != nil {
		toSerialize["secure-access-enable"] = o.SecureAccessEnable
	}
	if o.SecureAccessHost != nil {
		toSerialize["secure-access-host"] = o.SecureAccessHost
	}
	if o.SecureAccessWeb != nil {
		toSerialize["secure-access-web"] = o.SecureAccessWeb
	}
	if o.Tags != nil {
		toSerialize["tags"] = o.Tags
	}
	if o.TargetName != nil {
		toSerialize["target-name"] = o.TargetName
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if o.UserTtl != nil {
		toSerialize["user-ttl"] = o.UserTtl
	}
	return json.Marshal(toSerialize)
}

type NullableDynamicSecretUpdateMsSql struct {
	value *DynamicSecretUpdateMsSql
	isSet bool
}

func (v NullableDynamicSecretUpdateMsSql) Get() *DynamicSecretUpdateMsSql {
	return v.value
}

func (v *NullableDynamicSecretUpdateMsSql) Set(val *DynamicSecretUpdateMsSql) {
	v.value = val
	v.isSet = true
}

func (v NullableDynamicSecretUpdateMsSql) IsSet() bool {
	return v.isSet
}

func (v *NullableDynamicSecretUpdateMsSql) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDynamicSecretUpdateMsSql(val *DynamicSecretUpdateMsSql) *NullableDynamicSecretUpdateMsSql {
	return &NullableDynamicSecretUpdateMsSql{value: val, isSet: true}
}

func (v NullableDynamicSecretUpdateMsSql) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDynamicSecretUpdateMsSql) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


