// Copyright 2024 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package gkebackup provides access to the Backup for GKE API.
//
// For product documentation, see: https://cloud.google.com/kubernetes-engine/docs/add-on/backup-for-gke
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/gkebackup/v1"
//	...
//	ctx := context.Background()
//	gkebackupService, err := gkebackup.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	gkebackupService, err := gkebackup.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	gkebackupService, err := gkebackup.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package gkebackup // import "google.golang.org/api/gkebackup/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version

const apiId = "gkebackup:v1"
const apiName = "gkebackup"
const apiVersion = "v1"
const basePath = "https://gkebackup.googleapis.com/"
const basePathTemplate = "https://gkebackup.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://gkebackup.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Projects = NewProjectsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.BackupPlans = NewProjectsLocationsBackupPlansService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	rs.RestorePlans = NewProjectsLocationsRestorePlansService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	BackupPlans *ProjectsLocationsBackupPlansService

	Operations *ProjectsLocationsOperationsService

	RestorePlans *ProjectsLocationsRestorePlansService
}

func NewProjectsLocationsBackupPlansService(s *Service) *ProjectsLocationsBackupPlansService {
	rs := &ProjectsLocationsBackupPlansService{s: s}
	rs.Backups = NewProjectsLocationsBackupPlansBackupsService(s)
	return rs
}

type ProjectsLocationsBackupPlansService struct {
	s *Service

	Backups *ProjectsLocationsBackupPlansBackupsService
}

func NewProjectsLocationsBackupPlansBackupsService(s *Service) *ProjectsLocationsBackupPlansBackupsService {
	rs := &ProjectsLocationsBackupPlansBackupsService{s: s}
	rs.VolumeBackups = NewProjectsLocationsBackupPlansBackupsVolumeBackupsService(s)
	return rs
}

type ProjectsLocationsBackupPlansBackupsService struct {
	s *Service

	VolumeBackups *ProjectsLocationsBackupPlansBackupsVolumeBackupsService
}

func NewProjectsLocationsBackupPlansBackupsVolumeBackupsService(s *Service) *ProjectsLocationsBackupPlansBackupsVolumeBackupsService {
	rs := &ProjectsLocationsBackupPlansBackupsVolumeBackupsService{s: s}
	return rs
}

type ProjectsLocationsBackupPlansBackupsVolumeBackupsService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

func NewProjectsLocationsRestorePlansService(s *Service) *ProjectsLocationsRestorePlansService {
	rs := &ProjectsLocationsRestorePlansService{s: s}
	rs.Restores = NewProjectsLocationsRestorePlansRestoresService(s)
	return rs
}

type ProjectsLocationsRestorePlansService struct {
	s *Service

	Restores *ProjectsLocationsRestorePlansRestoresService
}

func NewProjectsLocationsRestorePlansRestoresService(s *Service) *ProjectsLocationsRestorePlansRestoresService {
	rs := &ProjectsLocationsRestorePlansRestoresService{s: s}
	rs.VolumeRestores = NewProjectsLocationsRestorePlansRestoresVolumeRestoresService(s)
	return rs
}

type ProjectsLocationsRestorePlansRestoresService struct {
	s *Service

	VolumeRestores *ProjectsLocationsRestorePlansRestoresVolumeRestoresService
}

func NewProjectsLocationsRestorePlansRestoresVolumeRestoresService(s *Service) *ProjectsLocationsRestorePlansRestoresVolumeRestoresService {
	rs := &ProjectsLocationsRestorePlansRestoresVolumeRestoresService{s: s}
	return rs
}

type ProjectsLocationsRestorePlansRestoresVolumeRestoresService struct {
	s *Service
}

// AuditConfig: Specifies the audit configuration for a service. The
// configuration determines which permission types are logged, and what
// identities, if any, are exempted from logging. An AuditConfig must have one
// or more AuditLogConfigs. If there are AuditConfigs for both `allServices`
// and a specific service, the union of the two AuditConfigs is used for that
// service: the log_types specified in each AuditConfig are enabled, and the
// exempted_members in each AuditLogConfig are exempted. Example Policy with
// multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
// "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
// "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
// "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
// "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
// "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
// sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
// logging. It also exempts `jose@example.com` from DATA_READ logging, and
// `aliya@example.com` from DATA_WRITE logging.
type AuditConfig struct {
	// AuditLogConfigs: The configuration for logging of each type of permission.
	AuditLogConfigs []*AuditLogConfig `json:"auditLogConfigs,omitempty"`
	// Service: Specifies a service that will be enabled for audit logging. For
	// example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices`
	// is a special value that covers all services.
	Service string `json:"service,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AuditLogConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuditLogConfigs") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuditConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AuditConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AuditLogConfig: Provides the configuration for logging a type of
// permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ",
// "exempted_members": [ "user:jose@example.com" ] }, { "log_type":
// "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while
// exempting jose@example.com from DATA_READ logging.
type AuditLogConfig struct {
	// ExemptedMembers: Specifies the identities that do not cause logging for this
	// type of permission. Follows the same format of Binding.members.
	ExemptedMembers []string `json:"exemptedMembers,omitempty"`
	// LogType: The log type that this config enables.
	//
	// Possible values:
	//   "LOG_TYPE_UNSPECIFIED" - Default case. Should never be this.
	//   "ADMIN_READ" - Admin reads. Example: CloudIAM getIamPolicy
	//   "DATA_WRITE" - Data writes. Example: CloudSQL Users create
	//   "DATA_READ" - Data reads. Example: CloudSQL Users list
	LogType string `json:"logType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExemptedMembers") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExemptedMembers") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuditLogConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AuditLogConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Backup: Represents a request to perform a single point-in-time capture of
// some portion of the state of a GKE cluster, the record of the backup
// operation itself, and an anchor for the underlying artifacts that comprise
// the Backup (the config backup and VolumeBackups).
type Backup struct {
	// AllNamespaces: Output only. If True, all namespaces were included in the
	// Backup.
	AllNamespaces bool `json:"allNamespaces,omitempty"`
	// ClusterMetadata: Output only. Information about the GKE cluster from which
	// this Backup was created.
	ClusterMetadata *ClusterMetadata `json:"clusterMetadata,omitempty"`
	// CompleteTime: Output only. Completion time of the Backup
	CompleteTime string `json:"completeTime,omitempty"`
	// ConfigBackupSizeBytes: Output only. The size of the config backup in bytes.
	ConfigBackupSizeBytes int64 `json:"configBackupSizeBytes,omitempty,string"`
	// ContainsSecrets: Output only. Whether or not the Backup contains Kubernetes
	// Secrets. Controlled by the parent BackupPlan's include_secrets value.
	ContainsSecrets bool `json:"containsSecrets,omitempty"`
	// ContainsVolumeData: Output only. Whether or not the Backup contains volume
	// data. Controlled by the parent BackupPlan's include_volume_data value.
	ContainsVolumeData bool `json:"containsVolumeData,omitempty"`
	// CreateTime: Output only. The timestamp when this Backup resource was
	// created.
	CreateTime string `json:"createTime,omitempty"`
	// DeleteLockDays: Optional. Minimum age for this Backup (in days). If this
	// field is set to a non-zero value, the Backup will be "locked" against
	// deletion (either manual or automatic deletion) for the number of days
	// provided (measured from the creation time of the Backup). MUST be an integer
	// value between 0-90 (inclusive). Defaults to parent BackupPlan's
	// backup_delete_lock_days setting and may only be increased (either at
	// creation time or in a subsequent update).
	DeleteLockDays int64 `json:"deleteLockDays,omitempty"`
	// DeleteLockExpireTime: Output only. The time at which an existing delete lock
	// will expire for this backup (calculated from create_time +
	// delete_lock_days).
	DeleteLockExpireTime string `json:"deleteLockExpireTime,omitempty"`
	// Description: Optional. User specified descriptive string for this Backup.
	Description string `json:"description,omitempty"`
	// EncryptionKey: Output only. The customer managed encryption key that was
	// used to encrypt the Backup's artifacts. Inherited from the parent
	// BackupPlan's encryption_key value.
	EncryptionKey *EncryptionKey `json:"encryptionKey,omitempty"`
	// Etag: Output only. `etag` is used for optimistic concurrency control as a
	// way to help prevent simultaneous updates of a backup from overwriting each
	// other. It is strongly suggested that systems make use of the `etag` in the
	// read-modify-write cycle to perform backup updates in order to avoid race
	// conditions: An `etag` is returned in the response to `GetBackup`, and
	// systems are expected to put that etag in the request to `UpdateBackup` or
	// `DeleteBackup` to ensure that their change will be applied to the same
	// version of the resource.
	Etag string `json:"etag,omitempty"`
	// Labels: Optional. A set of custom labels supplied by user.
	Labels map[string]string `json:"labels,omitempty"`
	// Manual: Output only. This flag indicates whether this Backup resource was
	// created manually by a user or via a schedule in the BackupPlan. A value of
	// True means that the Backup was created manually.
	Manual bool `json:"manual,omitempty"`
	// Name: Output only. The fully qualified name of the Backup.
	// `projects/*/locations/*/backupPlans/*/backups/*`
	Name string `json:"name,omitempty"`
	// PermissiveMode: Output only. If false, Backup will fail when Backup for GKE
	// detects Kubernetes configuration that is non-standard or requires additional
	// setup to restore. Inherited from the parent BackupPlan's permissive_mode
	// value.
	PermissiveMode bool `json:"permissiveMode,omitempty"`
	// PodCount: Output only. The total number of Kubernetes Pods contained in the
	// Backup.
	PodCount int64 `json:"podCount,omitempty"`
	// ResourceCount: Output only. The total number of Kubernetes resources
	// included in the Backup.
	ResourceCount int64 `json:"resourceCount,omitempty"`
	// RetainDays: Optional. The age (in days) after which this Backup will be
	// automatically deleted. Must be an integer value >= 0: - If 0, no automatic
	// deletion will occur for this Backup. - If not 0, this must be >=
	// delete_lock_days and <= 365. Once a Backup is created, this value may only
	// be increased. Defaults to the parent BackupPlan's backup_retain_days value.
	RetainDays int64 `json:"retainDays,omitempty"`
	// RetainExpireTime: Output only. The time at which this Backup will be
	// automatically deleted (calculated from create_time + retain_days).
	RetainExpireTime string `json:"retainExpireTime,omitempty"`
	// SelectedApplications: Output only. If set, the list of ProtectedApplications
	// whose resources were included in the Backup.
	SelectedApplications *NamespacedNames `json:"selectedApplications,omitempty"`
	// SelectedNamespaces: Output only. If set, the list of namespaces that were
	// included in the Backup.
	SelectedNamespaces *Namespaces `json:"selectedNamespaces,omitempty"`
	// SizeBytes: Output only. The total size of the Backup in bytes = config
	// backup size + sum(volume backup sizes)
	SizeBytes int64 `json:"sizeBytes,omitempty,string"`
	// State: Output only. Current state of the Backup
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The Backup resource is in the process of being
	// created.
	//   "CREATING" - The Backup resource has been created and the associated
	// BackupJob Kubernetes resource has been injected into the source cluster.
	//   "IN_PROGRESS" - The gkebackup agent in the cluster has begun executing the
	// backup operation.
	//   "SUCCEEDED" - The backup operation has completed successfully.
	//   "FAILED" - The backup operation has failed.
	//   "DELETING" - This Backup resource (and its associated artifacts) is in the
	// process of being deleted.
	State string `json:"state,omitempty"`
	// StateReason: Output only. Human-readable description of why the backup is in
	// the current `state`.
	StateReason string `json:"stateReason,omitempty"`
	// Uid: Output only. Server generated global unique identifier of UUID4
	// (https://en.wikipedia.org/wiki/Universally_unique_identifier)
	Uid string `json:"uid,omitempty"`
	// UpdateTime: Output only. The timestamp when this Backup resource was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// VolumeCount: Output only. The total number of volume backups contained in
	// the Backup.
	VolumeCount int64 `json:"volumeCount,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AllNamespaces") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllNamespaces") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Backup) MarshalJSON() ([]byte, error) {
	type NoMethod Backup
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BackupConfig: BackupConfig defines the configuration of Backups created via
// this BackupPlan.
type BackupConfig struct {
	// AllNamespaces: If True, include all namespaced resources
	AllNamespaces bool `json:"allNamespaces,omitempty"`
	// EncryptionKey: Optional. This defines a customer managed encryption key that
	// will be used to encrypt the "config" portion (the Kubernetes resources) of
	// Backups created via this plan. Default (empty): Config backup artifacts will
	// not be encrypted.
	EncryptionKey *EncryptionKey `json:"encryptionKey,omitempty"`
	// IncludeSecrets: Optional. This flag specifies whether Kubernetes Secret
	// resources should be included when they fall into the scope of Backups.
	// Default: False
	IncludeSecrets bool `json:"includeSecrets,omitempty"`
	// IncludeVolumeData: Optional. This flag specifies whether volume data should
	// be backed up when PVCs are included in the scope of a Backup. Default: False
	IncludeVolumeData bool `json:"includeVolumeData,omitempty"`
	// PermissiveMode: Optional. If false, Backups will fail when Backup for GKE
	// detects Kubernetes configuration that is non-standard or requires additional
	// setup to restore. Default: False
	PermissiveMode bool `json:"permissiveMode,omitempty"`
	// SelectedApplications: If set, include just the resources referenced by the
	// listed ProtectedApplications.
	SelectedApplications *NamespacedNames `json:"selectedApplications,omitempty"`
	// SelectedNamespaces: If set, include just the resources in the listed
	// namespaces.
	SelectedNamespaces *Namespaces `json:"selectedNamespaces,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllNamespaces") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllNamespaces") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BackupConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BackupConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BackupPlan: Defines the configuration and scheduling for a "line" of
// Backups.
type BackupPlan struct {
	// BackupConfig: Optional. Defines the configuration of Backups created via
	// this BackupPlan.
	BackupConfig *BackupConfig `json:"backupConfig,omitempty"`
	// BackupSchedule: Optional. Defines a schedule for automatic Backup creation
	// via this BackupPlan.
	BackupSchedule *Schedule `json:"backupSchedule,omitempty"`
	// Cluster: Required. Immutable. The source cluster from which Backups will be
	// created via this BackupPlan. Valid formats: -
	// `projects/*/locations/*/clusters/*` - `projects/*/zones/*/clusters/*`
	Cluster string `json:"cluster,omitempty"`
	// CreateTime: Output only. The timestamp when this BackupPlan resource was
	// created.
	CreateTime string `json:"createTime,omitempty"`
	// Deactivated: Optional. This flag indicates whether this BackupPlan has been
	// deactivated. Setting this field to True locks the BackupPlan such that no
	// further updates will be allowed (except deletes), including the deactivated
	// field itself. It also prevents any new Backups from being created via this
	// BackupPlan (including scheduled Backups). Default: False
	Deactivated bool `json:"deactivated,omitempty"`
	// Description: Optional. User specified descriptive string for this
	// BackupPlan.
	Description string `json:"description,omitempty"`
	// Etag: Output only. `etag` is used for optimistic concurrency control as a
	// way to help prevent simultaneous updates of a backup plan from overwriting
	// each other. It is strongly suggested that systems make use of the 'etag' in
	// the read-modify-write cycle to perform BackupPlan updates in order to avoid
	// race conditions: An `etag` is returned in the response to `GetBackupPlan`,
	// and systems are expected to put that etag in the request to
	// `UpdateBackupPlan` or `DeleteBackupPlan` to ensure that their change will be
	// applied to the same version of the resource.
	Etag string `json:"etag,omitempty"`
	// Labels: Optional. A set of custom labels supplied by user.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Output only. The full name of the BackupPlan resource. Format:
	// `projects/*/locations/*/backupPlans/*`
	Name string `json:"name,omitempty"`
	// ProtectedPodCount: Output only. The number of Kubernetes Pods backed up in
	// the last successful Backup created via this BackupPlan.
	ProtectedPodCount int64 `json:"protectedPodCount,omitempty"`
	// RetentionPolicy: Optional. RetentionPolicy governs lifecycle of Backups
	// created under this plan.
	RetentionPolicy *RetentionPolicy `json:"retentionPolicy,omitempty"`
	// RpoRiskLevel: Output only. A number that represents the current risk level
	// of this BackupPlan from RPO perspective with 1 being no risk and 5 being
	// highest risk.
	RpoRiskLevel int64 `json:"rpoRiskLevel,omitempty"`
	// RpoRiskReason: Output only. Human-readable description of why the BackupPlan
	// is in the current rpo_risk_level and action items if any.
	RpoRiskReason string `json:"rpoRiskReason,omitempty"`
	// State: Output only. State of the BackupPlan. This State field reflects the
	// various stages a BackupPlan can be in during the Create operation. It will
	// be set to "DEACTIVATED" if the BackupPlan is deactivated on an Update
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default first value for Enums.
	//   "CLUSTER_PENDING" - Waiting for cluster state to be RUNNING.
	//   "PROVISIONING" - The BackupPlan is in the process of being created.
	//   "READY" - The BackupPlan has successfully been created and is ready for
	// Backups.
	//   "FAILED" - BackupPlan creation has failed.
	//   "DEACTIVATED" - The BackupPlan has been deactivated.
	//   "DELETING" - The BackupPlan is in the process of being deleted.
	State string `json:"state,omitempty"`
	// StateReason: Output only. Human-readable description of why BackupPlan is in
	// the current `state`
	StateReason string `json:"stateReason,omitempty"`
	// Uid: Output only. Server generated global unique identifier of UUID
	// (https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
	Uid string `json:"uid,omitempty"`
	// UpdateTime: Output only. The timestamp when this BackupPlan resource was
	// last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BackupConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BackupConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BackupPlan) MarshalJSON() ([]byte, error) {
	type NoMethod BackupPlan
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Binding: Associates `members`, or principals, with a `role`.
type Binding struct {
	// Condition: The condition that is associated with this binding. If the
	// condition evaluates to `true`, then this binding applies to the current
	// request. If the condition evaluates to `false`, then this binding does not
	// apply to the current request. However, a different role binding might grant
	// the same role to one or more of the principals in this binding. To learn
	// which resources support conditions in their IAM policies, see the IAM
	// documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Condition *Expr `json:"condition,omitempty"`
	// Members: Specifies the principals requesting access for a Google Cloud
	// resource. `members` can have the following values: * `allUsers`: A special
	// identifier that represents anyone who is on the internet; with or without a
	// Google account. * `allAuthenticatedUsers`: A special identifier that
	// represents anyone who is authenticated with a Google account or a service
	// account. Does not include identities that come from external identity
	// providers (IdPs) through identity federation. * `user:{emailid}`: An email
	// address that represents a specific Google account. For example,
	// `alice@example.com` . * `serviceAccount:{emailid}`: An email address that
	// represents a Google service account. For example,
	// `my-other-app@appspot.gserviceaccount.com`. *
	// `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An
	// identifier for a Kubernetes service account
	// (https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts).
	// For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. *
	// `group:{emailid}`: An email address that represents a Google group. For
	// example, `admins@example.com`. * `domain:{domain}`: The G Suite domain
	// (primary) that represents all the users of that domain. For example,
	// `google.com` or `example.com`. *
	// `principal://iam.googleapis.com/locations/global/workforcePools/{pool_id}/sub
	// ject/{subject_attribute_value}`: A single identity in a workforce identity
	// pool. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// group/{group_id}`: All workforce identities in a group. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// attribute.{attribute_name}/{attribute_value}`: All workforce identities with
	// a specific attribute value. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// *`: All identities in a workforce identity pool. *
	// `principal://iam.googleapis.com/projects/{project_number}/locations/global/wo
	// rkloadIdentityPools/{pool_id}/subject/{subject_attribute_value}`: A single
	// identity in a workload identity pool. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/group/{group_id}`: A workload identity pool
	// group. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/attribute.{attribute_name}/{attribute_value}
	// `: All identities in a workload identity pool with a certain attribute. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/*`: All identities in a workload identity
	// pool. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus
	// unique identifier) representing a user that has been recently deleted. For
	// example, `alice@example.com?uid=123456789012345678901`. If the user is
	// recovered, this value reverts to `user:{emailid}` and the recovered user
	// retains the role in the binding. *
	// `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus
	// unique identifier) representing a service account that has been recently
	// deleted. For example,
	// `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
	// service account is undeleted, this value reverts to
	// `serviceAccount:{emailid}` and the undeleted service account retains the
	// role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email
	// address (plus unique identifier) representing a Google group that has been
	// recently deleted. For example,
	// `admins@example.com?uid=123456789012345678901`. If the group is recovered,
	// this value reverts to `group:{emailid}` and the recovered group retains the
	// role in the binding. *
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePools/{pool
	// _id}/subject/{subject_attribute_value}`: Deleted single identity in a
	// workforce identity pool. For example,
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePools/my-po
	// ol-id/subject/my-subject-attribute-value`.
	Members []string `json:"members,omitempty"`
	// Role: Role that is assigned to the list of `members`, or principals. For
	// example, `roles/viewer`, `roles/editor`, or `roles/owner`. For an overview
	// of the IAM roles and permissions, see the IAM documentation
	// (https://cloud.google.com/iam/docs/roles-overview). For a list of the
	// available pre-defined roles, see here
	// (https://cloud.google.com/iam/docs/understanding-roles).
	Role string `json:"role,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Binding) MarshalJSON() ([]byte, error) {
	type NoMethod Binding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ClusterMetadata: Information about the GKE cluster from which this Backup
// was created.
type ClusterMetadata struct {
	// AnthosVersion: Output only. Anthos version
	AnthosVersion string `json:"anthosVersion,omitempty"`
	// BackupCrdVersions: Output only. A list of the Backup for GKE CRD versions
	// found in the cluster.
	BackupCrdVersions map[string]string `json:"backupCrdVersions,omitempty"`
	// Cluster: Output only. The source cluster from which this Backup was created.
	// Valid formats: - `projects/*/locations/*/clusters/*` -
	// `projects/*/zones/*/clusters/*` This is inherited from the parent
	// BackupPlan's cluster field.
	Cluster string `json:"cluster,omitempty"`
	// GkeVersion: Output only. GKE version
	GkeVersion string `json:"gkeVersion,omitempty"`
	// K8sVersion: Output only. The Kubernetes server version of the source
	// cluster.
	K8sVersion string `json:"k8sVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnthosVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnthosVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ClusterMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod ClusterMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ClusterResourceRestoreScope: Defines the scope of cluster-scoped resources
// to restore. Some group kinds are not reasonable choices for a restore, and
// will cause an error if selected here. Any scope selection that would restore
// "all valid" resources automatically excludes these group kinds. -
// gkebackup.gke.io/BackupJob - gkebackup.gke.io/RestoreJob -
// metrics.k8s.io/NodeMetrics - migration.k8s.io/StorageState -
// migration.k8s.io/StorageVersionMigration - Node -
// snapshot.storage.k8s.io/VolumeSnapshotContent - storage.k8s.io/CSINode Some
// group kinds are driven by restore configuration elsewhere, and will cause an
// error if selected here. - Namespace - PersistentVolume
type ClusterResourceRestoreScope struct {
	// AllGroupKinds: Optional. If True, all valid cluster-scoped resources will be
	// restored. Mutually exclusive to any other field in the message.
	AllGroupKinds bool `json:"allGroupKinds,omitempty"`
	// ExcludedGroupKinds: Optional. A list of cluster-scoped resource group kinds
	// to NOT restore from the backup. If specified, all valid cluster-scoped
	// resources will be restored except for those specified in the list. Mutually
	// exclusive to any other field in the message.
	ExcludedGroupKinds []*GroupKind `json:"excludedGroupKinds,omitempty"`
	// NoGroupKinds: Optional. If True, no cluster-scoped resources will be
	// restored. This has the same restore scope as if the message is not defined.
	// Mutually exclusive to any other field in the message.
	NoGroupKinds bool `json:"noGroupKinds,omitempty"`
	// SelectedGroupKinds: Optional. A list of cluster-scoped resource group kinds
	// to restore from the backup. If specified, only the selected resources will
	// be restored. Mutually exclusive to any other field in the message.
	SelectedGroupKinds []*GroupKind `json:"selectedGroupKinds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllGroupKinds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllGroupKinds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ClusterResourceRestoreScope) MarshalJSON() ([]byte, error) {
	type NoMethod ClusterResourceRestoreScope
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Date: Represents a whole or partial calendar date, such as a birthday. The
// time of day and time zone are either specified elsewhere or are
// insignificant. The date is relative to the Gregorian Calendar. This can
// represent one of the following: * A full date, with non-zero year, month,
// and day values. * A month and day, with a zero year (for example, an
// anniversary). * A year on its own, with a zero month and a zero day. * A
// year and month, with a zero day (for example, a credit card expiration
// date). Related types: * google.type.TimeOfDay * google.type.DateTime *
// google.protobuf.Timestamp
type Date struct {
	// Day: Day of a month. Must be from 1 to 31 and valid for the year and month,
	// or 0 to specify a year by itself or a year and month where the day isn't
	// significant.
	Day int64 `json:"day,omitempty"`
	// Month: Month of a year. Must be from 1 to 12, or 0 to specify a year without
	// a month and day.
	Month int64 `json:"month,omitempty"`
	// Year: Year of the date. Must be from 1 to 9999, or 0 to specify a date
	// without a year.
	Year int64 `json:"year,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Day") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Day") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Date) MarshalJSON() ([]byte, error) {
	type NoMethod Date
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DayOfWeekList: Holds repeated DaysOfWeek values as a container.
type DayOfWeekList struct {
	// DaysOfWeek: Optional. A list of days of week.
	//
	// Possible values:
	//   "DAY_OF_WEEK_UNSPECIFIED" - The day of the week is unspecified.
	//   "MONDAY" - Monday
	//   "TUESDAY" - Tuesday
	//   "WEDNESDAY" - Wednesday
	//   "THURSDAY" - Thursday
	//   "FRIDAY" - Friday
	//   "SATURDAY" - Saturday
	//   "SUNDAY" - Sunday
	DaysOfWeek []string `json:"daysOfWeek,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DaysOfWeek") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DaysOfWeek") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DayOfWeekList) MarshalJSON() ([]byte, error) {
	type NoMethod DayOfWeekList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use it as
// the request or the response type of an API method. For instance: service Foo
// { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// EncryptionKey: Defined a customer managed encryption key that will be used
// to encrypt Backup artifacts.
type EncryptionKey struct {
	// GcpKmsEncryptionKey: Optional. Google Cloud KMS encryption key. Format:
	// `projects/*/locations/*/keyRings/*/cryptoKeys/*`
	GcpKmsEncryptionKey string `json:"gcpKmsEncryptionKey,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcpKmsEncryptionKey") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcpKmsEncryptionKey") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EncryptionKey) MarshalJSON() ([]byte, error) {
	type NoMethod EncryptionKey
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExclusionWindow: Defines a time window during which no backup should happen.
// All time and date are in UTC.
type ExclusionWindow struct {
	// Daily: The exclusion window occurs every day if set to "True". Specifying
	// this field to "False" is an error.
	Daily bool `json:"daily,omitempty"`
	// DaysOfWeek: The exclusion window occurs on these days of each week in UTC.
	DaysOfWeek *DayOfWeekList `json:"daysOfWeek,omitempty"`
	// Duration: Required. Specifies duration of the window. Duration must be >= 5
	// minutes and < (target RPO - 20 minutes). Additional restrictions based on
	// the recurrence type to allow some time for backup to happen: -
	// single_occurrence_date: no restriction, but UI may warn about this when
	// duration >= target RPO - daily window: duration < 24 hours - weekly window:
	// - days of week includes all seven days of a week: duration < 24 hours - all
	// other weekly window: duration < 168 hours (i.e., 24 * 7 hours)
	Duration string `json:"duration,omitempty"`
	// SingleOccurrenceDate: No recurrence. The exclusion window occurs only once
	// and on this date in UTC.
	SingleOccurrenceDate *Date `json:"singleOccurrenceDate,omitempty"`
	// StartTime: Required. Specifies the start time of the window using time of
	// the day in UTC.
	StartTime *TimeOfDay `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Daily") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Daily") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExclusionWindow) MarshalJSON() ([]byte, error) {
	type NoMethod ExclusionWindow
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Expr: Represents a textual expression in the Common Expression Language
// (CEL) syntax. CEL is a C-like expression language. The syntax and semantics
// of CEL are documented at https://github.com/google/cel-spec. Example
// (Comparison): title: "Summary size limit" description: "Determines if a
// summary is less than 100 chars" expression: "document.summary.size() < 100"
// Example (Equality): title: "Requestor is owner" description: "Determines if
// requestor is the document owner" expression: "document.owner ==
// request.auth.claims.email" Example (Logic): title: "Public documents"
// description: "Determine whether the document should be publicly visible"
// expression: "document.type != 'private' && document.type != 'internal'"
// Example (Data Manipulation): title: "Notification string" description:
// "Create a notification string with a timestamp." expression: "'New message
// received at ' + string(document.create_time)" The exact variables and
// functions that may be referenced within an expression are determined by the
// service that evaluates it. See the service documentation for additional
// information.
type Expr struct {
	// Description: Optional. Description of the expression. This is a longer text
	// which describes the expression, e.g. when hovered over it in a UI.
	Description string `json:"description,omitempty"`
	// Expression: Textual representation of an expression in Common Expression
	// Language syntax.
	Expression string `json:"expression,omitempty"`
	// Location: Optional. String indicating the location of the expression for
	// error reporting, e.g. a file name and a position in the file.
	Location string `json:"location,omitempty"`
	// Title: Optional. Title for the expression, i.e. a short string describing
	// its purpose. This can be used e.g. in UIs which allow to enter the
	// expression.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Expr) MarshalJSON() ([]byte, error) {
	type NoMethod Expr
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Filter: Defines the filter for `Restore`. This filter can be used to further
// refine the resource selection of the `Restore` beyond the coarse-grained
// scope defined in the `RestorePlan`. `exclusion_filters` take precedence over
// `inclusion_filters`. If a resource matches both `inclusion_filters` and
// `exclusion_filters`, it will not be restored.
type Filter struct {
	// ExclusionFilters: Optional. Excludes resources from restoration. If
	// specified, a resource will not be restored if it matches any
	// `ResourceSelector` of the `exclusion_filters`.
	ExclusionFilters []*ResourceSelector `json:"exclusionFilters,omitempty"`
	// InclusionFilters: Optional. Selects resources for restoration. If specified,
	// only resources which match `inclusion_filters` will be selected for
	// restoration. A resource will be selected if it matches any
	// `ResourceSelector` of the `inclusion_filters`.
	InclusionFilters []*ResourceSelector `json:"inclusionFilters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExclusionFilters") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExclusionFilters") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Filter) MarshalJSON() ([]byte, error) {
	type NoMethod Filter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GetBackupIndexDownloadUrlResponse: Response message for
// GetBackupIndexDownloadUrl.
type GetBackupIndexDownloadUrlResponse struct {
	SignedUrl string `json:"signedUrl,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "SignedUrl") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SignedUrl") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GetBackupIndexDownloadUrlResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GetBackupIndexDownloadUrlResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningCancelOperationRequest: The request message for
// Operations.CancelOperation.
type GoogleLongrunningCancelOperationRequest struct {
}

// GoogleLongrunningListOperationsResponse: The response message for
// Operations.ListOperations.
type GoogleLongrunningListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Operations: A list of operations that matches the specified filter in the
	// request.
	Operations []*GoogleLongrunningOperation `json:"operations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleLongrunningListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningListOperationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningOperation: This resource represents a long-running
// operation that is the result of a network API call.
type GoogleLongrunningOperation struct {
	// Done: If the value is `false`, it means the operation is still in progress.
	// If `true`, the operation is completed, and either `error` or `response` is
	// available.
	Done bool `json:"done,omitempty"`
	// Error: The error result of the operation in case of failure or cancellation.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as create
	// time. Some services might not provide such metadata. Any method that returns
	// a long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The server-assigned name, which is only unique within the same service
	// that originally returns it. If you use the default HTTP mapping, the `name`
	// should be a resource name ending with `operations/{unique_id}`.
	Name string `json:"name,omitempty"`
	// Response: The normal, successful response of the operation. If the original
	// method returns no data on success, such as `Delete`, the response is
	// `google.protobuf.Empty`. If the original method is standard
	// `Get`/`Create`/`Update`, the response should be the resource. For other
	// methods, the response should have the type `XxxResponse`, where `Xxx` is the
	// original method name. For example, if the original method name is
	// `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleLongrunningOperation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningOperation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleRpcStatus: The `Status` type defines a logical error model that is
// suitable for different programming environments, including REST APIs and RPC
// APIs. It is used by gRPC (https://github.com/grpc). Each `Status` message
// contains three pieces of data: error code, error message, and error details.
// You can find out more about this error model and how to work with it in the
// API Design Guide (https://cloud.google.com/apis/design/errors).
type GoogleRpcStatus struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleRpcStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleRpcStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GroupKind: This is a direct map to the Kubernetes GroupKind type GroupKind
// (https://godoc.org/k8s.io/apimachinery/pkg/runtime/schema#GroupKind) and is
// used for identifying specific "types" of resources to restore.
type GroupKind struct {
	// ResourceGroup: Optional. API group string of a Kubernetes resource, e.g.
	// "apiextensions.k8s.io", "storage.k8s.io", etc. Note: use empty string for
	// core API group.
	ResourceGroup string `json:"resourceGroup,omitempty"`
	// ResourceKind: Optional. Kind of a Kubernetes resource, must be in
	// UpperCamelCase (PascalCase) and singular form. E.g.
	// "CustomResourceDefinition", "StorageClass", etc.
	ResourceKind string `json:"resourceKind,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ResourceGroup") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ResourceGroup") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GroupKind) MarshalJSON() ([]byte, error) {
	type NoMethod GroupKind
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GroupKindDependency: Defines a dependency between two group kinds.
type GroupKindDependency struct {
	// Requiring: Required. The requiring group kind requires that the other group
	// kind be restored first.
	Requiring *GroupKind `json:"requiring,omitempty"`
	// Satisfying: Required. The satisfying group kind must be restored first in
	// order to satisfy the dependency.
	Satisfying *GroupKind `json:"satisfying,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Requiring") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Requiring") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GroupKindDependency) MarshalJSON() ([]byte, error) {
	type NoMethod GroupKindDependency
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListBackupPlansResponse: Response message for ListBackupPlans.
type ListBackupPlansResponse struct {
	// BackupPlans: The list of BackupPlans matching the given criteria.
	BackupPlans []*BackupPlan `json:"backupPlans,omitempty"`
	// NextPageToken: A token which may be sent as page_token in a subsequent
	// `ListBackupPlans` call to retrieve the next page of results. If this field
	// is omitted or empty, then there are no more results to return.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BackupPlans") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BackupPlans") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListBackupPlansResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListBackupPlansResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListBackupsResponse: Response message for ListBackups.
type ListBackupsResponse struct {
	// Backups: The list of Backups matching the given criteria.
	Backups []*Backup `json:"backups,omitempty"`
	// NextPageToken: A token which may be sent as page_token in a subsequent
	// `ListBackups` call to retrieve the next page of results. If this field is
	// omitted or empty, then there are no more results to return.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Backups") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Backups") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListBackupsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListBackupsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListLocationsResponse: The response message for Locations.ListLocations.
type ListLocationsResponse struct {
	// Locations: A list of locations that matches the specified filter in the
	// request.
	Locations []*Location `json:"locations,omitempty"`
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Locations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Locations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListLocationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListLocationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListRestorePlansResponse: Response message for ListRestorePlans.
type ListRestorePlansResponse struct {
	// NextPageToken: A token which may be sent as page_token in a subsequent
	// `ListRestorePlans` call to retrieve the next page of results. If this field
	// is omitted or empty, then there are no more results to return.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// RestorePlans: The list of RestorePlans matching the given criteria.
	RestorePlans []*RestorePlan `json:"restorePlans,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListRestorePlansResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListRestorePlansResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListRestoresResponse: Response message for ListRestores.
type ListRestoresResponse struct {
	// NextPageToken: A token which may be sent as page_token in a subsequent
	// `ListRestores` call to retrieve the next page of results. If this field is
	// omitted or empty, then there are no more results to return.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Restores: The list of Restores matching the given criteria.
	Restores []*Restore `json:"restores,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListRestoresResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListRestoresResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListVolumeBackupsResponse: Response message for ListVolumeBackups.
type ListVolumeBackupsResponse struct {
	// NextPageToken: A token which may be sent as page_token in a subsequent
	// `ListVolumeBackups` call to retrieve the next page of results. If this field
	// is omitted or empty, then there are no more results to return.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// VolumeBackups: The list of VolumeBackups matching the given criteria.
	VolumeBackups []*VolumeBackup `json:"volumeBackups,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListVolumeBackupsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListVolumeBackupsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListVolumeRestoresResponse: Response message for ListVolumeRestores.
type ListVolumeRestoresResponse struct {
	// NextPageToken: A token which may be sent as page_token in a subsequent
	// `ListVolumeRestores` call to retrieve the next page of results. If this
	// field is omitted or empty, then there are no more results to return.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// VolumeRestores: The list of VolumeRestores matching the given criteria.
	VolumeRestores []*VolumeRestore `json:"volumeRestores,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListVolumeRestoresResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListVolumeRestoresResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Location: A resource that represents a Google Cloud location.
type Location struct {
	// DisplayName: The friendly name for this location, typically a nearby city
	// name. For example, "Tokyo".
	DisplayName string `json:"displayName,omitempty"`
	// Labels: Cross-service attributes for the location. For example
	// {"cloud.googleapis.com/region": "us-east1"}
	Labels map[string]string `json:"labels,omitempty"`
	// LocationId: The canonical id for this location. For example: "us-east1".
	LocationId string `json:"locationId,omitempty"`
	// Metadata: Service-specific metadata. For example the available capacity at
	// the given location.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: Resource name for the location, which may vary between
	// implementations. For example:
	// "projects/example-project/locations/us-east1"
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Location) MarshalJSON() ([]byte, error) {
	type NoMethod Location
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NamespacedName: A reference to a namespaced resource in Kubernetes.
type NamespacedName struct {
	// Name: Optional. The name of the Kubernetes resource.
	Name string `json:"name,omitempty"`
	// Namespace: Optional. The Namespace of the Kubernetes resource.
	Namespace string `json:"namespace,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NamespacedName) MarshalJSON() ([]byte, error) {
	type NoMethod NamespacedName
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NamespacedNames: A list of namespaced Kubernetes resources.
type NamespacedNames struct {
	// NamespacedNames: Optional. A list of namespaced Kubernetes resources.
	NamespacedNames []*NamespacedName `json:"namespacedNames,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NamespacedNames") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NamespacedNames") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NamespacedNames) MarshalJSON() ([]byte, error) {
	type NoMethod NamespacedNames
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Namespaces: A list of Kubernetes Namespaces.
type Namespaces struct {
	// Namespaces: Optional. A list of Kubernetes Namespaces.
	Namespaces []string `json:"namespaces,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Namespaces") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Namespaces") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Namespaces) MarshalJSON() ([]byte, error) {
	type NoMethod Namespaces
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OperationMetadata: Represents the metadata of the long-running operation.
type OperationMetadata struct {
	// ApiVersion: Output only. API version used to start the operation.
	ApiVersion string `json:"apiVersion,omitempty"`
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// RequestedCancellation: Output only. Identifies whether the user has
	// requested cancellation of the operation. Operations that have successfully
	// been cancelled have Operation.error value with a google.rpc.Status.code of
	// 1, corresponding to `Code.CANCELLED`.
	RequestedCancellation bool `json:"requestedCancellation,omitempty"`
	// StatusMessage: Output only. Human-readable status of the operation, if any.
	StatusMessage string `json:"statusMessage,omitempty"`
	// Target: Output only. Server-defined resource path for the target of the
	// operation.
	Target string `json:"target,omitempty"`
	// Verb: Output only. Name of the verb executed by the operation.
	Verb string `json:"verb,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod OperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Policy: An Identity and Access Management (IAM) policy, which specifies
// access controls for Google Cloud resources. A `Policy` is a collection of
// `bindings`. A `binding` binds one or more `members`, or principals, to a
// single `role`. Principals can be user accounts, service accounts, Google
// groups, and domains (such as G Suite). A `role` is a named list of
// permissions; each `role` can be an IAM predefined role or a user-created
// custom role. For some types of Google Cloud resources, a `binding` can also
// specify a `condition`, which is a logical expression that allows access to a
// resource only if the expression evaluates to `true`. A condition can add
// constraints based on attributes of the request, the resource, or both. To
// learn which resources support conditions in their IAM policies, see the IAM
// documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies). **JSON
// example:** ``` { "bindings": [ { "role":
// "roles/resourcemanager.organizationAdmin", "members": [
// "user:mike@example.com", "group:admins@example.com", "domain:google.com",
// "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
// "roles/resourcemanager.organizationViewer", "members": [
// "user:eve@example.com" ], "condition": { "title": "expirable access",
// "description": "Does not grant access after Sep 2020", "expression":
// "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
// "BwWWja0YfJA=", "version": 3 } ``` **YAML example:** ``` bindings: -
// members: - user:mike@example.com - group:admins@example.com -
// domain:google.com - serviceAccount:my-project-id@appspot.gserviceaccount.com
// role: roles/resourcemanager.organizationAdmin - members: -
// user:eve@example.com role: roles/resourcemanager.organizationViewer
// condition: title: expirable access description: Does not grant access after
// Sep 2020 expression: request.time < timestamp('2020-10-01T00:00:00.000Z')
// etag: BwWWja0YfJA= version: 3 ``` For a description of IAM and its features,
// see the IAM documentation (https://cloud.google.com/iam/docs/).
type Policy struct {
	// AuditConfigs: Specifies cloud audit logging configuration for this policy.
	AuditConfigs []*AuditConfig `json:"auditConfigs,omitempty"`
	// Bindings: Associates a list of `members`, or principals, with a `role`.
	// Optionally, may specify a `condition` that determines how and when the
	// `bindings` are applied. Each of the `bindings` must contain at least one
	// principal. The `bindings` in a `Policy` can refer to up to 1,500 principals;
	// up to 250 of these principals can be Google groups. Each occurrence of a
	// principal counts towards these limits. For example, if the `bindings` grant
	// 50 different roles to `user:alice@example.com`, and not to any other
	// principal, then you can add another 1,450 principals to the `bindings` in
	// the `Policy`.
	Bindings []*Binding `json:"bindings,omitempty"`
	// Etag: `etag` is used for optimistic concurrency control as a way to help
	// prevent simultaneous updates of a policy from overwriting each other. It is
	// strongly suggested that systems make use of the `etag` in the
	// read-modify-write cycle to perform policy updates in order to avoid race
	// conditions: An `etag` is returned in the response to `getIamPolicy`, and
	// systems are expected to put that etag in the request to `setIamPolicy` to
	// ensure that their change will be applied to the same version of the policy.
	// **Important:** If you use IAM Conditions, you must include the `etag` field
	// whenever you call `setIamPolicy`. If you omit this field, then IAM allows
	// you to overwrite a version `3` policy with a version `1` policy, and all of
	// the conditions in the version `3` policy are lost.
	Etag string `json:"etag,omitempty"`
	// Version: Specifies the format of the policy. Valid values are `0`, `1`, and
	// `3`. Requests that specify an invalid value are rejected. Any operation that
	// affects conditional role bindings must specify version `3`. This requirement
	// applies to the following operations: * Getting a policy that includes a
	// conditional role binding * Adding a conditional role binding to a policy *
	// Changing a conditional role binding in a policy * Removing any role binding,
	// with or without a condition, from a policy that includes conditions
	// **Important:** If you use IAM Conditions, you must include the `etag` field
	// whenever you call `setIamPolicy`. If you omit this field, then IAM allows
	// you to overwrite a version `3` policy with a version `1` policy, and all of
	// the conditions in the version `3` policy are lost. If a policy does not
	// include any conditions, operations on that policy may specify any valid
	// version or leave the field unset. To learn which resources support
	// conditions in their IAM policies, see the IAM documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Version int64 `json:"version,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AuditConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuditConfigs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Policy) MarshalJSON() ([]byte, error) {
	type NoMethod Policy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ResourceFilter: ResourceFilter specifies matching criteria to limit the
// scope of a change to a specific set of kubernetes resources that are
// selected for restoration from a backup.
type ResourceFilter struct {
	// GroupKinds: Optional. (Filtering parameter) Any resource subject to
	// transformation must belong to one of the listed "types". If this field is
	// not provided, no type filtering will be performed (all resources of all
	// types matching previous filtering parameters will be candidates for
	// transformation).
	GroupKinds []*GroupKind `json:"groupKinds,omitempty"`
	// JsonPath: Optional. This is a [JSONPath]
	// (https://github.com/json-path/JsonPath/blob/master/README.md) expression
	// that matches specific fields of candidate resources and it operates as a
	// filtering parameter (resources that are not matched with this expression
	// will not be candidates for transformation).
	JsonPath string `json:"jsonPath,omitempty"`
	// Namespaces: Optional. (Filtering parameter) Any resource subject to
	// transformation must be contained within one of the listed Kubernetes
	// Namespace in the Backup. If this field is not provided, no namespace
	// filtering will be performed (all resources in all Namespaces, including all
	// cluster-scoped resources, will be candidates for transformation).
	Namespaces []string `json:"namespaces,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GroupKinds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GroupKinds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ResourceFilter) MarshalJSON() ([]byte, error) {
	type NoMethod ResourceFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ResourceSelector: Defines a selector to identify a single or a group of
// resources. Conditions in the selector are optional, but at least one field
// should be set to a non-empty value. If a condition is not specified, no
// restrictions will be applied on that dimension. If more than one condition
// is specified, a resource will be selected if and only if all conditions are
// met.
type ResourceSelector struct {
	// GroupKind: Optional. Selects resources using their Kubernetes GroupKinds. If
	// specified, only resources of provided GroupKind will be selected.
	GroupKind *GroupKind `json:"groupKind,omitempty"`
	// Labels: Optional. Selects resources using Kubernetes labels
	// (https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/).
	// If specified, a resource will be selected if and only if the resource has
	// all of the provided labels and all the label values match.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Optional. Selects resources using their resource names. If specified,
	// only resources with the provided name will be selected.
	Name string `json:"name,omitempty"`
	// Namespace: Optional. Selects resources using their namespaces. This only
	// applies to namespace scoped resources and cannot be used for selecting
	// cluster scoped resources. If specified, only resources in the provided
	// namespace will be selected. If not specified, the filter will apply to both
	// cluster scoped and namespace scoped resources (e.g. name or label). The
	// Namespace (https://pkg.go.dev/k8s.io/api/core/v1#Namespace) resource itself
	// will be restored if and only if any resources within the namespace are
	// restored.
	Namespace string `json:"namespace,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GroupKind") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GroupKind") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ResourceSelector) MarshalJSON() ([]byte, error) {
	type NoMethod ResourceSelector
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Restore: Represents both a request to Restore some portion of a Backup into
// a target GKE cluster and a record of the restore operation itself.
type Restore struct {
	// Backup: Required. Immutable. A reference to the Backup used as the source
	// from which this Restore will restore. Note that this Backup must be a
	// sub-resource of the RestorePlan's backup_plan. Format:
	// `projects/*/locations/*/backupPlans/*/backups/*`.
	Backup string `json:"backup,omitempty"`
	// Cluster: Output only. The target cluster into which this Restore will
	// restore data. Valid formats: - `projects/*/locations/*/clusters/*` -
	// `projects/*/zones/*/clusters/*` Inherited from parent RestorePlan's cluster
	// value.
	Cluster string `json:"cluster,omitempty"`
	// CompleteTime: Output only. Timestamp of when the restore operation
	// completed.
	CompleteTime string `json:"completeTime,omitempty"`
	// CreateTime: Output only. The timestamp when this Restore resource was
	// created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: User specified descriptive string for this Restore.
	Description string `json:"description,omitempty"`
	// Etag: Output only. `etag` is used for optimistic concurrency control as a
	// way to help prevent simultaneous updates of a restore from overwriting each
	// other. It is strongly suggested that systems make use of the `etag` in the
	// read-modify-write cycle to perform restore updates in order to avoid race
	// conditions: An `etag` is returned in the response to `GetRestore`, and
	// systems are expected to put that etag in the request to `UpdateRestore` or
	// `DeleteRestore` to ensure that their change will be applied to the same
	// version of the resource.
	Etag string `json:"etag,omitempty"`
	// Filter: Optional. Immutable. Filters resources for `Restore`. If not
	// specified, the scope of the restore will remain the same as defined in the
	// `RestorePlan`. If this is specified and no resources are matched by the
	// `inclusion_filters` or everyting is excluded by the `exclusion_filters`,
	// nothing will be restored. This filter can only be specified if the value of
	// namespaced_resource_restore_mode is set to `MERGE_SKIP_ON_CONFLICT`,
	// `MERGE_REPLACE_VOLUME_ON_CONFLICT` or `MERGE_REPLACE_ON_CONFLICT`.
	Filter *Filter `json:"filter,omitempty"`
	// Labels: A set of custom labels supplied by user.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Output only. The full name of the Restore resource. Format:
	// `projects/*/locations/*/restorePlans/*/restores/*`
	Name string `json:"name,omitempty"`
	// ResourcesExcludedCount: Output only. Number of resources excluded during the
	// restore execution.
	ResourcesExcludedCount int64 `json:"resourcesExcludedCount,omitempty"`
	// ResourcesFailedCount: Output only. Number of resources that failed to be
	// restored during the restore execution.
	ResourcesFailedCount int64 `json:"resourcesFailedCount,omitempty"`
	// ResourcesRestoredCount: Output only. Number of resources restored during the
	// restore execution.
	ResourcesRestoredCount int64 `json:"resourcesRestoredCount,omitempty"`
	// RestoreConfig: Output only. Configuration of the Restore. Inherited from
	// parent RestorePlan's restore_config.
	RestoreConfig *RestoreConfig `json:"restoreConfig,omitempty"`
	// State: Output only. The current state of the Restore.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The Restore resource is in the process of being
	// created.
	//   "CREATING" - The Restore resource has been created and the associated
	// RestoreJob Kubernetes resource has been injected into target cluster.
	//   "IN_PROGRESS" - The gkebackup agent in the cluster has begun executing the
	// restore operation.
	//   "SUCCEEDED" - The restore operation has completed successfully. Restored
	// workloads may not yet be operational.
	//   "FAILED" - The restore operation has failed.
	//   "DELETING" - This Restore resource is in the process of being deleted.
	State string `json:"state,omitempty"`
	// StateReason: Output only. Human-readable description of why the Restore is
	// in its current state.
	StateReason string `json:"stateReason,omitempty"`
	// Uid: Output only. Server generated global unique identifier of UUID
	// (https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
	Uid string `json:"uid,omitempty"`
	// UpdateTime: Output only. The timestamp when this Restore resource was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// VolumeDataRestorePolicyOverrides: Optional. Immutable. Overrides the volume
	// data restore policies selected in the Restore Config for override-scoped
	// resources.
	VolumeDataRestorePolicyOverrides []*VolumeDataRestorePolicyOverride `json:"volumeDataRestorePolicyOverrides,omitempty"`
	// VolumesRestoredCount: Output only. Number of volumes restored during the
	// restore execution.
	VolumesRestoredCount int64 `json:"volumesRestoredCount,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Backup") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Backup") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Restore) MarshalJSON() ([]byte, error) {
	type NoMethod Restore
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RestoreConfig: Configuration of a restore.
type RestoreConfig struct {
	// AllNamespaces: Restore all namespaced resources in the Backup if set to
	// "True". Specifying this field to "False" is an error.
	AllNamespaces bool `json:"allNamespaces,omitempty"`
	// ClusterResourceConflictPolicy: Optional. Defines the behavior for handling
	// the situation where cluster-scoped resources being restored already exist in
	// the target cluster. This MUST be set to a value other than
	// CLUSTER_RESOURCE_CONFLICT_POLICY_UNSPECIFIED if
	// cluster_resource_restore_scope is not empty.
	//
	// Possible values:
	//   "CLUSTER_RESOURCE_CONFLICT_POLICY_UNSPECIFIED" - Unspecified. Only allowed
	// if no cluster-scoped resources will be restored.
	//   "USE_EXISTING_VERSION" - Do not attempt to restore the conflicting
	// resource.
	//   "USE_BACKUP_VERSION" - Delete the existing version before re-creating it
	// from the Backup. This is a dangerous option which could cause unintentional
	// data loss if used inappropriately. For example, deleting a CRD will cause
	// Kubernetes to delete all CRs of that type.
	ClusterResourceConflictPolicy string `json:"clusterResourceConflictPolicy,omitempty"`
	// ClusterResourceRestoreScope: Optional. Identifies the cluster-scoped
	// resources to restore from the Backup. Not specifying it means NO cluster
	// resource will be restored.
	ClusterResourceRestoreScope *ClusterResourceRestoreScope `json:"clusterResourceRestoreScope,omitempty"`
	// ExcludedNamespaces: A list of selected namespaces excluded from restoration.
	// All namespaces except those in this list will be restored.
	ExcludedNamespaces *Namespaces `json:"excludedNamespaces,omitempty"`
	// NamespacedResourceRestoreMode: Optional. Defines the behavior for handling
	// the situation where sets of namespaced resources being restored already
	// exist in the target cluster. This MUST be set to a value other than
	// NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED.
	//
	// Possible values:
	//   "NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED" - Unspecified (invalid).
	//   "DELETE_AND_RESTORE" - When conflicting top-level resources (either
	// Namespaces or ProtectedApplications, depending upon the scope) are
	// encountered, this will first trigger a delete of the conflicting resource
	// AND ALL OF ITS REFERENCED RESOURCES (e.g., all resources in the Namespace or
	// all resources referenced by the ProtectedApplication) before restoring the
	// resources from the Backup. This mode should only be used when you are
	// intending to revert some portion of a cluster to an earlier state.
	//   "FAIL_ON_CONFLICT" - If conflicting top-level resources (either Namespaces
	// or ProtectedApplications, depending upon the scope) are encountered at the
	// beginning of a restore process, the Restore will fail. If a conflict occurs
	// during the restore process itself (e.g., because an out of band process
	// creates conflicting resources), a conflict will be reported.
	//   "MERGE_SKIP_ON_CONFLICT" - This mode merges the backup and the target
	// cluster and skips the conflicting resources. If a single resource to restore
	// exists in the cluster before restoration, the resource will be skipped,
	// otherwise it will be restored.
	//   "MERGE_REPLACE_VOLUME_ON_CONFLICT" - This mode merges the backup and the
	// target cluster and skips the conflicting resources except volume data. If a
	// PVC to restore already exists, this mode will restore/reconnect the volume
	// without overwriting the PVC. It is similar to MERGE_SKIP_ON_CONFLICT except
	// that it will apply the volume data policy for the conflicting PVCs: -
	// RESTORE_VOLUME_DATA_FROM_BACKUP: restore data only and respect the reclaim
	// policy of the original PV; - REUSE_VOLUME_HANDLE_FROM_BACKUP: reconnect and
	// respect the reclaim policy of the original PV; - NO_VOLUME_DATA_RESTORATION:
	// new provision and respect the reclaim policy of the original PV. Note that
	// this mode could cause data loss as the original PV can be retained or
	// deleted depending on its reclaim policy.
	//   "MERGE_REPLACE_ON_CONFLICT" - This mode merges the backup and the target
	// cluster and replaces the conflicting resources with the ones in the backup.
	// If a single resource to restore exists in the cluster before restoration,
	// the resource will be replaced with the one from the backup. To replace an
	// existing resource, the first attempt is to update the resource to match the
	// one from the backup; if the update fails, the second attempt is to delete
	// the resource and restore it from the backup. Note that this mode could cause
	// data loss as it replaces the existing resources in the target cluster, and
	// the original PV can be retained or deleted depending on its reclaim policy.
	NamespacedResourceRestoreMode string `json:"namespacedResourceRestoreMode,omitempty"`
	// NoNamespaces: Do not restore any namespaced resources if set to "True".
	// Specifying this field to "False" is not allowed.
	NoNamespaces bool `json:"noNamespaces,omitempty"`
	// RestoreOrder: Optional. RestoreOrder contains custom ordering to use on a
	// Restore.
	RestoreOrder *RestoreOrder `json:"restoreOrder,omitempty"`
	// SelectedApplications: A list of selected ProtectedApplications to restore.
	// The listed ProtectedApplications and all the resources to which they refer
	// will be restored.
	SelectedApplications *NamespacedNames `json:"selectedApplications,omitempty"`
	// SelectedNamespaces: A list of selected Namespaces to restore from the
	// Backup. The listed Namespaces and all resources contained in them will be
	// restored.
	SelectedNamespaces *Namespaces `json:"selectedNamespaces,omitempty"`
	// SubstitutionRules: Optional. A list of transformation rules to be applied
	// against Kubernetes resources as they are selected for restoration from a
	// Backup. Rules are executed in order defined - this order matters, as changes
	// made by a rule may impact the filtering logic of subsequent rules. An empty
	// list means no substitution will occur.
	SubstitutionRules []*SubstitutionRule `json:"substitutionRules,omitempty"`
	// TransformationRules: Optional. A list of transformation rules to be applied
	// against Kubernetes resources as they are selected for restoration from a
	// Backup. Rules are executed in order defined - this order matters, as changes
	// made by a rule may impact the filtering logic of subsequent rules. An empty
	// list means no transformation will occur.
	TransformationRules []*TransformationRule `json:"transformationRules,omitempty"`
	// VolumeDataRestorePolicy: Optional. Specifies the mechanism to be used to
	// restore volume data. Default: VOLUME_DATA_RESTORE_POLICY_UNSPECIFIED (will
	// be treated as NO_VOLUME_DATA_RESTORATION).
	//
	// Possible values:
	//   "VOLUME_DATA_RESTORE_POLICY_UNSPECIFIED" - Unspecified (illegal).
	//   "RESTORE_VOLUME_DATA_FROM_BACKUP" - For each PVC to be restored, create a
	// new underlying volume and PV from the corresponding VolumeBackup contained
	// within the Backup.
	//   "REUSE_VOLUME_HANDLE_FROM_BACKUP" - For each PVC to be restored, attempt
	// to reuse the original PV contained in the Backup (with its original
	// underlying volume). This option is likely only usable when restoring a
	// workload to its original cluster.
	//   "NO_VOLUME_DATA_RESTORATION" - For each PVC to be restored, create PVC
	// without any particular action to restore data. In this case, the normal
	// Kubernetes provisioning logic would kick in, and this would likely result in
	// either dynamically provisioning blank PVs or binding to statically
	// provisioned PVs.
	VolumeDataRestorePolicy string `json:"volumeDataRestorePolicy,omitempty"`
	// VolumeDataRestorePolicyBindings: Optional. A table that binds volumes by
	// their scope to a restore policy. Bindings must have a unique scope. Any
	// volumes not scoped in the bindings are subject to the policy defined in
	// volume_data_restore_policy.
	VolumeDataRestorePolicyBindings []*VolumeDataRestorePolicyBinding `json:"volumeDataRestorePolicyBindings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllNamespaces") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllNamespaces") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RestoreConfig) MarshalJSON() ([]byte, error) {
	type NoMethod RestoreConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RestoreOrder: Allows customers to specify dependencies between resources
// that Backup for GKE can use to compute a resasonable restore order.
type RestoreOrder struct {
	// GroupKindDependencies: Optional. Contains a list of group kind dependency
	// pairs provided by the customer, that is used by Backup for GKE to generate a
	// group kind restore order.
	GroupKindDependencies []*GroupKindDependency `json:"groupKindDependencies,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GroupKindDependencies") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GroupKindDependencies") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RestoreOrder) MarshalJSON() ([]byte, error) {
	type NoMethod RestoreOrder
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RestorePlan: The configuration of a potential series of Restore operations
// to be performed against Backups belong to a particular BackupPlan.
type RestorePlan struct {
	// BackupPlan: Required. Immutable. A reference to the BackupPlan from which
	// Backups may be used as the source for Restores created via this RestorePlan.
	// Format: `projects/*/locations/*/backupPlans/*`.
	BackupPlan string `json:"backupPlan,omitempty"`
	// Cluster: Required. Immutable. The target cluster into which Restores created
	// via this RestorePlan will restore data. NOTE: the cluster's region must be
	// the same as the RestorePlan. Valid formats: -
	// `projects/*/locations/*/clusters/*` - `projects/*/zones/*/clusters/*`
	Cluster string `json:"cluster,omitempty"`
	// CreateTime: Output only. The timestamp when this RestorePlan resource was
	// created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. User specified descriptive string for this
	// RestorePlan.
	Description string `json:"description,omitempty"`
	// Etag: Output only. `etag` is used for optimistic concurrency control as a
	// way to help prevent simultaneous updates of a restore from overwriting each
	// other. It is strongly suggested that systems make use of the `etag` in the
	// read-modify-write cycle to perform restore updates in order to avoid race
	// conditions: An `etag` is returned in the response to `GetRestorePlan`, and
	// systems are expected to put that etag in the request to `UpdateRestorePlan`
	// or `DeleteRestorePlan` to ensure that their change will be applied to the
	// same version of the resource.
	Etag string `json:"etag,omitempty"`
	// Labels: Optional. A set of custom labels supplied by user.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Output only. The full name of the RestorePlan resource. Format:
	// `projects/*/locations/*/restorePlans/*`.
	Name string `json:"name,omitempty"`
	// RestoreConfig: Required. Configuration of Restores created via this
	// RestorePlan.
	RestoreConfig *RestoreConfig `json:"restoreConfig,omitempty"`
	// State: Output only. State of the RestorePlan. This State field reflects the
	// various stages a RestorePlan can be in during the Create operation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default first value for Enums.
	//   "CLUSTER_PENDING" - Waiting for cluster state to be RUNNING.
	//   "READY" - The RestorePlan has successfully been created and is ready for
	// Restores.
	//   "FAILED" - RestorePlan creation has failed.
	//   "DELETING" - The RestorePlan is in the process of being deleted.
	State string `json:"state,omitempty"`
	// StateReason: Output only. Human-readable description of why RestorePlan is
	// in the current `state`
	StateReason string `json:"stateReason,omitempty"`
	// Uid: Output only. Server generated global unique identifier of UUID
	// (https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
	Uid string `json:"uid,omitempty"`
	// UpdateTime: Output only. The timestamp when this RestorePlan resource was
	// last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BackupPlan") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BackupPlan") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RestorePlan) MarshalJSON() ([]byte, error) {
	type NoMethod RestorePlan
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RetentionPolicy: RetentionPolicy defines a Backup retention policy for a
// BackupPlan.
type RetentionPolicy struct {
	// BackupDeleteLockDays: Optional. Minimum age for Backups created via this
	// BackupPlan (in days). This field MUST be an integer value between 0-90
	// (inclusive). A Backup created under this BackupPlan will NOT be deletable
	// until it reaches Backup's (create_time + backup_delete_lock_days). Updating
	// this field of a BackupPlan does NOT affect existing Backups under it.
	// Backups created AFTER a successful update will inherit the new value.
	// Default: 0 (no delete blocking)
	BackupDeleteLockDays int64 `json:"backupDeleteLockDays,omitempty"`
	// BackupRetainDays: Optional. The default maximum age of a Backup created via
	// this BackupPlan. This field MUST be an integer value >= 0 and <= 365. If
	// specified, a Backup created under this BackupPlan will be automatically
	// deleted after its age reaches (create_time + backup_retain_days). If not
	// specified, Backups created under this BackupPlan will NOT be subject to
	// automatic deletion. Updating this field does NOT affect existing Backups
	// under it. Backups created AFTER a successful update will automatically pick
	// up the new value. NOTE: backup_retain_days must be >=
	// backup_delete_lock_days. If cron_schedule is defined, then this must be <=
	// 360 * the creation interval. If rpo_config is defined, then this must be <=
	// 360 * target_rpo_minutes / (1440minutes/day). Default: 0 (no automatic
	// deletion)
	BackupRetainDays int64 `json:"backupRetainDays,omitempty"`
	// Locked: Optional. This flag denotes whether the retention policy of this
	// BackupPlan is locked. If set to True, no further update is allowed on this
	// policy, including the `locked` field itself. Default: False
	Locked bool `json:"locked,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BackupDeleteLockDays") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BackupDeleteLockDays") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RetentionPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod RetentionPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RpoConfig: Defines RPO scheduling configuration for automatically creating
// Backups via this BackupPlan.
type RpoConfig struct {
	// ExclusionWindows: Optional. User specified time windows during which backup
	// can NOT happen for this BackupPlan - backups should start and finish outside
	// of any given exclusion window. Note: backup jobs will be scheduled to start
	// and finish outside the duration of the window as much as possible, but
	// running jobs will not get canceled when it runs into the window. All the
	// time and date values in exclusion_windows entry in the API are in UTC. We
	// only allow <=1 recurrence (daily or weekly) exclusion window for a
	// BackupPlan while no restriction on number of single occurrence windows.
	ExclusionWindows []*ExclusionWindow `json:"exclusionWindows,omitempty"`
	// TargetRpoMinutes: Required. Defines the target RPO for the BackupPlan in
	// minutes, which means the target maximum data loss in time that is acceptable
	// for this BackupPlan. This must be at least 60, i.e., 1 hour, and at most
	// 86400, i.e., 60 days.
	TargetRpoMinutes int64 `json:"targetRpoMinutes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExclusionWindows") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExclusionWindows") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RpoConfig) MarshalJSON() ([]byte, error) {
	type NoMethod RpoConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Schedule: Defines scheduling parameters for automatically creating Backups
// via this BackupPlan.
type Schedule struct {
	// CronSchedule: Optional. A standard cron (https://wikipedia.com/wiki/cron)
	// string that defines a repeating schedule for creating Backups via this
	// BackupPlan. This is mutually exclusive with the rpo_config field since at
	// most one schedule can be defined for a BackupPlan. If this is defined, then
	// backup_retain_days must also be defined. Default (empty): no automatic
	// backup creation will occur.
	CronSchedule string `json:"cronSchedule,omitempty"`
	// NextScheduledBackupTime: Output only. Start time of next scheduled backup
	// under this BackupPlan by either cron_schedule or rpo config.
	NextScheduledBackupTime string `json:"nextScheduledBackupTime,omitempty"`
	// Paused: Optional. This flag denotes whether automatic Backup creation is
	// paused for this BackupPlan. Default: False
	Paused bool `json:"paused,omitempty"`
	// RpoConfig: Optional. Defines the RPO schedule configuration for this
	// BackupPlan. This is mutually exclusive with the cron_schedule field since at
	// most one schedule can be defined for a BackupPLan. If this is defined, then
	// backup_retain_days must also be defined. Default (empty): no automatic
	// backup creation will occur.
	RpoConfig *RpoConfig `json:"rpoConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CronSchedule") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CronSchedule") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Schedule) MarshalJSON() ([]byte, error) {
	type NoMethod Schedule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SetIamPolicyRequest: Request message for `SetIamPolicy` method.
type SetIamPolicyRequest struct {
	// Policy: REQUIRED: The complete policy to be applied to the `resource`. The
	// size of the policy is limited to a few 10s of KB. An empty policy is a valid
	// policy but certain Google Cloud services (such as Projects) might reject
	// them.
	Policy *Policy `json:"policy,omitempty"`
	// UpdateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
	// modify. Only the fields in the mask will be modified. If no mask is
	// provided, the following default mask is used: `paths: "bindings, etag"
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Policy") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Policy") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SetIamPolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SetIamPolicyRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SubstitutionRule: A transformation rule to be applied against Kubernetes
// resources as they are selected for restoration from a Backup. A rule
// contains both filtering logic (which resources are subject to substitution)
// and substitution logic.
type SubstitutionRule struct {
	// NewValue: Optional. This is the new value to set for any fields that pass
	// the filtering and selection criteria. To remove a value from a Kubernetes
	// resource, either leave this field unspecified, or set it to the empty string
	// ("").
	NewValue string `json:"newValue,omitempty"`
	// OriginalValuePattern: Optional. (Filtering parameter) This is a [regular
	// expression] (https://en.wikipedia.org/wiki/Regular_expression) that is
	// compared against the fields matched by the target_json_path expression (and
	// must also have passed the previous filters). Substitution will not be
	// performed against fields whose value does not match this expression. If this
	// field is NOT specified, then ALL fields matched by the target_json_path
	// expression will undergo substitution. Note that an empty (e.g., "", rather
	// than unspecified) value for this field will only match empty fields.
	OriginalValuePattern string `json:"originalValuePattern,omitempty"`
	// TargetGroupKinds: Optional. (Filtering parameter) Any resource subject to
	// substitution must belong to one of the listed "types". If this field is not
	// provided, no type filtering will be performed (all resources of all types
	// matching previous filtering parameters will be candidates for substitution).
	TargetGroupKinds []*GroupKind `json:"targetGroupKinds,omitempty"`
	// TargetJsonPath: Required. This is a [JSONPath]
	// (https://kubernetes.io/docs/reference/kubectl/jsonpath/) expression that
	// matches specific fields of candidate resources and it operates as both a
	// filtering parameter (resources that are not matched with this expression
	// will not be candidates for substitution) as well as a field identifier
	// (identifies exactly which fields out of the candidate resources will be
	// modified).
	TargetJsonPath string `json:"targetJsonPath,omitempty"`
	// TargetNamespaces: Optional. (Filtering parameter) Any resource subject to
	// substitution must be contained within one of the listed Kubernetes Namespace
	// in the Backup. If this field is not provided, no namespace filtering will be
	// performed (all resources in all Namespaces, including all cluster-scoped
	// resources, will be candidates for substitution). To mix cluster-scoped and
	// namespaced resources in the same rule, use an empty string ("") as one of
	// the target namespaces.
	TargetNamespaces []string `json:"targetNamespaces,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NewValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NewValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SubstitutionRule) MarshalJSON() ([]byte, error) {
	type NoMethod SubstitutionRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TestIamPermissionsRequest: Request message for `TestIamPermissions` method.
type TestIamPermissionsRequest struct {
	// Permissions: The set of permissions to check for the `resource`. Permissions
	// with wildcards (such as `*` or `storage.*`) are not allowed. For more
	// information see IAM Overview
	// (https://cloud.google.com/iam/docs/overview#permissions).
	Permissions []string `json:"permissions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Permissions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TestIamPermissionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod TestIamPermissionsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TestIamPermissionsResponse: Response message for `TestIamPermissions`
// method.
type TestIamPermissionsResponse struct {
	// Permissions: A subset of `TestPermissionsRequest.permissions` that the
	// caller is allowed.
	Permissions []string `json:"permissions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Permissions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TestIamPermissionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod TestIamPermissionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TimeOfDay: Represents a time of day. The date and time zone are either not
// significant or are specified elsewhere. An API may choose to allow leap
// seconds. Related types are google.type.Date and `google.protobuf.Timestamp`.
type TimeOfDay struct {
	// Hours: Hours of day in 24 hour format. Should be from 0 to 23. An API may
	// choose to allow the value "24:00:00" for scenarios like business closing
	// time.
	Hours int64 `json:"hours,omitempty"`
	// Minutes: Minutes of hour of day. Must be from 0 to 59.
	Minutes int64 `json:"minutes,omitempty"`
	// Nanos: Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
	Nanos int64 `json:"nanos,omitempty"`
	// Seconds: Seconds of minutes of the time. Must normally be from 0 to 59. An
	// API may allow the value 60 if it allows leap-seconds.
	Seconds int64 `json:"seconds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Hours") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Hours") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TimeOfDay) MarshalJSON() ([]byte, error) {
	type NoMethod TimeOfDay
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TransformationRule: A transformation rule to be applied against Kubernetes
// resources as they are selected for restoration from a Backup. A rule
// contains both filtering logic (which resources are subject to transform) and
// transformation logic.
type TransformationRule struct {
	// Description: Optional. The description is a user specified string
	// description of the transformation rule.
	Description string `json:"description,omitempty"`
	// FieldActions: Required. A list of transformation rule actions to take
	// against candidate resources. Actions are executed in order defined - this
	// order matters, as they could potentially interfere with each other and the
	// first operation could affect the outcome of the second operation.
	FieldActions []*TransformationRuleAction `json:"fieldActions,omitempty"`
	// ResourceFilter: Optional. This field is used to specify a set of fields that
	// should be used to determine which resources in backup should be acted upon
	// by the supplied transformation rule actions, and this will ensure that only
	// specific resources are affected by transformation rule actions.
	ResourceFilter *ResourceFilter `json:"resourceFilter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TransformationRule) MarshalJSON() ([]byte, error) {
	type NoMethod TransformationRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TransformationRuleAction: TransformationRuleAction defines a
// TransformationRule action based on the JSON Patch RFC
// (https://www.rfc-editor.org/rfc/rfc6902)
type TransformationRuleAction struct {
	// FromPath: Optional. A string containing a JSON Pointer value that references
	// the location in the target document to move the value from.
	FromPath string `json:"fromPath,omitempty"`
	// Op: Required. op specifies the operation to perform.
	//
	// Possible values:
	//   "OP_UNSPECIFIED" - Unspecified operation
	//   "REMOVE" - The "remove" operation removes the value at the target
	// location.
	//   "MOVE" - The "move" operation removes the value at a specified location
	// and adds it to the target location.
	//   "COPY" - The "copy" operation copies the value at a specified location to
	// the target location.
	//   "ADD" - The "add" operation performs one of the following functions,
	// depending upon what the target location references: 1. If the target
	// location specifies an array index, a new value is inserted into the array at
	// the specified index. 2. If the target location specifies an object member
	// that does not already exist, a new member is added to the object. 3. If the
	// target location specifies an object member that does exist, that member's
	// value is replaced.
	//   "TEST" - The "test" operation tests that a value at the target location is
	// equal to a specified value.
	//   "REPLACE" - The "replace" operation replaces the value at the target
	// location with a new value. The operation object MUST contain a "value"
	// member whose content specifies the replacement value.
	Op string `json:"op,omitempty"`
	// Path: Optional. A string containing a JSON-Pointer value that references a
	// location within the target document where the operation is performed.
	Path string `json:"path,omitempty"`
	// Value: Optional. A string that specifies the desired value in string format
	// to use for transformation.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FromPath") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FromPath") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TransformationRuleAction) MarshalJSON() ([]byte, error) {
	type NoMethod TransformationRuleAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VolumeBackup: Represents the backup of a specific persistent volume as a
// component of a Backup - both the record of the operation and a pointer to
// the underlying storage-specific artifacts.
type VolumeBackup struct {
	// CompleteTime: Output only. The timestamp when the associated underlying
	// volume backup operation completed.
	CompleteTime string `json:"completeTime,omitempty"`
	// CreateTime: Output only. The timestamp when this VolumeBackup resource was
	// created.
	CreateTime string `json:"createTime,omitempty"`
	// DiskSizeBytes: Output only. The minimum size of the disk to which this
	// VolumeBackup can be restored.
	DiskSizeBytes int64 `json:"diskSizeBytes,omitempty,string"`
	// Etag: Output only. `etag` is used for optimistic concurrency control as a
	// way to help prevent simultaneous updates of a volume backup from overwriting
	// each other. It is strongly suggested that systems make use of the `etag` in
	// the read-modify-write cycle to perform volume backup updates in order to
	// avoid race conditions.
	Etag string `json:"etag,omitempty"`
	// Format: Output only. The format used for the volume backup.
	//
	// Possible values:
	//   "VOLUME_BACKUP_FORMAT_UNSPECIFIED" - Default value, not specified.
	//   "GCE_PERSISTENT_DISK" - Compute Engine Persistent Disk snapshot based
	// volume backup.
	Format string `json:"format,omitempty"`
	// Name: Output only. The full name of the VolumeBackup resource. Format:
	// `projects/*/locations/*/backupPlans/*/backups/*/volumeBackups/*`.
	Name string `json:"name,omitempty"`
	// SourcePvc: Output only. A reference to the source Kubernetes PVC from which
	// this VolumeBackup was created.
	SourcePvc *NamespacedName `json:"sourcePvc,omitempty"`
	// State: Output only. The current state of this VolumeBackup.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - This is an illegal state and should not be
	// encountered.
	//   "CREATING" - A volume for the backup was identified and backup process is
	// about to start.
	//   "SNAPSHOTTING" - The volume backup operation has begun and is in the
	// initial "snapshot" phase of the process. Any defined ProtectedApplication
	// "pre" hooks will be executed before entering this state and "post" hooks
	// will be executed upon leaving this state.
	//   "UPLOADING" - The snapshot phase of the volume backup operation has
	// completed and the snapshot is now being uploaded to backup storage.
	//   "SUCCEEDED" - The volume backup operation has completed successfully.
	//   "FAILED" - The volume backup operation has failed.
	//   "DELETING" - This VolumeBackup resource (and its associated artifacts) is
	// in the process of being deleted.
	State string `json:"state,omitempty"`
	// StateMessage: Output only. A human readable message explaining why the
	// VolumeBackup is in its current state.
	StateMessage string `json:"stateMessage,omitempty"`
	// StorageBytes: Output only. The aggregate size of the underlying artifacts
	// associated with this VolumeBackup in the backup storage. This may change
	// over time when multiple backups of the same volume share the same backup
	// storage location. In particular, this is likely to increase in size when the
	// immediately preceding backup of the same volume is deleted.
	StorageBytes int64 `json:"storageBytes,omitempty,string"`
	// Uid: Output only. Server generated global unique identifier of UUID
	// (https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
	Uid string `json:"uid,omitempty"`
	// UpdateTime: Output only. The timestamp when this VolumeBackup resource was
	// last updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// VolumeBackupHandle: Output only. A storage system-specific opaque handle to
	// the underlying volume backup.
	VolumeBackupHandle string `json:"volumeBackupHandle,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CompleteTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompleteTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VolumeBackup) MarshalJSON() ([]byte, error) {
	type NoMethod VolumeBackup
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VolumeDataRestorePolicyBinding: Binds resources in the scope to the given
// VolumeDataRestorePolicy.
type VolumeDataRestorePolicyBinding struct {
	// Policy: Required. The VolumeDataRestorePolicy to apply when restoring
	// volumes in scope.
	//
	// Possible values:
	//   "VOLUME_DATA_RESTORE_POLICY_UNSPECIFIED" - Unspecified (illegal).
	//   "RESTORE_VOLUME_DATA_FROM_BACKUP" - For each PVC to be restored, create a
	// new underlying volume and PV from the corresponding VolumeBackup contained
	// within the Backup.
	//   "REUSE_VOLUME_HANDLE_FROM_BACKUP" - For each PVC to be restored, attempt
	// to reuse the original PV contained in the Backup (with its original
	// underlying volume). This option is likely only usable when restoring a
	// workload to its original cluster.
	//   "NO_VOLUME_DATA_RESTORATION" - For each PVC to be restored, create PVC
	// without any particular action to restore data. In this case, the normal
	// Kubernetes provisioning logic would kick in, and this would likely result in
	// either dynamically provisioning blank PVs or binding to statically
	// provisioned PVs.
	Policy string `json:"policy,omitempty"`
	// VolumeType: The volume type, as determined by the PVC's bound PV, to apply
	// the policy to.
	//
	// Possible values:
	//   "VOLUME_TYPE_UNSPECIFIED" - Default
	//   "GCE_PERSISTENT_DISK" - Compute Engine Persistent Disk volume
	VolumeType string `json:"volumeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Policy") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Policy") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VolumeDataRestorePolicyBinding) MarshalJSON() ([]byte, error) {
	type NoMethod VolumeDataRestorePolicyBinding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VolumeDataRestorePolicyOverride: Defines an override to apply a
// VolumeDataRestorePolicy for scoped resources.
type VolumeDataRestorePolicyOverride struct {
	// Policy: Required. The VolumeDataRestorePolicy to apply when restoring
	// volumes in scope.
	//
	// Possible values:
	//   "VOLUME_DATA_RESTORE_POLICY_UNSPECIFIED" - Unspecified (illegal).
	//   "RESTORE_VOLUME_DATA_FROM_BACKUP" - For each PVC to be restored, create a
	// new underlying volume and PV from the corresponding VolumeBackup contained
	// within the Backup.
	//   "REUSE_VOLUME_HANDLE_FROM_BACKUP" - For each PVC to be restored, attempt
	// to reuse the original PV contained in the Backup (with its original
	// underlying volume). This option is likely only usable when restoring a
	// workload to its original cluster.
	//   "NO_VOLUME_DATA_RESTORATION" - For each PVC to be restored, create PVC
	// without any particular action to restore data. In this case, the normal
	// Kubernetes provisioning logic would kick in, and this would likely result in
	// either dynamically provisioning blank PVs or binding to statically
	// provisioned PVs.
	Policy string `json:"policy,omitempty"`
	// SelectedPvcs: A list of PVCs to apply the policy override to.
	SelectedPvcs *NamespacedNames `json:"selectedPvcs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Policy") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Policy") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VolumeDataRestorePolicyOverride) MarshalJSON() ([]byte, error) {
	type NoMethod VolumeDataRestorePolicyOverride
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VolumeRestore: Represents the operation of restoring a volume from a
// VolumeBackup.
type VolumeRestore struct {
	// CompleteTime: Output only. The timestamp when the associated underlying
	// volume restoration completed.
	CompleteTime string `json:"completeTime,omitempty"`
	// CreateTime: Output only. The timestamp when this VolumeRestore resource was
	// created.
	CreateTime string `json:"createTime,omitempty"`
	// Etag: Output only. `etag` is used for optimistic concurrency control as a
	// way to help prevent simultaneous updates of a volume restore from
	// overwriting each other. It is strongly suggested that systems make use of
	// the `etag` in the read-modify-write cycle to perform volume restore updates
	// in order to avoid race conditions.
	Etag string `json:"etag,omitempty"`
	// Name: Output only. Full name of the VolumeRestore resource. Format:
	// `projects/*/locations/*/restorePlans/*/restores/*/volumeRestores/*`
	Name string `json:"name,omitempty"`
	// State: Output only. The current state of this VolumeRestore.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - This is an illegal state and should not be
	// encountered.
	//   "CREATING" - A volume for the restore was identified and restore process
	// is about to start.
	//   "RESTORING" - The volume is currently being restored.
	//   "SUCCEEDED" - The volume has been successfully restored.
	//   "FAILED" - The volume restoration process failed.
	//   "DELETING" - This VolumeRestore resource is in the process of being
	// deleted.
	State string `json:"state,omitempty"`
	// StateMessage: Output only. A human readable message explaining why the
	// VolumeRestore is in its current state.
	StateMessage string `json:"stateMessage,omitempty"`
	// TargetPvc: Output only. The reference to the target Kubernetes PVC to be
	// restored.
	TargetPvc *NamespacedName `json:"targetPvc,omitempty"`
	// Uid: Output only. Server generated global unique identifier of UUID
	// (https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
	Uid string `json:"uid,omitempty"`
	// UpdateTime: Output only. The timestamp when this VolumeRestore resource was
	// last updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// VolumeBackup: Output only. The full name of the VolumeBackup from which the
	// volume will be restored. Format:
	// `projects/*/locations/*/backupPlans/*/backups/*/volumeBackups/*`.
	VolumeBackup string `json:"volumeBackup,omitempty"`
	// VolumeHandle: Output only. A storage system-specific opaque handler to the
	// underlying volume created for the target PVC from the volume backup.
	VolumeHandle string `json:"volumeHandle,omitempty"`
	// VolumeType: Output only. The type of volume provisioned
	//
	// Possible values:
	//   "VOLUME_TYPE_UNSPECIFIED" - Default
	//   "GCE_PERSISTENT_DISK" - Compute Engine Persistent Disk volume
	VolumeType string `json:"volumeType,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CompleteTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompleteTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VolumeRestore) MarshalJSON() ([]byte, error) {
	type NoMethod VolumeRestore
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProjectsLocationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a location.
//
// - name: Resource name for the location.
func (r *ProjectsLocationsService) Get(name string) *ProjectsLocationsGetCall {
	c := &ProjectsLocationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGetCall) Context(ctx context.Context) *ProjectsLocationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Location.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGetCall) Do(opts ...googleapi.CallOption) (*Location, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Location{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists information about the supported locations for this service.
//
// - name: The resource that owns the locations collection, if applicable.
func (r *ProjectsLocationsService) List(name string) *ProjectsLocationsListCall {
	c := &ProjectsLocationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": A filter to narrow down results
// to a preferred subset. The filtering language accepts strings like
// "displayName=tokyo", and is documented in more detail in AIP-160
// (https://google.aip.dev/160).
func (c *ProjectsLocationsListCall) Filter(filter string) *ProjectsLocationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return. If not set, the service selects a default.
func (c *ProjectsLocationsListCall) PageSize(pageSize int64) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from the `next_page_token` field in the response. Send that page token to
// receive the subsequent page.
func (c *ProjectsLocationsListCall) PageToken(pageToken string) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsListCall) Context(ctx context.Context) *ProjectsLocationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/locations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListLocationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsListCall) Do(opts ...googleapi.CallOption) (*ListLocationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListLocationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsListCall) Pages(ctx context.Context, f func(*ListLocationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsBackupPlansCreateCall struct {
	s          *Service
	parent     string
	backupplan *BackupPlan
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new BackupPlan in a given location.
//
//   - parent: The location within which to create the BackupPlan. Format:
//     `projects/*/locations/*`.
func (r *ProjectsLocationsBackupPlansService) Create(parent string, backupplan *BackupPlan) *ProjectsLocationsBackupPlansCreateCall {
	c := &ProjectsLocationsBackupPlansCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.backupplan = backupplan
	return c
}

// BackupPlanId sets the optional parameter "backupPlanId": Required. The
// client-provided short name for the BackupPlan resource. This name must: - be
// between 1 and 63 characters long (inclusive) - consist of only lower-case
// ASCII letters, numbers, and dashes - start with a lower-case letter - end
// with a lower-case letter or number - be unique within the set of BackupPlans
// in this location
func (c *ProjectsLocationsBackupPlansCreateCall) BackupPlanId(backupPlanId string) *ProjectsLocationsBackupPlansCreateCall {
	c.urlParams_.Set("backupPlanId", backupPlanId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackupPlansCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackupPlansCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackupPlansCreateCall) Context(ctx context.Context) *ProjectsLocationsBackupPlansCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackupPlansCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackupPlansCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.backupplan)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/backupPlans")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.backupPlans.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBackupPlansCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsBackupPlansDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an existing BackupPlan.
//
//   - name: Fully qualified BackupPlan name. Format:
//     `projects/*/locations/*/backupPlans/*`.
func (r *ProjectsLocationsBackupPlansService) Delete(name string) *ProjectsLocationsBackupPlansDeleteCall {
	c := &ProjectsLocationsBackupPlansDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": If provided, this value must match
// the current value of the target BackupPlan's etag field or the request is
// rejected.
func (c *ProjectsLocationsBackupPlansDeleteCall) Etag(etag string) *ProjectsLocationsBackupPlansDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackupPlansDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackupPlansDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackupPlansDeleteCall) Context(ctx context.Context) *ProjectsLocationsBackupPlansDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackupPlansDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackupPlansDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.backupPlans.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBackupPlansDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsBackupPlansGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieve the details of a single BackupPlan.
//
//   - name: Fully qualified BackupPlan name. Format:
//     `projects/*/locations/*/backupPlans/*`.
func (r *ProjectsLocationsBackupPlansService) Get(name string) *ProjectsLocationsBackupPlansGetCall {
	c := &ProjectsLocationsBackupPlansGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackupPlansGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackupPlansGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBackupPlansGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsBackupPlansGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackupPlansGetCall) Context(ctx context.Context) *ProjectsLocationsBackupPlansGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackupPlansGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackupPlansGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.backupPlans.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *BackupPlan.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBackupPlansGetCall) Do(opts ...googleapi.CallOption) (*BackupPlan, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &BackupPlan{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsBackupPlansGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns an
// empty policy if the resource exists and does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsBackupPlansService) GetIamPolicy(resource string) *ProjectsLocationsBackupPlansGetIamPolicyCall {
	c := &ProjectsLocationsBackupPlansGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that will be
// used to format the policy. Valid values are 0, 1, and 3. Requests specifying
// an invalid value will be rejected. Requests for policies with any
// conditional role bindings must specify version 3. Policies with no
// conditional role bindings may specify any valid value or leave the field
// unset. The policy in the response might use the policy version that you
// specified, or it might use a lower policy version. For example, if you
// specify version 3, but the policy has no conditional role bindings, the
// response uses version 1. To learn which resources support conditions in
// their IAM policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsBackupPlansGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsBackupPlansGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackupPlansGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackupPlansGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBackupPlansGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsBackupPlansGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackupPlansGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsBackupPlansGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackupPlansGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackupPlansGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.backupPlans.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBackupPlansGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsBackupPlansListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists BackupPlans in a given location.
//
//   - parent: The location that contains the BackupPlans to list. Format:
//     `projects/*/locations/*`.
func (r *ProjectsLocationsBackupPlansService) List(parent string) *ProjectsLocationsBackupPlansListCall {
	c := &ProjectsLocationsBackupPlansListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Field match expression used to
// filter the results.
func (c *ProjectsLocationsBackupPlansListCall) Filter(filter string) *ProjectsLocationsBackupPlansListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Field by which to sort the
// results.
func (c *ProjectsLocationsBackupPlansListCall) OrderBy(orderBy string) *ProjectsLocationsBackupPlansListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The target number of
// results to return in a single response. If not specified, a default value
// will be chosen by the service. Note that the response may include a partial
// list and a caller should only rely on the response's next_page_token to
// determine if there are more instances left to be queried.
func (c *ProjectsLocationsBackupPlansListCall) PageSize(pageSize int64) *ProjectsLocationsBackupPlansListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value of
// next_page_token received from a previous `ListBackupPlans` call. Provide
// this to retrieve the subsequent page in a multi-page list of results. When
// paginating, all other parameters provided to `ListBackupPlans` must match
// the call that provided the page token.
func (c *ProjectsLocationsBackupPlansListCall) PageToken(pageToken string) *ProjectsLocationsBackupPlansListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackupPlansListCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackupPlansListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBackupPlansListCall) IfNoneMatch(entityTag string) *ProjectsLocationsBackupPlansListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackupPlansListCall) Context(ctx context.Context) *ProjectsLocationsBackupPlansListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackupPlansListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackupPlansListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/backupPlans")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.backupPlans.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListBackupPlansResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBackupPlansListCall) Do(opts ...googleapi.CallOption) (*ListBackupPlansResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListBackupPlansResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsBackupPlansListCall) Pages(ctx context.Context, f func(*ListBackupPlansResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsBackupPlansPatchCall struct {
	s          *Service
	name       string
	backupplan *BackupPlan
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Update a BackupPlan.
//
//   - name: Output only. The full name of the BackupPlan resource. Format:
//     `projects/*/locations/*/backupPlans/*`.
func (r *ProjectsLocationsBackupPlansService) Patch(name string, backupplan *BackupPlan) *ProjectsLocationsBackupPlansPatchCall {
	c := &ProjectsLocationsBackupPlansPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.backupplan = backupplan
	return c
}

// UpdateMask sets the optional parameter "updateMask": This is used to specify
// the fields to be overwritten in the BackupPlan targeted for update. The
// values for each of these updated fields will be taken from the `backup_plan`
// provided with this request. Field names are relative to the root of the
// resource (e.g., `description`, `backup_config.include_volume_data`, etc.) If
// no `update_mask` is provided, all fields in `backup_plan` will be written to
// the target BackupPlan resource. Note that OUTPUT_ONLY and IMMUTABLE fields
// in `backup_plan` are ignored and are not used to update the target
// BackupPlan.
func (c *ProjectsLocationsBackupPlansPatchCall) UpdateMask(updateMask string) *ProjectsLocationsBackupPlansPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackupPlansPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackupPlansPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackupPlansPatchCall) Context(ctx context.Context) *ProjectsLocationsBackupPlansPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackupPlansPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackupPlansPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.backupplan)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.backupPlans.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBackupPlansPatchCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsBackupPlansSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified resource.
// Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`,
// and `PERMISSION_DENIED` errors.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsBackupPlansService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsLocationsBackupPlansSetIamPolicyCall {
	c := &ProjectsLocationsBackupPlansSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackupPlansSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackupPlansSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackupPlansSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsBackupPlansSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackupPlansSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackupPlansSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.backupPlans.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBackupPlansSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsBackupPlansTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource. If the resource does not exist, this will return an empty set of
// permissions, not a `NOT_FOUND` error. Note: This operation is designed to be
// used for building permission-aware UIs and command-line tools, not for
// authorization checking. This operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsLocationsBackupPlansService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsLocationsBackupPlansTestIamPermissionsCall {
	c := &ProjectsLocationsBackupPlansTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackupPlansTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackupPlansTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackupPlansTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsBackupPlansTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackupPlansTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackupPlansTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.backupPlans.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBackupPlansTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsBackupPlansBackupsCreateCall struct {
	s          *Service
	parent     string
	backup     *Backup
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a Backup for the given BackupPlan.
//
//   - parent: The BackupPlan within which to create the Backup. Format:
//     `projects/*/locations/*/backupPlans/*`.
func (r *ProjectsLocationsBackupPlansBackupsService) Create(parent string, backup *Backup) *ProjectsLocationsBackupPlansBackupsCreateCall {
	c := &ProjectsLocationsBackupPlansBackupsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.backup = backup
	return c
}

// BackupId sets the optional parameter "backupId": The client-provided short
// name for the Backup resource. This name must: - be between 1 and 63
// characters long (inclusive) - consist of only lower-case ASCII letters,
// numbers, and dashes - start with a lower-case letter - end with a lower-case
// letter or number - be unique within the set of Backups in this BackupPlan
func (c *ProjectsLocationsBackupPlansBackupsCreateCall) BackupId(backupId string) *ProjectsLocationsBackupPlansBackupsCreateCall {
	c.urlParams_.Set("backupId", backupId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackupPlansBackupsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackupPlansBackupsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackupPlansBackupsCreateCall) Context(ctx context.Context) *ProjectsLocationsBackupPlansBackupsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackupPlansBackupsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackupPlansBackupsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.backup)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/backups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.backupPlans.backups.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBackupPlansBackupsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsBackupPlansBackupsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an existing Backup.
//
//   - name: Name of the Backup resource. Format:
//     `projects/*/locations/*/backupPlans/*/backups/*`.
func (r *ProjectsLocationsBackupPlansBackupsService) Delete(name string) *ProjectsLocationsBackupPlansBackupsDeleteCall {
	c := &ProjectsLocationsBackupPlansBackupsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": If provided, this value must match
// the current value of the target Backup's etag field or the request is
// rejected.
func (c *ProjectsLocationsBackupPlansBackupsDeleteCall) Etag(etag string) *ProjectsLocationsBackupPlansBackupsDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// Force sets the optional parameter "force": If set to true, any VolumeBackups
// below this Backup will also be deleted. Otherwise, the request will only
// succeed if the Backup has no VolumeBackups.
func (c *ProjectsLocationsBackupPlansBackupsDeleteCall) Force(force bool) *ProjectsLocationsBackupPlansBackupsDeleteCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackupPlansBackupsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackupPlansBackupsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackupPlansBackupsDeleteCall) Context(ctx context.Context) *ProjectsLocationsBackupPlansBackupsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackupPlansBackupsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackupPlansBackupsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.backupPlans.backups.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBackupPlansBackupsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsBackupPlansBackupsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieve the details of a single Backup.
//
//   - name: Full name of the Backup resource. Format:
//     `projects/*/locations/*/backupPlans/*/backups/*`.
func (r *ProjectsLocationsBackupPlansBackupsService) Get(name string) *ProjectsLocationsBackupPlansBackupsGetCall {
	c := &ProjectsLocationsBackupPlansBackupsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackupPlansBackupsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackupPlansBackupsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBackupPlansBackupsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsBackupPlansBackupsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackupPlansBackupsGetCall) Context(ctx context.Context) *ProjectsLocationsBackupPlansBackupsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackupPlansBackupsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackupPlansBackupsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.backupPlans.backups.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Backup.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBackupPlansBackupsGetCall) Do(opts ...googleapi.CallOption) (*Backup, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Backup{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsBackupPlansBackupsGetBackupIndexDownloadUrlCall struct {
	s            *Service
	backup       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetBackupIndexDownloadUrl: Retrieve the link to the backupIndex.
//
//   - backup: Full name of Backup resource. Format:
//     projects/{project}/locations/{location}/backupPlans/{backup_plan}/backups/{
//     backup}.
func (r *ProjectsLocationsBackupPlansBackupsService) GetBackupIndexDownloadUrl(backup string) *ProjectsLocationsBackupPlansBackupsGetBackupIndexDownloadUrlCall {
	c := &ProjectsLocationsBackupPlansBackupsGetBackupIndexDownloadUrlCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.backup = backup
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackupPlansBackupsGetBackupIndexDownloadUrlCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackupPlansBackupsGetBackupIndexDownloadUrlCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBackupPlansBackupsGetBackupIndexDownloadUrlCall) IfNoneMatch(entityTag string) *ProjectsLocationsBackupPlansBackupsGetBackupIndexDownloadUrlCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackupPlansBackupsGetBackupIndexDownloadUrlCall) Context(ctx context.Context) *ProjectsLocationsBackupPlansBackupsGetBackupIndexDownloadUrlCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackupPlansBackupsGetBackupIndexDownloadUrlCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackupPlansBackupsGetBackupIndexDownloadUrlCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+backup}:getBackupIndexDownloadUrl")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"backup": c.backup,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.backupPlans.backups.getBackupIndexDownloadUrl" call.
// Any non-2xx status code is an error. Response headers are in either
// *GetBackupIndexDownloadUrlResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBackupPlansBackupsGetBackupIndexDownloadUrlCall) Do(opts ...googleapi.CallOption) (*GetBackupIndexDownloadUrlResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GetBackupIndexDownloadUrlResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsBackupPlansBackupsGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns an
// empty policy if the resource exists and does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsBackupPlansBackupsService) GetIamPolicy(resource string) *ProjectsLocationsBackupPlansBackupsGetIamPolicyCall {
	c := &ProjectsLocationsBackupPlansBackupsGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that will be
// used to format the policy. Valid values are 0, 1, and 3. Requests specifying
// an invalid value will be rejected. Requests for policies with any
// conditional role bindings must specify version 3. Policies with no
// conditional role bindings may specify any valid value or leave the field
// unset. The policy in the response might use the policy version that you
// specified, or it might use a lower policy version. For example, if you
// specify version 3, but the policy has no conditional role bindings, the
// response uses version 1. To learn which resources support conditions in
// their IAM policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsBackupPlansBackupsGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsBackupPlansBackupsGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackupPlansBackupsGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackupPlansBackupsGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBackupPlansBackupsGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsBackupPlansBackupsGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackupPlansBackupsGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsBackupPlansBackupsGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackupPlansBackupsGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackupPlansBackupsGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.backupPlans.backups.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBackupPlansBackupsGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsBackupPlansBackupsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the Backups for a given BackupPlan.
//
//   - parent: The BackupPlan that contains the Backups to list. Format:
//     `projects/*/locations/*/backupPlans/*`.
func (r *ProjectsLocationsBackupPlansBackupsService) List(parent string) *ProjectsLocationsBackupPlansBackupsListCall {
	c := &ProjectsLocationsBackupPlansBackupsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Field match expression used to
// filter the results.
func (c *ProjectsLocationsBackupPlansBackupsListCall) Filter(filter string) *ProjectsLocationsBackupPlansBackupsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Field by which to sort the
// results.
func (c *ProjectsLocationsBackupPlansBackupsListCall) OrderBy(orderBy string) *ProjectsLocationsBackupPlansBackupsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The target number of
// results to return in a single response. If not specified, a default value
// will be chosen by the service. Note that the response may include a partial
// list and a caller should only rely on the response's next_page_token to
// determine if there are more instances left to be queried.
func (c *ProjectsLocationsBackupPlansBackupsListCall) PageSize(pageSize int64) *ProjectsLocationsBackupPlansBackupsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value of
// next_page_token received from a previous `ListBackups` call. Provide this to
// retrieve the subsequent page in a multi-page list of results. When
// paginating, all other parameters provided to `ListBackups` must match the
// call that provided the page token.
func (c *ProjectsLocationsBackupPlansBackupsListCall) PageToken(pageToken string) *ProjectsLocationsBackupPlansBackupsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackupPlansBackupsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackupPlansBackupsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBackupPlansBackupsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsBackupPlansBackupsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackupPlansBackupsListCall) Context(ctx context.Context) *ProjectsLocationsBackupPlansBackupsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackupPlansBackupsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackupPlansBackupsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/backups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.backupPlans.backups.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListBackupsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsBackupPlansBackupsListCall) Do(opts ...googleapi.CallOption) (*ListBackupsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListBackupsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsBackupPlansBackupsListCall) Pages(ctx context.Context, f func(*ListBackupsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsBackupPlansBackupsPatchCall struct {
	s          *Service
	name       string
	backup     *Backup
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Update a Backup.
//
//   - name: Output only. The fully qualified name of the Backup.
//     `projects/*/locations/*/backupPlans/*/backups/*`.
func (r *ProjectsLocationsBackupPlansBackupsService) Patch(name string, backup *Backup) *ProjectsLocationsBackupPlansBackupsPatchCall {
	c := &ProjectsLocationsBackupPlansBackupsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.backup = backup
	return c
}

// UpdateMask sets the optional parameter "updateMask": This is used to specify
// the fields to be overwritten in the Backup targeted for update. The values
// for each of these updated fields will be taken from the `backup_plan`
// provided with this request. Field names are relative to the root of the
// resource. If no `update_mask` is provided, all fields in `backup` will be
// written to the target Backup resource. Note that OUTPUT_ONLY and IMMUTABLE
// fields in `backup` are ignored and are not used to update the target Backup.
func (c *ProjectsLocationsBackupPlansBackupsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsBackupPlansBackupsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackupPlansBackupsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackupPlansBackupsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackupPlansBackupsPatchCall) Context(ctx context.Context) *ProjectsLocationsBackupPlansBackupsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackupPlansBackupsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackupPlansBackupsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.backup)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.backupPlans.backups.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBackupPlansBackupsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsBackupPlansBackupsSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified resource.
// Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`,
// and `PERMISSION_DENIED` errors.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsBackupPlansBackupsService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsLocationsBackupPlansBackupsSetIamPolicyCall {
	c := &ProjectsLocationsBackupPlansBackupsSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackupPlansBackupsSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackupPlansBackupsSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackupPlansBackupsSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsBackupPlansBackupsSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackupPlansBackupsSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackupPlansBackupsSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.backupPlans.backups.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBackupPlansBackupsSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsBackupPlansBackupsTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource. If the resource does not exist, this will return an empty set of
// permissions, not a `NOT_FOUND` error. Note: This operation is designed to be
// used for building permission-aware UIs and command-line tools, not for
// authorization checking. This operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsLocationsBackupPlansBackupsService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsLocationsBackupPlansBackupsTestIamPermissionsCall {
	c := &ProjectsLocationsBackupPlansBackupsTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackupPlansBackupsTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackupPlansBackupsTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackupPlansBackupsTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsBackupPlansBackupsTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackupPlansBackupsTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackupPlansBackupsTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.backupPlans.backups.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBackupPlansBackupsTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsBackupPlansBackupsVolumeBackupsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieve the details of a single VolumeBackup.
//
//   - name: Full name of the VolumeBackup resource. Format:
//     `projects/*/locations/*/backupPlans/*/backups/*/volumeBackups/*`.
func (r *ProjectsLocationsBackupPlansBackupsVolumeBackupsService) Get(name string) *ProjectsLocationsBackupPlansBackupsVolumeBackupsGetCall {
	c := &ProjectsLocationsBackupPlansBackupsVolumeBackupsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackupPlansBackupsVolumeBackupsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackupPlansBackupsVolumeBackupsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBackupPlansBackupsVolumeBackupsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsBackupPlansBackupsVolumeBackupsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackupPlansBackupsVolumeBackupsGetCall) Context(ctx context.Context) *ProjectsLocationsBackupPlansBackupsVolumeBackupsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackupPlansBackupsVolumeBackupsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackupPlansBackupsVolumeBackupsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.backupPlans.backups.volumeBackups.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *VolumeBackup.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBackupPlansBackupsVolumeBackupsGetCall) Do(opts ...googleapi.CallOption) (*VolumeBackup, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &VolumeBackup{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsBackupPlansBackupsVolumeBackupsGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns an
// empty policy if the resource exists and does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsBackupPlansBackupsVolumeBackupsService) GetIamPolicy(resource string) *ProjectsLocationsBackupPlansBackupsVolumeBackupsGetIamPolicyCall {
	c := &ProjectsLocationsBackupPlansBackupsVolumeBackupsGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that will be
// used to format the policy. Valid values are 0, 1, and 3. Requests specifying
// an invalid value will be rejected. Requests for policies with any
// conditional role bindings must specify version 3. Policies with no
// conditional role bindings may specify any valid value or leave the field
// unset. The policy in the response might use the policy version that you
// specified, or it might use a lower policy version. For example, if you
// specify version 3, but the policy has no conditional role bindings, the
// response uses version 1. To learn which resources support conditions in
// their IAM policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsBackupPlansBackupsVolumeBackupsGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsBackupPlansBackupsVolumeBackupsGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackupPlansBackupsVolumeBackupsGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackupPlansBackupsVolumeBackupsGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBackupPlansBackupsVolumeBackupsGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsBackupPlansBackupsVolumeBackupsGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackupPlansBackupsVolumeBackupsGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsBackupPlansBackupsVolumeBackupsGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackupPlansBackupsVolumeBackupsGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackupPlansBackupsVolumeBackupsGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.backupPlans.backups.volumeBackups.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBackupPlansBackupsVolumeBackupsGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsBackupPlansBackupsVolumeBackupsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the VolumeBackups for a given Backup.
//
//   - parent: The Backup that contains the VolumeBackups to list. Format:
//     `projects/*/locations/*/backupPlans/*/backups/*`.
func (r *ProjectsLocationsBackupPlansBackupsVolumeBackupsService) List(parent string) *ProjectsLocationsBackupPlansBackupsVolumeBackupsListCall {
	c := &ProjectsLocationsBackupPlansBackupsVolumeBackupsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Field match expression used to
// filter the results.
func (c *ProjectsLocationsBackupPlansBackupsVolumeBackupsListCall) Filter(filter string) *ProjectsLocationsBackupPlansBackupsVolumeBackupsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Field by which to sort the
// results.
func (c *ProjectsLocationsBackupPlansBackupsVolumeBackupsListCall) OrderBy(orderBy string) *ProjectsLocationsBackupPlansBackupsVolumeBackupsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The target number of
// results to return in a single response. If not specified, a default value
// will be chosen by the service. Note that the response may include a partial
// list and a caller should only rely on the response's next_page_token to
// determine if there are more instances left to be queried.
func (c *ProjectsLocationsBackupPlansBackupsVolumeBackupsListCall) PageSize(pageSize int64) *ProjectsLocationsBackupPlansBackupsVolumeBackupsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value of
// next_page_token received from a previous `ListVolumeBackups` call. Provide
// this to retrieve the subsequent page in a multi-page list of results. When
// paginating, all other parameters provided to `ListVolumeBackups` must match
// the call that provided the page token.
func (c *ProjectsLocationsBackupPlansBackupsVolumeBackupsListCall) PageToken(pageToken string) *ProjectsLocationsBackupPlansBackupsVolumeBackupsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackupPlansBackupsVolumeBackupsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackupPlansBackupsVolumeBackupsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBackupPlansBackupsVolumeBackupsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsBackupPlansBackupsVolumeBackupsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackupPlansBackupsVolumeBackupsListCall) Context(ctx context.Context) *ProjectsLocationsBackupPlansBackupsVolumeBackupsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackupPlansBackupsVolumeBackupsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackupPlansBackupsVolumeBackupsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/volumeBackups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.backupPlans.backups.volumeBackups.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListVolumeBackupsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBackupPlansBackupsVolumeBackupsListCall) Do(opts ...googleapi.CallOption) (*ListVolumeBackupsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListVolumeBackupsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsBackupPlansBackupsVolumeBackupsListCall) Pages(ctx context.Context, f func(*ListVolumeBackupsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsBackupPlansBackupsVolumeBackupsSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified resource.
// Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`,
// and `PERMISSION_DENIED` errors.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsBackupPlansBackupsVolumeBackupsService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsLocationsBackupPlansBackupsVolumeBackupsSetIamPolicyCall {
	c := &ProjectsLocationsBackupPlansBackupsVolumeBackupsSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackupPlansBackupsVolumeBackupsSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackupPlansBackupsVolumeBackupsSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackupPlansBackupsVolumeBackupsSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsBackupPlansBackupsVolumeBackupsSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackupPlansBackupsVolumeBackupsSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackupPlansBackupsVolumeBackupsSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.backupPlans.backups.volumeBackups.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBackupPlansBackupsVolumeBackupsSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsBackupPlansBackupsVolumeBackupsTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource. If the resource does not exist, this will return an empty set of
// permissions, not a `NOT_FOUND` error. Note: This operation is designed to be
// used for building permission-aware UIs and command-line tools, not for
// authorization checking. This operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsLocationsBackupPlansBackupsVolumeBackupsService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsLocationsBackupPlansBackupsVolumeBackupsTestIamPermissionsCall {
	c := &ProjectsLocationsBackupPlansBackupsVolumeBackupsTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBackupPlansBackupsVolumeBackupsTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsBackupPlansBackupsVolumeBackupsTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBackupPlansBackupsVolumeBackupsTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsBackupPlansBackupsVolumeBackupsTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBackupPlansBackupsVolumeBackupsTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBackupPlansBackupsVolumeBackupsTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.backupPlans.backups.volumeBackups.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBackupPlansBackupsVolumeBackupsTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsOperationsCancelCall struct {
	s                                       *Service
	name                                    string
	googlelongrunningcanceloperationrequest *GoogleLongrunningCancelOperationRequest
	urlParams_                              gensupport.URLParams
	ctx_                                    context.Context
	header_                                 http.Header
}

// Cancel: Starts asynchronous cancellation on a long-running operation. The
// server makes a best effort to cancel the operation, but success is not
// guaranteed. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or
// other methods to check whether the cancellation succeeded or whether the
// operation completed despite cancellation. On successful cancellation, the
// operation is not deleted; instead, it becomes an operation with an
// Operation.error value with a google.rpc.Status.code of 1, corresponding to
// `Code.CANCELLED`.
//
// - name: The name of the operation resource to be cancelled.
func (r *ProjectsLocationsOperationsService) Cancel(name string, googlelongrunningcanceloperationrequest *GoogleLongrunningCancelOperationRequest) *ProjectsLocationsOperationsCancelCall {
	c := &ProjectsLocationsOperationsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlelongrunningcanceloperationrequest = googlelongrunningcanceloperationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsCancelCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsCancelCall) Context(ctx context.Context) *ProjectsLocationsOperationsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlelongrunningcanceloperationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.operations.cancel" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsCancelCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsOperationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a long-running operation. This method indicates that the
// client is no longer interested in the operation result. It does not cancel
// the operation. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`.
//
// - name: The name of the operation resource to be deleted.
func (r *ProjectsLocationsOperationsService) Delete(name string) *ProjectsLocationsOperationsDeleteCall {
	c := &ProjectsLocationsOperationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsDeleteCall) Context(ctx context.Context) *ProjectsLocationsOperationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.operations.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsOperationsService) Get(name string) *ProjectsLocationsOperationsGetCall {
	c := &ProjectsLocationsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsOperationsService) List(name string) *ProjectsLocationsOperationsListCall {
	c := &ProjectsLocationsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list filter.
func (c *ProjectsLocationsOperationsListCall) Filter(filter string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *ProjectsLocationsOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *ProjectsLocationsOperationsListCall) PageToken(pageToken string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsListCall) Context(ctx context.Context) *ProjectsLocationsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsRestorePlansCreateCall struct {
	s           *Service
	parent      string
	restoreplan *RestorePlan
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Create: Creates a new RestorePlan in a given location.
//
//   - parent: The location within which to create the RestorePlan. Format:
//     `projects/*/locations/*`.
func (r *ProjectsLocationsRestorePlansService) Create(parent string, restoreplan *RestorePlan) *ProjectsLocationsRestorePlansCreateCall {
	c := &ProjectsLocationsRestorePlansCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.restoreplan = restoreplan
	return c
}

// RestorePlanId sets the optional parameter "restorePlanId": Required. The
// client-provided short name for the RestorePlan resource. This name must: -
// be between 1 and 63 characters long (inclusive) - consist of only lower-case
// ASCII letters, numbers, and dashes - start with a lower-case letter - end
// with a lower-case letter or number - be unique within the set of
// RestorePlans in this location
func (c *ProjectsLocationsRestorePlansCreateCall) RestorePlanId(restorePlanId string) *ProjectsLocationsRestorePlansCreateCall {
	c.urlParams_.Set("restorePlanId", restorePlanId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRestorePlansCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsRestorePlansCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRestorePlansCreateCall) Context(ctx context.Context) *ProjectsLocationsRestorePlansCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRestorePlansCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRestorePlansCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.restoreplan)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/restorePlans")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.restorePlans.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsRestorePlansCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsRestorePlansDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an existing RestorePlan.
//
//   - name: Fully qualified RestorePlan name. Format:
//     `projects/*/locations/*/restorePlans/*`.
func (r *ProjectsLocationsRestorePlansService) Delete(name string) *ProjectsLocationsRestorePlansDeleteCall {
	c := &ProjectsLocationsRestorePlansDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": If provided, this value must match
// the current value of the target RestorePlan's etag field or the request is
// rejected.
func (c *ProjectsLocationsRestorePlansDeleteCall) Etag(etag string) *ProjectsLocationsRestorePlansDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// Force sets the optional parameter "force": If set to true, any Restores
// below this RestorePlan will also be deleted. Otherwise, the request will
// only succeed if the RestorePlan has no Restores.
func (c *ProjectsLocationsRestorePlansDeleteCall) Force(force bool) *ProjectsLocationsRestorePlansDeleteCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRestorePlansDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsRestorePlansDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRestorePlansDeleteCall) Context(ctx context.Context) *ProjectsLocationsRestorePlansDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRestorePlansDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRestorePlansDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.restorePlans.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsRestorePlansDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsRestorePlansGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieve the details of a single RestorePlan.
//
//   - name: Fully qualified RestorePlan name. Format:
//     `projects/*/locations/*/restorePlans/*`.
func (r *ProjectsLocationsRestorePlansService) Get(name string) *ProjectsLocationsRestorePlansGetCall {
	c := &ProjectsLocationsRestorePlansGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRestorePlansGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsRestorePlansGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsRestorePlansGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsRestorePlansGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRestorePlansGetCall) Context(ctx context.Context) *ProjectsLocationsRestorePlansGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRestorePlansGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRestorePlansGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.restorePlans.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *RestorePlan.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsRestorePlansGetCall) Do(opts ...googleapi.CallOption) (*RestorePlan, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RestorePlan{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsRestorePlansGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns an
// empty policy if the resource exists and does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsRestorePlansService) GetIamPolicy(resource string) *ProjectsLocationsRestorePlansGetIamPolicyCall {
	c := &ProjectsLocationsRestorePlansGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that will be
// used to format the policy. Valid values are 0, 1, and 3. Requests specifying
// an invalid value will be rejected. Requests for policies with any
// conditional role bindings must specify version 3. Policies with no
// conditional role bindings may specify any valid value or leave the field
// unset. The policy in the response might use the policy version that you
// specified, or it might use a lower policy version. For example, if you
// specify version 3, but the policy has no conditional role bindings, the
// response uses version 1. To learn which resources support conditions in
// their IAM policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsRestorePlansGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsRestorePlansGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRestorePlansGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsRestorePlansGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsRestorePlansGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsRestorePlansGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRestorePlansGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsRestorePlansGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRestorePlansGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRestorePlansGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.restorePlans.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsRestorePlansGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsRestorePlansListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists RestorePlans in a given location.
//
//   - parent: The location that contains the RestorePlans to list. Format:
//     `projects/*/locations/*`.
func (r *ProjectsLocationsRestorePlansService) List(parent string) *ProjectsLocationsRestorePlansListCall {
	c := &ProjectsLocationsRestorePlansListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Field match expression used to
// filter the results.
func (c *ProjectsLocationsRestorePlansListCall) Filter(filter string) *ProjectsLocationsRestorePlansListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Field by which to sort the
// results.
func (c *ProjectsLocationsRestorePlansListCall) OrderBy(orderBy string) *ProjectsLocationsRestorePlansListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The target number of
// results to return in a single response. If not specified, a default value
// will be chosen by the service. Note that the response may include a partial
// list and a caller should only rely on the response's next_page_token to
// determine if there are more instances left to be queried.
func (c *ProjectsLocationsRestorePlansListCall) PageSize(pageSize int64) *ProjectsLocationsRestorePlansListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value of
// next_page_token received from a previous `ListRestorePlans` call. Provide
// this to retrieve the subsequent page in a multi-page list of results. When
// paginating, all other parameters provided to `ListRestorePlans` must match
// the call that provided the page token.
func (c *ProjectsLocationsRestorePlansListCall) PageToken(pageToken string) *ProjectsLocationsRestorePlansListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRestorePlansListCall) Fields(s ...googleapi.Field) *ProjectsLocationsRestorePlansListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsRestorePlansListCall) IfNoneMatch(entityTag string) *ProjectsLocationsRestorePlansListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRestorePlansListCall) Context(ctx context.Context) *ProjectsLocationsRestorePlansListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRestorePlansListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRestorePlansListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/restorePlans")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.restorePlans.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListRestorePlansResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsRestorePlansListCall) Do(opts ...googleapi.CallOption) (*ListRestorePlansResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListRestorePlansResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsRestorePlansListCall) Pages(ctx context.Context, f func(*ListRestorePlansResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsRestorePlansPatchCall struct {
	s           *Service
	name        string
	restoreplan *RestorePlan
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Patch: Update a RestorePlan.
//
//   - name: Output only. The full name of the RestorePlan resource. Format:
//     `projects/*/locations/*/restorePlans/*`.
func (r *ProjectsLocationsRestorePlansService) Patch(name string, restoreplan *RestorePlan) *ProjectsLocationsRestorePlansPatchCall {
	c := &ProjectsLocationsRestorePlansPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.restoreplan = restoreplan
	return c
}

// UpdateMask sets the optional parameter "updateMask": This is used to specify
// the fields to be overwritten in the RestorePlan targeted for update. The
// values for each of these updated fields will be taken from the
// `restore_plan` provided with this request. Field names are relative to the
// root of the resource. If no `update_mask` is provided, all fields in
// `restore_plan` will be written to the target RestorePlan resource. Note that
// OUTPUT_ONLY and IMMUTABLE fields in `restore_plan` are ignored and are not
// used to update the target RestorePlan.
func (c *ProjectsLocationsRestorePlansPatchCall) UpdateMask(updateMask string) *ProjectsLocationsRestorePlansPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRestorePlansPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsRestorePlansPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRestorePlansPatchCall) Context(ctx context.Context) *ProjectsLocationsRestorePlansPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRestorePlansPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRestorePlansPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.restoreplan)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.restorePlans.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsRestorePlansPatchCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsRestorePlansSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified resource.
// Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`,
// and `PERMISSION_DENIED` errors.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsRestorePlansService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsLocationsRestorePlansSetIamPolicyCall {
	c := &ProjectsLocationsRestorePlansSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRestorePlansSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsRestorePlansSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRestorePlansSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsRestorePlansSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRestorePlansSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRestorePlansSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.restorePlans.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsRestorePlansSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsRestorePlansTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource. If the resource does not exist, this will return an empty set of
// permissions, not a `NOT_FOUND` error. Note: This operation is designed to be
// used for building permission-aware UIs and command-line tools, not for
// authorization checking. This operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsLocationsRestorePlansService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsLocationsRestorePlansTestIamPermissionsCall {
	c := &ProjectsLocationsRestorePlansTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRestorePlansTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsRestorePlansTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRestorePlansTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsRestorePlansTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRestorePlansTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRestorePlansTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.restorePlans.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsRestorePlansTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsRestorePlansRestoresCreateCall struct {
	s          *Service
	parent     string
	restore    *Restore
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new Restore for the given RestorePlan.
//
//   - parent: The RestorePlan within which to create the Restore. Format:
//     `projects/*/locations/*/restorePlans/*`.
func (r *ProjectsLocationsRestorePlansRestoresService) Create(parent string, restore *Restore) *ProjectsLocationsRestorePlansRestoresCreateCall {
	c := &ProjectsLocationsRestorePlansRestoresCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.restore = restore
	return c
}

// RestoreId sets the optional parameter "restoreId": Required. The
// client-provided short name for the Restore resource. This name must: - be
// between 1 and 63 characters long (inclusive) - consist of only lower-case
// ASCII letters, numbers, and dashes - start with a lower-case letter - end
// with a lower-case letter or number - be unique within the set of Restores in
// this RestorePlan.
func (c *ProjectsLocationsRestorePlansRestoresCreateCall) RestoreId(restoreId string) *ProjectsLocationsRestorePlansRestoresCreateCall {
	c.urlParams_.Set("restoreId", restoreId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRestorePlansRestoresCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsRestorePlansRestoresCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRestorePlansRestoresCreateCall) Context(ctx context.Context) *ProjectsLocationsRestorePlansRestoresCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRestorePlansRestoresCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRestorePlansRestoresCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.restore)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/restores")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.restorePlans.restores.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsRestorePlansRestoresCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsRestorePlansRestoresDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an existing Restore.
//
//   - name: Full name of the Restore Format:
//     `projects/*/locations/*/restorePlans/*/restores/*`.
func (r *ProjectsLocationsRestorePlansRestoresService) Delete(name string) *ProjectsLocationsRestorePlansRestoresDeleteCall {
	c := &ProjectsLocationsRestorePlansRestoresDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": If provided, this value must match
// the current value of the target Restore's etag field or the request is
// rejected.
func (c *ProjectsLocationsRestorePlansRestoresDeleteCall) Etag(etag string) *ProjectsLocationsRestorePlansRestoresDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// Force sets the optional parameter "force": If set to true, any
// VolumeRestores below this restore will also be deleted. Otherwise, the
// request will only succeed if the restore has no VolumeRestores.
func (c *ProjectsLocationsRestorePlansRestoresDeleteCall) Force(force bool) *ProjectsLocationsRestorePlansRestoresDeleteCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRestorePlansRestoresDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsRestorePlansRestoresDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRestorePlansRestoresDeleteCall) Context(ctx context.Context) *ProjectsLocationsRestorePlansRestoresDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRestorePlansRestoresDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRestorePlansRestoresDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.restorePlans.restores.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsRestorePlansRestoresDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsRestorePlansRestoresGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves the details of a single Restore.
//
//   - name: Name of the restore resource. Format:
//     `projects/*/locations/*/restorePlans/*/restores/*`.
func (r *ProjectsLocationsRestorePlansRestoresService) Get(name string) *ProjectsLocationsRestorePlansRestoresGetCall {
	c := &ProjectsLocationsRestorePlansRestoresGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRestorePlansRestoresGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsRestorePlansRestoresGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsRestorePlansRestoresGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsRestorePlansRestoresGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRestorePlansRestoresGetCall) Context(ctx context.Context) *ProjectsLocationsRestorePlansRestoresGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRestorePlansRestoresGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRestorePlansRestoresGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.restorePlans.restores.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Restore.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsRestorePlansRestoresGetCall) Do(opts ...googleapi.CallOption) (*Restore, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Restore{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsRestorePlansRestoresGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns an
// empty policy if the resource exists and does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsRestorePlansRestoresService) GetIamPolicy(resource string) *ProjectsLocationsRestorePlansRestoresGetIamPolicyCall {
	c := &ProjectsLocationsRestorePlansRestoresGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that will be
// used to format the policy. Valid values are 0, 1, and 3. Requests specifying
// an invalid value will be rejected. Requests for policies with any
// conditional role bindings must specify version 3. Policies with no
// conditional role bindings may specify any valid value or leave the field
// unset. The policy in the response might use the policy version that you
// specified, or it might use a lower policy version. For example, if you
// specify version 3, but the policy has no conditional role bindings, the
// response uses version 1. To learn which resources support conditions in
// their IAM policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsRestorePlansRestoresGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsRestorePlansRestoresGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRestorePlansRestoresGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsRestorePlansRestoresGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsRestorePlansRestoresGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsRestorePlansRestoresGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRestorePlansRestoresGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsRestorePlansRestoresGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRestorePlansRestoresGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRestorePlansRestoresGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.restorePlans.restores.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsRestorePlansRestoresGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsRestorePlansRestoresListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the Restores for a given RestorePlan.
//
//   - parent: The RestorePlan that contains the Restores to list. Format:
//     `projects/*/locations/*/restorePlans/*`.
func (r *ProjectsLocationsRestorePlansRestoresService) List(parent string) *ProjectsLocationsRestorePlansRestoresListCall {
	c := &ProjectsLocationsRestorePlansRestoresListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Field match expression used to
// filter the results.
func (c *ProjectsLocationsRestorePlansRestoresListCall) Filter(filter string) *ProjectsLocationsRestorePlansRestoresListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Field by which to sort the
// results.
func (c *ProjectsLocationsRestorePlansRestoresListCall) OrderBy(orderBy string) *ProjectsLocationsRestorePlansRestoresListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The target number of
// results to return in a single response. If not specified, a default value
// will be chosen by the service. Note that the response may include a partial
// list and a caller should only rely on the response's next_page_token to
// determine if there are more instances left to be queried.
func (c *ProjectsLocationsRestorePlansRestoresListCall) PageSize(pageSize int64) *ProjectsLocationsRestorePlansRestoresListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value of
// next_page_token received from a previous `ListRestores` call. Provide this
// to retrieve the subsequent page in a multi-page list of results. When
// paginating, all other parameters provided to `ListRestores` must match the
// call that provided the page token.
func (c *ProjectsLocationsRestorePlansRestoresListCall) PageToken(pageToken string) *ProjectsLocationsRestorePlansRestoresListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRestorePlansRestoresListCall) Fields(s ...googleapi.Field) *ProjectsLocationsRestorePlansRestoresListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsRestorePlansRestoresListCall) IfNoneMatch(entityTag string) *ProjectsLocationsRestorePlansRestoresListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRestorePlansRestoresListCall) Context(ctx context.Context) *ProjectsLocationsRestorePlansRestoresListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRestorePlansRestoresListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRestorePlansRestoresListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/restores")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.restorePlans.restores.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListRestoresResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsRestorePlansRestoresListCall) Do(opts ...googleapi.CallOption) (*ListRestoresResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListRestoresResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsRestorePlansRestoresListCall) Pages(ctx context.Context, f func(*ListRestoresResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsRestorePlansRestoresPatchCall struct {
	s          *Service
	name       string
	restore    *Restore
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Update a Restore.
//
//   - name: Output only. The full name of the Restore resource. Format:
//     `projects/*/locations/*/restorePlans/*/restores/*`.
func (r *ProjectsLocationsRestorePlansRestoresService) Patch(name string, restore *Restore) *ProjectsLocationsRestorePlansRestoresPatchCall {
	c := &ProjectsLocationsRestorePlansRestoresPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.restore = restore
	return c
}

// UpdateMask sets the optional parameter "updateMask": This is used to specify
// the fields to be overwritten in the Restore targeted for update. The values
// for each of these updated fields will be taken from the `restore` provided
// with this request. Field names are relative to the root of the resource. If
// no `update_mask` is provided, all fields in `restore` will be written to the
// target Restore resource. Note that OUTPUT_ONLY and IMMUTABLE fields in
// `restore` are ignored and are not used to update the target Restore.
func (c *ProjectsLocationsRestorePlansRestoresPatchCall) UpdateMask(updateMask string) *ProjectsLocationsRestorePlansRestoresPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRestorePlansRestoresPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsRestorePlansRestoresPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRestorePlansRestoresPatchCall) Context(ctx context.Context) *ProjectsLocationsRestorePlansRestoresPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRestorePlansRestoresPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRestorePlansRestoresPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.restore)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.restorePlans.restores.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsRestorePlansRestoresPatchCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsRestorePlansRestoresSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified resource.
// Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`,
// and `PERMISSION_DENIED` errors.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsRestorePlansRestoresService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsLocationsRestorePlansRestoresSetIamPolicyCall {
	c := &ProjectsLocationsRestorePlansRestoresSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRestorePlansRestoresSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsRestorePlansRestoresSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRestorePlansRestoresSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsRestorePlansRestoresSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRestorePlansRestoresSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRestorePlansRestoresSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.restorePlans.restores.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsRestorePlansRestoresSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsRestorePlansRestoresTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource. If the resource does not exist, this will return an empty set of
// permissions, not a `NOT_FOUND` error. Note: This operation is designed to be
// used for building permission-aware UIs and command-line tools, not for
// authorization checking. This operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsLocationsRestorePlansRestoresService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsLocationsRestorePlansRestoresTestIamPermissionsCall {
	c := &ProjectsLocationsRestorePlansRestoresTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRestorePlansRestoresTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsRestorePlansRestoresTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRestorePlansRestoresTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsRestorePlansRestoresTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRestorePlansRestoresTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRestorePlansRestoresTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.restorePlans.restores.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsRestorePlansRestoresTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsRestorePlansRestoresVolumeRestoresGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieve the details of a single VolumeRestore.
//
//   - name: Full name of the VolumeRestore resource. Format:
//     `projects/*/locations/*/restorePlans/*/restores/*/volumeRestores/*`.
func (r *ProjectsLocationsRestorePlansRestoresVolumeRestoresService) Get(name string) *ProjectsLocationsRestorePlansRestoresVolumeRestoresGetCall {
	c := &ProjectsLocationsRestorePlansRestoresVolumeRestoresGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRestorePlansRestoresVolumeRestoresGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsRestorePlansRestoresVolumeRestoresGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsRestorePlansRestoresVolumeRestoresGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsRestorePlansRestoresVolumeRestoresGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRestorePlansRestoresVolumeRestoresGetCall) Context(ctx context.Context) *ProjectsLocationsRestorePlansRestoresVolumeRestoresGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRestorePlansRestoresVolumeRestoresGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRestorePlansRestoresVolumeRestoresGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.restorePlans.restores.volumeRestores.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *VolumeRestore.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsRestorePlansRestoresVolumeRestoresGetCall) Do(opts ...googleapi.CallOption) (*VolumeRestore, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &VolumeRestore{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsRestorePlansRestoresVolumeRestoresGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns an
// empty policy if the resource exists and does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsRestorePlansRestoresVolumeRestoresService) GetIamPolicy(resource string) *ProjectsLocationsRestorePlansRestoresVolumeRestoresGetIamPolicyCall {
	c := &ProjectsLocationsRestorePlansRestoresVolumeRestoresGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that will be
// used to format the policy. Valid values are 0, 1, and 3. Requests specifying
// an invalid value will be rejected. Requests for policies with any
// conditional role bindings must specify version 3. Policies with no
// conditional role bindings may specify any valid value or leave the field
// unset. The policy in the response might use the policy version that you
// specified, or it might use a lower policy version. For example, if you
// specify version 3, but the policy has no conditional role bindings, the
// response uses version 1. To learn which resources support conditions in
// their IAM policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsRestorePlansRestoresVolumeRestoresGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsRestorePlansRestoresVolumeRestoresGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRestorePlansRestoresVolumeRestoresGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsRestorePlansRestoresVolumeRestoresGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsRestorePlansRestoresVolumeRestoresGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsRestorePlansRestoresVolumeRestoresGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRestorePlansRestoresVolumeRestoresGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsRestorePlansRestoresVolumeRestoresGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRestorePlansRestoresVolumeRestoresGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRestorePlansRestoresVolumeRestoresGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.restorePlans.restores.volumeRestores.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsRestorePlansRestoresVolumeRestoresGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsRestorePlansRestoresVolumeRestoresListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the VolumeRestores for a given Restore.
//
//   - parent: The Restore that contains the VolumeRestores to list. Format:
//     `projects/*/locations/*/restorePlans/*/restores/*`.
func (r *ProjectsLocationsRestorePlansRestoresVolumeRestoresService) List(parent string) *ProjectsLocationsRestorePlansRestoresVolumeRestoresListCall {
	c := &ProjectsLocationsRestorePlansRestoresVolumeRestoresListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Field match expression used to
// filter the results.
func (c *ProjectsLocationsRestorePlansRestoresVolumeRestoresListCall) Filter(filter string) *ProjectsLocationsRestorePlansRestoresVolumeRestoresListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Field by which to sort the
// results.
func (c *ProjectsLocationsRestorePlansRestoresVolumeRestoresListCall) OrderBy(orderBy string) *ProjectsLocationsRestorePlansRestoresVolumeRestoresListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The target number of
// results to return in a single response. If not specified, a default value
// will be chosen by the service. Note that the response may include a partial
// list and a caller should only rely on the response's next_page_token to
// determine if there are more instances left to be queried.
func (c *ProjectsLocationsRestorePlansRestoresVolumeRestoresListCall) PageSize(pageSize int64) *ProjectsLocationsRestorePlansRestoresVolumeRestoresListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value of
// next_page_token received from a previous `ListVolumeRestores` call. Provide
// this to retrieve the subsequent page in a multi-page list of results. When
// paginating, all other parameters provided to `ListVolumeRestores` must match
// the call that provided the page token.
func (c *ProjectsLocationsRestorePlansRestoresVolumeRestoresListCall) PageToken(pageToken string) *ProjectsLocationsRestorePlansRestoresVolumeRestoresListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRestorePlansRestoresVolumeRestoresListCall) Fields(s ...googleapi.Field) *ProjectsLocationsRestorePlansRestoresVolumeRestoresListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsRestorePlansRestoresVolumeRestoresListCall) IfNoneMatch(entityTag string) *ProjectsLocationsRestorePlansRestoresVolumeRestoresListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRestorePlansRestoresVolumeRestoresListCall) Context(ctx context.Context) *ProjectsLocationsRestorePlansRestoresVolumeRestoresListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRestorePlansRestoresVolumeRestoresListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRestorePlansRestoresVolumeRestoresListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/volumeRestores")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.restorePlans.restores.volumeRestores.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListVolumeRestoresResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsRestorePlansRestoresVolumeRestoresListCall) Do(opts ...googleapi.CallOption) (*ListVolumeRestoresResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListVolumeRestoresResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsRestorePlansRestoresVolumeRestoresListCall) Pages(ctx context.Context, f func(*ListVolumeRestoresResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsRestorePlansRestoresVolumeRestoresSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified resource.
// Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`,
// and `PERMISSION_DENIED` errors.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsRestorePlansRestoresVolumeRestoresService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsLocationsRestorePlansRestoresVolumeRestoresSetIamPolicyCall {
	c := &ProjectsLocationsRestorePlansRestoresVolumeRestoresSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRestorePlansRestoresVolumeRestoresSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsRestorePlansRestoresVolumeRestoresSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRestorePlansRestoresVolumeRestoresSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsRestorePlansRestoresVolumeRestoresSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRestorePlansRestoresVolumeRestoresSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRestorePlansRestoresVolumeRestoresSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.restorePlans.restores.volumeRestores.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsRestorePlansRestoresVolumeRestoresSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsRestorePlansRestoresVolumeRestoresTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource. If the resource does not exist, this will return an empty set of
// permissions, not a `NOT_FOUND` error. Note: This operation is designed to be
// used for building permission-aware UIs and command-line tools, not for
// authorization checking. This operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsLocationsRestorePlansRestoresVolumeRestoresService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsLocationsRestorePlansRestoresVolumeRestoresTestIamPermissionsCall {
	c := &ProjectsLocationsRestorePlansRestoresVolumeRestoresTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRestorePlansRestoresVolumeRestoresTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsRestorePlansRestoresVolumeRestoresTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRestorePlansRestoresVolumeRestoresTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsRestorePlansRestoresVolumeRestoresTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRestorePlansRestoresVolumeRestoresTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRestorePlansRestoresVolumeRestoresTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkebackup.projects.locations.restorePlans.restores.volumeRestores.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsRestorePlansRestoresVolumeRestoresTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}
