/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.engine.openai.dto;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.ai.AIMessage;
import org.jkiss.dbeaver.model.ai.AIMessageType;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.OAIMessageContent;

public class OAIMessage {
    public static final String TYPE_MESSAGE = "message";
    public static final String TYPE_FUNCTION_CALL = "function_call";
    public static final String TYPE_FUNCTION_REASONING = "reasoning";
    public String id;
    public String type;
    public String status;
    public String role;
    public String name;
    public String arguments;
    @SerializedName(value="call_id")
    public String callId;
    public List<OAIMessageContent> content;

    public OAIMessage() {
    }

    public OAIMessage(@NotNull AIMessage msg) {
        this.type = TYPE_MESSAGE;
        this.role = OAIMessage.mapRole(msg.getRole());
        boolean input = switch (msg.getRole()) {
            case AIMessageType.SYSTEM, AIMessageType.USER -> true;
            default -> false;
        };
        this.content = List.of(new OAIMessageContent(input, msg.getContent()));
    }

    @NotNull
    public String getFullText() {
        if (this.content == null) {
            return "";
        }
        return this.content.stream().map(c -> c.text).collect(Collectors.joining());
    }

    @Nullable
    private static String mapRole(@NotNull AIMessageType role) {
        return switch (role) {
            case AIMessageType.SYSTEM -> "system";
            case AIMessageType.USER -> "user";
            case AIMessageType.ASSISTANT, AIMessageType.FUNCTION -> "assistant";
            default -> null;
        };
    }
}

