#!/usr/bin/env gpgscm

;; Copyright (C) 2016 g10 Code GmbH
;;
;; This file is part of GnuPG.
;;
;; GnuPG is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 3 of the License, or
;; (at your option) any later version.
;;
;; GnuPG is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, see <http://www.gnu.org/licenses/>.

(load (in-srcdir "tests" "openpgp" "defs.scm"))
(setup-legacy-environment)

(define (check-signing args input)
  (lambda (source sink)
    (lettmp (signed)
	    (call-popen `(,@GPG --output ,signed --yes
				,@args ,source) input)
	    (call-popen `(,@GPG --output ,sink --yes --verify ,signed) ""))))

(for-each-p
 "Checking signing and verifying plain text messages"
 (lambda (source)
   (check-identity
    source
    (check-signing '(--passphrase-fd "0" --clear-sign) usrpass1)))
 (append plain-files '("plain-large")))

;; The test vectors are lists of length three, containing
;; - a string to be signed,
;; - a flag indicating whether we verify that the exact message is
;;   reconstructed (whitespace at the end is normalized for plain text
;;   messages),
;; - and a list of arguments to add to gpg when encoding
;;   the string.

(define :string car)
(define :check-equality cadr)
(define :options caddr)

(define
  vectors
  '(;; one with long lines
    ("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxyx

xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
" #t ())

    ;; one with only one long line
    ("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxyx
" #t ())

    ;; and one with an empty body
    ("" #t ())

    ;; and one with one empty line at the end
    ("line 1
line 2
line 3
there is a blank line after this

" #t ())

    ;; Input text with trailing whitespace on any line will have the
    ;; trailing whitespace stripped when clearsigning (see RFC 4880
    ;; section 7.1), so verification will succeed, but the type-
    ;; specific data passed to the digest will not be identical.
    ("this is a sig test
 " #f ())))

(let ((counter (make-counter)))
  (for-each-p'
   "Checking signing and verifying test vectors"
   (lambda (vec)
     (lettmp (tmp)
       (with-output-to-file tmp (lambda () (display (:string vec))))
       ((if (:check-equality vec) check-identity check-execution)
	tmp
	(check-signing `(--passphrase-fd "0" --clear-sign ,@(:options vec))
		       usrpass1))))
   (lambda (vec) (counter))
   vectors))
