/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.tools.HiDPISupport;
import org.openstreetmap.josm.tools.ImageProcessor;
import org.openstreetmap.josm.tools.ImageProvider;

public class ImageOverlay
implements ImageProcessor {
    public ImageProvider image;
    private final double offsetLeft;
    private final double offsetRight;
    private final double offsetTop;
    private final double offsetBottom;

    public ImageOverlay(ImageProvider image, double offsetLeft, double offsetTop, double offsetRight, double offsetBottom) {
        this.image = image;
        this.offsetLeft = offsetLeft;
        this.offsetTop = offsetTop;
        this.offsetRight = offsetRight;
        this.offsetBottom = offsetBottom;
    }

    public ImageOverlay(ImageProvider image) {
        this.image = image;
        this.offsetLeft = -1.0;
        this.offsetTop = -1.0;
        this.offsetRight = 1.0;
        this.offsetBottom = 1.0;
    }

    @Override
    public BufferedImage process(BufferedImage ground) {
        return this.process(ground, false);
    }

    BufferedImage process(BufferedImage ground, boolean highResolution) {
        List<Image> resolutionVariants;
        int w = ground.getWidth();
        int h = ground.getHeight();
        int width = -1;
        int height = -1;
        if (this.offsetRight > 0.0 && this.offsetLeft > 0.0) {
            width = (int)((double)w * (this.offsetRight - this.offsetLeft));
        }
        if (this.offsetTop > 0.0 && this.offsetBottom > 0.0) {
            height = (int)((double)h * (this.offsetBottom - this.offsetTop));
        }
        this.image = new ImageProvider(this.image).setMaxSize(new Dimension(width, height));
        ImageIcon overlay = this.image.get();
        if (highResolution && (resolutionVariants = HiDPISupport.getResolutionVariants(overlay.getImage())).size() >= 2) {
            overlay = new ImageIcon(resolutionVariants.get(1));
        }
        int x = width == -1 && this.offsetLeft < 0.0 ? (int)((double)w * this.offsetRight) - overlay.getIconWidth() : (int)((double)w * this.offsetLeft);
        int y = height == -1 && this.offsetTop < 0.0 ? (int)((double)h * this.offsetBottom) - overlay.getIconHeight() : (int)((double)h * this.offsetTop);
        overlay.paintIcon(null, ground.getGraphics(), x, y);
        return ground;
    }
}

