# Upgrade 3.3
delimiter //


# Called by db_sql_select_domain:
# Insert/update domain, return domain_ref
#
DROP PROCEDURE IF EXISTS recv_from_domain//

CREATE PROCEDURE recv_from_domain (
  IN m_domain VARCHAR(63),
  IN m_dkim TINYINT,
  IN m_prefix_len TINYINT,
  IN m_dmarc_ri MEDIUMINT UNSIGNED,
  IN m_original_ri MEDIUMINT UNSIGNED,
  IN m_dmarc_rec VARCHAR(63),
  IN m_dmarc_rua VARCHAR(64))
  MODIFIES SQL DATA
BEGIN
  DECLARE d_id INT UNSIGNED;
  DECLARE d_white TINYINT;
  BEGIN
    DECLARE Empty_set CONDITION FOR 1329;
    DECLARE CONTINUE HANDLER FOR Empty_set
      BEGIN
        # meanwhile, domain might have been inserted by another child
        DECLARE Duplicate_entry CONDITION FOR 1062;
        DECLARE CONTINUE HANDLER FOR Duplicate_entry
          SELECT id, whitelisted INTO d_id, d_white
            FROM domain WHERE domain = m_domain;
        SET d_white = 0;
        SET d_id = 0;
        INSERT INTO domain SET domain = m_domain;
        IF d_id = 0 THEN
          SELECT LAST_INSERT_ID() INTO d_id;
        END IF;
      END;
      SELECT id, whitelisted INTO d_id, d_white
        FROM domain WHERE domain = m_domain;
  END;
  IF d_white >= 0 AND d_white < 1 AND m_dkim = 1 THEN
    # whitelisted=1 just affects the order of signature validation attempts
    UPDATE domain SET whitelisted = GREATEST(1, whitelisted),
      prefix_len = IFNULL(m_prefix_len, prefix_len),
      recv = recv + 1, last_recv = UNIX_TIMESTAMP()+0 WHERE id = d_id;
  ELSE
    UPDATE domain SET recv = recv + 1,
      prefix_len = IFNULL(m_prefix_len, prefix_len),
      last_recv = UNIX_TIMESTAMP()+0 WHERE id = d_id;
  END IF;
  IF m_dmarc_ri > 0 THEN
    UPDATE domain SET dmarc_ri = m_dmarc_ri, original_ri = m_original_ri,
      dmarc_rec = m_dmarc_rec, dmarc_rua = m_dmarc_rua  WHERE id = d_id;
  END IF;
  SELECT d_id AS domain_ref;
END //

# Called by db_sql_insert_target_ref:
#  Insert/update domain, insert msg_out_ref
#
DROP PROCEDURE IF EXISTS sent_to_domain //
CREATE PROCEDURE sent_to_domain (
  IN message_ref INT UNSIGNED,
  IN c_flag TINYINT UNSIGNED,
  IN m_domain VARCHAR(63))
  MODIFIES SQL DATA
BEGIN
  DECLARE d_id INT UNSIGNED;
  DECLARE d_white TINYINT;
  DECLARE Empty_set CONDITION FOR 1329;
  DECLARE CONTINUE HANDLER FOR Empty_set
    BEGIN
      INSERT INTO domain SET domain = m_domain;
      SELECT LAST_INSERT_ID() INTO d_id;
    END;
  SELECT id INTO d_id FROM domain WHERE domain = m_domain;
  IF c_flag = 0 THEN
    SET d_white = 2;
  ELSE
    SET d_white = 0;
  END IF;
  UPDATE domain SET whitelisted = IF(whitelisted<0, whitelisted, GREATEST(whitelisted, d_white)),
    sent = sent + 1,
    last_sent = UNIX_TIMESTAMP()+0 WHERE id = d_id;
  INSERT INTO msg_out_ref SET message_out = message_ref,
    domain = d_id;
END //
