/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;

public class BaseProgressDialog
extends BaseDialog
implements DBRRunnableContext {
    private int runningOperations;
    private ProgressMonitorPart monitorPart;
    private Composite mainComposite;

    public BaseProgressDialog(Shell parentShell, String title, @Nullable DBPImage icon) {
        super(parentShell, title, icon);
    }

    @Override
    protected Composite createDialogArea(Composite parent) {
        this.mainComposite = super.createDialogArea(parent);
        return this.mainComposite;
    }

    @Override
    protected Control createButtonBar(Composite parent) {
        this.monitorPart = new ProgressMonitorPart(this.mainComposite, null, true){

            public void setCanceled(boolean b) {
                super.setCanceled(b);
                if (b) {
                    BaseProgressDialog.this.cancelCurrentOperation();
                }
            }
        };
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalIndent = 20;
        gd.verticalIndent = 0;
        gd.exclude = true;
        this.monitorPart.setLayoutData((Object)gd);
        this.monitorPart.setVisible(false);
        return super.createButtonBar(parent);
    }

    protected void cancelCurrentOperation() {
    }

    public void run(boolean fork, boolean cancelable, DBRRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        if (this.monitorPart != null) {
            ((GridData)this.monitorPart.getLayoutData()).exclude = false;
            this.monitorPart.setVisible(true);
            this.monitorPart.getParent().layout();
            this.monitorPart.attachToCancelComponent(null);
        }
        ControlEnableState buttonsEnableState = ControlEnableState.disable((Control)this.getButtonBar());
        try {
            ++this.runningOperations;
            ModalContext.run(monitor -> runnable.run((DBRProgressMonitor)new DefaultProgressMonitor(monitor)), (boolean)true, (IProgressMonitor)this.monitorPart, (Display)this.getShell().getDisplay());
        }
        finally {
            --this.runningOperations;
            buttonsEnableState.restore();
            if (this.monitorPart != null) {
                this.monitorPart.done();
                ((GridData)this.monitorPart.getLayoutData()).exclude = true;
                this.monitorPart.setVisible(false);
                this.monitorPart.getParent().layout();
            }
        }
    }
}

